<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */

include_once('../../../../param.php');

global $username,$password,$database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");



// DB table to use
$table = 'Service_Call';

// Table's primary key
$primaryKey = "service_call_id";

$salespersonID = $_GET['salespersonID'];
$hide=trim(''.$_GET['hide'],"'");

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`sa`.`salesperson_id`', 'dt' => 'salesperson_id', 'field' => 'salesperson_id' ),

    array( 'db' => '`s`.`service_call_id`', 'dt' => 'service_call_id', 'field' => 'service_call_id' ),
    array( 'db' => '`s`.`service_call_code`', 'dt' => 'code', 'field' => 'service_call_code' ),
    array( 'db' => '`c`.`customer_code`', 'dt' => 'ccode', 'field' => 'customer_code' ),
    array( 'db' => '`c`.`customer_company_name`', 'dt' => 'customer', 'formatter' => function( $d, $row ) {
        $p = $row['service_call_id'];
        global $username,$password,$database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");

        $stm = $db->prepare("SELECT color FROM SC_Types,Service_Call WHERE SC_Types.type_id=Service_Call.type_id AND Service_Call.service_call_id='$p' LIMIT 1");
        $stm->execute();
        $stm->bind_result($color);
        while ($stm->fetch()) {

            if(strcmp($color,"")==0)
            {
                $color="#333";
            }

        }
        $stm->close();




        return "<span style='font-weight:bold;color:$color'>$d</span>";}, 'field' => 'customer_company_name' ),
    array( 'db' => '`t`.`type_name`', 'dt' => 'type', 'field' => 'type_name' ),
    array( 'db' => '`s`.`date`', 'dt' =>  'date', 'formatter' => function( $d, $row ) {

        if(strcmp($d,"0000-00-00 00:00:00") == 0)
        {
            return "";
        }

        $d = date('d-m-Y H:i:s',strtotime($d));

        $d = str_replace("00:00:00", "", $d);

        return $d;
    }, 'field' =>'date' ),

    array( 'db' => '`s`.`topic`', 'dt' => 'topic' , 'field' => 'topic' ),
    array( 'db' => '`scp`.`priority_color`', 'dt' => 'priorityColor' , 'formatter' => function( $d, $row ) {$GLOBALS['priorityColor']=$d;return $d;}, 'field' => 'priority_color' ),
    array( 'db' => '`scp`.`priority_name`', 'dt' => 'priority', 'formatter' => function( $d, $row ) {

        if(strcmp($GLOBALS['priorityColor'],'')!=0){
            $color = $GLOBALS['priorityColor'];
            return '<span style="font-weight:bolder;color:'.$color.'">'.$d.' </span>';
        }
        else if(strcmp($d,"Emergency") == 0)
        {
            return '<span style="color:#b22222">'.$d.' </span>';
        }
        else if(strcmp($d,"High") == 0)
        {
            return '<span style="color:steelblue">'.$d.' </span>';
        }
        else
        {
            return $d;
        }

    },'field' => 'priority_name' ),

    array( 'db' => '`st`.`status_name`', 'dt' => 'statuslabel','field' => 'status_name' ),
    array( 'db' => '`st`.`status_color`', 'dt' => 'statusColor','field' => 'status_color' ),
    array( 'db' => '`st`.`status_name`', 'dt' => 'statusid', 'field' => 'status_name' ),

    array( 'db' => '`s`.`due_date`', 'dt' => 'duedate', 'formatter' => function( $d, $row ) {

        if(strcmp($d,"0000-00-00 00:00:00") == 0)
        {
            return "";
        }
        $date = date('Y-m-d H:i:s',strtotime($d));
        $d = date('d-m-Y H:i:s',strtotime($d));

        $d = str_replace("00:00:00", "", $d);
        $p = $row['statuslabel'];
        if ($date < date('Y-m-d H:i:s') && strcmp($p,'Closed')!=0){
            $d = "<span style='color: firebrick'><b>$d</b></span>";
        }
        return $d;
    }, 'field' => 'due_date' ),

    array( 'db' => '`s`.`status_id`', 'dt' => 'status_id' , 'field' => 'status_id' ),

    array( 'db' => '`s`.`schedule_start_date`', 'dt' => 'startDate', 'formatter' => function( $d, $row ) {

        if(strcmp($d,"0000-00-00 00:00:00") == 0)
        {
            return "";
        }

        $d = date('d-m-Y H:i:s',strtotime($d));

        $d = str_replace("00:00:00", "", $d);

        return $d;
    }, 'field' => 'schedule_start_date' ),

    array( 'db' => '`s`.`schedule_end_date`', 'dt' => 'endDate', 'formatter' => function( $d, $row ) {
        if(strcmp($d,"0000-00-00 00:00:00") == 0)
        {
            return "";
        }

        $d = date('d-m-Y H:i:s',strtotime($d));

        $d = str_replace("00:00:00", "", $d);

        return $d;
    }, 'field' => 'schedule_end_date' ),



    array( 'db' => '`s`.`service_call_id`', 'dt' => 'actions', 'formatter' => function( $d, $row )use($db) {
        $serviceCallID =$d;
        $statusID = $row['status_id'];
        $salespersonID = $row['salesperson_id'];

        $statusFrom = $_GET['statusFrom'];
        $statusTo = $_GET['statusTo'];

        if($statusID==$statusTo){
            $checked = "checked";
            $nextStatusID = $statusFrom;

        }
        else{
            $checked = "";
            $nextStatusID = $statusTo;
        }

        $stm = $db->prepare("SELECT status_name FROM SC_Status WHERE status_id=? LIMIT 1");
        $stm->bind_param("i",$nextStatusID);
        $stm->execute();
        $stm->bind_result($statusName);
        while ($stm->fetch()) {

        }
        $stm->close();

        return "<input type='checkbox' class='form-control' id='changeStatus$d' style='height: 25px;width: 25px' $checked  onclick='changeStatus($nextStatusID, \"$statusName\" ,$serviceCallID, $salespersonID)'>";

        }, 'field' => 'service_call_id' )

);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Service_Call` AS `s` LEFT JOIN `SC_Types` AS `t` ON (`s`.`type_id` = `t`.`type_id` ) LEFT JOIN `SC_Status` AS `st` ON (`s`.`status_id` = `st`.`status_id` ) LEFT JOIN `Customers` AS `c` ON (`c`.`customer_id` = `s`.`customer_id`) LEFT JOIN `SalesPersons` AS `sa` ON (`s`.`assign_to` = `sa`.`salesperson_id` ) LEFT JOIN `SC_Priorities` AS `scp` ON (`s`.`priority_id` = `scp`.`priority_id` )";
require( ROOT.'backend/core/controllers/ssp2.class.php' );

if(isset($salespersonID) &&strcmp($salespersonID,"")!=0 &&isset($hide)&&strcmp($hide,"")!=0)
{
    if(!isset($_GET['filterDate']) || empty($_GET['filterDate'])){
        $filterDate =  date('d/m/Y');
    }
    else {
        $filterDate = $_GET['filterDate'];
    }
    $filterDate = date('Y-m-d', strtotime(str_replace('/', '-', $filterDate)));

    $where="(`s`.assign_to=$salespersonID  OR  `s`.service_call_id IN(SELECT service_call_id AS service_call_id FROM SC_Referred_To WHERE salesperson_id =$salespersonID)) AND (NOT `st`.visible = '$hide' OR `st`.visible IS NULL)   AND (DATE(`s`.schedule_start_date) >= DATE('$filterDate') AND DATE(`s`.schedule_end_date) <= DATE('$filterDate'))";
}

if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= "`c`.`customer_id` IN (".$_SESSION['Allow_Customers'].")";
}
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " `s`.`assign_to` IN (".$_SESSION['Allow_Salespersons'].")";
}

if(isset($_SESSION['Allow_SC_Types']) && strcmp($_SESSION['Allow_SC_Types'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " `s`.`type_id` IN (".$_SESSION['Allow_SC_Types'].")";
}



echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>