<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */

include_once('../../../../param.php');
// DB table to use
$table = 'Service_Call';

// Table's primary key
$primaryKey = "service_call_id";

$salespersonID = $_GET['salespersonID'];
$status=$_GET['status'];
$user =$_GET['user'];
$groupID =$_GET['groupID'];
$serialNumberID=$_GET['serialNumberID'];
$openOnly=$_GET['serialNumberID'];
$city=$_GET['city'];
$serviceCallNewID;
$from=$_GET['from'];
$to=$_GET['to'];
$offers=$_GET['offers'];
$partsWaiting=$_GET['partsWaiting'];


// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`s`.`service_call_id`', 'dt' => 'img', 'formatter' => function( $d, $row ) {
        $GLOBALS['serviceCallNewID']=$d;
        return '<img class="custom-rounded-image monthly center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/settingsicon.png" width="30" height="30"></td>';},
        'field' => 'service_call_id' ),
    array( 'db' => '`s`.`service_call_code`', 'dt' => 'code', 'field' => 'service_call_code' ),
    array( 'db' => '`c`.`customer_code`', 'dt' => 'ccode', 'field' => 'customer_code' ),
    array( 'db' => '`c`.`customer_company_name`', 'dt' => 'customer', 'formatter' => function( $d, $row ) {
        $p = $GLOBALS['serviceCallNewID'];
        global $username,$password,$database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");

        $stm = $db->prepare("SELECT color FROM SC_Types,Service_Call WHERE SC_Types.type_id=Service_Call.type_id AND Service_Call.service_call_id='$p' LIMIT 1");
        $stm->execute();
        $stm->bind_result($color);
        while ($stm->fetch()) {

            if(strcmp($color,"")==0)
            {
                $color="#333";
            }

        }
        $stm->close();

        $customField="";
        $stm2 = $db->prepare("SELECT custom_form_id,custom_form_code,custom_form_name FROM  ZA_Custom_Form_Definition,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Definition.custom_form_definition_id=ZA_Custom_Form_Usage.custom_form_id  AND linked_table='Service_Call'");
        $stm2->execute();
        $stm2->bind_result($customFormID,$customFormCode,$customFormName);
        while ($stm2->fetch()) {

            require_once("./dbhelper.php");


            $db3= new mysqli(localhost,$username,$password,$database);
            if (mysqli_connect_errno())
            {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db3->set_charset("utf8");
            $stm3 = $db3->prepare("SELECT ZA_Custom_Field_Definition.custom_field_id,custom_field_name,type,values_range,css_style,position,required,editable,class FROM  ZA_Custom_Field_Definition,ZA_Custom_Form_Custom_Field WHERE ZA_Custom_Field_Definition.custom_field_id=ZA_Custom_Form_Custom_Field.custom_field_id  AND ZA_Custom_Form_Custom_Field.custom_form_id='$customFormID' ORDER BY position");
            $stm3->execute();
            $stm3->bind_result($customFieldID,$customFieldName,$type,$valuesRange,$cssStyle,$position,$required,$editable,$class);
            while ($stm3->fetch()) {




                $customField.=" ". getLastValueOfCustomForm($customFormID, $customFieldID, "Service_Call", $p);


            }


        }
        $stm2->close();



        return "<span style='font-weight:bold;color:$color'>$d</span><span style='font-weight:bold;color:#b22222'>$customField</span>";}, 'field' => 'customer_company_name' ),
    array( 'db' => '`t`.`type_name`', 'dt' => 'type', 'field' => 'type_name' ),
    array( 'db' => '`s`.`date`', 'dt' =>  'date', 'formatter' => function( $d, $row ) {

        if(strcmp($d,"0000-00-00 00:00:00") == 0)
        {
            return "";
        }

        $d = date('d-m-Y H:i:s',strtotime($d));

        $d = str_replace("00:00:00", "", $d);

        return $d;
    }, 'field' =>'date' ),
    array( 'db' => '`c`.`mobile`', 'dt' => 'duedate', 'formatter' => function( $d, $row ) {



        return $d;
    }, 'field' => 'mobile' ),
    array( 'db' => '`s`.`topic`', 'dt' => 'topic' , 'field' => 'topic' ),
    array( 'db' => '`scp`.`priority_name`', 'dt' => 'priority', 'formatter' => function( $d, $row ) {

        if(strcmp($d,"Emergency") == 0)
        {
            return '<span style="color:#b22222">'.$d.' </span>';
        }
        else if(strcmp($d,"High") == 0)
        {
            return '<span style="color:steelblue">'.$d.' </span>';
        }
        else
        {
            return $d;
        }

    },'field' => 'priority_name' ),
    array( 'db' => '`sa`.`salesperson_id`', 'dt' => 'salID', 'formatter' => function( $d, $row ) {
        $GLOBALS['salepersonIDHelper']=$d;
        return"";

    }, 'field' => 'salesperson_id' ),
    array( 'db' => '`sa`.`salesperson_code`', 'dt' => 'sal', 'formatter' => function( $d, $row ) {
        $GLOBALS['salepersonCode']=$d;
        return"";

    }, 'field' => 'salesperson_code' ),
    array( 'db' => '`sa`.`first_name`', 'dt' => 'salespersonid', 'formatter' => function( $d, $row ) {

        $p = $GLOBALS['serviceCallNewID'];
        $salesP=$GLOBALS['salepersonCode'];


        $styleReferred="";

        if(isset($_GET['salespersonID']) && strcmp($GLOBALS['salepersonIDHelper'],$_GET['salespersonID'])!=0)
        {
            $styleReferred="background-color:#add8e6";
        }




        $options=" <select class='form-control serviceCallAssign'  id='serviceCallAssign' name='serviceCallAssign' onchange='changeAssignTo(this,$p)' style='$styleReferred'>";
        global $username,$password,$database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $check = false;
        $stm = $db->prepare("SELECT salesperson_id,salesperson_code,CONCAT(salesperson_code,' ',first_name,' ',last_name),status FROM SalesPersons");
        $stm->execute();
        $stm->bind_result($salespersonID,$salespersonCode,$salespersonName,$status);

        while ($stm->fetch()) {
            if(strcmp($salesP,$salespersonCode)==0){
                if(strcmp($status,'disabled')!=0) {
                    $options .= "<option onclick='' value='$salespersonID' selected>$salespersonName</option>";
                } else {
                    $options .= "<option onclick='' value='$salespersonID' selected disabled>$salespersonName</option>";
                }
            }
            else{
                if(strcmp($status,'disabled')!=0) {
                    $options .= "<option onclick='' value='$salespersonID'>$salespersonName </option>";
                }
            }

        }
        $stm->close();

        $options.="</select>";
        return $options;

    }, 'field' => 'first_name' ),
    array( 'db' => '`st`.`status_name`', 'dt' => 'statusid', 'formatter' => function( $d, $row ) {

        $p = $GLOBALS['serviceCallNewID'];
        $options=" <select class='form-control serviceCallStatus'  id='serviceCallStatus' name='serviceCallStatus' onchange='changeStatus(this,$p)'>";
        global $username,$password,$database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $check = false;
        $stm = $db->prepare("SELECT status_id,status_name FROM SC_Status ORDER BY position");
        $stm->execute();
        $stm->bind_result($statusID,$statusName);

        while ($stm->fetch()) {
            if(strcmp($d,$statusName)==0){
                $options.= "<option onclick='' value='$statusID' selected>$statusName</option>";
            }
            else{
                $options.= "<option onclick='' value='$statusID'>$statusName </option>";
            }

        }
        $stm->close();

        $options.="</select>";
        return $options;

    }, 'field' => 'status_name' ),
    array( 'db' => '`s`.`service_call_id`', 'dt' => 'actions', 'formatter' => function( $d, $row ) {

        return '<form id="'.$d.'" class="tableRowForm" target="_blank"  action="//'.HTML_PATH .'/cop/backend/modules/service/views/service_call.php" method="post" style="display:inline;">
           		<input type="hidden" class="service_call_id" name="service_call_id" value="'.$d.'">		
			</form>
			'

            ;},
        'field' => 'service_call_id' )
);

$db2= new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db2->set_charset("utf8");

$stm2 = $db2->prepare("SELECT custom_form_id,custom_form_code,custom_form_name FROM  ZA_Custom_Form_Definition,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Definition.custom_form_definition_id=ZA_Custom_Form_Usage.custom_form_id  AND linked_table='Service_Call'");
$stm2->execute();
$stm2->bind_result($customFormID,$customFormCode,$customFormName);
while ($stm2->fetch()) {

    require_once("./dbhelper.php");


    $db3= new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db3->set_charset("utf8");
    $stm3 = $db3->prepare("SELECT ZA_Custom_Field_Definition.custom_field_id,custom_field_name,type,values_range,css_style,position,required,editable,class FROM  ZA_Custom_Field_Definition,ZA_Custom_Form_Custom_Field WHERE ZA_Custom_Field_Definition.custom_field_id=ZA_Custom_Form_Custom_Field.custom_field_id  AND ZA_Custom_Form_Custom_Field.custom_form_id='$customFormID' ORDER BY position");
    $stm3->execute();
    $stm3->bind_result($customFieldID,$customFieldName,$type,$valuesRange,$cssStyle,$position,$required,$editable,$class);
    while ($stm3->fetch()) {


        $column = array( 'db' => '`s`.`service_call_id`','customerForm'=>$customFormID,'customField'=>$customFieldID, 'dt' => $customFieldID, 'field' => 'service_call_id' );





        $formatter = function( $d, $row)use($customFormID,$customFieldID) {

            return getLastValueOfCustomForm($customFormID, $customFieldID, "Service_Call", $d);
        };

        $column['formatter'] = $formatter;

        array_push($columns,$column);
    }


}
$stm2->close();

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Service_Call` AS `s` LEFT JOIN `SC_Types` AS `t` ON (`s`.`type_id` = `t`.`type_id` ) LEFT JOIN `SC_Status` AS `st` ON (`s`.`status_id` = `st`.`status_id` ) LEFT JOIN `Customers` AS `c` ON (`c`.`customer_id` = `s`.`customer_id`) LEFT JOIN `SalesPersons` AS `sa` ON (`s`.`assign_to` = `sa`.`salesperson_id` ) LEFT JOIN `SC_Priorities` AS `scp` ON (`s`.`priority_id` = `scp`.`priority_id` )";
require( ROOT.'backend/core/controllers/ssp2.class.php' );
if(isset($salespersonID) &&strcmp($salespersonID,"")!=0 &&isset($status)&&strcmp($status,"")!=0)
{
    $where="(`s`.assign_to=$salespersonID  OR  `s`.service_call_id IN(SELECT service_call_id AS service_call_id FROM SC_Referred_To WHERE salesperson_id =$salespersonID))  AND `s`.status_id IN ($status)";
}
else if(isset($user))
{
    $where="`s`.salesperson_id=$user";
}
else if(isset($groupID))
{
    $where="`c`.customer_id IN(SELECT customer_id AS customer_id FROM Customer_CustomersGroup WHERE group_id='$groupID')";
}
else if(isset($serialNumberID))
{
    $where="`s`.serial_number_id=$serialNumberID";
}
else if(isset($openOnly))
{
    $where="`s`.status_id IN(1,2,4,5)";
}
else if(isset($city))
{
    //$where="`s`.salesperson_id IN(SELECT id AS salesperson_id FROM Admin WHERE user_group='$city') AND `s`.status_id IN(1,4,5)" ;
    $where=" ((`s`.assign_to =0 AND `s`.salesperson_id IN(SELECT id AS salesperson_id FROM Admin WHERE user_group='$city')) OR (`s`.assign_to IN(SELECT id AS salesperson_id FROM Admin WHERE user_group='$city'))) AND `s`.status_id IN(1,2,4,5)" ;
}
else if(isset($from) && isset($to)&& isset($status))
{
    $where=" `s`.assign_to ='$to' AND `s`.salesperson_id ='$from' AND `s`.status_id IN(1,2,4,5) AND `s`.customer_id=1000497" ;
}
else if(isset($offers))
{
    $where=" `s`.`type_id`=4 AND `s`.status_id IN(1,2,4,5)" ;
}

else if(isset($partsWaiting))
{
    $where="`s`.status_id IN(5)" ;
}

else{
    $where='';
}


if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= "`c`.`customer_id` IN (".$_SESSION['Allow_Customers'].")";
}
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " `s`.`assign_to` IN (".$_SESSION['Allow_Salespersons'].")";
}


echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>