<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');

// DB table to use
$table = 'SC_Types';

// Table's primary key
$primaryKey = "type_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array(
        'db' => '`s`.`type_code`',
        'dt' => 'code',
        'field' => 'type_code'
    ),
    array(
        'db' => '`s`.`type_name`',
        'dt' => 'name',
        'field' => 'type_name'
    ),

    array(
    'db' => '`s`.`color`',
    'dt' => 'color',
    'field' => 'color'
),

    array(
    'db' => '`s`.`type_id`',
    'dt' => 'form',
    'field' => 'type_id'
    ),
    
    array(
        'db' => '`s`.`type_code`',
        'dt' => 'code_with_edit',
        'formatter' => function( $d, $row ) {
            $typeID = $row['type_id'];
            $typeField = 'code';
           return "
           <div 
           id='editable-$typeID' 
           data-field-name='type_code' 
           data-id='$typeID' 
           style='position: relative; cursor: pointer;'
           onmouseover='$(this).find(\".fa-pencil\").show();'
           onmouseleave='$(this).find(\".fa-pencil\").hide();'
           onclick='openEditField($typeID, \"$typeField\", this);'>
               <span id='value-$typeField-$typeID'>$d</span>
               <span id='pen-$typeField-$typeID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
           </div>
           <input type='text' class='form-control text-center' id='input-$typeField-$typeID' value='' style='display:none;'>
           <button id='save-$typeField-$typeID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>";
        },
        'field' => 'type_code'
    ),
    
    array(
        'db' => '`s`.`type_name`',
        'dt' => 'name_with_edit',
        'formatter' => function( $d, $row ) {
            $typeID = $row['type_id'];
            $typeField = 'name';
            $displayValue = !empty($d) ? $d :'&nbsp;';

          return "
          <div 
          id='editable-$typeID' 
          data-id='$typeID' 
          style='position: relative; cursor: pointer;'
          onmouseover='$(this).find(\".fa-pencil\").show();'
          onmouseleave='$(this).find(\".fa-pencil\").hide();'
          onclick='openEditField($typeID, \"$typeField\", this);'>
              <span id='value-$typeField-$typeID'>$displayValue</span>
              <span id='pen-$typeField-$typeID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
          </div>
          <input type='text' class='form-control text-center' id='input-$typeField-$typeID' value='' style='display:none;'>
          <button id='save-$typeField-$typeID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>";
        },
        'field' => 'type_name'
    ),
    

array(
        'db' => '`s`.`color`',
        'dt' => 'color_with_edit',
        'formatter' => function( $d, $row ) {
            $typeID = $row['type_id'];
            $typeField = 'color';
            $colorisChecked = empty($d) ? 'checked' : '';
            $displayValue = !empty($d) ? $d : '#ffffff'; 
            $displayColor = !empty($d) ? $d : 'transparent'; 
          return " <div 
              id='editable-$typeID' 
              data-id='$typeID' 
              style='position: relative; cursor: pointer;'
              onmouseover='$(this).find(\".fa-pencil\").show();'
              onmouseleave='$(this).find(\".fa-pencil\").hide();'
              onclick='initColorChange(\"noColor-$typeField-$typeID\",\"typeColor-$typeField-$typeID\",\"input-$typeField-$typeID\");openEditField($typeID, \"$typeField\", this);'>
                  <span style='color:$displayColor;background-color:$displayColor;border: 1px solid black;width:100px; !important' class='form-control' id='value-$typeField-$typeID'>$displayValue</span>
                  <span id='pen-$typeField-$typeID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
           </div>
           <div id='inputDiv-$typeField-$typeID' style='display:none;'>
                <label >No Color:<input type='checkbox' id='noColor-$typeField-$typeID' style='margin: 0 5px;vertical-align: middle;width:35px;height:20px;' $colorisChecked > </label>
                <input type='color' class='form-control' id='typeColor-$typeField-$typeID' style='width: 15%;' value='$displayValue'>
                <input type='hidden' class='form-control text-center' id='input-$typeField-$typeID' value='' style='display:none;'>
              <button id='save-$typeField-$typeID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
           <div>
          ";
        },
        'field' => 'color'
    )
);

// SQL server connection information
global $username,$password,$database;
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `SC_Types` AS `s`";  // No joins needed for types table in this case
$where = ''; // Add any specific where clauses if needed


require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);

?>