<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../../../param.php");


// DB table to use
$table = 'Profit_Center';

// Table's primary key
$primaryKey = "profit_center_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array(
        'db' => 'profit_center_id',
        'dt' => 'profit_center_id',
        'field' => 'profit_center_id'
    ),

    array(
        'db' => 'profit_center_code',
        'dt' => 'code',
        'field' => 'profit_center_code'
    ),
    array(
        'db' => 'profit_center_name',
        'dt' => 'name',
        'field' => 'profit_center_name'
    ),
    array(
        'db' => 'active',
        'dt' => 'active',
        'field' => 'active'
    ),

    array( 'db' => '`profit_center_id`', 'dt' =>  'form', 'formatter' => function( $d, $row ) {
        $code = $row["profit_center_code"];
        $name = $row["profit_center_name"];
        $active = $row["active"];
        $button = "<a onclick='openEditModal(\"$d\",\"$code\",\"$name\",\"$active\");'>
                        <button type='submit' class='btn btn-primary' style='width:80px'> Edit</button>
                    </a>
                    ";
        return $button;
    }, 'field' =>'profit_center_id'

    )

);

global $username, $password, $database;
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);



$joinQuery = "FROM `Profit_Center`";
$where='';

require(ROOT . 'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>