<?php
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 include_once('../../../../param.php');
// DB table to use
$table = 'Orders';
 
// Table's primary key
$primaryKey = "order_code";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`p`.`pick_id`', 'dt' => 'img', 'formatter' => function( $d, $row ) {

        return '<img class="custom-rounded-image invoice center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/pickinglisticon.png" width="30" height="30"></td>';},
        'field' => 'pick_id' ),
     array( 'db' => '`p`.`pick_code`', 'dt' =>  'pick', 'field' =>'pick_code' ),
     array( 'db' => '`o`.`order_code`', 'dt' =>  'code', 'field' =>'order_code' ),
       array( 'db' => '`c`.`customer_company_name`', 'dt' => 'customer', 'field' => 'customer_company_name' ),
    array( 'db' => '`c`.`customer_code`', 'dt' => 'customercode', 'field' => 'customer_code' ),
     array( 'db' => '`p`.`date`', 'dt' => 'date' , 'formatter' => function( $d, $row ) {
         return date('d-m-Y',strtotime($d));},'field' => 'date' ),
    
            array( 'db' => '`s`.`salesperson_code`', 'dt' => 'salesperson', 'field' => 'salesperson_code' ),
             array( 'db' => '`o`.`delivery_date`', 'dt' => 'delivery', 'formatter' => function( $d, $row ) {
                 if(strcmp($d,'0000-00-00')!=0){
                     return date('d-m-Y',strtotime($d));
                 } else {
                        return '-';
                 }
                 },'field' => 'delivery_date' ),
             array( 'db' => '`o`.`grand_total`', 'dt' => 'grand', 'formatter' => function( $d, $row ) {
                return currencySymbol . number_format($d,2);},
          'field' => 'grand_total' ),
    array( 'db' => '`p`.`pick_id`', 'dt' => 'salesPersonSelect', 'formatter' => function( $d, $row ) {

        global $username, $password, $database;

        $db = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $disabled = '';
        $selectInput = true;
        $stm = $db->prepare("SELECT Pick.status FROM Pick WHERE pick_id LIKE '$d'");
        $stm->execute();
        $stm->bind_result($pickStatus);
        while ($stm->fetch()) {
            if(strcmp($pickStatus,'Cancelled')==0 || strcmp($pickStatus,'Canceled')==0 || strcmp($pickStatus,'Completed')==0){
                $disabled = 'disabled';
                $selectInput = false;
            }
        }
        $stm->close();

        $stm = $db->prepare("SELECT Pick.salesperson_id, salesperson_code, CONCAT(first_name,' ',last_name) FROM Pick INNER JOIN SalesPersons ON (SalesPersons.salesperson_id = Pick.salesperson_id) WHERE pick_id LIKE '$d'");
        $stm->execute();
        $stm->bind_result($salesPersonID, $salesPersonCode, $salesPersonName);
        while ($stm->fetch()) {
        }
        $stm->close();

        if($selectInput) {
            $select = "<select name='select$d' id ='select$d' class='form-control' onchange='updateSalesPerson($d)' $disabled>";

            $select .= "<option value='$salesPersonID' selected >$salesPersonCode $salesPersonName</option>";

            $stm = $db->prepare("SELECT salesperson_id, salesperson_code, CONCAT(first_name,' ',last_name) FROM SalesPersons  WHERE salesperson_id NOT LIKE '$salesPersonID'");
            $stm->execute();
            $stm->bind_result($salesPersonID, $salesPersonCode, $salesPersonName);
            while ($stm->fetch()) {
                $select .= "<option value='$salesPersonID' >$salesPersonCode $salesPersonName</option>";
            }
            $stm->close();
            $select .= "</select>";
        } else {
            $select = "<label >$salesPersonCode $salesPersonName</label>";
        }


        return $select;


    },
            'field' => 'pick_id' ),
    array( 'db' => '`p`.`status`', 'dt' =>  'status', 'formatter' => function( $d, $row ) {
        switch ($d){
            case 'Cancelled':
                $result = "<div style='color: firebrick;'><b>$d</b></div>";
                break;
            case 'Ready to Pick':
                $result = "<div style='color: #0a6ebd;width: 100px;'><b>$d</b></div>";
                break;
            case 'Partially Picked':
                $result = "<div style='color: #898a01;width: 100px;'><b>$d</b></div>";
                break;
            case 'Completed':
                $result = "<div style='color: #00a300;'><b>$d</b></div>";
                break;
            default:
                $result = "<div style='color: black;'>$d</div>";
        }
        return $result;
    },'field' =>'status' ),
     array( 'db' => '`p`.`pick_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {

         global $username, $password, $database;

         $db = new mysqli(localhost,$username,$password,$database);
         if (mysqli_connect_errno())
         {
             printf("Connect failed: %s\n", mysqli_connect_error());
             exit();
         }
         $stm = $db->prepare("SELECT order_id FROM Pick_Order INNER JOIN Pick ON (Pick.pick_id = Pick_Order.pick_id) WHERE Pick.pick_id LIKE '$d'");
         $stm->execute();
         $stm->bind_result($orderID);
         while ($stm->fetch()) {}
         $stm->close();

                return '<form style="display:inline;" target="_blank" id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/core/views/view/view_pick.php" method="post">
           		            <input type="hidden" name="pick_id" value="'.$d.'">	           			                   
			                <input style="font-size:13px;width:110px; margin-top: 3px;" type="submit" class="btn btn-invoice" value="View Pick" >
			            </form>
			            <form style="display:inline;" target="_blank" id="'.$orderID.'" action="//'.HTML_PATH .'/cop/backend/core/views/view/view_order.php" method="post">
           		            <input type="hidden" name="order_id" value="'.$orderID.'">	           			                   
			                <input style="font-size:13px;width:110px; margin-top: 3px;" type="submit" class="btn btn-primary" value="View Order" >
			            </form>
			           <!-- <button type="button" class="btn btn-danger" style="font-size:12px; width: 110px; margin-top: 3px;" onclick="cancelPick('.$orderID.')">Cancel Picking</button>
			 <form style="display:inline;" class="tableRowForm" id="'.$d.'" action="create_invoice.php" method="post">
           		<input type="hidden" class="orderID" name="order_id" value="'.$d.'">
			<input style="" type="submit" class="btn btn-invoice" value="Convert To Invoice">
			</form>
			<form style="display:inline;" class="tableRowForm" id="'.$d.'" action="create_warehouse_transfer.php" method="post">
           		<input type="hidden" class="orderID" name="order_id" value="'.$d.'">
			<input style="" type="submit" class="btn btn-invoice" value="Convert To WT">
			</form> -->
						
			';},
            'field' => 'pick_id' )
);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$where = '';
if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= "`c`.`customer_id` IN (".$_SESSION['Allow_Customers'].")";
}
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " `o`.`salesperson_id` IN (".$_SESSION['Allow_Salespersons'].")";
}
$joinQuery = "FROM `Orders` AS `o` INNER JOIN `Pick_Order` AS `po` ON (`o`.`order_id` = `po`.`order_id`) INNER JOIN `Pick` AS `p`  ON (`po`.`pick_id` = `p`.`pick_id`) LEFT JOIN `Customers` AS `c` ON (`o`.`customer_id` = `c`.`customer_id`) LEFT JOIN `SalesPersons` AS `s` ON (`o`.`salesperson_id` = `s`.`salesperson_id`)";
require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>