<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');
// DB table to use
$table = 'Serial_Numbers';

// Table's primary key
$primaryKey = "serial_number_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`i`.`item_id`', 'dt' => 'image', 'formatter' => function( $d, $row ) {
        global $username,$password,$database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $check = false;
        $stm = $db->prepare("SELECT image_name FROM Item_Images WHERE item_id='$d'");
        $stm->execute();
        $stm->bind_result($imgName);

        while ($stm->fetch()) {
            $d = "../productImages/$imgName.jpg";
            $check = true;

        }
        $stm->close();
        if(!$check) {
            $d = "./img/itemdefaulticon.jpg";
        }
        return '<img class="img-responsive img-rounded center-canvas" src="'.$d.'" width="32" height="32"></td>';},
        'field' => 'item_id' ),
    array( 'db' => '`s`.`desription_1`', 'dt' =>  'modis', 'field' =>'desription_1' ),
    array( 'db' => '`s`.`serial_number`', 'dt' =>  'serial', 'field' =>'serial_number' ),
    array( 'db' => '`i`.`item_code`', 'dt' =>  'code', 'field' =>'item_code' ),
    array( 'db' => '`s`.`desription_2`', 'dt' =>  'desc1', 'field' =>'desription_2' ),
    array( 'db' => '`s`.`details_1`', 'dt' =>  'details1', 'field' =>'details_1' ),
    array( 'db' => '`s`.`details_2`', 'dt' =>  'details2', 'field' =>'details_2' ),
    array( 'db' => '`s`.`notes`', 'dt' =>  'notes', 'field' =>'notes' ),
    array( 'db' => '`s`.`serial_number_id`', 'dt' => 'customer', 'formatter' => function( $d, $row ) {

        global $username,$password,$database;

        $customer='';
        $db2= new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");

        $stm2 = $db2->prepare("SELECT CONCAT(customer_code,' ',customer_company_name) FROM Customers WHERE customer_id IN (SELECT customer_id AS customer_id FROM Contracts WHERE serial_number_id='$d' AND valid='yes')");
        $stm2->execute();
        $stm2->bind_result($customer);
        while ($stm2->fetch()) {


        }
        $stm2->close();

        if(strcmp($customer,"")==0)
        {
            $customer='Stock';
        }

        return $customer




            ;},
        'field' => 'serial_number_id' ),

    array( 'db' => '`s`.`serial_number_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
        return '<form id="'.$d.'"  action="//'.HTML_PATH .'/cop/backend/core/views/addedit/new_serial_number.php" method="post" style="display:inline;">
           		<input type="hidden" name="serial_number_id" value="'.$d.'">
			<input  type="submit" class="btn btn-success" value="View" style="margin-top:5px;height:30px;padding-top:2px;">
			</form><form id="'.$d.'"  action="//'.HTML_PATH .'/cop/backend/core/views/manage/manage_serial_number_history.php" method="post" style="display:inline;">
           		<input type="hidden" name="serial_number_id" value="'.$d.'">
			<input  type="submit" class="btn btn-primary" value="History" style="margin-top:5px;height:30px;padding-top:2px;">
			</form>
					
			
			
			'

            ;},
        'field' => 'serial_number_id' )
);

$db2= new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db2->set_charset("utf8");

$stm2 = $db2->prepare("SELECT custom_form_id,custom_form_code,custom_form_name FROM  ZA_Custom_Form_Definition,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Definition.custom_form_definition_id=ZA_Custom_Form_Usage.custom_form_id  AND linked_table='Serial_Numbers'");
$stm2->execute();
$stm2->bind_result($customFormID,$customFormCode,$customFormName);
while ($stm2->fetch()) {

    require_once("./dbhelper.php");


    $db3= new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db3->set_charset("utf8");
    $stm3 = $db3->prepare("SELECT ZA_Custom_Field_Definition.custom_field_id,custom_field_name,type,values_range,css_style,position,required,editable,class FROM  ZA_Custom_Field_Definition,ZA_Custom_Form_Custom_Field WHERE ZA_Custom_Field_Definition.custom_field_id=ZA_Custom_Form_Custom_Field.custom_field_id  AND ZA_Custom_Form_Custom_Field.custom_form_id='$customFormID' ORDER BY position");
    $stm3->execute();
    $stm3->bind_result($customFieldID,$customFieldName,$type,$valuesRange,$cssStyle,$position,$required,$editable,$class);
    while ($stm3->fetch()) {


        $column = array( 'db' => '`s`.`serial_number_id`','customerForm'=>$customFormID,'customField'=>$customFieldID, 'dt' => $customFieldID, 'field' => 'serial_number_id' );





        $formatter = function( $d, $row)use($customFormID,$customFieldID) {

            return getLastValueOfCustomForm($customFormID, $customFieldID, "Serial_Numbers", $d);
        };

        $column['formatter'] = $formatter;

        array_push($columns,$column);
    }


}
$stm2->close();

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Serial_Numbers` AS `s` LEFT JOIN `Items` AS `i` ON (`i`.`item_id` = `s`.`item_id`)";

require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery)
);

?>