<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');

// DB table to use
$table = 'CRM_Types';

// Table's primary key
$primaryKey = "type_id";

// Array of database columns which should be read and sent back to DataTables.
// The db parameter represents the column name in the database, while the dt
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array(
        'db' => 'type_id',
        'dt' => 'type_id',
        'field' => 'type_id'
    ),
   

    array(
        'db' => 'type_name',
        'dt' => 'name',
        'formatter' => function( $d, $row ) {
            $uniqueID = $row['type_id'];
            $fieldName = 'name';
            $displayValue = !empty($d) ? $d : '&nbsp;';

            return "
          <div 
          id='editable-$uniqueID' 
          data-id='$uniqueID' 
          style='position: relative; cursor: pointer;'
          onmouseover='$(this).find(\".fa-pencil\").show();'
          onmouseleave='$(this).find(\".fa-pencil\").hide();'
          onclick='openEditField($uniqueID, \"$fieldName\");'>
              <span id='value-$fieldName-$uniqueID'>$displayValue</span>
              <span id='pen-$fieldName-$uniqueID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
          </div>
          <div  style='white-space: nowrap;'>
              <input type='text' class='form-control text-center' id='input-$fieldName-$uniqueID' value='' style='display:none;'>
              <button id='save-$fieldName-$uniqueID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
          <div  style='white-space: nowrap;'>";
        },
        'field' => 'type_name'
    ),

    array(
        'db' => 'position',
        'dt' => 'position',
        'formatter' => function( $d, $row ) {
            $uniqueID = $row['type_id'];
            $fieldName = 'position';
            return "
          <div 
          id='editable-$uniqueID' 
          data-id='$uniqueID' 
          style='position: relative; cursor: pointer;'
          onmouseover='$(this).find(\".fa-pencil\").show();'
          onmouseleave='$(this).find(\".fa-pencil\").hide();'
          onclick='openEditField($uniqueID, \"$fieldName\");'>
              <span id='value-$fieldName-$uniqueID'>$d</span>
              <span id='pen-$fieldName-$uniqueID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
          </div>
          <div  style='white-space: nowrap;'>
              <input type='number' class='form-control text-center' id='input-$fieldName-$uniqueID' value='' style='display:none;'>
              <button id='save-$fieldName-$uniqueID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
          </div>";
        },
        'field' => 'position'
    ),
    array(
        'db' => 'visible',
        'dt' => 'visible',
        'formatter' => function( $d, $row ) {
            $uniqueID = $row['type_id'];
            $fieldName = 'visible';
            return "
              <div 
              id='editable-$uniqueID' 
              data-id='$uniqueID' 
              style='position: relative; cursor: pointer;'
              onmouseover='$(this).find(\".fa-pencil\").show();'
              onmouseleave='$(this).find(\".fa-pencil\").hide();'
              onclick='openEditField($uniqueID, \"$fieldName\");'>
                  <span id='value-$fieldName-$uniqueID'>$d</span>
                  <span id='pen-$fieldName-$uniqueID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
              </div>
              <div  style='white-space: nowrap;'>
                  <select id='input-$fieldName-$uniqueID' style='display:none;' class='form-control' >
                        <option value='yes' " . ($d == 'yes' ? 'selected' : '') . ">yes</option>
                        <option value='no' " . ($d == 'no' ? 'selected' : '') . ">no</option>
                  </select>
              <button id='save-$fieldName-$uniqueID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
               </div>
               ";
        },
        'field' => 'visible'
    ),

    array(
        'db' => 'icon',
        'dt' => 'icon',
        'formatter' => function( $d, $row ) {
            $uniqueID = $row['type_id'];
            $fieldName = 'icon';
            return "
              <div 
              id='editable-$uniqueID' 
              data-id='$uniqueID' 
              style='position: relative; cursor: pointer;'
              onmouseover='$(this).find(\".fa-pencil\").show();'
              onmouseleave='$(this).find(\".fa-pencil\").hide();'
              onclick='openEditField($uniqueID, \"$fieldName\");'>
                  <span id='value-$fieldName-$uniqueID'>$d</span>
                  <span id='pen-$fieldName-$uniqueID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
              </div>
              <div  style='white-space: nowrap;'>
                  <input type='text' class='form-control text-center' id='input-$fieldName-$uniqueID' value='' style='display:none;'>
                  <button id='save-$fieldName-$uniqueID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
              </div>";
        },
        'field' => 'icon'
    ),


    array(
        'db' => 'color',
        'dt' => 'color',
        'formatter' => function( $d, $row ) {
            $uniqueID = $row['type_id'];
            $fieldName = 'color';
            $colorIsChecked = empty($d) ? 'checked' : '';
            $displayValue = !empty($d) ? $d : '#ffffff';
            $displayColor = !empty($d) ? $d : 'transparent';


            return "
          <div 
              id='editable-$uniqueID' 
              data-id='$uniqueID' 
              style='position: relative; cursor: pointer;'
              onmouseover='$(this).find(\".fa-pencil\").show();'
              onmouseleave='$(this).find(\".fa-pencil\").hide();'
              onclick='initColorChange(\"noColor-$fieldName-$uniqueID\",\"typeColor-$fieldName-$uniqueID\",\"input-$fieldName-$uniqueID\");openEditField($uniqueID, \"$fieldName\");'>
                  <span style='color:$displayColor;background-color:$displayColor;border: 1px solid black;width:100px; !important' class='form-control' id='value-$fieldName-$uniqueID'>$displayValue</span>
                  <span id='pen-$fieldName-$uniqueID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
           </div>
           <div  style='white-space: nowrap;'>
               <div id='inputDiv-$fieldName-$uniqueID' style='display:none;'>
                    <label >No Color:<input type='checkbox' id='noColor-$fieldName-$uniqueID' style='margin: 0 5px;vertical-align: middle;width:35px;height:20px;' $colorIsChecked > </label>
                    <input type='color' class='form-control' id='typeColor-$fieldName-$uniqueID' style='width: 25%;' value='$displayValue'>
                    <input type='hidden' class='form-control text-center' id='input-$fieldName-$uniqueID' value='' style='display:none;'>
                  <button id='save-$fieldName-$uniqueID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
               </div>
            </div>
          ";
        },
        'field' => 'color'
    )
);

// SQL server connection information
global $username,$password,$database;
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM CRM_Types ";  // No joins needed for SC_Status table in this case
$where = ''; // Add any specific where clauses if needed


require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);

?>