<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');

// DB table to use
$table = 'CRM_Opportunity_Stages';

// Table's primary key
$primaryKey = "stage_id";

// Array of database columns which should be read and sent back to DataTables.
// The db parameter represents the column name in the database, while the dt
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array(
        'db' => 'stage_id',
        'dt' => 'stage_id',
        'field' => 'stage_id'
    ),
    array(
        'db' => 'stage_code',
        'dt' => 'code',
        'formatter' => function( $d, $row ) {
            $uniqueID = $row['stage_id'];
            $fieldName = 'code';
            $displayValue = !empty($d) ? $d :'&nbsp;';
           return "
           <div 
           id='editable-$uniqueID' 
           data-id='$uniqueID' 
           style='position: relative; cursor: pointer;'
           onmouseover='$(this).find(\".fa-pencil\").show();'
           onmouseleave='$(this).find(\".fa-pencil\").hide();'
           onclick='openEditField($uniqueID, \"$fieldName\");'>
               <span id='value-$fieldName-$uniqueID'>$displayValue</span>
               <span id='pen-$fieldName-$uniqueID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
           </div>
           <div  style='white-space: nowrap;'>
               <input type='text' class='form-control text-center' id='input-$fieldName-$uniqueID' value='' style='display:none;'>
               <button id='save-$fieldName-$uniqueID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
           </div>";
        },
        'field' => 'stage_code'
    ),
    
    array(
        'db' => 'stage_name',
        'dt' => 'name',
        'formatter' => function( $d, $row ) {
            $uniqueID = $row['stage_id'];
            $fieldName = 'name';
            $displayValue = !empty($d) ? $d : '&nbsp;';

          return "
          <div 
          id='editable-$uniqueID' 
          data-id='$uniqueID' 
          style='position: relative; cursor: pointer;'
          onmouseover='$(this).find(\".fa-pencil\").show();'
          onmouseleave='$(this).find(\".fa-pencil\").hide();'
          onclick='openEditField($uniqueID, \"$fieldName\");'>
              <span id='value-$fieldName-$uniqueID'>$displayValue</span>
              <span id='pen-$fieldName-$uniqueID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
          </div>
          <div  style='white-space: nowrap;'>
              <input type='text' class='form-control text-center' id='input-$fieldName-$uniqueID' value='' style='display:none;'>
              <button id='save-$fieldName-$uniqueID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
          <div  style='white-space: nowrap;'>";
        },
        'field' => 'stage_name'
    ),
    
    array(
        'db' => 'stage_position',
        'dt' => 'position',
        'formatter' => function( $d, $row ) {
            $uniqueID = $row['stage_id'];
            $fieldName = 'position';
          return "
          <div 
          id='editable-$uniqueID' 
          data-id='$uniqueID' 
          style='position: relative; cursor: pointer;'
          onmouseover='$(this).find(\".fa-pencil\").show();'
          onmouseleave='$(this).find(\".fa-pencil\").hide();'
          onclick='openEditField($uniqueID, \"$fieldName\");'>
              <span id='value-$fieldName-$uniqueID'>$d</span>
              <span id='pen-$fieldName-$uniqueID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
          </div>
          <div  style='white-space: nowrap;'>
              <input type='number' class='form-control text-center' id='input-$fieldName-$uniqueID' value='' style='display:none;'>
              <button id='save-$fieldName-$uniqueID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
          </div>";
        },
        'field' => 'stage_position'
    ),
    array(
            'db' => 'stage_active',
            'dt' => 'active',
            'formatter' => function( $d, $row ) {
                $uniqueID = $row['stage_id'];
                $fieldName = 'active';
              return "
              <div 
              id='editable-$uniqueID' 
              data-id='$uniqueID' 
              style='position: relative; cursor: pointer;'
              onmouseover='$(this).find(\".fa-pencil\").show();'
              onmouseleave='$(this).find(\".fa-pencil\").hide();'
              onclick='openEditField($uniqueID, \"$fieldName\");'>
                  <span id='value-$fieldName-$uniqueID'>$d</span>
                  <span id='pen-$fieldName-$uniqueID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
              </div>
              <div  style='white-space: nowrap;'>
                  <select id='input-$fieldName-$uniqueID' style='display:none;' class='form-control' >
                        <option value='yes' " . ($d == 'yes' ? 'selected' : '') . ">yes</option>
                        <option value='no' " . ($d == 'no' ? 'selected' : '') . ">no</option>
                  </select>
              <button id='save-$fieldName-$uniqueID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
               </div>
               ";
            },
            'field' => 'stage_active'
        ),
array(
        'db' => 'stage_close_flag',
        'dt' => 'close_flag',
        'formatter' => function( $d, $row ) {
            $uniqueID = $row['stage_id'];
            $fieldName = 'closeFlag';
          return "
          <div 
              id='editable-$uniqueID' 
              data-id='$uniqueID' 
              style='position: relative; cursor: pointer;'
              onmouseover='$(this).find(\".fa-pencil\").show();'
              onmouseleave='$(this).find(\".fa-pencil\").hide();'
              onclick='openEditField($uniqueID, \"$fieldName\");'>
                    <span id='value-$fieldName-$uniqueID'>$d</span>
                    <span id='pen-$fieldName-$uniqueID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
          </div>
        <div  style='white-space: nowrap;'>
          <select id='input-$fieldName-$uniqueID' style='display:none;'  class='form-control'  >
            <option value='yes' " . ($d == 'yes' ? 'selected' : '') . ">yes</option>
            <option value='no' " . ($d == 'no' ? 'selected' : '') . ">no</option>
          </select>                          
          <button id='save-$fieldName-$uniqueID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
         </div>
          ";
        },
        'field' => 'stage_close_flag'
    ),
    
array(
        'db' => 'stage_color',
        'dt' => 'color',
        'formatter' => function( $d, $row ) {
            $uniqueID = $row['stage_id'];
            $fieldName = 'color';
            $colorIsChecked = empty($d) ? 'checked' : '';
            $displayValue = !empty($d) ? $d : '#ffffff'; 
            $displayColor = !empty($d) ? $d : 'transparent'; 


          return "
          <div 
              id='editable-$uniqueID' 
              data-id='$uniqueID' 
              style='position: relative; cursor: pointer;'
              onmouseover='$(this).find(\".fa-pencil\").show();'
              onmouseleave='$(this).find(\".fa-pencil\").hide();'
              onclick='initColorChange(\"noColor-$fieldName-$uniqueID\",\"stageColor-$fieldName-$uniqueID\",\"input-$fieldName-$uniqueID\");openEditField($uniqueID, \"$fieldName\");'>
                  <span style='color:$displayColor;background-color:$displayColor;border: 1px solid black;width:100px; !important' class='form-control' id='value-$fieldName-$uniqueID'>$displayValue</span>
                  <span id='pen-$fieldName-$uniqueID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
           </div>
           <div  style='white-space: nowrap;'>
               <div id='inputDiv-$fieldName-$uniqueID' style='display:none;'>
                    <label >No Color:<input type='checkbox' id='noColor-$fieldName-$uniqueID' style='margin: 0 5px;vertical-align: middle;width:35px;height:20px;' $colorIsChecked > </label>
                    <input type='color' class='form-control' id='stageColor-$fieldName-$uniqueID' style='width: 25%;' value='$displayValue'>
                    <input type='hidden' class='form-control text-center' id='input-$fieldName-$uniqueID' value='' style='display:none;'>
                  <button id='save-$fieldName-$uniqueID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
               </div>
            </div>
          ";
        },
        'field' => 'stage_color'
    )
);

// SQL server connection information
global $username,$password,$database;
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM CRM_Opportunity_Stages ";  // No joins needed for SC_Status table in this case
$where = ''; // Add any specific where clauses if needed


require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);

?>