<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');

// DB table to use
$table = 'Banks';

// Table's primary key
$primaryKey = "bank_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array(
        'db' => '`b`.`code`',
        'dt' => 'code',
        'field' => 'code'
    ),
    array(
        'db' => '`b`.`name`',
        'dt' => 'name',
        'field' => 'name'
    ),
    array(
        'db' => '`b`.`status`',
        'dt' => 'status',
        'formatter' => function ($d, $row) {
            if(strcmp("$d","yes")==0){
                $status = 'Active';
            } else {
                $status = "Inactive";
            }
            return $status;
        },
        'field' => 'status'
    ),
    
    array(
    'db' => '`b`.`bank_id`',
    'dt' => 'form',
    'formatter' => function ($d, $row) {
        global $username, $password, $database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT status FROM Banks WHERE bank_id = ?");
        $stm->bind_param("i", $d); 
        $stm->execute();
        $stm->bind_result($status);
        $stm->fetch(); 
        $stm->close();

        if (strcmp("$status", "yes") == 0) {
            $button2 = '
                <button id="a' . $d . '" class="btn btn-danger" onclick="deactivateButtonClicked(' . $d . ');" style="width:100px;margin-top:5px;padding-top:2px;">Deactivate</button>
            ';
        } else {
            $button2 = '
                <button id="a' . $d . '" class="btn btn-success" onclick="activateButtonClicked(' . $d . ');" style="width:100px;margin-top:5px;padding-top:2px;">Activate</button>
            ';
        }

        return
        //'<form target="_blank" id="view_' . $d . '" action="//' . HTML_PATH . '/cop/backend/core/views/view/view_bank.php" method="post" style="display:inline;">
            //     <input type="hidden" name="bank_id" value="' . $d . '">
            //     <input type="submit" class="btn btn-success" value="View" style="width:60px">
            // </form>
            //' . $button2 . '
            '<form target="_blank" id="edit_' . $d . '" action="//' . HTML_PATH . '/cop/backend/core/views/addedit/new_bank.php" method="post" style="display:inline;">
                <input type="hidden" name="bankID" value="' . $d . '">
                <input type="submit" class="btn btn-primary" value="Edit" style="width:60px;margin-top:5px;padding-top:2px;">
            </form>
             ' . $button2 . '
        ';
        
    },
    'field' => 'bank_id'
    )

 
    
);
global $username,$password,$database;
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Banks` AS `b`";  // No joins needed for Banks table in this case
$where = ''; // Add any specific where clauses if needed

$filterStatus = $_GET['filterStatus'];
if(isset($filterStatus) && strcmp("$filterStatus","")!=0){
    if(strcmp("$where","")!=0){$where .= "AND";}
    
    if(strcmp("$filterStatus","yes")==0){
        $where .= " `b`.`status` = 'yes' ";
    } else {
        $where .= " NOT `b`.`status` = 'yes' ";
    }
    
}

require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);

?>
