<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */

include_once('../../../../param.php');

// DB table to use
$table = 'Action_Numbering';

// Table's primary key
$primaryKey = "numbering_id";

// Array of database columns which should be read and sent back to DataTables.
// The db parameter represents the column name in the database, while the dt
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array(
        'db' => 'CONCAT(c.company_code," ",c.company_name)',
        'dt' => 'company',
        'field' => 'company',
        'as' => 'company'

    ),
    array(
        'db' => 'CONCAT(s.salesperson_code," ",s.first_name," ",s.last_name)',
        'dt' => 'salesperson',
        'field' => 'salesperson',
        'as' => 'salesperson'
    ),

    array(
        'db' => 'a.action',
        'dt' => 'action',
        'field' => 'action'
    ),
    array(
        'db' => 'a.prefix',
        'dt' => 'prefix',
        'field' => 'prefix'
    ),
    array(
        'db' => 'a.preceding_device_prefix',
        'dt' => 'device_prefix',
        'field' => 'preceding_device_prefix'
    ),
    array(
        'db' => 'a.begin_number',
        'dt' => 'begin_number',
        'field' => 'begin_number'
    ),

    array(
        'db' => 'a.title',
        'dt' => 'title',
        'field' => 'title'
    ),
    array(
        'db' => 'a.details',
        'dt' => 'details',
        'field' => 'details'
    ),
    array(
        'db' => 'a.notes',
        'dt' => 'notes',
        'field' => 'notes'
    ),
    array(
        'db' => 'a.position',
        'dt' => 'position',
        'field' => 'position'
    ),
    array(
        'db' => 'a.active',
        'dt' => 'active',
        'field' => 'active'
    ),


    array(
        'db' => 'a.numbering_id',
        'dt' => 'form',
        'formatter' => function ($d, $row) {
            $active = $row['active'];

            if(strcmp(strtolower($active), "yes") == 0)
            {
                $activateButton='<button   id="a'.$d.'" class="btn btn-danger" onclick="deactivateButtonClicked('.$d.');" style="margin-bottom: 1px; width:100px">Deactive</button>';
            }
            else{
                $activateButton= '
			<button  id="a'.$d.'"  class="btn btn-success" onclick="activateButtonClicked('.$d.');" style="margin-bottom: 1px;width:100px" >Active</button>
			';
            }

            $editButton = '	<button class="btn btn-primary" onclick="openEditModal('.$d.');" >Edit</button>';


            return $activateButton . $editButton;

        },
        'field' => 'numbering_id'
    )



);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM Action_Numbering as a LEFT JOIN Companies AS c ON a.company_id = c.company_id LEFT JOIN SalesPersons AS s ON a.salesperson_id = s.salesperson_id";
$where = ''; // Add any specific where clauses if needed


require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);

?>
