<?php
include("../../../../param.php");

// DB table to use
$table = 'Items';

// Table's primary key
$primaryKey = "item_code";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`i`.`item_id`', 'dt' => 'image', 'formatter' => function( $d, $row ) {
        global $username,$password,$database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $check = false;
        $stm = $db->prepare("SELECT thumbnail_url FROM Items WHERE item_id='$d'");
        $stm->execute();
        $stm->bind_result($imgName);

        while ($stm->fetch()) {
            if(strcmp($imgName,'')!=0) {
                $d = "//" . HTML_PATH . "/cop/media/productImages/$imgName.jpg";
                if (file_exists(ROOT . "media/productImages/$imgName.jpg")) {
                    $check = true;
                }
            }

        }
        $stm->close();
        if(!$check) {
            $d = "//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/itemdefaulticon.jpg";
        }
        return '<a  data-toggle="modal" data-target="#imageModal" onclick="showImage(\''.$d.'\')"><img class="img-responsive img-rounded center-canvas" src="'.$d.'" width="40" height="40"></a></td>';},
        'field' => 'item_id' ),

    array( 'db' => '`i`.`item_id`', 'dt' =>  'delete', 'formatter' => function( $d, $row ) {
        $GLOBALS['item_id']=$d;
        return "<img class='deletRowButton' onclick='deleteRow(this);' data-item='$d' src='//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/deleteicon.png' style='width:20px;height:20px;opacity:0' onMouseOver='$(this).css(\"opacity\",\"1\")' onMouseOut='$(this).css(\"opacity\",\"0\")' />";
    }, 'field' =>'item_id' ),
    array( 'db' => '`i`.`status`', 'dt' =>  'status', 'formatter' => function( $d, $row ) {
        $GLOBALS['status']=$d;
        return $d;
    }, 'field' =>'status' ),
    array( 'db' => '`i`.`item_code`', 'dt' =>  'code', 'field' =>'item_code' ),
    array( 'db' => '`i`.`name`', 'dt' => 'name','formatter' => function( $d, $row ) {
        $status = $GLOBALS['status'];
        if(strcmp($status,'inactive')==0){
            return $d." <b style='color:firebrick'>(Inactive)</b>";
        } else {
            return $d;
        }
    } , 'field' => 'name' ),
    array( 'db' => '`i`.`item_sku`', 'dt' => 'sku' , 'field' => 'item_sku' ),
    array( 'db' => '`v`.`vat_display_name`', 'dt' => 'vat', 'field' => 'vat_display_name' ),
    array( 'db' => '`p`.`allow_discount`', 'dt' => 'allow_discount', 'formatter' => function( $d, $row ) {
        $GLOBALS['allow_discount'] = $d;
        $itemID = $GLOBALS['item_id'];
        return "<input type='number' id='allowDiscount' onchange='changePrice(this,$itemID);' class='form-control text-center' value='$d'/>";
    } , 'field' => 'allow_discount' ),
    array( 'db' => '`p`.`price`', 'dt' => 'price', 'formatter' => function( $d, $row ) {
        $allowDiscount =  $GLOBALS['allow_discount'];
        $itemID = $GLOBALS['item_id'];
        $price = $d / (1 - (floatval($allowDiscount))/100);
        return "<input type='number' id='price' onchange='changePrice(this,$itemID);' class='form-control text-center' value='$price'/>";
    } , 'field' => 'price' ),

    array( 'db' => '`p`.`price`', 'dt' => 'final_price', 'formatter' => function( $d, $row ) {
        return "$d";
    } , 'field' => 'price' ),
    array( 'db' => '`p`.`inc_vat`', 'dt' => 'inc_vat', 'formatter' => function( $d, $row ) {
        $itemID = $GLOBALS['item_id'];
        $result = "<select id='incVat' onchange='changePrice(this,$itemID);' class='form-control text-center' style='width: fit-content;white-space: nowrap;'>";
        if(strcmp("$d","yes")==0){
            $result .= "<option value='yes' selected>Yes</option><option value='no'>No</option>";
        } else {
            $result .= "<option value='yes'>Yes</option><option value='no' selected>No</option>";
        }
        $result .= "</select>";

        return "$result";
    } , 'field' => 'inc_vat' ),




);


$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);

if(isset($_GET['priceTypeID']) && strcmp($_GET['priceTypeID'],'')!=0) {
    $where = " `p`.`pricetype_id` = " . intval($_GET['priceTypeID']);
} else {
    $where = ' 0=1 ';
}
if(isset($_SESSION['Allow_Items']) && strcmp($_SESSION['Allow_Items'],'')!=0){
    $where .= " AND `i`.`item_id` IN (".$_SESSION['Allow_Items'].")";
}
$joinQuery = "FROM `Items` AS `i` INNER JOIN `Prices` AS `p` ON (`i`.`item_id` = `p`.`item_id`) LEFT JOIN `Vats` AS `v` ON (`i`.`vat_id` = `v`.`vat_id`)";
require(ROOT . '/backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>