<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');
// DB table to use
$table = 'Item_Images';

// Table's primary key
$primaryKey = "item_image_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`ii`.`item_image_id`', 'dt' => 'item_image_id', 'formatter' => function( $d, $row ) {
        $GLOBALS['imageID'] = $d;
        return '';

    },'field' => 'item_image_id' ),
    array( 'db' => '`ii`.`image_name`', 'dt' => 'img', 'formatter' => function( $d, $row ) {
        $GLOBALS['imageFile'] = $d;
        if(file_exists(ROOT . "media/productImages/$d.jpg")) {
            $itemImageUrl = "//" . HTML_PATH . "/cop/media/productImages/$d.jpg";
        } else {
            $itemImageUrl = "//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/itemdefaulticon.jpg";
        }
        return '<img class="img-responsive img-rounded center-canvas" style="width:80px;height:80px;" src="'.$itemImageUrl.'" width="80" height="80"/>';

    },'field' => 'image_name' ),
    array( 'db' => '`ii`.`image_name`', 'dt' =>  'name', 'field' =>'image_name' ),
    array( 'db' => '`ii`.`image_order`', 'dt' => 'position', 'formatter' => function( $d, $row ) {
        $id = $GLOBALS['imageID'];
        return "<input type='number' class='form-control text-center' onchange='changeImagePosition(this);' data-imageid='$id' value='$d'>";
    }, 'field' => 'image_order' ),
    array( 'db' => '`i`.`thumbnail_url`', 'dt' => 'default', 'formatter' => function( $d, $row ) {
        $id = $GLOBALS['imageID'];
        $f  = $GLOBALS['imageFile'];

        if(strcmp($d,$f)==0){
            $defaultItemImageCheck = 'checked';
        } else {
            $defaultItemImageCheck = '';
        }

        return "<td class='text-center'> <label><strong><input type='checkbox' class='setDefaultImageCheck' style='width: 30px;height:30px;' onclick='setDefaultImage($id,this);' $defaultItemImageCheck></strong></label></td>";

    },'field' => 'thumbnail_url' ),

    array(  'db' => '`ii`.`item_image_id`', 'dt' => 'gallery', 'formatter' => function( $d, $row ) {

        return "<td class='text-center'> <label><strong><input type='checkbox' class='setDefaultImageCheck' name='gallery' value='$d' style='width: 30px;height:30px;'></strong></label></td>";

    },'field' => 'item_image_id' ),

);

// SQL server connection information
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Item_Images` AS `ii` INNER JOIN `Items` AS `i` ON (`ii`.`item_id`=`i`.`item_id`) ";
if(isset($_GET['itemID']) && $_GET['itemID'] > 0){
    $where = ' ii.item_id='.$_GET['itemID'];

} else {
    $where = ' 0=1 ';

}

require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>