<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");

$stockTakingItemID  = trim($_POST['stockTakingItemID']);
$fieldOption = trim($_POST['field']);
$value       = trim($_POST['value']);

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
     printf("Connect failed: %s\n", mysqli_connect_error());
     exit();
}
$db->set_charset("utf8");

try {
    $db->begin_transaction();

    switch ($fieldOption) {

        case 'batchNumber':

            if(strcmp($value,"")==0) {$value = 0;}
            $stm = $db->prepare("SELECT batch_number FROM Stock_Taking_Item WHERE stock_taking_item_id=? LIMIT 1");
            $stm->bind_param('i', $stockTakingItemID);
            $stm-> execute();
            $stm-> bind_result($prevBatchNumberBinLocation);
            while ($stm->fetch()) {
                if (strpos($prevBatchNumberBinLocation,';BIN;')==true){
                    $prevBatchNumberBinLocationArray = explode(';BIN;',$prevBatchNumberBinLocation);
                    $value = $value . ';BIN;' . $prevBatchNumberBinLocationArray[1];
                }
            }
            $stm-> close();

            $stmt = $db->prepare("UPDATE Stock_Taking_Item SET batch_number = ?  WHERE stock_taking_item_id = ?");
            $stmt->bind_param('si', $value, $stockTakingItemID);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception();}
            $stmt->close();

            break;
        case 'binLocation':

            if(strcmp($value,"")==0) {$value = 0;}
            $stm = $db->prepare("SELECT batch_number FROM Stock_Taking_Item WHERE stock_taking_item_id=? LIMIT 1");
            $stm->bind_param('i', $stockTakingItemID);
            $stm-> execute();
            $stm-> bind_result($prevBatchNumberBinLocation);
            while ($stm->fetch()) {
                if (strpos($prevBatchNumberBinLocation,';BIN;')==true){
                    $prevBatchNumberBinLocationArray = explode(';BIN;',$prevBatchNumberBinLocation);
                    $value = $prevBatchNumberBinLocationArray[0] . ';BIN;' . $value;
                }
            }
            $stm-> close();

            $stmt = $db->prepare("UPDATE Stock_Taking_Item SET batch_number = ?  WHERE stock_taking_item_id = ?");
            $stmt->bind_param('si', $value, $stockTakingItemID);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception();}
            $stmt->close();

            break;
        case 'qty':

            $stmt = $db->prepare("UPDATE Stock_Taking_Item SET qty = ?  WHERE stock_taking_item_id = ?");
            $stmt->bind_param('ii', $value, $stockTakingItemID);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception();}
            $stmt->close();

            break;
        case 'item':

            $stmt = $db->prepare("UPDATE Stock_Taking_Item SET item_id = ?  WHERE stock_taking_item_id = ?");
            $stmt->bind_param('ii', $value, $stockTakingItemID);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception();}
            $stmt->close();

            break;
        case 'remove':

            $stmt = $db->prepare("DELETE FROM Stock_Taking_Item WHERE stock_taking_id = ? AND stock_taking_item_id = ?");
            $stmt->bind_param('ii', $value, $stockTakingItemID);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception();}
            $stmt->close();

            $deleteID = getNextKey("Deletes", "delete_id");
            $statement ="DELETE FROM Stock_Taking_Item WHERE stock_taking_id = '$value' AND stock_taking_item_id = '$stockTakingItemID'";

            $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
            $stmt->bind_param('is',$deleteID,$statement);
            $stmt->execute();
            $stmt->close();

            break;
        default:
            throw new Exception();
    }



    $db->commit(true);

    echo "success";

} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}





?>