<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

$tenderID           = trim(''.$_POST['tenderID']);
$tenderCode         = trim(''.$_POST['tenderCode']);
$customerID         = trim(''.$_POST['customerID']);
$tenderDate         = trim(''.$_POST['tenderDate']);
$currencyID         = trim(''.$_POST['currencyID']);
$salespersonSearch  = trim(''.$_POST['salespersonSearch']);
$subtotal           = trim(''.$_POST['subtotal']);
$discount           = trim(''.$_POST['discount']);
$vatTotal           = trim(''.$_POST['vatTotal']);
$grandTotal         = trim(''.$_POST['grandTotal']);
$details            = trim(''.$_POST['details']);

$status = "Placed";

$orderItems         = array();
$orderItems         = json_decode($_POST['tenderItems'], true);


global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

try {
    $db->begin_transaction();

    if (isset($tenderDate) && strcmp("$tenderDate", "") != 0) {
        $date = DateTime::createFromFormat('d/m/Y', $tenderDate);
        $tenderDate = $date->format('Y-m-d');
    }

    if (strpos($discount, '%') !== false) {
        $globalDiscountPercentage = str_replace("%", "", $discount);
        $discount = $subtotal * floatval($globalDiscountPercentage) / 100;
    } else {
        $globalDiscountPercentage = 0;
    }

    lockDocumentSingleTransaction($tenderID, "Tenders", $db);

    $stmt = $db->prepare("SELECT status FROM Tenders WHERE tender_id='$tenderID'");
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->bind_result($prevStatus);
    while ($stmt->fetch()) {
        if (strcmp($prevStatus, '') != 0) {
            $status = $prevStatus;
        }
    }
    $stmt->close();

    $stmt = $db->prepare("DELETE FROM Tenders WHERE tender_id=?");
    $stmt->bind_param('i', $tenderID);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    $deleteID  = getNextKeySingleTransaction("Deletes", "delete_id", $db);
    $statement = "DELETE FROM Tenders WHERE tender_id=$tenderID";

    $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt->bind_param('is', $deleteID, $statement);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    $stmt = $db->prepare("INSERT INTO Tenders (tender_id,tender_code,customer_id,salesperson_id,subtotal,grand_total,vat_amount,discount_amount,tender_date,details,global_discount_percentage,status,currency_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiddddssdsi', $tenderID, $tenderCode, $customerID, $salespersonSearch, $subtotal, $grandTotal, $vatTotal, $discount, $tenderDate, $details, $globalDiscountPercentage, $status, $currencyID);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    $stmt = $db->prepare("DELETE FROM Tender_Item WHERE tender_id=?");
    $stmt->bind_param('i', $tenderID);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    $deleteID  = getNextKeySingleTransaction("Deletes", "delete_id", $db);
    $statement = "DELETE FROM Tender_Item WHERE tender_id=$tenderID";

    $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt->bind_param('is', $deleteID, $statement);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    $lineTotals = 0;
    $lineDiscountTotals = 0;
    $itemsCounter = 0;

    if(count($orderItems) == 0) {throw new Exception();}

    foreach ($orderItems as $orderItem) {

        $itemID = $orderItem['itemID'];

        if ($itemID > 0) {

            $itemsCounter++;

            $qty            = $orderItem['Qty'];
            $unitPrice      = $orderItem['UP'];
            $lineDiscount   = $orderItem['LD'];
            $priceType      = $orderItem['PC'];
            $globalDiscount = $orderItem['globalDiscount'];
            $vatTotal       = $orderItem['vatLine'];
            $vatCode        = $orderItem['VAT'];
            $itemNotes      = $orderItem['Notes'];
            $subunits       = getSubUnits($itemID, $db);
            $vatID          = getVatID($vatCode, $db);

            $qty = floatval($qty);
            $unitPrice = floatval($unitPrice);
            $lineDiscount = floatval($lineDiscount);
            $globalDiscount = floatval($globalDiscount);
            $vatTotal = floatval($vatTotal);

            if (strpos($lineDiscount, '%') !== false) {
                $lineDiscountSelectedPercentage = str_replace("%", "", $lineDiscount);
                $lineDiscount = ($qty / $subunits) * $unitPrice * ($lineDiscountSelectedPercentage / 100);
            } else {
                $lineDiscountSelectedPercentage = 0;
            }

            $lineTotals += $unitPrice * $qty / $subunits;
            $lineDiscountTotals += $lineDiscount;

            $tenderItemID = getNextKeySingleTransaction("Tender_Item", "tender_item_id", $db);

            $stmt = $db->prepare("INSERT INTO Tender_Item (tender_item_id,tender_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iiidddddiids', $tenderItemID, $tenderID, $itemID, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID, $lineDiscountSelectedPercentage, $itemNotes);
            $stmt->execute();
            $stmt->close();

            $custTable = new CustomTable('Tender_Item', $tenderItemID);
            $codes = array();
            $codes = $custTable->getCustomTableCodes($db);
            foreach ($codes as $code) {
                $custTable->insertVariablesToCustomTableLine($orderItem, $code->tableCode, $db);
            }

        }

    }

    $discount = floatval($discount);
    $discount += $lineDiscountTotals;

    $stmt = $db->prepare("UPDATE  Tenders SET subtotal =? ,discount_amount=? WHERE tender_id=?");
    $stmt->bind_param('ddi', $lineTotals, $discount, $tenderID);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    $custTable = new CustomTable('Tenders', $tenderID);
    $codes = array();
    $codes = $custTable->getCustomTableCodes($db);
    foreach ($codes as $code) {
        $custTable->insertVariablesToCustomTable($_POST[$code->formCode], $code->tableCode, $db);
    }

    $db->commit(true);

    echo "$tenderID";

} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}

$custForm = new CustomForm('Tenders',$tenderID);
$codes = array();
$codes = $custForm->getFormCodes();
foreach ($codes as $code) {
    $custForm->insertVariablesToCustomForm($_POST[$code], $code);
}




				
	
	

	
function redirect($url)
{
	if (headers_sent())
	{
		die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
	}
	else
	{
		header('Location: ' . $url);
		die();
	}    
}

function getVatID($vatCode,$db)
{

    $z="";
    $stm1 = $db->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        $z=$counter;
    }
    $stm1->close();


    return $z;



}

function getSubUnits($itemID,$db) {
    $subunits = 1;
    $stm1 = $db->prepare("SELECT subunits FROM Items WHERE item_id='$itemID' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($sub);
    while ($stm1->fetch()) {
        return $sub;
    }
    $stm1->close();
    return $subunits;


}

function updateCustomerBalance($customerID,$amount)
{
 global $username;
 global $password;
 global $database;
 $db = new mysqli(localhost,$username,$password,$database);
 if (mysqli_connect_errno())
 {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db->set_charset("utf8");
 $stmt = $db->prepare("UPDATE  Customers SET balance = balance + ? WHERE customer_id=?");
 $stmt->bind_param('di',$amount,$customerID);
 $stmt->execute();
 $stmt->close();

}
?>