<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

$companyID         = $_SESSION['companyID'];
$orderID           = trim(''.$_POST['orderID']);
$orderCode         = trim(''.$_POST['orderCode']);
$customerID        = trim(''.$_POST['customerID']);
$deliveryAddress   = trim(''.$_POST['deliveryAddress']);
$billingAddress    = trim(''.$_POST['billingAddress']);
$orderDate         = trim(''.$_POST['orderDate']);
$currencyID        = trim(''.$_POST['currencyID']);
$dueDate           = trim(''.$_POST['dueDate']);
$paymentMethod     = trim(''.$_POST['paymentMethod']);
$salespersonSearch = trim(''.$_POST['salespersonSearch']);
$warehouseSearch   = trim(''.$_POST['warehouseSearch']);
$subtotal          = trim(''.$_POST['subtotal']);
$discount          = trim(''.$_POST['discount']);
$vatTotal          = trim(''.$_POST['vatTotal']);
$grandTotal        = trim(''.$_POST['grandTotal']);
$details           = trim(''.$_POST['details']);
$status            = "Placed";

$orderItems        = array();
$orderItems        = json_decode($_POST['orderItems'], true);

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

try {
    $db->begin_transaction();

    if(isset($orderDate)) {
        $orderDate = date_format( date_create_from_format('d/m/Y', $orderDate), 'Y-m-d');
    } else {
        $orderDate = date('Y-m-d');
    }

    if(isset($dueDate) AND strcmp($dueDate,"")!=0) {
        $dueDate = date_format( date_create_from_format('d/m/Y', $dueDate), 'Y-m-d');
    }

    if(strpos($discount, '%') !== false)
    {
        $globalDiscountPercentage=str_replace("%","",$discount);
        $discount=$subtotal*$globalDiscountPercentage/100;
    } else {
        $globalDiscountPercentage=0;
    }

    include_once(ROOT . 'backend/core/model/ActionAutomation.php');
    $automation = new ActionAutomation($db, ROOT, HTML_PATH, 'Orders', 'order_id', $orderID);

    lockDocumentSingleTransaction($orderID, "Orders",$db);

    $stmt = $db->prepare("SELECT status FROM Orders WHERE order_id='$orderID'");
    $stmt->execute();
    $stmt->bind_result($prevStatus);
    while ($stmt->fetch()) {if(strcmp($prevStatus,'')!=0){$status=$prevStatus;}}
    $stmt->close();

    $stmt = $db->prepare("DELETE FROM Orders WHERE order_id=?");
    $stmt->bind_param('i', $orderID);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    $deleteID = getNextKeySingleTransaction("Deletes", "delete_id",$db);
    $statement = "DELETE FROM Orders WHERE order_id=$orderID";
    $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt->bind_param('is', $deleteID, $statement);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();


    $stmt = $db->prepare("INSERT INTO Orders (order_id,order_code,company_id,customer_id,salesperson_id,paymenttype_id,subtotal,grand_total,vat_amount,discount_amount,order_address_id,delivery_address_id,order_date,delivery_date,details,global_discount_percentage,status, delivery_method,currency_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiiiddddiisssdssi', $orderID, $orderCode, $companyID, $customerID, $salespersonSearch, $paymentMethod, $subtotal, $grandTotal, $vatTotal, $discount, $billingAddress, $deliveryAddress, $orderDate, $dueDate, $details, $globalDiscountPercentage, $status, $warehouseSearch, $currencyID);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();


    $orderItemsForSockArray = getStockUpdateLinesOfDocument($db, 2, $orderID);

    foreach ($orderItemsForSockArray as $itemObject) {

        $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $itemObject->warehouseID, $itemObject->itemID, $itemObject->batchNumber, -$itemObject->available, -$itemObject->reserved, -$itemObject->delivered, -$itemObject->onOrder, -$itemObject->requested, -$itemObject->sold, "0000-00-00", 2, $orderID, $orderCode, 'Edit Order (Remove)', 0, null, null, 0, null);
        if(!$insertStockUpdateStatementResult){throw new Exception();}


        $insertStockStatementResult = insertStockRecord($db, $itemObject->warehouseID, $itemObject->itemID, $itemObject->batchNumber, -$itemObject->available, -$itemObject->reserved, -$itemObject->delivered, -$itemObject->onOrder, -$itemObject->requested, -$itemObject->sold, '0000-00-00');
        if(!$insertStockStatementResult){throw new Exception();}

    }

    $stmt = $db->prepare("DELETE FROM Order_Item WHERE order_id=?");
    $stmt->bind_param('i', $orderID);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    $deleteID = getNextKeySingleTransaction("Deletes", "delete_id",$db);
    $statement = "DELETE FROM Order_Item WHERE order_id=$orderID";
    $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt->bind_param('is', $deleteID, $statement);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    $lineTotals         = 0;
    $lineDiscountTotals = 0;
    $itemsCounter       = 0;

    if(count($orderItems) == 0) {throw new Exception();}

    foreach ($orderItems as $orderItem) {

        $itemID = $orderItem['itemID'];

        if ($itemID > 0) {
            $itemsCounter++;

            $itemNotes      = $orderItem['Notes'];
            $qty            = $orderItem['Qty'];
            $qtyInvoiced    = $orderItem['qtyInvoiced'];
            $unitPrice      = $orderItem['UP'];
            $lineDiscount   = $orderItem['LD'];
            $priceType      = $orderItem['PC'];
            $globalDiscount = $orderItem['globalDiscount'];
            $vatTotal       = $orderItem['vatLine'];
            $vatCode        = $orderItem['VAT'];

            $vatID          = getVatID($vatCode,$db);
            $subunits       = getSubUnits($itemID,$db);
            $orderItemID    = getNextKeySingleTransaction( "Order_Item", "order_item_id",$db);

            $batchNumber    = '0';

            if (strpos($lineDiscount, '%') !== false) {
                $lineDiscountSelectedPercentage = str_replace("%", "", $lineDiscount);
                $lineDiscount = ($qty / $subunits) * $unitPrice * ($lineDiscountSelectedPercentage / 100);
            } else {
                $lineDiscountSelectedPercentage = 0;
            }

            $lineTotals += floatval($unitPrice) * $qty / $subunits;
            $lineDiscountTotals += floatval($lineDiscount);

            $stmt = $db->prepare("INSERT INTO Order_Item (order_item_id,order_id,item_id,qty,qty_invoiced, unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iiiddddddiids', $orderItemID, $orderID, $itemID, $qty, $qtyInvoiced, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID, $lineDiscountSelectedPercentage, $itemNotes);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception();}
            $stmt->close();

            $reserved = $qty;
            $insertStockStatementResult = insertStockRecord($db, $warehouseSearch, $itemID, $batchNumber, 0, $reserved, 0, 0, 0, 0, '0000-00-00');
            if(!$insertStockStatementResult){throw new Exception();}

            $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $warehouseSearch, $itemID, $batchNumber, 0, $reserved, 0, 0, 0, 0, "0000-00-00", 2, $orderID, $orderCode, 'Edit Order (Add)', 0, null, null, 0, null);
            if(!$insertStockUpdateStatementResult){throw new Exception();}

            $custTable = new CustomTable('Order_Item', $orderItemID);
            $codes = array();
            $codes = $custTable->getCustomTableCodes($db);
            foreach ($codes as $code) {
                $custTable->insertVariablesToCustomTableLine($orderItem, $code->tableCode, $db);
            }

            $uomID = $orderItem['uomID'];
            if(intval($uomID) > 0) {
                $custForm = new CustomForm('Order_Item',$orderItemID);
                $custForm->insertCustomUOM($uomID,$db);
            }

        }

    }

    $discount += $lineDiscountTotals;
    $stmt = $db->prepare("UPDATE  Orders SET subtotal =? ,discount_amount=? WHERE order_id=?");
    $stmt->bind_param('ddi', $lineTotals, $discount, $orderID);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();


    $custTable = new CustomTable('Orders', $orderID);
    $codes = array();
    $codes = $custTable->getCustomTableCodes($db);
    foreach ($codes as $code) {
        $custTable->insertVariablesToCustomTable($_POST[$code->formCode], $code->tableCode, $db);
    }

    $automation->executeAutomations();

    $db->commit(true);

    echo "$orderID";

} catch (Exception  $e) {
    echo 'error '.$e->getMessage().' '.$e->getLine();
    $db->rollback();
}

$custForm = new CustomForm('Orders',$orderID);
$codes = array();
$codes = $custForm->getFormCodes();
foreach ($codes as $code) {
    $custForm->insertVariablesToCustomForm($_POST[$code], $code);
}






 
				
	
	

	
function redirect($url)
{
	if (headers_sent())
	{
		die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
	}
	else
	{
		header('Location: ' . $url);
		die();
	}    
}

function getVatID($vatCode,$db)
{

    $z="";
    $stm1 = $db->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        $z=$counter;
    }
    $stm1->close();


    return $z;



}

function getSubUnits($itemID,$db) {

    $stm1 = $db->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($sub);
    while ($stm1->fetch()) {
        return $sub;
    }
    $stm1->close();
    return $sub;


}

function updateCustomerBalance($customerID,$amount)
{
 global $username;
 global $password;
 global $database;
 $db = new mysqli(localhost,$username,$password,$database);
 if (mysqli_connect_errno())
 {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db->set_charset("utf8");
 $stmt = $db->prepare("UPDATE  Customers SET balance = balance + ? WHERE customer_id=?");
 $stmt->bind_param('di',$amount,$customerID);
 $stmt->execute();
 $stmt->close();

}
?>