<?php
include_once("../../../../param.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
$text = trim(''.$_POST['text']);
$days = trim(''.$_POST['days']);
$newCustomerID = intval(trim(''.$_POST['customer']));

if(isset($_POST['old_customer'])){
    $oldCustomerID = intval(trim(''.$_POST['old_customer'])); //edit
}
else{
    $oldCustomerID=0; // add
}

if(empty($newCustomerID)){
    return;
}

global $username, $password, $database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

if(($oldCustomerID != $newCustomerID) || $oldCustomerID <= 0) {
    $stm = $db->prepare("SELECT customer_id FROM Customer_Payment_Terms WHERE customer_id = ? LIMIT 1");
    $stm->bind_param("i", $newCustomerID);
    $stm->execute();
    $stm->bind_result($existingCustomerID);
    $stm->fetch();
    $stm->close();
    $existingCustomerID = intval($existingCustomerID);
    if ($existingCustomerID > 0) {
        echo "existingCustomer";
        return;
    }
}


if($oldCustomerID > 0){

    $stmt = $db->prepare("UPDATE Customer_Payment_Terms SET customer_id = ?,payment_term_text = ?, payment_term_days = ? WHERE customer_id = ?");
    $stmt->bind_param('isii',$newCustomerID, $text,$days,$oldCustomerID);
    $stmt->execute();
    $error = $stmt->error;
    $stmt->close();
} else {

    $stmt = $db->prepare("INSERT INTO Customer_Payment_Terms (customer_id,payment_term_text,payment_term_days, timestamp) VALUES (?,?,?,NOW())");
    $stmt->bind_param('isi',$newCustomerID,$text,$days);
    $stmt->execute();
    $error = $stmt->error;
    $stmt->close();

}


if($error){
    echo 'error';
    exit();
}





?>