<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

$returnID = trim($_POST['returnID']);
$myfile = fopen(ROOT."/logs/deletedRecords-".date('d-m-Y').".txt", "a") or die("Unable to open file!");
global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

$stmt = $db->prepare("SELECT return_id, return_code, company_id, customer_id, salesperson_id, paymenttype_id, order_id, subtotal, grand_total, vat_amount, vat_i_e, discount_amount, return_address_id, print_count, return_date, details, status, currency_id, global_discount_percentage, return_type, timestamp FROM Returns WHERE return_id='$returnID'");
$stmt->execute();
$stmt->bind_result($returnID, $returnCode, $companyID, $customerID, $salespersonID, $paymentTypeID, $orderID, $subtotal, $grandTotal, $vatAmount, $vatIorE, $discountAmount, $returnAddressID, $printCount, $returnDATE, $details, $status, $currencyID, $globalDiscountPercentage, $returnType, $timestamp);
while ($stmt->fetch()) {}
$stmt->close();

$hasInvoice = false;
$stmt = $db->prepare("SELECT invoice_id FROM Invoice_Return WHERE return_id='$returnID' LIMIT 1");
$stmt->execute();
$stmt->bind_result($invoiceID);
while ($stmt->fetch()) {if($invoiceID > 0){$hasInvoice = true;}}
$stmt->close();

$type = 'Return';
$adminID=$_SESSION['adminID'];
$cancelledID = getNextKey("Cancelled_Actions", "cancelled_id");
$stmt = $db->prepare("INSERT INTO Cancelled_Actions (cancelled_id,type,code,customer_id,salesperson_id,user_id,discount_amount,subtotal,vat_amount,grand_total,date,time_canceled,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,NOW(),NOW())");
$stmt->bind_param('issiiidddds',$cancelledID,$type,$returnCode,$customerID,$salespersonID,$adminID,$discountAmount,$subtotal,$vatAmount,$grandTotal,$returnDATE);
$stmt->execute();
$stmt->close();

fwrite($myfile,"\n$type|$returnCode|$returnType|$subtotal|$discountAmount|$vatAmount|$grandTotal|");

if(strcmp($returnType,"Credit")==0) {
    updateCustomerBalance($customerID, $grandTotal);
    fwrite($myfile,"Update Customer Balance|");
} else {
    fwrite($myfile,"Keep Customer Balance|");
}

$lockedDocumentType = "Returns";
$stmt = $db->prepare("DELETE FROM ZD_Lock_Document WHERE document_id=? AND document_type=?");
$stmt->bind_param('is', $returnID, $documentType);
$stmt->execute();
$stmt->close();
fwrite($myfile,"Remove Locked Document|");

$stmt = $db->prepare("DELETE FROM Returns WHERE return_id=?");
$stmt->bind_param('i',$returnID);
$stmt->execute();
$stmt->close();

$deleteID = getNextKey("Deletes", "delete_id");
$statement ="DELETE FROM Returns WHERE return_id=$returnID";
$stmt2 = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
$stmt2->bind_param('is',$deleteID,$statement);
$stmt2->execute();
$stmt2->close();
fwrite($myfile,"Remove Header|");

$detailsTra="Return $returnCode";
$stmt = $db->prepare("DELETE FROM Transactions WHERE transaction_code=?");
$stmt->bind_param('s',$returnCode);
$stmt->execute();
$stmt->close();

$deleteID = getNextKey("Deletes", "delete_id");
$statement ="DELETE FROM Transactions WHERE transaction_code=\"$returnCode\"";
$stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
$stmt->bind_param('is',$deleteID,$statement);
$stmt->execute();
$stmt->close();
fwrite($myfile,"Remove Transactions|");

$stmt = $db->prepare("SELECT item_id,batch_number,warehouse_id,qty FROM Return_Item WHERE return_id='$returnID'");
$stmt->execute();
$stmt->bind_result($itemID, $batchNumber, $warehouseID, $qty);
while ($stmt->fetch()) {
    $db2 = new mysqli('localhost', $username, $password, $database);
    if(mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    if(strcmp($batchNumber, '') == 0) {$batchNumber = '0';}
    $available = -$qty;
    $db2->set_charset("utf8");
    $stmt2 = $db2->prepare("INSERT INTO Stock (warehouse_id,item_id,batch_number,available) VALUES(?,?,?,?) ON DUPLICATE KEY UPDATE available=available+?");
    $stmt2->bind_param('iisdd', $warehouseID, $itemID, $batchNumber, $available, $available);
    $stmt2->execute();
    $stmt2->close();



}
$stmt->close();
fwrite($myfile,"Update Stock|");

if($hasInvoice) {

    $stmt = $db->prepare("DELETE FROM Invoice_Return WHERE return_id=?");
    $stmt->bind_param('i',$returnID);
    $stmt->execute();
    $stmt->close();

    $deleteID = getNextKey("Deletes", "delete_id");
    $statement ="DELETE FROM Invoice_Return WHERE return_id=$returnID";
    $stmt2 = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt2->bind_param('is',$deleteID,$statement);
    $stmt2->execute();
    $stmt2->close();
    fwrite($myfile,"Remove Return Link|");

}

$stmt = $db->prepare("DELETE FROM Return_Item WHERE return_id=?");
$stmt->bind_param('i',$returnID);
$stmt->execute();
$stmt->close();

$deleteID = getNextKey("Deletes", "delete_id");
$statement ="DELETE FROM Return_Item WHERE return_id=$returnID";
$stmt2 = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
$stmt2->bind_param('is',$deleteID,$statement);
$stmt2->execute();
$stmt2->close();
fwrite($myfile,"Remove Return Lines|");
fwrite($myfile,"Removed");

redirect("//" .  HTML_PATH . "/cop/backend/core/views/manage/manage_returns.php");

function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

function updateCustomerBalance($customerID,$amount)
{
    global $username;
    global $password;
    global $database;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");
    $stmt1 = $db1->prepare("UPDATE  Customers SET balance = balance + ? WHERE customer_id=?");
    $stmt1->bind_param('di',$amount,$customerID);
    $stmt1->execute();
    $stmt1->close();

}



?>