<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

$companyID          = $_SESSION['companyID'];
$customerID         = trim(''.$_POST['customerID']);
$deliveryAddress    = trim(''.$_POST['deliveryAddress']);
$billingAddress     = trim(''.$_POST['billingAddress']);
$orderID            = trim(''.$_POST['orderID']);
$currencyID         = trim(''.$_POST['currencyID']);
$waybillDate        = trim(''.$_POST['waybillDate']);
$serviceCallID      = trim(''.$_POST['serviceCallID']);
$paymentMethod      = trim(''.$_POST['paymentMethod']);
$salespersonSearch  = trim(''.$_POST['salespersonSearch']);
$warehouseSearch    = trim(''.$_POST['warehouseSearch']);
$subtotal           = trim(''.$_POST['subtotal']);
$discount           = trim(''.$_POST['discount']);
$vatTotal           = trim(''.$_POST['vatTotal']);
$grandTotal         = trim(''.$_POST['grandTotal']);
$details            = trim(''.$_POST['details']);

$status             = "Placed";

$waybillItems       = array();
$waybillItems       = json_decode($_POST['waybillItems'], true);

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

try {
    $db->begin_transaction();

    if (isset($waybillDate)) {
        $date = DateTime::createFromFormat('d/m/Y', $waybillDate);
        $waybillDate = $date->format('Y-m-d');
    }

    $dueDate = trim(''.$_POST['dueDate']);

    if (isset($dueDate) and strcmp($dueDate, "") != 0) {
        $date = DateTime::createFromFormat('d/m/Y', $dueDate);
        $dueDate = $date->format('Y-m-d');
    }

    if (strpos($discount, '%') !== false) {
        $globalDiscountPercentage = str_replace("%", "", $discount);
        $discount = $subtotal * $globalDiscountPercentage / 100;
    } else {
        $globalDiscountPercentage = 0;
    }

    $waybillID   = getNextKeySingleTransaction("Waybills", "waybill_id", $db);
    $waybillCode = getNextCodeSingleTransaction("Waybills", "waybill_code", "W", "CLOUD", $db);

    if (strcmp($waybillCode, '') == 0) {
        $waybillCode = getNextWaybillCode("CLOUD", $db);
    }

    if (isset($orderID) && $orderID > 0){
        $stmt = $db->prepare("SELECT order_code FROM Orders WHERE order_id='$orderID'");
        $stmt->execute();
        if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
        $stmt->bind_result($orderCode);
        while ($stmt->fetch()) {}
        $stmt->close();
    }

    $db->set_charset("utf8");
    $stmt = $db->prepare("INSERT INTO Waybills (waybill_id,waybill_code,company_id,customer_id,salesperson_id,paymenttype_id,subtotal,grand_total,vat_amount,discount_amount,waybill_address_id,delivery_address_id,waybill_date,details,global_discount_percentage,status,currency_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiiiddddiissdsi', $waybillID, $waybillCode, $companyID, $customerID, $salespersonSearch, $paymentMethod, $subtotal, $grandTotal, $vatTotal, $discount, $billingAddress, $deliveryAddress, $waybillDate, $details, $globalDiscountPercentage, $status, $currencyID);
    $stmt->execute();
    $stmt->close();

    lockDocumentSingleTransaction($waybillID, "Waybills", $db);

    $lineTotals         = 0;
    $lineDiscountTotals = 0;
    $itemsCounter       = 0;

    if (count($waybillItems) == 0) {throw new Exception();}

    foreach ($waybillItems as $waybillItem) {

        $itemID = $waybillItem['itemID'];

        if ($itemID > 0) {
            $itemsCounter++;
            $orderItemID    = $waybillItem['orderItemID'];
            $itemNotes      = $waybillItem['Notes'];
            $qty            = $waybillItem['Qty'];
            $unitPrice      = $waybillItem['UP'];
            $lineDiscount   = $waybillItem['LD'];
            $priceType      = $waybillItem['PC'];
            $globalDiscount = $waybillItem['globalDiscount'];
            $vatTotal       = $waybillItem['vatLine'];
            $vatCode        = $waybillItem['VAT'];

            $subunits = getSubUnits($itemID, $db);
            $vatID    = getVatID($vatCode, $db);

            if (strpos($lineDiscount, '%') !== false) {
                $lineDiscountSelectedPercentage = str_replace("%", "", $lineDiscount);
                $lineDiscount = ($qty / $subunits) * $unitPrice * ($lineDiscountSelectedPercentage / 100);
            } else {
                $lineDiscountSelectedPercentage = 0;
            }

            $lineTotals += floatval($unitPrice) * $qty / $subunits;
            $lineDiscountTotals += floatval($lineDiscount);
            $batchNumber = '0';

            $waybillItemID = getNextKeySingleTransaction("Waybill_Item", "waybill_item_id", $db);

            $stmt = $db->prepare("INSERT INTO Waybill_Item (waybill_item_id,waybill_id,item_id,warehouse_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description,batch_number) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iiiidddddiidss', $waybillItemID, $waybillID, $itemID, $warehouseSearch, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID, $lineDiscountSelectedPercentage, $itemNotes,$batchNumber);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception();}
            $stmt->close();


            $available = -$qty;
            $delivered = $qty;

            $insertStockStatementResult = insertStockRecord($db, $warehouseSearch, $itemID, $batchNumber, $available, 0, $delivered, 0, 0, 0, '0000-00-00');
            if(!$insertStockStatementResult){throw new Exception();}

            $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $warehouseSearch, $itemID, $batchNumber, $available, 0, $delivered, 0, 0, 0, "0000-00-00", 3, $waybillID, $waybillCode, 'Insert Waybill', 0, null, null, 0, null);
            if(!$insertStockUpdateStatementResult){throw new Exception();}

            if (isset($orderItemID) && $orderItemID > 0) {
                $stmt = $db->prepare("SELECT (qty-Order_Item.qty_invoiced-Order_Item.qty_delivered) as available FROM Order_Item WHERE order_item_id='$orderItemID'");
                $stmt->execute();
                if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
                $stmt->bind_result($orderAvailableQty);
                while ($stmt->fetch()) {}
                $stmt->close();

                if($orderAvailableQty <= $qty){
                    $reserved  = $orderAvailableQty;
                } else {
                    $reserved  = $qty;
                }

                $stmt = $db->prepare("UPDATE Order_Item SET qty_delivered=qty_delivered+? WHERE order_item_id=?");
                $stmt->bind_param('di', $reserved, $orderItemID);
                $stmt->execute();
                if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
                $stmt->close();
                // ------------------------------------------

                $fromActionQty = $reserved;
                $reserved=-$reserved;

                $insertStockStatementResult = insertStockRecord($db, $warehouseSearch, $itemID, $batchNumber, 0, $reserved, 0, 0, 0, 0, '0000-00-00');
                if(!$insertStockStatementResult){throw new Exception();}

                $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $warehouseSearch, $itemID, $batchNumber, 0, $reserved, 0, 0, 0, 0, "0000-00-00", 3, $waybillID, $waybillCode, 'Waybill Order', 2, $orderID, $orderCode, $fromActionQty, "qty_delivered");
                if(!$insertStockUpdateStatementResult){throw new Exception();}

            }

            $custTable = new CustomTable('Waybill_Item', $waybillItemID);
            $codes = array();
            $codes = $custTable->getCustomTableCodes($db);
            foreach ($codes as $code) {
                $custTable->insertVariablesToCustomTableLine($waybillItem, $code->tableCode, $db);
            }

        }

    }
    $discount = floatval($discount);
    $discount += $lineDiscountTotals;

    $stmt = $db->prepare("UPDATE  Waybills SET subtotal =? ,discount_amount=? WHERE waybill_id=?");
    $stmt->bind_param('ddi', $lineTotals, $discount, $waybillID);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    if (isset($orderID) && $orderID > 0) {

        $stmt = $db->prepare("INSERT INTO Order_Waybill(order_id, waybill_id, timestamp) VALUES (?,?,NOW())");
        $stmt->bind_param('ii', $orderID, $waybillID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();

        $stm = $db->prepare("SELECT SUM(qty-qty_delivered) FROM Order_Item WHERE order_id ='$orderID'");
        $stm->execute();
        $stm->bind_result($sumPendingItems);
        while ($stm->fetch()) {}
        $stm->close();

        if (isset($sumPendingItems) && $sumPendingItems > 0) {
            $orderStatus = "Partially Delivered";
            $stmt = $db->prepare("UPDATE  Orders SET status =? WHERE order_id=?");
            $stmt->bind_param('si', $orderStatus, $orderID);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception();}
            $stmt->close();
        } else if (isset($sumPendingItems) && $sumPendingItems == 0) {
            $orderStatus = "Fully Delivered";
            $stmt = $db->prepare("UPDATE  Orders SET status =? WHERE order_id=?");
            $stmt->bind_param('si', $orderStatus, $orderID);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception();}
            $stmt->close();
        }

    }

    if ($serviceCallID > 0) {
        date_default_timezone_set('Europe/Athens');
        $serviceCallReplyID = getNextKeySingleTransaction("Service_Call_Reply", "service_call_reply_id", $db);
        $status             = 0;
        $timezone           = 2;
        $date               = date("Y-m-d H:i:s");
        $replyTypeID        = 3;
        $details            = "New Waybill Issued";
        $documentType       = "Waybills";
        $salespersonTo      = 0;
        $emailResponse      = "";
        $priorityID         = 0;
        $stmt = $db->prepare("INSERT INTO Service_Call_Reply (service_call_reply_id,service_call_id,salesperson_id,status_id,date,reply_type_id,details,document_id,document_type,salesperson_to,email_response,priority_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iiiisisisisi', $serviceCallReplyID, $serviceCallID, $salespersonSearch, $status, $date, $replyTypeID, $details, $waybillID, $documentType, $salespersonTo, $emailResponse, $priorityID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();
    }

    $custTable = new CustomTable('Waybills', $waybillID);
    $codes = array();
    $codes = $custTable->getCustomTableCodes($db);
    foreach ($codes as $code) {
        $custTable->insertVariablesToCustomTable($_POST[$code->formCode], $code->tableCode, $db);
    }

    $db->commit(true);

    echo "$waybillID";

} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}

$custForm = new CustomForm('Waybills',$waybillID);
$codes = array();
$codes = $custForm->getFormCodes();
foreach ($codes as $code) {
    $custForm->insertVariablesToCustomForm($_POST[$code], $code);
}







function getVatID($vatCode,$db)
{

    $z="";
    $stm1 = $db->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        $z=$counter;
    }
    $stm1->close();


    return $z;



}

function getSubUnits($itemID,$db) {
    $subunits = 1;
    $stm1 = $db->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($sub);
    while ($stm1->fetch()) {
        return $sub;
    }
    $stm1->close();
    return $subunits;


}

?>