<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");

$companyID = $_SESSION['companyID'];
$salespersonID= trim(''.$_POST['salespersonSearch']);
$warehouseID= trim(''.$_POST['warehouseIDTo']);
$details= trim(''.$_POST['details']);
$stockAdjustmentDate= trim(''.$_POST['wtDate']);
$serviceCallID = trim(''.$_POST['serviceCallID']);
$convertedOrderID = trim(''.$_POST['fromOrderID']);

$wtItems = array();
$wtItems =$_POST['orderItems'];


global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

try {
    $db->begin_transaction();

    if (isset($stockAdjustmentDate)) {
        $date = DateTime::createFromFormat('d/m/Y', $stockAdjustmentDate);
        $stockAdjustmentDate = $date->format('Y-m-d');
    }


    $stockAdjustmentID = getNextKeySingleTransaction("Stock_Adjustment", "stock_taking_id", $db);
    $stockAdjustmentCode = getNextCodeSingleTransaction("Stock_Adjustment", "stock_taking_code", "A", "CLOUD", $db);

    $printCount = 0;
    $addOverwrite = '';
    $actionHash = '';
    $stmt = $db->prepare("INSERT INTO Stock_Adjustment (stock_taking_id, stock_taking_code, company_id, warehouse_id, salesperson_id, print_count, date, details, add_override, action_hash) VALUES(?,?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiiissss', $stockAdjustmentID, $stockAdjustmentCode, $companyID,$warehouseID, $salespersonID, $printCount, $stockAdjustmentDate, $details,$addOverwrite,$actionHash);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception($stmt->error);}
    $stmt->close();

    lockDocumentSingleTransaction($stockAdjustmentID, "Stock_Adjustment", $db);

    $purchaseItems = array();
    foreach ($wtItems as $wtItem) {


        $itemID = $wtItem['itemID'];
        if ($itemID > 0) {
            $qty = $wtItem['Qty'];
            $batchNumber = $wtItem['Batch Number'];
            $itemDetails = $wtItem['Notes'];
            $expiryDate = '';


            if(true) {
                $warehouseItemID = getNextKeySingleTransaction("Stock_Adjustment_Item", "stock_taking_item_id", $db);

                if (strcmp("$batchNumber", '') == 0 || !isset($batchNumber)) {
                    $batchNumber = '0';
                }

                if (strcmp("$expiryDate", '') == 0 || !isset($expiryDate)) {
                    $expiryDate = '0000-00-00';
                }


                $serialNumber = '';
                $stmt = $db->prepare("INSERT INTO Stock_Adjustment_Item (stock_taking_item_id, stock_taking_id, item_id, batch_number, warehouse_id, qty, serialnumber, description) VALUES(?,?,?,?,?,?,?,?)");
                $stmt->bind_param('iiisidss', $warehouseItemID, $stockAdjustmentID, $itemID,$batchNumber, $warehouseID, $qty,$serialNumber,$itemDetails);
                $stmt->execute();
                if (strcmp("$stmt->error", "") != 0) {throw new Exception($stmt->error);}
                $stmt->close();


                $existingStock = getItemAvailableStock($itemID,$warehouseID,$batchNumber,$db);

                $available = $qty - $existingStock;
                $insertStockStatementResult = insertStockRecord($db, $warehouseID, $itemID, $batchNumber, $available, 0, 0, 0, 0, 0, $expiryDate);
                if (!$insertStockStatementResult) {throw new Exception();}

                $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $warehouseID, $itemID, $batchNumber, $available, 0, 0, 0, 0, 0, $expiryDate, 14, $stockAdjustmentID, $stockAdjustmentCode, 'Stock Adjustment', 0, null, null, 0, null);
                if (!$insertStockUpdateStatementResult) {throw new Exception();}
            }
        }
    }






    $db->commit(true);

    echo "$stockAdjustmentID";
} catch (Exception  $e) {
    echo 'error';
    echo $e->getMessage();
    $db->rollback();
}




function getSubUnits($itemID,$db1='') {

    if(is_string($db1) && strcmp($db1,'')==0) {
        global $username, $password, $database;
        $db1 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db1->set_charset("utf8");
    }

    $stm1 = $db1->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($sub);
    while ($stm1->fetch()) {
        return $sub;
    }
    $stm1->close();
    return $sub;


}

function getItemAvailableStock($itemID,$warehouseID,$batchNumber,$db1='') {

    if(is_string($db1) && strcmp($db1,'')==0) {
        global $username, $password, $database;
        $db1 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db1->set_charset("utf8");
    }

    $stm1 = $db1->prepare("SELECT available FROM Stock WHERE item_id='$itemID' AND warehouse_id='$warehouseID' AND batch_number='$batchNumber' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($available);
    while ($stm1->fetch()) {}
    $stm1->close();
    return (float)$available;


}
	
function redirect($url)
{
	if (headers_sent())
	{
		die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
	}
	else
	{
		header('Location: ' . $url);
		die();
	}    
}

?>