<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");

$companyID = $_SESSION['companyID'];
$reverseWarehouseTransactionID = trim($_POST['reverseWarehouseTransactionID']);
$transactionType="Reverse";
$wtDate = date('Y-m-d');


if(isset($_POST['reverseWarehouseTransactionID']) && $reverseWarehouseTransactionID > 0) {

    $wtID = getNextKey("Warehouse_Transactions", "warehouse_transaction_id");
    $wtCode = "RT" . getNextWTCode("CLOUD");


    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $stmt = $db->prepare("SELECT warehouse_transaction_code,warehouse_id_from,warehouse_id_to,company_id,salesperson_id FROM Warehouse_Transactions WHERE warehouse_transaction_id='" . $reverseWarehouseTransactionID . "'");
    $stmt->execute();
    $stmt->bind_result($reverseTransactionCode, $warehouseIDTo, $warehouseIDFrom,$companyID, $salespersonID);
    while ($stmt->fetch()) {
    }
    $stmt->close();


    $wtItems = array();
    $stmt = $db->prepare("SELECT item_id,qty FROM Warehouse_Transaction_Item WHERE warehouse_transaction_id = '" . $reverseWarehouseTransactionID . "'");
    $stmt->execute();
    $stmt->bind_result($reverseItemID, $reverseQty);
    while ($stmt->fetch()) {

        $wtItem['itemID'] = $reverseItemID;
        $wtItem['Qty'] = $reverseQty;
        array_push($wtItems, $wtItem);
    }
    $stmt->close();

    $details = "Reverse Transaction $reverseTransactionCode";

    $db->set_charset("utf8");
    $stmt = $db->prepare("INSERT INTO Warehouse_Transactions (warehouse_transaction_id,warehouse_transaction_code,warehouse_id_from,warehouse_id_to,company_id,salesperson_id,type,transaction_date,details) VALUES(?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiiisss', $wtID, $wtCode, $warehouseIDFrom, $warehouseIDTo, $companyID, $salespersonID, $transactionType, $wtDate, $details);
    $stmt->execute();
    $stmt->close();


    lockDocument($wtID, "Warehouse_Transactions");


    foreach ($wtItems as $wtItem) {


        $itemID = $wtItem['itemID'];
        if ($itemID != 0) {
            $qty = $wtItem['Qty'];


            $warehouseItemID = getNextKey("Warehouse_Transaction_Item", "warehouse_transaction_item_id");

            $batchNumber = '0';
            $expiryDate = '0000-00-00';

            $db = new mysqli(localhost, $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db->set_charset("utf8");
            $stmt = $db->prepare("INSERT INTO Warehouse_Transaction_Item (warehouse_transaction_item_id,warehouse_transaction_id,item_id,warehouse_id,qty) VALUES(?,?,?,?,?)");
            $stmt->bind_param('iiiid', $warehouseItemID, $wtID, $itemID, $warehouseIDFrom, $qty);
            $stmt->execute();
            $stmt->close();


            $available = -$qty;
            $insertStockStatementResult = insertStockRecord($db, $warehouseIDFrom, $itemID, $batchNumber, $available, 0, 0, 0, 0, 0, $expiryDate);
//      if(!$insertStockStatementResult){throw new Exception();}

            $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $warehouseIDFrom, $itemID, $batchNumber, $available, 0, 0, 0, 0, 0, $expiryDate, 7, $wtID, $wtCode, 'Insert Transfer', 0, null, null, 0, null);
//      if(!$insertStockUpdateStatementResult){throw new Exception();}

            $available = $qty;
            $insertStockStatementResult = insertStockRecord($db, $warehouseIDTo, $itemID, $batchNumber, $available, 0, 0, 0, 0, 0, $expiryDate);
//      if(!$insertStockStatementResult){throw new Exception();}

            $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $warehouseIDTo, $itemID, $batchNumber, $available, 0, 0, 0, 0, 0, $expiryDate, 7, $wtID, $wtCode, 'Insert Transfer', 0, null, null, 0, null);
//      if(!$insertStockUpdateStatementResult){throw new Exception();}

        }

    }


    if ($serviceCallID > 0) {
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");

        $serviceCallReplyID = getNextKey("Service_Call_Reply", "service_call_reply_id");
        $status = 0;
        $timezone = 2;
        date_default_timezone_set('Europe/Athens');
        $date = date("Y-m-d H:i:s");
        $replyTypeID = 3;
        $details = "Warehouse Transfer Reverse";
        $documentType = "Transfer";
        $salespersonTo = 0;
        $emailResponse = "";
        $priorityID = 0;
        $stmt = $db->prepare("INSERT INTO Service_Call_Reply (service_call_reply_id,service_call_id,salesperson_id,status_id,date,reply_type_id,details,document_id,document_type,salesperson_to,email_response,priority_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iiiisisisisi', $serviceCallReplyID, $serviceCallID, $salespersonID, $status, $date, $replyTypeID, $details, $wtID, $documentType, $salespersonTo, $emailResponse, $priorityID);
        $stmt->execute();
        $stmt->close();

    }


    setNextWTCode("CLOUD");

    $url = "//".HTML_PATH."/cop/backend/core/views/addedit/create_warehouse_transfer.php?wt_id=$wtID";
    header('Location: ' . $url);
    die();

}

?>