<?php
include_once("../../../../param.php");
require_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

$companyID          = $_SESSION['companyID'];
$customerID         = trim(''.$_POST['customerID']);
$returnAddress      = trim(''.$_POST['returnAddress']);
$returnType         = trim(''.$_POST['returnType']);
$returnDate         = trim(''.$_POST['returnDate']);
$serviceCallID      = trim(''.$_POST['serviceCallID']);
$invoiceID          = trim(''.$_POST['invoiceID']);
$paymentMethod      = trim(''.$_POST['paymentMethod']);
$salespersonSearch  = trim(''.$_POST['salespersonSearch']);
$warehouseSearch    = trim(''.$_POST['warehouseSearch']);
$subtotal           = trim(''.$_POST['subtotal']);
$discount           = trim(''.$_POST['discount']);
$vatTotal           = trim(''.$_POST['vatTotal']);
$grandTotal         = trim(''.$_POST['grandTotal']);
$details            = trim(''.$_POST['details']);

$returnItems        = array();
$returnItems        = json_decode($_POST['returnItems'], true);

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

try {
    $db->begin_transaction();

    if (isset($returnDate)) {
        $date = DateTime::createFromFormat('d/m/Y', $returnDate);
        $returnDate = $date->format('Y-m-d');
    }

    if (strpos($discount, '%') !== false) {
        $globalDiscountPercentage = str_replace("%", "", $discount);
        $discount = $subtotal * $globalDiscountPercentage / 100;
    } else {
        $globalDiscountPercentage = 0;
    }

    if (strcmp($returnType, 'Cash') == 0) {
        $status = "Paid";
    } else {
        $status = "Not Paid";
    }

    $returnID   = getNextKeySingleTransaction("Returns", "return_id", $db);
    $returnCode = getNextCodeSingleTransaction("Returns", "return_code", "N", "CLOUD", $db);

    if (strcmp($returnCode, '') == 0) {
        $returnCode = getNextReturnCode("CLOUD", $db);
    }

    $stmt = $db->prepare("INSERT INTO Returns (return_id, return_code, company_id, customer_id, salesperson_id, paymenttype_id, subtotal, grand_total, vat_amount, discount_amount, return_address_id,return_date, details, return_type, global_discount_percentage, status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiiiddddisssds', $returnID, $returnCode, $companyID, $customerID, $salespersonSearch, $paymentMethod, $subtotal, $grandTotal, $vatTotal, $discount, $returnAddress, $returnDate, $details, $returnType, $globalDiscountPercentage, $status);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    lockDocumentSingleTransaction($returnID, "Returns", $db);

    $detailsTra = "Return $returnCode";

    $lineTotals         = 0;
    $lineDiscountTotals = 0;
    $itemsCounter       = 0;

    if (count($returnItems) == 0) {throw new Exception();}

    foreach ($returnItems as $returnItem) {

        $itemID = $returnItem['itemID'];

        if ($itemID > 0) {
            $itemsCounter++;

            $itemNotes      = $returnItem['Notes'];
            $qty            = $returnItem['Qty'];
            $unitPrice      = $returnItem['UP'];
            $lineDiscount   = $returnItem['LD'];
            $itemStatus     = $returnItem['Condition'];
            $priceType      = $returnItem['PC'];
            $globalDiscount = $returnItem['globalDiscount'];
            $vatTotal       = $returnItem['vatLine'];
            $vatCode        = $returnItem['VAT'];

            $unitPrice = floatval($unitPrice);

            $vatID    = getVatID($vatCode, $db);
            $subunits = getSubUnits($itemID, $db);

            if (strpos($lineDiscount, '%') !== false) {
                $lineDiscountSelectedPercentage = str_replace("%", "", $lineDiscount);
                $lineDiscount = ($qty / $subunits) * $unitPrice * ($lineDiscountSelectedPercentage / 100);
            } else {
                $lineDiscountSelectedPercentage = 0;
            }

            $lineDiscount = floatval($lineDiscount);

            $lineTotals += $unitPrice * $qty / $subunits;
            $lineDiscountTotals += $lineDiscount;

            $returnItemID = getNextKeySingleTransaction("Return_Item", "return_item_id", $db);

            $batchNumber = '0';

            $stmt = $db->prepare("INSERT INTO Return_Item (return_item_id, return_id, item_id, warehouse_id, qty, unit_price, line_discount, global_discount,  vat_amount, pricetype_id, vat_id, line_discount_percentage, status,description,batch_number) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iiiidddddiidsss', $returnItemID, $returnID, $itemID, $warehouseSearch, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID, $lineDiscountSelectedPercentage, $itemStatus, $itemNotes,$batchNumber);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception();}
            $stmt->close();


//            if (strcmp($itemStatus, 'Good') == 0) {
//                $available = $qty;
//                $insertStockStatementResult = insertStockRecord($db, $warehouseSearch, $itemID, $batchNumber, $available, 0, 0, 0, 0, 0, '0000-00-00');
//                if(!$insertStockStatementResult){throw new Exception();}
//
//                $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $warehouseSearch, $itemID, $batchNumber, $available, 0, 0, 0, 0, 0, "0000-00-00", 4, $returnID, $returnCode, 'Insert Return', 0, null, null, 0, null);
//                if(!$insertStockUpdateStatementResult){throw new Exception();}
//            }

            $custTable = new CustomTable('Return_Item', $returnItemID);
            $codes = array();
            $codes = $custTable->getCustomTableCodes($db);
            foreach ($codes as $code) {
                $custTable->insertVariablesToCustomTableLine($returnItem, $code->tableCode, $db);
            }

        }

    }
    $discount = floatval($discount);
    $discount += $lineDiscountTotals;

    $stmt = $db->prepare("UPDATE Returns SET subtotal =? ,discount_amount=? WHERE return_id=?");
    $stmt->bind_param('ddi', $lineTotals, $discount, $returnID);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    if ($serviceCallID > 0) {
        date_default_timezone_set('Europe/Athens');
        $serviceCallReplyID = getNextKeySingleTransaction("Service_Call_Reply", "service_call_reply_id", $db);
        $status = 0;
        $timezone = 2;
        $date = date("Y-m-d H:i:s");
        $replyTypeID = 3;
        $details = "New Return Issued";
        $documentType = "Returns";
        $salespersonTo = 0;
        $emailResponse = "";
        $priorityID = 0;
        $stmt = $db->prepare("INSERT INTO Service_Call_Reply (service_call_reply_id,service_call_id,salesperson_id,status_id,date,reply_type_id,details,document_id,document_type,salesperson_to,email_response,priority_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iiiisisisisi', $serviceCallReplyID, $serviceCallID, $salespersonSearch, $status, $date, $replyTypeID, $details, $returnID, $documentType, $salespersonTo, $emailResponse, $priorityID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();
    }

    if ($invoiceID > 0) {
        $stmt = $db->prepare("INSERT INTO Invoice_Return (return_id,invoice_id,timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('ii', $returnID, $invoiceID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();
    }


    $custTable = new CustomTable('Returns', $returnID);
    $codes = array();
    $codes = $custTable->getCustomTableCodes($db);
    foreach ($codes as $code) {
        $custTable->insertVariablesToCustomTable($_POST[$code->formCode], $code->tableCode, $db);
    }

    if (strcmp($returnType, "Credit") == 0) {
        $sign = -1;
        $transactionID = getNextKeySingleTransaction("Transactions", "transaction_id", $db);
        $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isisssids', $transactionID, $returnCode, $customerID, $returnDate, $returnDate, $returnCode, $sign, $grandTotal, $detailsTra);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();
        updateCustomerBalance($customerID, $grandTotal, $db);
    } else {
        $sign = -1;
        $transactionID = getNextKeySingleTransaction("Transactions", "transaction_id", $db);
        $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isisssids', $transactionID, $returnCode, $customerID, $returnDate, $returnDate, $returnCode, $sign, $grandTotal, $detailsTra);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();
        $sign = 1;
        $transactionID = getNextKeySingleTransaction("Transactions", "transaction_id", $db);
        $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isisssids', $transactionID, $returnCode, $customerID, $returnDate, $returnDate, $returnCode, $sign, $grandTotal, $detailsTra);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();
    }

    $db->commit(true);

    echo "$returnID";

} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}

$custForm = new CustomForm('Returns',$returnID);
$codes = array();
$codes = $custForm->getFormCodes();
foreach ($codes as $code) {
    $custForm->insertVariablesToCustomForm($_POST[$code], $code);
}





function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

function getVatID($vatCode,$db)
{

    $z="";
    $stm1 = $db->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        $z=$counter;
    }
    $stm1->close();


    return $z;



}

function getSubUnits($itemID,$db) {
    $subunits = 1;
    $stm1 = $db->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($sub);
    while ($stm1->fetch()) {
        return $sub;
    }
    $stm1->close();
    return $subunits;


}

function updateCustomerBalance($customerID,$amount,$db)
{

    $stmt = $db->prepare("UPDATE  Customers SET balance = balance - ? WHERE customer_id=?");
    $stmt->bind_param('di',$amount,$customerID);
    $stmt->execute();
    $stmt->close();

}
?>