<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

$companyID          = $_SESSION['companyID'];
$customerID         = trim(''.$_POST['customerID']);
$deliveryAddress    = trim(''.$_POST['deliveryAddress']);
$billingAddress     = trim(''.$_POST['billingAddress']);
$orderDate          = trim(''.$_POST['orderDate']);
$serviceCallID      = trim(''.$_POST['serviceCallID']);
$currencyID         = trim(''.$_POST['currencyID']);
$dueDate            = trim(''.$_POST['dueDate']);
$paymentMethod      = trim(''.$_POST['paymentMethod']);
$salespersonSearch  = trim(''.$_POST['salespersonSearch']);
$warehouseSearch    = trim(''.$_POST['warehouseSearch']);
$subtotal           = trim(''.$_POST['subtotal']);
$discount           = trim(''.$_POST['discount']);
$vatTotal           = trim(''.$_POST['vatTotal']);
$grandTotal         = trim(''.$_POST['grandTotal']);
$details            = trim(''.$_POST['details']);
$project            = trim(''.$_POST['project']);
$administrationFees = trim(''.$_POST['administrationFees']);
$status             = "Placed";
$orderItems         = array();
$orderItems         = json_decode($_POST['orderItems'], true);


global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

try {
    $db->begin_transaction();

    $orderID            = getNextKeySingleTransaction("Orders","order_id",$db);
    $orderCode          = getNextCodeSingleTransaction("Orders", "order_code","O","CLOUD",$db);

    if(strcmp($orderCode,'')==0){
        $orderCode = getNextOrderCode("CLOUD",$db);
    }

    if(isset($orderDate)) {
        $orderDate = date_format( date_create_from_format('d/m/Y', $orderDate), 'Y-m-d');
    } else {
        $orderDate = date('Y-m-d');
    }

    if(isset($dueDate) AND strcmp($dueDate,"")!=0) {
        $dueDate = date_format( date_create_from_format('d/m/Y', $dueDate), 'Y-m-d');
    }

    if(strcmp($warehouseSearch,'')==0) {
        $warehouseSearch = 1;
    }

    if(strpos($discount, '%') !== false) {
        $globalDiscountPercentage=str_replace("%","",$discount);
        $discount=$subtotal*$globalDiscountPercentage/100;
    } else {
        $globalDiscountPercentage=0;
    }

    include_once (ROOT . 'backend/core/model/ActionAutomation.php');
    $automation = new ActionAutomation($db, ROOT, HTML_PATH, 'Orders', 'order_id', $orderID);

    $stmt = $db->prepare("INSERT INTO Orders (order_id,order_code,company_id,customer_id,salesperson_id,paymenttype_id,subtotal,grand_total,vat_amount,discount_amount,order_address_id,delivery_address_id,order_date,delivery_date,details,global_discount_percentage,status, delivery_method,tender_id,currency_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiiiddddiisssdssii',$orderID,$orderCode,$companyID,$customerID,$salespersonSearch,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$billingAddress,$deliveryAddress,$orderDate,$dueDate,$details,$globalDiscountPercentage,$status,$warehouseSearch,$project,$currencyID);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    lockDocumentSingleTransaction($orderID,"Orders",$db);

    $lineTotals         = 0;
    $lineDiscountTotals = 0;
    $itemsCounter       = 0;

    $discount = floatval($discount);

    if(count($orderItems) == 0) {throw new Exception();}

    foreach($orderItems as $orderItem)
    {
        $itemID = $orderItem['itemID'];

        if($itemID > 0) {
            $itemsCounter++;

            $qty            = $orderItem['Qty'];
            $unitPrice      = $orderItem['UP'];
            $lineDiscount   = $orderItem['LD'];
            $itemNotes      = $orderItem['Notes'];
            $priceType      = $orderItem['PC'];
            $globalDiscount = $orderItem['globalDiscount'];
            $vatTotal       = $orderItem['vatLine'];
            $vatCode        = $orderItem['VAT'];

            $vatID          = getVatID($vatCode,$db);
            $subunits       = getSubUnits($itemID,$db);
            $orderItemID    = getNextKeySingleTransaction("Order_Item", "order_item_id",$db);

            $batchNumber    = '0';

            if(strpos($lineDiscount, '%') !== false) {
                $lineDiscountSelectedPercentage=str_replace("%","",$lineDiscount);
                $lineDiscount = ($qty/$subunits)*$unitPrice *($lineDiscountSelectedPercentage/100);
            } else {
                $lineDiscountSelectedPercentage=0;
            }

            $lineTotals += floatval($unitPrice)*floatval($qty)/floatval($subunits);
            $lineDiscountTotals += floatval($lineDiscount);

            $stmt = $db->prepare("INSERT INTO Order_Item (order_item_id,order_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iiidddddiids', $orderItemID, $orderID, $itemID, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID,$lineDiscountSelectedPercentage,$itemNotes);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception();}
            $stmt->close();

            $reserved=$qty;
            $insertStockStatementResult = insertStockRecord($db, $warehouseSearch, $itemID, $batchNumber, 0, $reserved, 0, 0, 0, 0, '0000-00-00');
            if(!$insertStockStatementResult){throw new Exception();}

            $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $warehouseSearch, $itemID, $batchNumber, 0, $reserved, 0, 0, 0, 0, "0000-00-00", 2, $orderID, $orderCode, 'Insert Order', 0, null, null, 0, null);
            if(!$insertStockUpdateStatementResult){throw new Exception();}

            $custTable = new CustomTable('Order_Item',$orderItemID);
            $codes = array();
            $codes = $custTable->getCustomTableCodes($db);
            foreach ($codes as $code) {
                $custTable->insertVariablesToCustomTableLine($orderItem, $code->tableCode,$db);
            }

            $uomID = $orderItem['uomID'];
            if(intval($uomID) > 0) {
                $custForm = new CustomForm('Order_Item',$orderItemID);
                $custForm->insertCustomUOM($uomID,$db);
            }

        }

    }


    if($administrationFees>0)
    {
        $itemID          = getItemID("ADMIN",$db);
        $vatID           = getItemVatID($itemID,$db);
        $qty             = 1;
        $unitPrice       = $administrationFees;
        $lineDiscount    = $globalDiscount=0;
        $vatTotal        = $unitPrice*0.19;
        $priceType       = 0;
        $itemDescription = "";
        $orderItemID     = getNextKeySingleTransaction("Order_Item", "order_item_id",$db);
        $lineTotals     += $unitPrice*$qty;
        $lineDiscountSelectedPercentage = 0;

        $stmt = $db->prepare("INSERT INTO Order_Item (order_item_id,order_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iiidddddiids', $orderItemID, $orderID, $itemID, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID,$lineDiscountSelectedPercentage,$itemDescription);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();

    }

    $discount+=floatval($lineDiscountTotals);

    $stmt = $db->prepare("UPDATE  Orders SET subtotal =? ,discount_amount=? WHERE order_id=?");
    $stmt->bind_param('ddi',$lineTotals,$discount,$orderID);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    if($serviceCallID>0)
    {
        date_default_timezone_set('Europe/Athens');
        $serviceCallReplyID = getNextKeySingleTransaction("Service_Call_Reply", "service_call_reply_id",$db);

        $status        = 0;
        $timezone      = 2;
        $date          = date("Y-m-d H:i:s");
        $replyTypeID   = 3;
        $details       = "New Order Issued";
        $documentType  = "Orders";
        $salespersonTo = 0;
        $emailResponse = "";
        $priorityID    = 0;

        $stmt = $db->prepare("INSERT INTO Service_Call_Reply (service_call_reply_id,service_call_id,salesperson_id,status_id,date,reply_type_id,details,document_id,document_type,salesperson_to,email_response,priority_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iiiisisisisi',$serviceCallReplyID,$serviceCallID,$salespersonSearch,$status,$date,$replyTypeID,$details,$orderID,$documentType,$salespersonTo,$emailResponse,$priorityID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();
    }


    if(isset($_POST['tenderID'])){
        $tenderID = trim($_POST['tenderID']);
        $stmt = $db->prepare("UPDATE Tenders SET status = 'Ordered' WHERE tender_id=?");
        $stmt->bind_param('i',$tenderID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();

        $stmt = $db->prepare("INSERT INTO Tender_Order(tender_id,order_id,timestamp) VALUES (?,?,NOW())");
        $stmt->bind_param('ii',$tenderID,$orderID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();
    }

    $custTable = new CustomTable('Orders',$orderID);
    $codes = array();
    $codes = $custTable->getCustomTableCodes($db);
    foreach ($codes as $code) {
        $custTable->insertVariablesToCustomTable($_POST[$code->formCode], $code->tableCode,$db);
    }

    $automation->executeAutomations();

    $db->commit(true);

    if($serviceCallID>0){
        echo "$orderID&service_call_id=$serviceCallID";
    } else {
        echo "$orderID";
    }

} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}

$custForm = new CustomForm('Orders',$orderID);
$codes = array();
$codes = $custForm->getFormCodes();
foreach ($codes as $code) {
    $custForm->insertVariablesToCustomForm($_POST[$code], $code);
}



function getVatID($vatCode,$db)
{

    $z="";
    $stm1 = $db->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        $z=$counter;
    }
    $stm1->close();


    return $z;



}

function getSubUnits($itemID,$db) {
    $sub = 1;
    $stm1 = $db->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($sub);
    while ($stm1->fetch()) {
        return $sub;
    }
    $stm1->close();
    return $sub;


}

function updateCustomerBalance($customerID,$amount)
{
    global $username;
    global $password;
    global $database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE  Customers SET balance = balance + ? WHERE customer_id=?");
    $stmt->bind_param('di',$amount,$customerID);
    $stmt->execute();
    $stmt->close();

}

function getItemID($itemCode,$db)
{
    $z="";
    $stm1 = $db->prepare("SELECT item_id FROM Items WHERE item_code='$itemCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {$z=$counter;}
    $stm1->close();
    return $z;

}

function getItemVatID($itemID,$db)
{
    $deliveryfee=0;
    $stm1 = $db->prepare("SELECT vat_id FROM Items WHERE item_id='$itemID' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($itemID);
    while ($stm1->fetch()) {}
    $stm1->close();

    return $itemID;
}
?>