<?php
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);
session_start();
if(!isset($_SESSION['customerID']) ) {
    redirect("../login.php");
}
function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

include_once("../../param.php");
require_once("../dbaccess/dbhelper.php");
require_once('../dbaccess/emailOrder.php');
require_once('../langs/'.$_SESSION['lang'].'.php');

$failedPayment = false;

if(isset($_GET['redirect_status']) && isset($_GET['p']) && isset($_GET['oid'])){

    $stripeOrderCode = $_GET['oid'];
    $stripeCustomerID = $_SESSION['customerID'];


    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT order_id FROM Orders WHERE order_code = '$stripeOrderCode' AND customer_id='".$_SESSION['customerID']."'");
    $stm-> execute();
    $stm-> bind_result($stripeOrderID);
    while ($stm->fetch()) {}
    $stm-> close();

    switch ($_GET['redirect_status']){
        case 'succeeded':

            $amount = 0;

            $stm = $db->prepare("SELECT order_id,delivery_address_id,grand_total FROM Orders WHERE order_id=? AND customer_id=? AND NOT status='Canceled' AND NOT status='Placed'");
            $stm-> bind_param('ii', $stripeOrderID,$stripeCustomerID);
            $stm-> execute();
            $stm-> bind_result($orderID,$receiptAddress,$amount);
            while ($stm->fetch()) {}
            $stm->close();

            $status = "Placed";

            $db->set_charset("utf8");
            $stmt = $db->prepare("UPDATE Orders SET status=?,timestamp=NOW() WHERE order_id=? AND customer_id=? AND NOT status='Canceled' AND NOT status='Placed'");
            $stmt->bind_param('ssi',$status, $stripeOrderID,$stripeCustomerID);
            $stmt->execute();
            $stmt->close();

            $companyID = 0;
            $salespersonID = $_SESSION['userID'];
            $invoiceID = 0;
            $receiptAddress = 0;
            $cashDiscount = 0;
            $bank = 'Stripe';
            $branch = "";
            $chequeNumber = "";
            $chequeDate = date('Y-m-d');
            $receiptDate = date('Y-m-d');
            $paymentMethod ="Stripe Online";
            $notes = "For Online Order $stripeOrderCode";
            $receiptStatus = "Confirmed";


            $stm = $db->prepare("SELECT salesperson_for_order FROM B2B_Configuration LIMIT 1");
            $stm-> execute();
            $stm-> bind_result($defaultSalesPerson);
            while ($stm->fetch()) {
                if(strcmp($defaultSalesPerson,'')!=0 && $defaultSalesPerson > 0){
                    $salespersonID = $defaultSalesPerson;
                } else {
                    $salespersonID = 0;
                }
            }
            $stm->close();

            if($amount > 0) {

                $receiptID   = getNextKey("Receipts","receipt_id");
                $receiptCode = getReceiptPrefix("CLOUD").getNextReceiptCode("CLOUD");
                $db->set_charset("utf8");
                $stmt = $db->prepare("INSERT INTO Receipts (receipt_id, receipt_code, customer_id, company_id, salesperson_id, order_id, invoice_id, address_id, amount, payment_method, cash_discount, bank, branch, cheque_number, cheque_date, receipt_date, notes,status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                $stmt->bind_param('isiiiiiidsdsssssss', $receiptID, $receiptCode, $stripeCustomerID, $companyID, $salespersonID, $orderID, $invoiceID, $receiptAddress, $amount, $paymentMethod, $cashDiscount, $bank, $branch, $chequeNumber, $chequeDate, $receiptDate, $notes,$receiptStatus);
                $stmt->execute();
                $stmt->close();
                setNextReceiptCode("CLOUD");



                $detailsTra="Online Payment Receipt $receiptCode";
                $sign = -1;
                $payment -= $cashDiscount;
                $transactionID = getNextKey("Transactions", "transaction_id");
                $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
                $stmt->bind_param('isisssids', $transactionID, $receiptCode, $stripeCustomerID, $receiptDate, $receiptDate, $receiptCode, $sign, $amount, $detailsTra);
                $stmt->execute();
                $stmt->close();

                updateCustomerBalance($stripeCustomerID, $amount);
            }
            sendEmail($orderID, $receiptID);


            redirect('../viewsingleorder.php?p=1&Order='.$stripeOrderCode);
            break;
        case 'failed':

            redirect('./stripeCheckout.php?p=-1&oid='.$stripeOrderCode);
            break;
        default:

    }


}

if(isset($_GET['p']) && isset($_GET['oid'])){
    $paymentOrderCode = $_GET['oid'];
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT order_id FROM Orders WHERE order_code = '$paymentOrderCode' AND customer_id='".$_SESSION['customerID']."' AND NOT status='Canceled' AND NOT status='Placed'");
    $stm-> execute();
    $stm-> bind_result($singleOrderID);

    while ($stm->fetch()) {}
    $stm-> close();

    $paymentStatus = $_GET['p'];


    $stm = $db->prepare("SELECT company_name,primary_language,theme,favicon,use_as_b2c,google_analytics_id,allow_anonymous,facebook_link,twitter_link,logo_link,show_prices,show_language_selection FROM B2B_Configuration");
    $stm-> execute();
    $stm-> bind_result($companyName,$primaryLanguage,$theme,$custfavicon,$useAsB2C,$googleAnalyticsID,$anonymous,$facebookLink,$twitterLink,$logoLink,$showPrices,$show_language_selection);

    while ($stm->fetch()) {}
    $stm-> close();

    $stm = $db->prepare("SELECT order_id,order_code,order_date,delivery_date,subtotal,vat_amount,grand_total,details,order_address_id,status,delivery_method FROM Orders WHERE Orders.order_id='$singleOrderID' AND customer_id='".$_SESSION['customerID']."' AND NOT status='Canceled' AND NOT status='Placed' ");
    $stm-> execute();
    $stm-> bind_result($resolvedOrderID,$orderCode,$orderDate,$deliveryDate,$subtotal,$vatAmount,$grandTotal,$details,$orderAddressID,$orderStatus,$deliveryMethod);
    while ($stm->fetch()) {

        $displayGrandTotal = "".number_format(floatval($grandTotal*getPriceRate()),'2','.',',');
        if(strpos($orderStatus,'Payment Pending') !== false){$paymentStatus = 0;}
        else if(strpos($orderStatus,'Placed') !== false){$paymentStatus = 1;}


    }

    $stm-> close();



    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT currency_iso_code,merchant_id,logo FROM B2C_Payment_Methods WHERE payment_method_code = 'STRIPE' LIMIT 1");
    $stm->bind_result($isoCode,$paypalClientID,$stripeLogo);
    $stm->execute();
    while ($stm->fetch()) {}
    $stm->close();

    $currencyISO = getCurrencyIso();
    if((int)$currencyISO > 0){
        $stripeCurrencyCode = getCurrencyCodeFromISO($currencyISO);
    } else if((int)$isoCode > 0){
        $stripeCurrencyCode = getCurrencyCodeFromISO($isoCode);
    }
}


function updateCustomerBalance($customerID,$amount)
{
    global $username;
    global $password;
    global $database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE  Customers SET balance = balance - ? WHERE customer_id=?");
    $stmt->bind_param('di',$amount,$customerID);
    $stmt->execute();
    $stmt->close();

}

function getCurrencyCodeFromISO($isoCode){

    $array = array('EUR'=>'978','AFN'=>'971','ALL'=>'8','DZD'=>'12','AOA'=>'973','ARS'=>'32','AMD'=>'51','AWG'=>'533','AZN'=>'944','BSD'=>'44','BHD'=>'48','BDT'=>'50','BBD'=>'52','BYN'=>'933','BZD'=>'84','BMD'=>'60','BTN'=>'64','BOB'=>'68','BOV'=>'984','BAM'=>'977','BWP'=>'72','BRL'=>'986','BND'=>'96','BGN'=>'975','BIF'=>'108','CVE'=>'132','KHR'=>'116','CAD'=>'124','KYD'=>'136','CLF'=>'990','CLP'=>'152','CNY'=>'156','COP'=>'170','COU'=>'970','KMF'=>'174','CDF'=>'976','CRC'=>'188','HRK'=>'191','CUC'=>'931','CUP'=>'192','CZK'=>'203','DJF'=>'262','DOP'=>'214','EGP'=>'818','SVC'=>'222','ERN'=>'232','ETB'=>'230','FKP'=>'238','FJD'=>'242','XAF'=>'950','GMD'=>'270','GEL'=>'981','GHS'=>'936','GIP'=>'292','DKK'=>'208','GTQ'=>'320','GNF'=>'324','GYD'=>'328','HTG'=>'332','HNL'=>'340','HKD'=>'344','HUF'=>'348','ISK'=>'352','INR'=>'356','IDR'=>'360','XDR'=>'960','IRR'=>'364','IQD'=>'368','ILS'=>'376','JMD'=>'388','JPY'=>'392','JOD'=>'400','KZT'=>'398','KES'=>'404','KPW'=>'408','KRW'=>'410','KWD'=>'414','KGS'=>'417','LAK'=>'418','LBP'=>'422','LSL'=>'426','LRD'=>'430','LYD'=>'434','MOP'=>'446','MGA'=>'969','MWK'=>'454','MYR'=>'458','MVR'=>'462','MRU'=>'929','MUR'=>'480','XUA'=>'965','MXN'=>'484','MXV'=>'979','MDL'=>'498','MNT'=>'496','MZN'=>'943','MMK'=>'104','NAD'=>'516','NPR'=>'524','NIO'=>'558','NGN'=>'566','OMR'=>'512','PKR'=>'586','PAB'=>'590','PGK'=>'598','PYG'=>'600','PEN'=>'604','PHP'=>'608','PLN'=>'985','QAR'=>'634','MKD'=>'807','RON'=>'946','RUB'=>'643','RWF'=>'646','SHP'=>'654','XCD'=>'951','WST'=>'882','STN'=>'930','SAR'=>'682','RSD'=>'941','SCR'=>'690','SLL'=>'694','SGD'=>'702','ANG'=>'532','XSU'=>'994','SBD'=>'90','SOS'=>'706','ZAR'=>'710','SSP'=>'728','LKR'=>'144','SDG'=>'938','SRD'=>'968','NOK'=>'578','SZL'=>'748','SEK'=>'752','CHE'=>'947','CHF'=>'756','CHW'=>'948','SYP'=>'760','TWD'=>'901','TJS'=>'972','TZS'=>'834','THB'=>'764','XOF'=>'952','NZD'=>'554','TOP'=>'776','TTD'=>'780','TND'=>'788','TRY'=>'949','TMT'=>'934','AUD'=>'36','UGX'=>'800','UAH'=>'980','AED'=>'784','GBP'=>'826','USN'=>'997','UYI'=>'940','UYU'=>'858','UZS'=>'860','VUV'=>'548','VEF'=>'937','VED'=>'926','VND'=>'704','USD'=>'840','XPF'=>'953','MAD'=>'504','YER'=>'886','ZMW'=>'967','ZWL'=>'932');
    $result = array_search ((int)$isoCode, $array);
    return "$result";
}

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT password FROM B2C_Payment_Methods WHERE payment_method_code = 'STRIPE' LIMIT 1");
$stm->bind_result($PublicKey);
$stm->execute();
while ($stm->fetch()) {}
$stm->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <title>Stripe Payment</title>
    <meta name="description" content="Stripe Payment" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="stripeCheckout.css" />
    <link rel="shortcut icon" href="stripeIcon.png">
    <script src="https://js.stripe.com/v3/"></script>
    <script src="stripeChecout.js" defer></script>
    <link href="../assets/css/theme<?php echo $theme?>.css" rel="stylesheet">
    <link href="../assets/css/custom.css" rel="stylesheet">
</head>
<body style="background-color: rgb(245,246,250)">
<!-- Display a payment form -->
<form id="payment-form" style="background-color: white">
    <img class="img-rounded img-responsive center-canvas" src="../assets/img/<?php echo $stripeLogo; ?>" width="100%" height="auto" style="<?php if($singleOrderID > 0){echo "margin-top: -20px;";}else{echo"margin-top: 0px;";}?>">
    <h3 style="float: left;font-weight: bolder;margin-top:10px;color: #5469d4;"><?php if($singleOrderID > 0){echo $orderCode; }?></h3>
    <h3 style="float:right;font-weight: bolder;margin-top:10px;color: #5469d4;"><?php if($singleOrderID > 0){echo $displayGrandTotal.' '.$stripeCurrencyCode; }?></h3>
    <?php if($singleOrderID > 0){echo "<br><br>";}?>
    <input type="hidden" value="<?php echo $singleOrderID; ?>" id="orderID">
    <input type="hidden" value="<?php echo $_SESSION['customerID']; ?>" id="customerID">
    <input type="hidden" value="<?php echo $stripeCurrencyCode; ?>" id="currencyCode">
    <input type="hidden" value="<?php echo $PublicKey; ?>" id="strElement">
    <div id="payment-message" class="hidden" style="font-weight: bolder"></div>


    <?php
    if($singleOrderID > 0){
        echo '<div id="payment-element">
                    <!--Stripe.js injects the Payment Element-->
              </div>
            <button id="submit">
                <div class="spinner hidden" id="spinner"></div>
                <span id="button-text">Pay now</span>
            </button>';
        echo "<center>";

        echo "<table style='width: 100%;border: transparent;'><tr>";
        echo "<td style='width: 50%'>";
        echo "<button type='button' class='btn btn-theme btn-block btn-theme-transparent' onclick='document.getElementById(\"cancelorderForm\").submit()' style='max-width: 100%;border-radius: 4px;text-transform: none;margin-top: 14px;'><i class='fa fa-times' ></i>&nbsp;" .$langu['cancel_order']."</button>";
        echo "</td>";
        echo "<td>";
        echo "<button type='button' class='btn btn-theme btn-block ' onclick='document.getElementById(\"reorderForm\").submit()' style='max-width: 100%;border-radius: 4px;text-transform: none;margin-top: 14px;'><i class='fa fa-pencil-square-o' ></i>&nbsp;".$langu['edit_order']."</button>";

        echo "</td>";
        echo "</tr></table>";
        echo "</center>";
    }
    ?>



</form>



</body>
<?php
echo "<form action='../dbaccess/reorder.php' method='post' style='display:none;' id='reorderForm' name='reorderForm'>
                                                <input type=\"hidden\" name='orderIDToCopy' value='$singleOrderID'/>
                                                <input type=\"hidden\" name='cancelPreviousOrder' id='cancelPreviousOrder' value='yes'/>
                                                <input type=\"hidden\" name='newPaymentMethod' id='newPaymentMethod' value=''/>
                                                
                                              </form>";

echo "<form action='../dbaccess/cancelorder.php' method='post' style='display:none;' id='cancelorderForm' name='cancelorderForm'>
                                                <input type=\"hidden\" name='Cancel' value='$singleOrderID'/>
                                              </form>";


if(isset($_GET['p']) && $_GET['p'] == -1){
    echo "<script>
            var messageText = 'Your payment was not successful, please try again.';
            var messageContainerTemp = document.querySelector(\"#payment-message\");
            
                messageContainerTemp.classList.remove(\"hidden\");
                messageContainerTemp.textContent = messageText;
            
                setTimeout(function () {
                    messageContainerTemp.classList.add(\"hidden\");
                }, 4000);
            </script>";
}

?>
</html>


