<?php
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);
include_once("../../param.php");
require_once("../dbaccess/dbhelper.php");
require_once('./StripeLib/init.php');

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT merchant_id FROM B2C_Payment_Methods WHERE payment_method_code = 'STRIPE' LIMIT 1");
$stm->bind_result($MerchantKey);
$stm->execute();
while ($stm->fetch()) {}
$stm->close();


// This is your test secret API key.
\Stripe\Stripe::setApiKey($MerchantKey);

$jsonStr = file_get_contents('php://input');
$jsonObj = json_decode($jsonStr);


$orderID=$jsonObj->params[0]->orderID;
$customerID =$jsonObj->params[0]->customerID;
$currency =$jsonObj->params[0]->currencyCode;



header('Content-Type: application/json');

try {
    // retrieve JSON from POST body
    $orderObject = calculateOrderAmount($orderID, $customerID);

    // Create a PaymentIntent with amount and currency
    $paymentIntent = \Stripe\PaymentIntent::create([
        'amount' => $orderObject->amount,
        'currency' => "$currency",
        'description' => "$orderObject->orderCode",
        'automatic_payment_methods' => [
            'enabled' => true,
        ],
    ]);

    $output = [
        'clientSecret' => $paymentIntent->client_secret,
    ];

    echo json_encode($output);
} catch (Error $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}



function calculateOrderAmount($orderID, $customerID){
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");


    $stm = $db->prepare("SELECT order_code,order_date,delivery_date,subtotal,grand_total,vat_amount,customer_id,company_id,order_address_id,delivery_method,details FROM Orders WHERE order_id='$orderID' AND customer_id='$customerID'");
    $stm->execute();
    $stm->bind_result($orderCode, $orderDate,$deliveryDate, $subtotal, $grandTotal, $vatAmount,$customerID,$companyID,$orderAddressID,$deliveryMethod,$details);
    while ($stm->fetch()) {}
    $stm->close();



    $orderObject = new stdClass();
    $orderObject->amount = (int)round($grandTotal*getPriceRate()*100);
    $orderObject->orderCode = 'Online Order '.$orderCode;
    return $orderObject;
}







?>