<?php
include_once("../../param.php");
require_once("../dbaccess/dbhelper.php");

$onlineOrderID=$_POST['orderID'];
$customerID =$_POST['customerID'];
$currency =$_POST['currencyCode'];

if(isset($_GET['status']) && strcmp($_GET['status'],'1')==0){

    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ERROR);

    require_once('../dbaccess/emailOrder.php');

    $status = $_GET['status'];
    $onlineOrderID=$_GET['oid'];
    $customerID =$_GET['cid'];

    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT order_code FROM Orders WHERE order_id = '$onlineOrderID' AND customer_id='".$_SESSION['customerID']."'");
    $stm-> execute();
    $stm-> bind_result($onlineOrderCode);
    while ($stm->fetch()) {}
    $stm-> close();

    switch ($status){
        case '1':

            $amount = 0;


            $stm = $db->prepare("SELECT order_id,delivery_address_id,grand_total FROM Orders WHERE order_id=? AND customer_id=? AND NOT status='Canceled' AND NOT status='Placed'");
            $stm-> bind_param('ii', $onlineOrderID,$_SESSION['customerID']);
            $stm-> execute();
            $stm-> bind_result($orderID,$receiptAddress,$amount);
            while ($stm->fetch()) {}
            $stm->close();

            echo "SELECT order_id,delivery_address_id,grand_total FROM Orders WHERE order_id=$onlineOrderID AND customer_id=".$_SESSION['customerID']." AND NOT status='Canceled' AND NOT status='Placed'";

            $status = "Placed";

            $db->set_charset("utf8");
            $stmt = $db->prepare("UPDATE Orders SET status=?,timestamp=NOW() WHERE order_id=? AND customer_id=? AND NOT status='Canceled' AND NOT status='Placed'");
            $stmt->bind_param('ssi',$status, $onlineOrderID,$_SESSION['customerID']);
            $stmt->execute();
            $stmt->close();

            $companyID = 0;
            $salespersonID = $_SESSION['userID'];
            $invoiceID = 0;
            $receiptAddress = 0;
            $cashDiscount = 0;
            $bank = 'PayPal';
            $branch = "";
            $chequeNumber = "";
            $chequeDate = date('Y-m-d');
            $receiptDate = date('Y-m-d');
            $paymentMethod ="PayPal Online";
            $notes = "For Online Order $onlineOrderCode";
            $receiptStatus = "Confirmed";


            $stm = $db->prepare("SELECT salesperson_for_order FROM B2B_Configuration LIMIT 1");
            $stm-> execute();
            $stm-> bind_result($defaultSalesPerson);
            while ($stm->fetch()) {
                if(strcmp($defaultSalesPerson,'')!=0 && $defaultSalesPerson > 0){
                    $salespersonID = $defaultSalesPerson;
                } else {
                    $salespersonID = 0;
                }
            }
            $stm->close();
            if($amount > 0) {

                $receiptID   = getNextKey("Receipts","receipt_id");
                $receiptCode = getReceiptPrefix("CLOUD").getNextReceiptCode("CLOUD");
                $db->set_charset("utf8");
                $stmt = $db->prepare("INSERT INTO Receipts (receipt_id, receipt_code, customer_id, company_id, salesperson_id, order_id, invoice_id, address_id, amount, payment_method, cash_discount, bank, branch, cheque_number, cheque_date, receipt_date, notes,status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                $stmt->bind_param('isiiiiiidsdsssssss', $receiptID, $receiptCode, $customerID, $companyID, $salespersonID, $orderID, $invoiceID, $receiptAddress, $amount, $paymentMethod, $cashDiscount, $bank, $branch, $chequeNumber, $chequeDate, $receiptDate, $notes,$receiptStatus);
                $stmt->execute();
                $stmt->close();
                setNextReceiptCode("CLOUD");



                $detailsTra="Online Payment Receipt $receiptCode";
                $sign = -1;
                $payment -= $cashDiscount;
                $transactionID = getNextKey("Transactions", "transaction_id");
                $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
                $stmt->bind_param('isisssids', $transactionID, $receiptCode, $customerID, $receiptDate, $receiptDate, $receiptCode, $sign, $amount, $detailsTra);
                $stmt->execute();
                echo $stmt->error;
                $stmt->close();

                updateCustomerBalance($customerID, $amount);
            }
            sendEmail($orderID, $receiptID);

            redirect('../viewsingleorder.php?p=1&Order='.$onlineOrderCode);
            break;
        default:


    }

} else if(isset($currency) && strcmp($currency,'')!=0) {
    echo getItemsInCartForPaypal($onlineOrderID, $customerID, $currency);
}
function getItemsInCartForPaypal($orderID,$customerID,$currency)
{

    $dbOrderItems = array();
    $dbOrderSubTotal = 0;
    $dbOrderVatTotal = 0;
    $dbOrderDiscountTotal = 0;
    $dbOrderDeliveryTotal = 0;
    $vatNotes = array();
    $vatItems = array();

    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT company_name FROM B2B_Configuration LIMIT 1");
    $stm->bind_result($companyName);
    $stm->execute();
    while ($stm->fetch()) {}
    $stm->close();

    $stm = $db->prepare("SELECT order_code,order_date,delivery_date,subtotal,grand_total,vat_amount,customer_id,company_id,order_address_id,delivery_method,details FROM Orders WHERE order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($orderCode, $orderDate,$deliveryDate, $subtotal, $grandTotal, $vatAmount,$customerID,$companyID,$orderAddressID,$deliveryMethod,$details);
    while ($stm->fetch()) {}
    $stm->close();

    $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,country,region,city,landline FROM CustomerAddress WHERE customer_address_id='$orderAddressID'");
    $stm->execute();
    $stm->bind_result($addressLine1, $addressLine2,$postcode,$country,$region,$city,$landline);
    while ($stm->fetch()) {}
    $stm->close();

    $stm = $db->prepare("SELECT Items.name,Order_Item.item_id,Order_Item.qty,Order_Item.unit_price,Order_Item.line_discount,Order_Item.description,Order_Item.master_item,Items.vat_id,Order_Item.promotion_id FROM Order_Item,Items WHERE Order_Item.item_id=Items.item_id AND Order_Item.order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($itemName,$itemID, $qty, $unitPrice, $lineDiscount, $lineNotes, $masterItem, $vatID, $promoID);
    while ($stm->fetch()) {

        $lineTotal = ((float)$qty * (float)$unitPrice) - $lineDiscount;
        $vatPercent = getVatPercentage($vatID);
        $vatAmount = $lineTotal * $vatPercent / 100;
        if($vatPercent > 0) {
            array_push($vatNotes, $vatPercent . "%");
            $vatNotes = array_unique($vatNotes);
            $vatItems[$vatPercent] += $vatAmount;
        }

        $dbOrderSubTotal += $lineTotal;
        $dbOrderVatTotal += $vatAmount;
        $dbOrderDiscountTotal += $lineDiscount;

        $dbItem = new stdClass();
        $dbItem->name = $itemName;
        $dbItem->description = $lineNotes;
        $dbItem->unit_amount = array('currency_code'=>$currency,'value'=>round(($lineTotal)/(float)$qty,2));
        $dbItem->quantity = $qty;


        array_push($dbOrderItems, $dbItem);
    }
    $stm->close();




    $dbOrderSubTotal = round($dbOrderSubTotal, 2);
    $dbOrderVatTotal = round($dbOrderVatTotal, 2);
    $dbOrderDiscountTotal = round($dbOrderDiscountTotal, 2);
    $dbOrderDeliveryTotal = round($dbOrderDeliveryTotal, 2);
    $grandTotal = round($dbOrderSubTotal + $dbOrderVatTotal + $dbOrderDeliveryTotal - $dbOrderDiscountTotal, 2);

    if($dbOrderVatTotal){

        foreach ($vatItems as $vatPercent => $vatPercentTotal) {
            $dbItem = new stdClass();
            $dbItem->name = "VAT $vatPercent%";
            $dbItem->description = '';
            $dbItem->unit_amount = array('currency_code'=>$currency,'value'=>round($vatPercentTotal,2));
            $dbItem->quantity = 1;

            array_push($dbOrderItems, $dbItem);
        }

    }


    $dbOrder = new stdClass();

    $dbOrder->reference_id = "$orderCode";
    $dbOrder->amount = array(
        'currency_code' => $currency,
        'value'=>$grandTotal,
        'breakdown'=>array(
            'item_total'=>array(
                'currency_code'=>$currency,
                'value'=>$grandTotal
            )
        )
    );

    if(false) {
        $dbOrder->items = $dbOrderItems;
    }
    $dbOrder->shipping = array(
        "address"=>array(
            "address_line_1"=>"$addressLine1",
            "address_line_2"=>"$addressLine2",
            "admin_area_2"=>"$city",
            "admin_area_1"=>"$region",
            "postal_code"=>"$postcode",
            "country_code"=>getCountryCodeFromName($country)
        )
    );

    $result = new stdClass();
    $result->application_context = array(
        'brand_name'=>$companyName,
        "shipping_preference"=>"SET_PROVIDED_ADDRESS",
        "user_action"=>"PAY_NOW",
    );


    $result->purchase_units = array($dbOrder);


    return json_encode($result);
}

function getCountryCodeFromName($country){
    $array = array (
        'AW' => 'Aruba',
        'AF' => 'Afghanistan',
        'AO' => 'Angola',
        'AL' => 'Albania',
        'AD' => 'Andorra',
        'AE' => 'United Arab Emirates',
        'AR' => 'Argentina',
        'AM' => 'Armenia',
        'AS' => 'American Samoa',
        'AG' => 'Antigua and Barbuda',
        'AU' => 'Australia',
        'AT' => 'Austria',
        'AZ' => 'Azerbaijan',
        'BI' => 'Burundi',
        'BE' => 'Belgium',
        'BJ' => 'Benin',
        'BF' => 'Burkina Faso',
        'BD' => 'Bangladesh',
        'BG' => 'Bulgaria',
        'BH' => 'Bahrain',
        'BS' => 'Bahamas, The',
        'BA' => 'Bosnia and Herzegovina',
        'BY' => 'Belarus',
        'BZ' => 'Belize',
        'BM' => 'Bermuda',
        'BO' => 'Bolivia',
        'BR' => 'Brazil',
        'BB' => 'Barbados',
        'BN' => 'Brunei Darussalam',
        'BT' => 'Bhutan',
        'BW' => 'Botswana',
        'CF' => 'Central African Republic',
        'CA' => 'Canada',
        'CH' => 'Switzerland',
        'JG' => 'Channel Islands',
        'CL' => 'Chile',
        'CN' => 'China',
        'CI' => 'Cote d\'Ivoire',
        'CM' => 'Cameroon',
        'CD' => 'Congo, Dem. Rep.',
        'CG' => 'Congo, Rep.',
        'CO' => 'Colombia',
        'KM' => 'Comoros',
        'CV' => 'Cabo Verde',
        'CR' => 'Costa Rica',
        'CU' => 'Cuba',
        'CW' => 'Curacao',
        'KY' => 'Cayman Islands',
        'CY' => 'Cyprus',
        'CZ' => 'Czech Republic',
        'DE' => 'Germany',
        'DJ' => 'Djibouti',
        'DM' => 'Dominica',
        'DK' => 'Denmark',
        'DO' => 'Dominican Republic',
        'DZ' => 'Algeria',
        'EC' => 'Ecuador',
        'EG' => 'Egypt, Arab Rep.',
        'ER' => 'Eritrea',
        'ES' => 'Spain',
        'EE' => 'Estonia',
        'ET' => 'Ethiopia',
        'FI' => 'Finland',
        'FJ' => 'Fiji',
        'FR' => 'France',
        'FO' => 'Faroe Islands',
        'FM' => 'Micronesia, Fed. Sts.',
        'GA' => 'Gabon',
        'GB' => 'United Kingdom',
        'GE' => 'Georgia',
        'GH' => 'Ghana',
        'GI' => 'Gibraltar',
        'GN' => 'Guinea',
        'GM' => 'Gambia, The',
        'GW' => 'Guinea-Bissau',
        'GQ' => 'Equatorial Guinea',
        'GR' => 'Greece',
        'GD' => 'Grenada',
        'GL' => 'Greenland',
        'GT' => 'Guatemala',
        'GU' => 'Guam',
        'GY' => 'Guyana',
        'HK' => 'Hong Kong SAR, China',
        'HN' => 'Honduras',
        'HR' => 'Croatia',
        'HT' => 'Haiti',
        'HU' => 'Hungary',
        'ID' => 'Indonesia',
        'IM' => 'Isle of Man',
        'IN' => 'India',
        'IE' => 'Ireland',
        'IR' => 'Iran, Islamic Rep.',
        'IQ' => 'Iraq',
        'IS' => 'Iceland',
        'IL' => 'Israel',
        'IT' => 'Italy',
        'JM' => 'Jamaica',
        'JO' => 'Jordan',
        'JP' => 'Japan',
        'KZ' => 'Kazakhstan',
        'KE' => 'Kenya',
        'KG' => 'Kyrgyz Republic',
        'KH' => 'Cambodia',
        'KI' => 'Kiribati',
        'KN' => 'St. Kitts and Nevis',
        'KR' => 'Korea, Rep.',
        'KW' => 'Kuwait',
        'LA' => 'Lao PDR',
        'LB' => 'Lebanon',
        'LR' => 'Liberia',
        'LY' => 'Libya',
        'LC' => 'St. Lucia',
        'LI' => 'Liechtenstein',
        'LK' => 'Sri Lanka',
        'LS' => 'Lesotho',
        'LT' => 'Lithuania',
        'LU' => 'Luxembourg',
        'LV' => 'Latvia',
        'MO' => 'Macao SAR, China',
        'MF' => 'St. Martin (French part)',
        'MA' => 'Morocco',
        'MC' => 'Monaco',
        'MD' => 'Moldova',
        'MG' => 'Madagascar',
        'MV' => 'Maldives',
        'MX' => 'Mexico',
        'MH' => 'Marshall Islands',
        'MK' => 'Macedonia, FYR',
        'ML' => 'Mali',
        'MT' => 'Malta',
        'MM' => 'Myanmar',
        'ME' => 'Montenegro',
        'MN' => 'Mongolia',
        'MP' => 'Northern Mariana Islands',
        'MZ' => 'Mozambique',
        'MR' => 'Mauritania',
        'MU' => 'Mauritius',
        'MW' => 'Malawi',
        'MY' => 'Malaysia',
        'NA' => 'Namibia',
        'NC' => 'New Caledonia',
        'NE' => 'Niger',
        'NG' => 'Nigeria',
        'NI' => 'Nicaragua',
        'NL' => 'Netherlands',
        'NO' => 'Norway',
        'NP' => 'Nepal',
        'NR' => 'Nauru',
        'NZ' => 'New Zealand',
        'OM' => 'Oman',
        'PK' => 'Pakistan',
        'PA' => 'Panama',
        'PE' => 'Peru',
        'PH' => 'Philippines',
        'PW' => 'Palau',
        'PG' => 'Papua New Guinea',
        'PL' => 'Poland',
        'PR' => 'Puerto Rico',
        'KP' => 'Korea, Dem. People’s Rep.',
        'PT' => 'Portugal',
        'PY' => 'Paraguay',
        'PS' => 'West Bank and Gaza',
        'PF' => 'French Polynesia',
        'QA' => 'Qatar',
        'RO' => 'Romania',
        'RU' => 'Russian Federation',
        'RW' => 'Rwanda',
        'SA' => 'Saudi Arabia',
        'SD' => 'Sudan',
        'SN' => 'Senegal',
        'SG' => 'Singapore',
        'SB' => 'Solomon Islands',
        'SL' => 'Sierra Leone',
        'SV' => 'El Salvador',
        'SM' => 'San Marino',
        'SO' => 'Somalia',
        'RS' => 'Serbia',
        'SS' => 'South Sudan',
        'ST' => 'Sao Tome and Principe',
        'SR' => 'Suriname',
        'SK' => 'Slovak Republic',
        'SI' => 'Slovenia',
        'SE' => 'Sweden',
        'SZ' => 'Swaziland',
        'SX' => 'Sint Maarten (Dutch part)',
        'SC' => 'Seychelles',
        'SY' => 'Syrian Arab Republic',
        'TC' => 'Turks and Caicos Islands',
        'TD' => 'Chad',
        'TG' => 'Togo',
        'TH' => 'Thailand',
        'TJ' => 'Tajikistan',
        'TM' => 'Turkmenistan',
        'TL' => 'Timor-Leste',
        'TO' => 'Tonga',
        'TT' => 'Trinidad and Tobago',
        'TN' => 'Tunisia',
        'TR' => 'Turkey',
        'TV' => 'Tuvalu',
        'TW' => 'Taiwan, China',
        'TZ' => 'Tanzania',
        'UG' => 'Uganda',
        'UA' => 'Ukraine',
        'UY' => 'Uruguay',
        'US' => 'United States',
        'UZ' => 'Uzbekistan',
        'VC' => 'St. Vincent and the Grenadines',
        'VE' => 'Venezuela, RB',
        'VG' => 'British Virgin Islands',
        'VI' => 'Virgin Islands (U.S.)',
        'VN' => 'Vietnam',
        'VU' => 'Vanuatu',
        'WS' => 'Samoa',
        'XK' => 'Kosovo',
        'YE' => 'Yemen, Rep.',
        'ZA' => 'South Africa',
        'ZM' => 'Zambia',
        'ZW' => 'Zimbabwe',
    );

    $result = array_search($country, $array);

    return $result;
}

function updateCustomerBalance($customerID,$amount)
{
    global $username;
    global $password;
    global $database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE  Customers SET balance = balance - ? WHERE customer_id=?");
    $stmt->bind_param('di',$amount,$customerID);
    $stmt->execute();
    $stmt->close();

}

function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

?>
