<?php

include_once("../param.php");
header("content-type: text/html;charset=utf-8");

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$primaryLanguage = "en";
$stm = $db->prepare("SELECT company_name,primary_language,theme,favicon,use_as_b2c,google_analytics_id,allow_anonymous,facebook_link,twitter_link,logo_link,show_prices,show_language_selection FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($companyName,$primaryLanguage,$theme,$custfavicon,$useAsB2C,$googleAnalyticsID,$anonymous,$facebookLink,$twitterLink,$logoLink,$showPrices,$show_language_selection);

while ($stm->fetch()) {}
$stm-> close();
if(strcmp($show_language_selection,'no')==0){$_SESSION['show_language_selection'] = false;} else {$_SESSION['show_language_selection'] = true;}

$available_langs = array('en','el');

if(strcmp($useAsB2C,'yes')==0){$_SESSION['B2C'] = true;} else {$_SESSION['B2C'] = false;}


$favicon = "favicon.ico";
if(strcmp($custfavicon,'')!=0 && file_exists("./assets/ico/$custfavicon")){
    $favicon = $custfavicon;
}

if(!isset($_SESSION['lang']))
{
    $_SESSION['lang'] = $primaryLanguage;
}

if(isset($_GET['lang']) && $_GET['lang'] != ''){
    // check if the language is one we support
    if(in_array($_GET['lang'], $available_langs))
    {
        $_SESSION['lang'] = $_GET['lang']; // Set session
    }
}

if(strcmp($showPrices,'yes')==0){
    $showPrices = true;
} else {
    $showPrices = false;
}

if(strcmp($anonymous,'no')==0) {
    if (!isset($_SESSION['customerID'])||$_SESSION['customerID']==0) {
        $filePathURL = basename($_SERVER['REQUEST_URI'], '?' . $_SERVER['QUERY_STRING']);

        if(strcmp($filePathURL,"accountDeletionInfoWebView.php")!=0 && strcmp($filePathURL,"accountDeletionInfoNative.php")!=0 && strcmp($filePathURL,"product-gallery.php")!=0 && strcmp($filePathURL,"login.php")!=0 && strcmp($filePathURL,"request_account_page.php")!=0 && strcmp($filePathURL,"register_page.php")!=0 && strcmp($filePathURL,"forgotpassword.php")!=0 && strcmp($filePathURL,"resetpass.php")!=0 && strcmp($filePathURL,"dynamic_page.php")!=0) {
            redirect("login.php");
        }
    }
}

include('./langs/'.$_SESSION['lang'].'.php');


if(file_exists(B2B_ROOT . "custom/custom_functions.js")) {
    $customFunctionsDir = 'custom/custom_functions.js';
} else {
    $customFunctionsDir = 'assets/js/custom_functions.js';
}


?>


<!DOCTYPE html>
<html lang="en" translate="no">
<head>
    <base href="<?php echo "//".HTML_PATH."/cop/b2b/"; ?>">
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo $googleAnalyticsID?>"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', '<?php echo $googleAnalyticsID?>');
    </script>

    <meta charset="utf-8">
    <!--[if IE]><meta http-equiv="X-UA-Compatible" content="IE=edge"><![endif]-->
    <meta name="viewport" content="width=device-width, initial-scale=1">

         <title>  <?php echo $companyName ?></title>

    <!-- Favicon -->
    <link rel="apple-touch-icon-precomposed" sizes="144x144" href="assets/ico/<?php echo $favicon?>">
    <link rel="shortcut icon" href="assets/ico/<?php echo $favicon?>">

    <!-- CSS Global -->
    <link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/plugins/bootstrap-select/css/bootstrap-select.min.css" rel="stylesheet">
    <link href="assets/plugins/fontawesome/css/font-awesome.min.css" rel="stylesheet">
    <link href="assets/plugins/prettyphoto/css/prettyPhoto.css" rel="stylesheet">
    <link href="assets/plugins/owl-carousel2/assets/owl.carousel.min.css" rel="stylesheet">
    <link href="assets/plugins/owl-carousel2/assets/owl.theme.default.min.css" rel="stylesheet">
    <link href="assets/plugins/animate/animate.min.css" rel="stylesheet">


    <link href="assets/plugins/jquery-ui/jquery-ui.min.css" rel="stylesheet">

    <link href="assets/css/waitMe.min.css" rel="stylesheet">

    <!-- Theme CSS -->
    <link href="assets/css/theme<?php echo $theme?>.css" rel="stylesheet">
    <link href="assets/css/custom.css" rel="stylesheet">
    <link href="assets/css/autocomplete<?php echo $theme?>.css" rel="stylesheet">

    <link href="assets/css/jqpagination<?php echo $theme?>.css" rel="stylesheet">

    <link href="//cdn.rawgit.com/noelboss/featherlight/1.6.1/release/featherlight.min.css" type="text/css" rel="stylesheet" />

    <!-- Head Libs -->
    <script src="assets/plugins/modernizr.custom.js"></script>

    <!--[if lt IE 9]>
    <script src="assets/plugins/iesupport/html5shiv.js"></script>
    <script src="assets/plugins/iesupport/respond.min.js"></script>
    <![endif]-->

    <script src="//code.jquery.com/jquery-latest.js"></script>
    <script src="//cdn.rawgit.com/noelboss/featherlight/1.6.1/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>

    <script src="<?php echo $customFunctionsDir; ?>"></script>

</head>
