<?php
session_start();
include_once("../../param.php");
require("dbhelper.php");
include_once('emailOrder.php');

$showPrices=true;
$dropShip=false;
$addItemByUnits = true;
global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT primary_language,show_prices,drop_ship,order_qty_by_subunits FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($primaryLanguage,$showPrices,$isDropShip,$orderQtyBySubunits);

while ($stm->fetch()) {
    if(strcmp($showPrices,"no")==0 || $_SESSION['showPrices']==false)
    {
        $showPrices=false;
    }
    if(strcmp($isDropShip,"yes")==0){
        $dropShip=true;
    }
    if(strcmp($orderQtyBySubunits,'yes')==0){
        $addItemByUnits = false;
    }
}
$stm-> close();

if(strcmp($_SESSION['lang'],"")!=0){
    include('../langs/'.$_SESSION['lang'].'.php');
} else if(strcmp($primaryLanguage,"")!=0){
    include('../langs/'.$_SESSION['lang'].'.php');
} else {
    include('../langs/en.php');
}

$onlineOrderID=$_SESSION['orderID'];
$customerID =$_SESSION['customerID'];
$companyID =$_SESSION['companyID'];
$salespersonID =$_SESSION['userID'];
$userID=$_SESSION['userID'];

//setNextOrderCode("CLOUD");
$dataPOST = trim(file_get_contents('php://input'));

$orderDate = date('Y/m/d', time());

$deliveryTotal=$_POST['deliveryTotal'];
$subtotal = $_POST['subtotal'];
$vatAmount=$_POST['vatAmount'];
$grandTotal=$_POST['grandTotal'];
$discountAmount=$_POST['discountTotal'];
$orderAddressID = $_POST['billAddress'];
$deliveryAddressID=$_POST['address'];
$deliveryDate=$_POST['deliveryDate'];
$deliveryFeeItem=trim(''.$_POST['deliveryFeeItem']);
$weightFeeItem=trim(''.$_POST['weightFeeItem']);
$weightFeeItemQty=trim(''.$_POST['weightFeeItemQty']);
$deliveryMethod=trim(''.$_POST['deliveryMethod']);
$onlineOrderItems = $_POST['onlineOrderItems'];

if(strcmp($orderAddressID,'')==0 || $orderAddressID == 0){
    $orderAddressID = $deliveryAddressID;
}

$anonymousCheckout = $_POST['anonymousCheckout'];
if($anonymousCheckout){
    if(isset($_POST['anonymousCheckoutCustomer']) && $_POST['anonymousCheckoutCustomer'] > 0){
        $customerID = $_POST['anonymousCheckoutCustomer'];
        $salespersonID = 0;
    }
}

if(strcmp($deliveryMethod,'')==0){
    $deliveryMethod="Not Set";
}


$isCredit = true;
if(isset($_POST['isCredit']) && strcmp($_POST['isCredit'],'no')==0){
    $isCredit = false;
}

if(isset($deliveryTotal)&& $deliveryTotal>0) {
    $subtotal+=$deliveryTotal;
}



if(isset($_POST['details'])) {
    $details = $_POST['details'];
}
else{
    $details="";
}
if($isCredit) {
    $status = "Pending Approval";
} else {
    $status = "Payment Pending";
}
$printCount=0;
$paymentTypeID=1;
//$orderID= getNextKey("Orders","order_id");
$tenderID=$currencyID=$globalDiscountPercentage=$depositAmount=0;
$vatIE="E";
if(!isset($_POST['deliveryDate'])) {
    $deliveryDate = date('Y/m/d', time());
}

$defaultCurrency = getDefaultCurrency();
$currencyID = getOrderCurrency();
$currencySign = getCurrencySign();

$subtotalBase = 0;
$vatAmountBase = 0;
$grandTotalBase = 0;
$deliveryTotalBase = 0;
$weightFeeTotalBase = 0;

$onlineOrderItems = json_decode($onlineOrderItems, true);
foreach ($onlineOrderItems as $onlineOrderItem) {

    $itemID = $onlineOrderItem['itemID'];
    $qty = $onlineOrderItem['Quantity'];
    $unitPrice = $onlineOrderItem['UP'] / $defaultCurrency->rate;
    $vatID = $onlineOrderItem['vatID'];
    $discountAmountLine = $onlineOrderItem['discountAmountLine'];

    if($addItemByUnits) {
        $lineTotal = $unitPrice*$qty;
    } else {
        $lineTotal = $unitPrice*$qty / floatval(getSubUnits($itemID));
    }

    $vatAmountLine = ($lineTotal-$discountAmountLine) * getVatPercentage($vatID) / 100;

    $subtotalBase += $lineTotal;
    $vatAmountBase += $vatAmountLine;
    $grandTotalBase += $lineTotal+$vatAmountLine;

//    $testItemsText .= "$itemID - $qty - $unitPrice - $vatAmountLine - $lineTotal :: $subtotalBase - $vatAmountBase - $grandTotalBase\n";
}

$subTotalWithoutFee = $subtotalBase;
$deliveryFeeAndNotes=getDeliveryCost($subTotalWithoutFee,count($onlineOrderItems),$customerID,$db);
if (isset($deliveryFeeAndNotes[0]) && $deliveryFeeAndNotes[0] > 0) {
    $feeItemID = $deliveryFeeAndNotes[2];
    $vatID = getItemVatID($feeItemID, $db);
    $qty = 1;
    $unitPrice = $deliveryFeeAndNotes[0] / $defaultCurrency->rate;
    $vatAmountLine = $unitPrice * getVatPercentage($vatID) / 100;

    $subtotalBase += $unitPrice;
    $deliveryTotalBase += $unitPrice;
    $grandTotalBase += $unitPrice + $vatAmountLine;
    $vatAmountBase += $vatAmountLine;


}

if(isset($deliveryFeeItem) && $deliveryFeeItem > 0) {

    $itemID = $deliveryFeeItem;
    $vatID = getItemVatID($itemID, $db);
    $qty = 1;
    $unitPrice = getDefaultPrice($itemID, $customerID, $db) / $defaultCurrency->rate;
    $vatAmountLine = $unitPrice * getVatPercentage($vatID) / 100;

    $subtotalBase += $unitPrice;
    $vatAmountBase += $vatAmountLine;
    $deliveryTotalBase += $unitPrice;
    $grandTotalBase += $unitPrice+$vatAmountLine;
}

if(isset($weightFeeItem) && $weightFeeItem > 0) {

    $itemID = $weightFeeItem;
    $vatID = getItemVatID($itemID, $db);
    $qty = (float)$weightFeeItemQty;
    $unitPrice = getDefaultPrice($itemID, $customerID, $db) / $defaultCurrency->rate;

    $lineTotal = $unitPrice * $qty;
    $vatAmountLine = $lineTotal * getVatPercentage($vatID) / 100;



    $subtotal += $unitPrice * $qty;

    $subtotalBase += $lineTotal;
    $vatAmountBase += $vatAmountLine;
    $grandTotalBase += $lineTotal+$vatAmountLine;
    $weightFeeTotalBase = $lineTotal;
}

$discountAmountBase = $discountAmount  / $defaultCurrency->rate;
$grandTotalBase = $grandTotalBase - $discountAmountBase;

$discountAmountBase = round($discountAmountBase,2);
$subtotalBase = round($subtotalBase,2);
$vatAmountBase = round($vatAmountBase,2);
$grandTotalBase = round($grandTotalBase,2);

include_once('getItemsInCartForOrder.php');
$dbOrder = getItemsInCartForOrder($onlineOrderID,$customerID);
$error = false;
$errorText = "Order $onlineOrderID:\n";
//$errorText .= "$testItemsText";
$errorText .="\nCurrency Rate: $defaultCurrency->code -> $currencySign$defaultCurrency->rate \n";

if(strcmp($dbOrder->subTotalWithDelivery,(float)$subtotalBase)!=0 && (float)$subtotalBase > 0){$error = true;$errorText .="\nSubtotal Amount: DB $dbOrder->subTotalWithDelivery != VIEW $subtotalBase";}
if(round(abs($dbOrder->deliveryTotal - $deliveryTotalBase),2)>0.01 && (float)$deliveryTotalBase > 0){$error = true;$errorText .="\nDelivery Fee: DB $dbOrder->deliveryTotal != VIEW $deliveryTotalBase";}
if(round(abs($dbOrder->weightFeeTotal - $weightFeeTotalBase),2)>0.01 && (float)$weightFeeTotalBase > 0){$error = true;$errorText .="\nWeight Fee: DB $dbOrder->weightFeeTotal != VIEW $weightFeeTotalBase";}
if(round(abs($dbOrder->discountTotal - $discountAmountBase),2)>0.01 && (float)$discountAmountBase > 0){$error = true;$errorText .="\nDiscount Amount: DB $dbOrder->discountTotal != VIEW $discountAmountBase";}
if(round(abs($dbOrder->vatTotal - $vatAmountBase),2)>0.01 && (float)$vatAmountBase > 0){$error = true;$errorText .="\nVat Amount: DB $dbOrder->vatTotal != VIEW $vatAmountBase";}
if(round(abs($dbOrder->grandTotal - $grandTotalBase),2)>0.01  && $grandTotalBase > 0){$error = true;$errorText .="\nGrand Total: DB $dbOrder->grandTotal != VIEW $grandTotalBase ";}
if(count($dbOrder->items) !== count($onlineOrderItems)){$error = true;$errorText .="\nItems: DB ".count($dbOrder->items)." != VIEW ".count($onlineOrderItems);}
if($error){
    $errorFile = fopen('errorOrder.txt','w');
    fwrite($errorFile,"$errorText\n");
    fwrite($errorFile,json_encode($dbOrder)."\n");
    fclose($errorFile);
    echo 0;
    return 0;
} else {

    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    try {
        $db->begin_transaction();

        $orderCode =  getNextCode('Orders','order_code',"O","CLOUD",$db);

        $myfile = fopen("tata.txt", "w") or die("Unable to open file!");
        fwrite($myfile, $dataPOST);
        fwrite($myfile, "\n" . $orderCode);
        fclose($myfile);

        $stm = $db->prepare("SELECT salesperson_for_order FROM B2B_Configuration LIMIT 1");
        $stm->execute();
        $stm->bind_result($defaultSalesPerson);
        while ($stm->fetch()) {
            if (strcmp($defaultSalesPerson, '') != 0 && $defaultSalesPerson > 0) {
                $salespersonID = $defaultSalesPerson;
            }
        }
        $stm->close();
        if (strcmp($companyID, '') == 0) {
            $companyID = 0;
        }
        $checkItems = count($onlineOrderItems);

        if ($checkItems > 0) {

            $orderID = 0;
            $stmt = $db->prepare("INSERT INTO Orders (order_id,order_code,company_id,online_order_id,customer_id,salesperson_id,paymenttype_id,order_date,subtotal,grand_total,vat_amount,discount_amount,print_count,order_address_id,delivery_address_id,tender_id,vat_i_or_e,delivery_date,deposit_amount,details,status,currency_id,global_discount_percentage,delivery_method,timestamp) VALUES(?,?,1,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,0,?,?,NOW())");
            $stmt->bind_param('isiiiisddddiiiissdssds', $orderID, $orderCode, $onlineOrderID, $customerID, $salespersonID, $paymentTypeID, $orderDate, $subtotalBase, $grandTotalBase, $vatAmountBase, $discountAmountBase, $printCount, $orderAddressID, $deliveryAddressID, $tenderID, $vatIE, $deliveryDate, $depositAmount, $details, $status, $globalDiscountPercentage, $deliveryMethod);
            $stmt->execute();
            if (strcmp($stmt->error, "") != 0) {
                throw new Exception($stmt->error);
            }
            $stmt->close();


            $stm = $db->prepare("SELECT order_id FROM Orders WHERE online_order_id='$onlineOrderID'");
            $stm->execute();
            $stm->bind_result($orderID);
            while ($stm->fetch()) {

            }
            $stm->close();

            // -------------- Order_Delivery_Details 10112023 --------------

            $instantDeliveryCheck = $_SESSION['selectedDeliveryOption'];
            if(isset($_POST['timeSlotsFrom']) && strcmp("$instantDeliveryCheck",'instantDelivery')!=0){$timeSlotsFrom = $deliveryDate . ' ' . $_POST['timeSlotsFrom'];}
            else {$timeSlotsFrom = "";}

            if(isset($_POST['timeSlotsTo']) &&  strcmp("$instantDeliveryCheck",'instantDelivery')!=0){$timeSlotsTo = $deliveryDate . ' ' . $_POST['timeSlotsTo'];}
            else {$timeSlotsTo = "";}

            $serviceCallID = 0;
            $assignTo = 0;
            $deliveryStatus = "";
            $deliveryNotes = "";
            $paymentMethodID = intval($_POST['paymentMethodID']);
            $deliveryFeeItemID = intval($deliveryFeeItem);
            $weightFeeItemID = intval($weightFeeItem);
            $orderTime = date('Y-m-d H:i:s');
            $deliveryTime = "";
            $prepareDurationMinutes = 0;
            $b2bUserID = $_SESSION['userID'];

            $stm = $db->prepare("SELECT name FROM B2C_Payment_Methods WHERE payment_method_id='$paymentMethodID' LIMIT 1");
            $stm->execute();
            $stm->bind_result($paymentMethodDescription);
            while ($stm->fetch()) {}
            $stm->close();

            $paymentMethodDescription = "$paymentMethodDescription";

            $detailsPayment = explode("\nPayment Method:","$details");
            $deliveryNotes = $detailsPayment[0];
            $paymentMethodAndTimeslot = $detailsPayment[1];
            $paymentMethodAndTimeslot = explode("\nTime Slot:","$paymentMethodAndTimeslot");
            $paymentMethod = $paymentMethodAndTimeslot[0];
            $timeSlot = $paymentMethodAndTimeslot[1];
            $paymentMethodAndAnonymousCustomer = explode("\nCustomer: ","$paymentMethod");
            $addressLine1ANDCustomer = $paymentMethodAndAnonymousCustomer[1];
            $addressLine1ANDCustomer = explode("\nAddress: ","$addressLine1ANDCustomer");
            $anonymousCustomerName = $addressLine1ANDCustomer[0];
            $addressANDContact = $addressLine1ANDCustomer[1];
            $addressANDContact = explode("\nPhone: ","$addressANDContact");
            $anonymousAddress = $addressANDContact[0];
            $anonymousContact = $addressANDContact[1];

            if(strcmp($anonymousCustomerName,"")!=0) {
                $deliveryNotes .= "\nCustomer: $anonymousCustomerName\nAddress: $anonymousAddress\nPhone: $anonymousContact";
            }

            $deliveryNotes = str_replace("\n","#newline#",$deliveryNotes);


            $stmt = $db->prepare("INSERT INTO Order_Delivery_Details(order_id, service_call_id, assign_to, delivery_fee_item_id, weight_fee_item_id, time_slot_from, time_slot_to, order_time, delivery_time, prepare_duration_minutes, delivery_status, delivery_notes,payment_method_id,payment_method_description,user_id, timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
            $stmt->bind_param('iiiiisssssssisi', $orderID, $serviceCallID, $assignTo, $deliveryFeeItemID, $weightFeeItemID, $timeSlotsFrom, $timeSlotsTo, $orderTime, $deliveryTime, $prepareDurationMinutes, $deliveryStatus, $deliveryNotes,$paymentMethodID,$paymentMethodDescription,$b2bUserID);
            $stmt->execute();
            if (strcmp($stmt->error, "") != 0) {throw new Exception($stmt->error);}
            $stmt->close();

            // -------------- Order_Delivery_Details 10112023 --------------

            if($dbOrder->loyaltyPointsClaimed > 0) {
                $stmt = $db->prepare(" SELECT loyalty_type_id,name FROM Loyalty_Types WHERE type = '2' AND status='yes' AND DATE(valid_from)<=DATE(NOW()) AND DATE(valid_until)>=DATE(NOW()) ORDER BY valid_from DESC,valid_until ASC");
                $stmt->execute();
                $stmt->bind_result($activeLotyaltyID, $activeLoyaltyName);
                if (strcmp($stmt->error, "") != 0) {
                    throw new Exception($stmt->error);
                }
                while ($stmt->fetch()) {}
                $stmt->close();

                if ($activeLotyaltyID > 0) {
                    $loyaltyPoints = array();
                    $loyaltyPoints["$activeLotyaltyID"]["-1"]['points'] += (float)$dbOrder->loyaltyPointsClaimed;
                    $loyaltyPoints["$activeLotyaltyID"]["-1"]['name'] = $activeLoyaltyName;

                    if((float)$dbOrder->loyaltyPointsClaimed > 0){
                        $loyaltyDetails = "Loyalty Points Claimed: " . (float)$dbOrder->loyaltyPointsClaimed." ".$activeLoyaltyName.".\n".$details;
                        $stmt = $db->prepare("UPDATE Orders SET details = ? WHERE order_id = ?");
                        $stmt->bind_param('si', $loyaltyDetails, $orderID);
                        $stmt->execute();
                        if (strcmp($stmt->error, "") != 0) {throw new Exception($stmt->error);}
                        $stmt->close();
                    }
                }

                insertLoyaltyPoints($customerID, $loyaltyPoints, $orderID, $orderCode, $grandTotalBase, $userID, $companyID, $db);
            }







            $stmt = $db->prepare("INSERT INTO Multi_Currency_Orders (order_id, subtotal_base, grand_total_base, vat_amount_base, discount_base, subtotal_currency, grand_total_currency, vat_amount_currency, discount_currency, currency_id, currency_rate, currency_sign,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
            $stmt->bind_param('ssssssssssss', $orderID, $subtotalBase, $grandTotalBase, $vatAmountBase, $discountAmountBase, $subtotal, $grandTotal, $vatAmount, $discountAmount, $currencyID, $defaultCurrency->rate, $currencySign);
            $stmt->execute();
            if (strcmp($stmt->error, "") != 0) {
                throw new Exception($stmt->error);
            }
            $stmt->close();

            if ($dropShip) {

                $volume = "" . trim($_POST['totalVolumetrics']);
                $weight = "" . trim($_POST['totalWeight']);
                $distance = "" . trim($_POST['distanceKm']);
                $from_lat = "" . trim($_POST['latFrom']);
                $from_lng = "" . trim($_POST['lngFrom']);
                $to_lat = "" . trim($_POST['latTo']);
                $to_lng = "" . trim($_POST['lngTo']);
                $to_address_line_1 = "" . trim($_POST['addressTo']);
                $to_address_line_2 = "" . trim($_POST['addressTo']);
                $to_address_area = "" . trim($_POST['addressAreaTo']);
                $received_amount = "" . trim($_POST['freightCollectAmount']);
                $label_1 = "" . trim($_POST['clientNameTo']);
                $text_1 = "";
                $text_2 = "";
                $text_3 = "";

                $stmt = $db->prepare("INSERT INTO B2B_Dropship_Orders_Extra(order_id, order_code, volume, weight, distance, from_lat, from_lng, to_lat, to_lng, to_address_line_1, to_address_line_2, to_address_area, received_amount, label_1, text_1, text_2, text_3, timestamp) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
                $stmt->bind_param('isdddddddsssdssss', $orderID, $orderCode, $volume, $weight, $distance, $from_lat, $from_lng, $to_lat, $to_lng, $to_address_line_1, $to_address_line_2, $to_address_area, $received_amount, $label_1, $text_1, $text_2, $text_3);
                $stmt->execute();
                if (strcmp($stmt->error, "") != 0) {
                    throw new Exception($stmt->error);
                }
                $stmt->close();
            }
//$stm = $db->prepare("SELECT Online_Order_Item.item_id,qty,unit_price,Items.vat_id FROM Online_Order_Item,Items WHERE Online_Order_Item.item_id=Items.item_id AND Online_Order_Item.order_id='$onlineOrderID'");
//$stm-> execute();
//$stm-> bind_result($itemID,$qty,$unitPrice,$vatID);
//
//
//while ($stm->fetch()) {
            $itemCounter = 0;
            $totalDiscount = 0;
            $loyaltyPoints = array();
            foreach ($onlineOrderItems as $onlineOrderItem) {

                $itemID = $onlineOrderItem['itemID'];
                $qty = $onlineOrderItem['Quantity'];
                $unitPrice = $onlineOrderItem['UP'] / $defaultCurrency->rate;
                $vatID = $onlineOrderItem['vatID'];
                $onlineOrderItemID = $onlineOrderItem['onlineOrderItemID'];

                $attr = getItemAttributes($onlineOrderID, $itemID, $qty, $db);

                //$orderItemID= getNextKey("Order_Item","order_item_id");


                if($addItemByUnits) {
                    $qty = $qty * floatval(getSubUnits($itemID));
                    $lineTotal = $unitPrice*$qty;
                } else {
                    $lineTotal = $unitPrice*$qty / floatval(getSubUnits($itemID));
                }

                $vatAmount = ($lineTotal - (float)$attr->globalDiscount) * getVatPercentage($vatID) / 100;
                $qtyDelivered = $qtyInvoiced = $lineDiscount = $globalDiscount = $lineDiscountPercentage = 0;
                $description = "".getVolumetrics($onlineOrderItemID, $db);
                $masterItem = "".$attr->masterItem;
                $lineDiscount = (float)$attr->lineDiscount;
                $globalDiscount = (float)$attr->globalDiscount;
                $totalDiscount += (float)$lineDiscount + (float)$globalDiscount;
                $lineDiscountPercentage = (float)$attr->lineDiscountPercentage;
                $pricetypeID = getPriceType($itemID, $customerID, $unitPrice);
                if ($pricetypeID > 0) {
                } else {
                    $pricetypeID = 0;
                }

                if ($dropShip) {

                    $itemCounter++;
                    $itemVolumetrics = getVolumetrics($onlineOrderItemID, $db);
                    $masterItem = 'Pack';
                    $description = "$orderCode-$itemCounter|$itemVolumetrics";
                }


                $orderItemID = 0;
                $stmt1 = $db->prepare("INSERT INTO Order_Item (order_item_id,order_id,item_id,qty,qty_delivered,qty_invoiced,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,description,master_item,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
                $stmt1->bind_param('iiiddddddddiiss', $orderItemID, $orderID, $itemID, $qty, $qtyDelivered, $qtyInvoiced, $unitPrice, $lineDiscount, $globalDiscount, $lineDiscountPercentage, $vatAmount, $pricetypeID, $vatID, $description, $masterItem);
                $stmt1->execute();
                if (strcmp($stmt1->error, "") != 0) {
                    throw new Exception($stmt1->error);
                }
                $orderItemID = $stmt1->insert_id;
                $stmt1->close();

                $loyalties = calculateLoyaltyPoints($itemID, $customerID, $qty, $db);
                foreach ($loyalties as $loyalty) {
                    $loyaltyPoints["$loyalty->type"]["$loyalty->sign"]['points'] += $loyalty->points;
                    $loyaltyPoints["$loyalty->type"]["$loyalty->sign"]['name'] = $loyalty->name;
                }

            }


            insertLoyaltyPoints($customerID, $loyaltyPoints, $orderID, $orderCode, $grandTotal, $userID, $companyID, $db);



            if($feeItemID > 0) {
                $vatID = getItemVatID($feeItemID, $db);
                $qty = 1;
                $unitPrice = $lineTotal = $deliveryFeeAndNotes[0];
                $vatAmountLine = $unitPrice * getVatPercentage($vatID) / 100;
                $qtyDelivered = $qtyInvoiced = $lineDiscount = $globalDiscount = $lineDiscountPercentage = 0;
                $description = "";
                $pricetypeID = getPriceType($itemID, $customerID, $unitPrice, $db);
                if ($pricetypeID > 0) {}
                else {$pricetypeID = 0;}

                $orderItemID = 0;
                $stmt1 = $db->prepare("INSERT INTO Order_Item (order_item_id,order_id,item_id,qty,qty_delivered,qty_invoiced,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,description,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
                $stmt1->bind_param('iiiddddddddiis', $orderItemID, $orderID, $feeItemID, $qty, $qtyDelivered, $qtyInvoiced, $unitPrice, $lineDiscount, $globalDiscount, $lineDiscountPercentage, $vatAmount, $pricetypeID, $vatID, $description);
                $stmt1->execute();
                if (strcmp($stmt1->error, "") != 0) {throw new Exception($stmt->error);}
                $stmt1->close();
            }



            if (isset($deliveryFeeItem) && $deliveryFeeItem > 0) {
                $itemID = $deliveryFeeItem;
                $vatID = getItemVatID($itemID, $db);
                //$orderItemID= getNextKey("Order_Item","order_item_id");
                $qty = 1;
                $unitPrice = getDefaultPrice($itemID, $customerID, $db) / $defaultCurrency->rate;
                $vatAmount = $unitPrice * getVatPercentage($vatID) / 100;
                $qtyDelivered = $qtyInvoiced = $lineDiscount = $globalDiscount = $lineDiscountPercentage = 0;
                $description = "";
                $pricetypeID = getPriceType($itemID, $customerID, $unitPrice, $db);
                if ($pricetypeID > 0) {
                } else {
                    $pricetypeID = 0;
                }

                if ($unitPrice > 0) {


                    $orderItemID = 0;
                    $stmt1 = $db->prepare("INSERT INTO Order_Item (order_item_id,order_id,item_id,qty,qty_delivered,qty_invoiced,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,description,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
                    $stmt1->bind_param('iiiddddddddiis', $orderItemID, $orderID, $itemID, $qty, $qtyDelivered, $qtyInvoiced, $unitPrice, $lineDiscount, $globalDiscount, $lineDiscountPercentage, $vatAmount, $pricetypeID, $vatID, $description);
                    $stmt1->execute();
                    if (strcmp($stmt1->error, "") != 0) {
                        throw new Exception($stmt->error);
                    }
                    $stmt1->close();
                }

            }


            if (isset($weightFeeItem) && $weightFeeItem > 0) {

                $itemID = $weightFeeItem;
                $vatID = getItemVatID($itemID, $db);
                $qty = (float)$weightFeeItemQty;
                $unitPrice = getDefaultPrice($itemID, $customerID, $db) / $defaultCurrency->rate;
                $vatAmount = $unitPrice * $qty * getVatPercentage($vatID) / 100;
                $qtyDelivered = $qtyInvoiced = $lineDiscount = $globalDiscount = $lineDiscountPercentage = 0;
                $description = "";
                $pricetypeID = getPriceType($itemID, $customerID, $unitPrice, $db);
                if ($pricetypeID > 0) {
                } else {
                    $pricetypeID = 0;
                }

                if ($unitPrice > 0) {


                    $orderItemID = 0;
                    $stmt1 = $db->prepare("INSERT INTO Order_Item (order_item_id,order_id,item_id,qty,qty_delivered,qty_invoiced,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,description,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
                    $stmt1->bind_param('iiiddddddddiis', $orderItemID, $orderID, $itemID, $qty, $qtyDelivered, $qtyInvoiced, $unitPrice, $lineDiscount, $globalDiscount, $lineDiscountPercentage, $vatAmount, $pricetypeID, $vatID, $description);
                    $stmt1->execute();
                    if (strcmp($stmt1->error, "") != 0) {
                        throw new Exception($stmt->error);
                    }
                    $stmt1->close();
                }
            }


            $usedPromos = array();
            $stmt = $db->prepare("SELECT DISTINCT(Online_Order_Item.promotion_id) FROM Online_Order_Item,Promotions WHERE Online_Order_Item.promotion_id=Promotions.promotion_id AND Online_Order_Item.order_id='$onlineOrderID' AND Promotions.type > 2 AND Promotions.type < 6");
            $stmt->execute();
            $stmt->bind_result($usedPromoID);
            while ($stmt->fetch()) {
                array_push($usedPromos, $usedPromoID);
            }
            $stmt->close();

            foreach ($usedPromos as $usedPromoID) {
                $stmt = $db->prepare("UPDATE Promotions SET status='no',description='Used' WHERE promotion_id='$usedPromoID'");
                $stmt->execute();
                if (strcmp($stmt->error, "") != 0) {
                    throw new Exception($stmt->error);
                }
                $stmt->close();
            }

            $usedPromos = array();
            $stmt = $db->prepare("SELECT DISTINCT(Online_Order_Item.promotion_id),Promotions.type,Promotions.promotion_code FROM Online_Order_Item,Promotions WHERE Online_Order_Item.promotion_id=Promotions.promotion_id AND Online_Order_Item.order_id='$onlineOrderID' AND Promotions.type >= 6 AND Promotions.type <= 7");
            $stmt->execute();
            $stmt->bind_result($usedPromoID, $promoType, $promoCode);
            while ($stmt->fetch()) {
                $usedPromo = new stdClass();
                $usedPromo->id = $usedPromoID;
                $usedPromo->type = $promoType;
                $usedPromo->code = $promoCode;
                array_push($usedPromos, $usedPromo);
            }
            $stmt->close();

            foreach ($usedPromos as $usedPromo) {
                $b2bUserID = $_SESSION['userID'];
                $lotteryCode = substr($usedPromo->code, 0, 1) . "-$b2bUserID";
                if ($usedPromo->type == 6) {
                    $stm2 = $db->prepare("INSERT INTO Promotions( promotion_code, promotion_name, description, type, item_id, qty, fixed_discount_amount, fixed_discount_percent, pricetype_id, price, discount_qty, discount_percent_on_qty, printing_layout, color_in_cart, valid_from, valid_until, loyalty_points, all_customers, all_salespersons, status, timestamp) 
                                    SELECT  ?, promotion_name, ?, 6666, item_id, qty, fixed_discount_amount, fixed_discount_percent, pricetype_id, price, discount_qty, discount_percent_on_qty, printing_layout, color_in_cart, valid_from, valid_until, loyalty_points, all_customers, all_salespersons, promotion_id, NOW() FROM Promotions 
                                    WHERE promotion_id = ? LIMIT 1");
                    $stm2->bind_param('sss', $lotteryCode, $b2bUserID, $usedPromo->id);
                    $stm2->execute();
                    if (strcmp($stm2->error, "") != 0) {
                        throw new Exception($stmt->error);
                    }
                    $stm2->close();
                } else if ($usedPromo->type == 7) {
                    $stm2 = $db->prepare("INSERT INTO Promotions( promotion_code, promotion_name, description, type, item_id, qty, fixed_discount_amount, fixed_discount_percent, pricetype_id, price, discount_qty, discount_percent_on_qty, printing_layout, color_in_cart, valid_from, valid_until, loyalty_points, all_customers, all_salespersons, status, timestamp) 
                                    SELECT  ?, promotion_name, ?, 7777, item_id, qty, fixed_discount_amount, fixed_discount_percent, pricetype_id, price, discount_qty, discount_percent_on_qty, printing_layout, color_in_cart, valid_from, valid_until, loyalty_points, all_customers, all_salespersons, promotion_id, NOW() FROM Promotions 
                                    WHERE promotion_id = ? LIMIT 1");
                    $stm2->bind_param('sss', $lotteryCode, $b2bUserID, $usedPromo->id);
                    $stm2->execute();
                    if (strcmp($stm2->error, "") != 0) {
                        throw new Exception($stmt->error);
                    }
                    $stm2->close();
                }
            }

            $stmt = $db->prepare("DELETE FROM Online_Orders WHERE order_id='$onlineOrderID'");
            $stmt->execute();
            if (strcmp($stmt->error, "") != 0) {
                throw new Exception($stmt->error);
            }
            $stmt->close();

            $stmt = $db->prepare("DELETE FROM Online_Order_Item WHERE order_id='$onlineOrderID'");
            $stmt->execute();
            if (strcmp($stmt->error, "") != 0) {
                throw new Exception($stmt->error);
            }
            $stmt->close();

            // FILE ATTACHMENTS DEVELOPMENT START
            if (isset($_FILES['orderAttachment'])) {

                $action = 'Orders';
                $id = $orderID;

                $fileNameParts = explode('.', basename($_FILES['orderAttachment']['name']));
                $ext = end($fileNameParts);

                $imageName = "$action-$id-B2B.$ext";
                $imageName = str_replace(' ', '', $imageName);
                $file_path = "../../media/actionAttachments/" . $imageName;

                $i = 1;
                if(file_exists($file_path)) {
                    while (file_exists($file_path)) {
                        $newName = "(". $i.")".$imageName;
                        $file_path = "../../media/actionAttachments/" . $newName;
                        $i++;
                    }
                    $imageName = $newName;
                }



                if(!move_uploaded_file($_FILES['orderAttachment']['tmp_name'], $file_path)) {


                    throw new Exception('Order Attachment Upload Failed');

                } else {
                    $actionAttachmentID = getNextKeySingleTransaction("Action_Attachments","action_attachment_id",$db);
                    $stmt = $db->prepare("INSERT INTO Action_Attachments(action_attachment_id, action_type, action_id, attachment_url, name,timestamp) VALUES(?,?,?,?,?,NOW())");
                    $stmt->bind_param('isiss',$actionAttachmentID,$action,$id,$imageName,$imageName);
                    $stmt->execute();
                    if (strcmp($stmt->error, "") != 0) {
                        throw new Exception($stmt->error);
                    }
                    $stmt->close();
                }
            } else {

            }
            // FILE ATTACHMENTS DEVELOPMENT END

            if(isset($_SESSION['selectedDeliveryOption']) && strcmp($_SESSION['selectedDeliveryOption'],'instantDelivery')==0) {
                $instantDelivery = true;
            } else {
                $instantDelivery = false;
            }

            if(!confirmOrderAsPlaced($db,$orderID,$instantDelivery)){
                throw new Exception("Error Confirming Order");
            }

            $db->commit(true);

            $_SESSION['orderID'] = getAvailableOrderID($customerID, $userID);





            if ($isCredit) {

                // -------------------- Instant Delivery --------------------
                if(isset($_SESSION['selectedDeliveryOption']) && strcmp($_SESSION['selectedDeliveryOption'],'instantDelivery')==0) {

                    $detailsInstant = str_replace("\nTime Slot:".$timeSlot,"\nTime Slot: As soon as possible",$details);
                    $stmt = $db->prepare("UPDATE Orders SET details = ?, delivery_date = ? WHERE order_id = ?");
                    $stmt->bind_param('ssi', $detailsInstant,$orderDate, $orderID);
                    $stmt->execute();
                    $stmt->close();

                    $db->commit(true);

                    if (isset($_SESSION['deliveryApproval']) && strcmp(''.$_SESSION['deliveryApproval'],'yes')==0){
                        echo "<center><h2>Processing...</h2></center>";
                        echo "<script type=\"text/javascript\">window.location.href=\"./dbaccess/deliveryApprovalAppJson.php?deliveryApproval=yes&oid=$orderID\";</script>";
                        return ;
                    }
                } else if (isset($_SESSION['fromApp']) && strcmp(''.$_SESSION['fromApp'],'yes')==0){
                    echo "<center><h2>Processing...</h2></center>";
                    echo "<script type=\"text/javascript\">window.location.href=\"./dbaccess/deliveryApprovalAppJson.php?fromApp=yes&oid=$orderID\";</script>";
                    return ;
                }
                // -------------------- Instant Delivery/--------------------

                if ($dropShip) {
                    echo "

                    <div class='message-box col-sm-8 col-sm-offset-2'>
                        <div class='message-box-inner'>
                            <h2 style='text-transform: capitalize; font-size:14px;font-family: Open Sans, Arial, Helvetica, Sans-Serif'>" . $langu['place_order_message'] . "</h2>
                        </div>
                    </div>
                     <div>
                        <form style='margin:0 auto;width:50%;margin-bottom:20px;' method='POST' action='./dropShipPrintLabels.php' target='_blank'>
                           <input type='hidden' name='orderID' id='orderIDEmail' value='$orderID'/>
                           <input type='hidden' name='orderCode' value='$orderCode'/>
                           <div style='margin: 0 auto;width:80%'><center>
                           <input type='submit' class='btn btn-theme btn-theme-dark' style='display:inline-block;margin-top:15px;text-transform: capitalize;'id='printOrderButton' value='Print Labels'/>
                           <a href='./' class='btn btn-theme' style='display:inline-block;margin-top:15px;text-transform: capitalize;'>" . $langu['back_to_catalogue_label'] . "</a>
                           </div>
                        </form>
                      </div>
                        ";
                } else {
                    if ($showPrices) {
                        echo "

                    <div class='message-box col-sm-8 col-sm-offset-2'>
                        <div class='message-box-inner'>
                            <h2 style='text-transform: capitalize; font-size:14px;font-family: Open Sans, Arial, Helvetica, Sans-Serif'>" . $langu['place_order_message'] . "</h2>
                        </div>
                    </div>
                     <div>
                        <form style='margin:0 auto;width:50%;margin-bottom:20px;' method='POST' action='./dbaccess/printOrderPDF.php' target='_blank'>
                           <input type='hidden' name='orderID' id='orderIDEmail' value='$orderID'/>
                           <input type='hidden' name='orderCode' value='$orderCode'/>
                           <input type='hidden' name='prices' value='yes'/>
                           <div style='margin: 0 auto;width:80%'><center>
                           <input type='submit' class='btn btn-theme btn-theme-dark' style='display:inline-block;margin-top:15px;text-transform: capitalize;'id='printOrderButton' value='" . $langu['print_order'] . "'/>
                           <a href='./' class='btn btn-theme' style='display:inline-block;margin-top:15px;text-transform: capitalize;'>" . $langu['back_to_catalogue_label'] . "</a>
                           </div>
                        </form>
                      </div>
                        ";

                        $result = getOrderPDF($orderID);
                        echo "$result";

                    } else {
                        echo "

<div class='message-box col-sm-8 col-sm-offset-2'>
                        <div class='message-box-inner'>
                            <h2 style='text-transform: capitalize; font-size:14px;font-family: Open Sans, Arial, Helvetica, Sans-Serif'>" . $langu['place_order_message'] . " <br><br> $orderCode </h2>
                        </div>
                        </div>
                        <div>
                        <form style='margin:0 auto;width:50%;margin-bottom:20px;' method='POST' action='./dbaccess/printOrderPDF.php' target='_blank'>
                           <input type='hidden' name='orderID' id='orderIDEmail' value='$orderID'/>
                           <input type='hidden' name='orderCode' value='$orderCode'/>
                           <div style='margin: 0 auto;width:80%'><center>
                           <input type='submit' class='btn btn-theme btn-theme-dark' style='display:inline-block;margin-top:15px;text-transform: capitalize;'id='printOrderButton' value='" . $langu['print_order'] . "'/>
                           <a href='./' class='btn btn-theme' style='display:inline-block;margin-top:15px;text-transform: capitalize;'>" . $langu['back_to_catalogue_label'] . "</a>
                           </div>
                        </form>
                      </div>
                        ";
                    }
                    if ($showPrices) {
                        echo "<script>
                      $.ajax({
                        type:'POST',
                        url: './dbaccess/emailOrder.php',
                        data:{'orderID':'$orderID','showPrices':'yes','attachment':'$imageName'},
                        success:function(result){}
                      });
                  </script>";

                    } else {
                        echo "<script>
                      $.ajax({
                        type:'POST',
                        url: './dbaccess/emailOrder.php',
                        data:{'orderID':'$orderID','showPrices':'no','attachment':'$imageName'},
                        success:function(result){}
                      });
                  </script>";
                    }
                }
            } else {
                echo $orderCode;
            }

        } else {
            echo 0;
        }

    } catch (Exception  $e) {
        $errorFile = fopen('errorOrder.txt', 'w');
        fwrite($errorFile, "$e\n");
        fclose($errorFile);
        echo 0;
        $db->rollback();
        return 0;
    }
}

function calculateLoyaltyPoints($itemID,$customerID,$qty,$db11=''){
    $loyalties = array();


    if($itemID > 0 && $customerID > 0 && $qty > 0) {
        if(is_string($db11) && strcmp($db11,'')==0) {
            global $username, $password, $database;
            $db11 = new mysqli('localhost', $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db11->set_charset("utf8");
        }

        $hasAcqPoints = false;
        $hasSpendPoints = false;
        $stm11 = $db11->prepare(" SELECT name,type_id,qty,acquiring_points,spending_points 
                                         FROM Loyalty_Item,Loyalty_Types 
                                        WHERE Loyalty_Item.type_id=Loyalty_Types.loyalty_type_id 
                                          AND item_id='$itemID' 
                                          AND status='yes' 
                                          AND DATE(valid_from)<=DATE(NOW()) 
                                          AND DATE(valid_until)>=DATE(NOW())
                                          ORDER BY qty DESC
                                        ");
        $stm11->execute();
        $stm11->bind_result($name,$typeID, $checkQty, $acqPoints,$spendPoints);
        while ($stm11->fetch()) {
            if($qty >= $checkQty && !$hasAcqPoints){



                $hasAcqPoints = true;
                $loyalty = new stdClass();
                $loyalty->points = $acqPoints*$qty;
                $loyalty->type = $typeID;
                $loyalty->name = "$name";
                $loyalty->sign = "1";
                array_push($loyalties,$loyalty);

            }
            if($qty >= $checkQty &&  !$hasSpendPoints){




                $hasSpendPoints = true;
                $loyalty = new stdClass();
                $loyalty->points = $spendPoints*$qty;
                $loyalty->type = $typeID;
                $loyalty->name = "$name";
                $loyalty->sign = "-1";
                array_push($loyalties,$loyalty);

            }
            if($hasAcqPoints && $hasSpendPoints){break;}
        }
        $stm11->close();
    }


    return $loyalties;
}

function insertLoyaltyPoints($customerID,$loyalty,$orderID,$orderCode,$orderTotal,$userID,$companyID,$db12=''){

    foreach ($loyalty as $typeID => $loyaltyAndSign) {
        foreach ($loyaltyAndSign as $loyaltyTransactionSign => $loyaltyPropertiesArray) {
            $acqPoints = $loyaltyPropertiesArray['points'];
            $loyaltyName = $loyaltyPropertiesArray['name'];

            $action_type = "Order";
            $document_id = "$orderID";
            $document_code = "$orderCode";
            $document_total = "$orderTotal";
            $entry_date = date('Y-m-d H:i:s');
            $sign = "$loyaltyTransactionSign";
            $points = "$acqPoints";
            $user_id = "$userID";
            $company_id = "$companyID";
            $details = "$loyaltyName";

            if(is_string($db12) && strcmp($db12,'')==0) {
                global $username, $password, $database;
                $db12 = new mysqli('localhost', $username, $password, $database);
                if (mysqli_connect_errno()) {
                    printf("Connect failed: %s\n", mysqli_connect_error());
                    exit();
                }
                $db12->set_charset("utf8");
            }
            $stmt12 = $db12->prepare("INSERT INTO Loyalty_Transactions (type_id, action_type, document_id, document_code, document_total, entry_date, sign, points,customer_id, user_id, company_id, details, timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
            $stmt12->bind_param('ssssssssssss', $typeID, $action_type, $document_id, $document_code, $document_total, $entry_date, $sign, $points,$customerID, $user_id, $company_id, $details);
            $stmt12->execute();
            $stmt12->close();

            $points = (int)$sign*(float)$points;

            $stmt12 = $db12->prepare("INSERT INTO Loyalty_Balances (customer_id, user_id, type_id, balance,timestamp) VALUES(?,?,?,?,NOW()) ON DUPLICATE KEY UPDATE balance=balance+?");
            $stmt12->bind_param('iiidd', $customerID, $userID, $typeID, $points, $points);
            $stmt12->execute();
            $stmt12->close();
        }
    }
}

function getVolumetrics($itemID,$db1=''){
    if(is_string($db1) && strcmp($db1,'')==0) {
        global $username, $password, $database;
        $db1 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db1->set_charset("utf8");
    }

    $stm11 = $db1->prepare("SELECT description FROM Online_Order_Item WHERE order_item_id='$itemID'");
    $stm11-> execute();
    $stm11-> bind_result($result);
    while ($stm11->fetch()) {

    }
    $stm11->close();
    return "$result";
}

?>