<?php
session_start();
include_once("../../param.php");
require("dbhelper.php");

include('../langs/'.$_SESSION['lang'].'.php');
$missedTimeSlot = "Missed Time Slot";
$betweenLabel = $langu['between'];
$andLabel = $langu['and'];

$customerAddressID = trim($_POST['addressID']);
$deliveryDate = trim($_POST['deliveryDate']);
$timeSlotsText = trim($_POST['timeSlotsText']);
$confirmedTimeslot = false;
$timeslotsPerCity = false;
$anonymousCheckout = false;
$timeSlotOptions = '';

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT custom_delivery_time_slots,anonymous_checkout,anonymous_checkout_customer_id FROM B2B_Configuration LIMIT 1");
$stm-> execute();
$stm-> bind_result($customDeliveryTimeslots,$anonymousQuotationCheck,$anonymousCheckoutCustomerID);
while ($stm->fetch()) {
    if(strcmp($customDeliveryTimeslots,'city') == 0) {
        $timeslotsPerCity = true;
    }
    if(strcmp($anonymousQuotationCheck,'yes')==0 && $anonymousCheckoutCustomerID > 0){
        $anonymousCheckout = true;
    }
}
$stm-> close();

$stm = $db->prepare("SELECT postcode,city FROM CustomerAddress WHERE customer_address_id = '$customerAddressID'");
$stm-> execute();
$stm-> bind_result($customerZipCode,$customerCity);
while ($stm->fetch()) {}
$stm-> close();

$fromAnonymous = false;
if($anonymousCheckout){

    if(strcmp(trim(''.$_POST['postCode']),'')!=0 || strcmp(trim(''.$_POST['city']),'')!=0){
        $customerZipCode = trim($_POST['postCode']);
        $customerCity = trim($_POST['city']);
        $fromAnonymous = true;
    }

}

$stm = $db->prepare("SELECT zip_code_id,zip_code_region,zip_codes,time_slots,next_day_only_time_slots,disable_slot_hours_before,next_day_delivery_after_time FROM ZZ_Zip_Codes WHERE enable_timeslots='yes'");
$stm-> execute();
$stm-> bind_result($timeSlotsID,$region,$zipcodes,$timeslots,$nextDayTimeslots,$beforeHours,$cutoffTime);
while ($stm->fetch()) {
    $zipcodeArray = explode(',',$zipcodes);
    $timeslotsArray = explode(',',$timeslots);
    
    if (in_array($customerZipCode, $zipcodeArray) || $timeslotsPerCity && strcasecmp($customerCity, $region) == 0) {
        $timeslotsRegionTitle = "($region)";

        $dailySlots = getDailySlots($timeSlotsID,$deliveryDate);

        if(count($dailySlots) > 0){
            foreach ($dailySlots AS $dailySlot){
                if(strcmp("$dailySlot->dayName",date('l', strtotime($deliveryDate)))==0 && strcmp("$dailySlot->enableTimeslots",'yes')==0){

                    if(strcmp($dailySlot->timeSlots,'')==0){
                        $timeslotsArray = array();
                    } else {
                        $timeslotsArray = explode(',',$dailySlot->timeSlots);
                    }

                    $cutoffTime = $dailySlot->nextDayDeliveryAfterTime;
                    $nextDayTimeslots = $dailySlot->nextDayTimeslots;
                    $beforeHours = $dailySlot->beforeHours;
                }
            }
        }

        
        $holidaySlots = getHolidaySlots($timeSlotsID,$deliveryDate);
        
        if($holidaySlots->special == true){
            if(strcmp($holidaySlots->timeSlots,'')==0){
                $timeslotsArray = array();
            } else {
                $timeslotsArray = explode(',',$holidaySlots->timeSlots);
            }
            $cutoffTime = $holidaySlots->nextDayDeliveryAfterTime;
            $nextDayTimeslots = 'notApplicable';
        }
        
        foreach ($timeslotsArray AS $timeSlot){
            
            $forNextDay = false;
            if(strpos($nextDayTimeslots, $timeSlot) !== false){
                $forNextDay = true;
            }
            
            if($beforeHours >= 0){$timeInterval = "+$beforeHours minutes";}
            else {$timeInterval = "-".abs($beforeHours)." minutes";}
            
            $timeCheck = $deliveryDate." ".explode("-",$timeSlot)[0];
            $cutOffCheck = $deliveryDate." ".$cutoffTime;
            $timeSlotTimes = explode("-",$timeSlot);
            $timeSlotFrom = $timeSlotTimes[0];
            $timeSlotTo = $timeSlotTimes[1];
            $timeSlot = str_replace("-", " $andLabel ", $timeSlot);

            $d = new DateTime("now", new DateTimeZone("Europe/Athens"));
            $local_time_today_for_cutoff = $d->format('Y-m-d H:i');
            $local_date = $d->format('Y-m-d');
            $d->modify($timeInterval); 
            $local_time_today = $d->format('Y-m-d H:i');
            
            if($forNextDay && $deliveryDate > $local_date){
                $forNextDay = false;
            }
            
            if($timeCheck > $local_time_today && $cutOffCheck > $local_time_today_for_cutoff && !$forNextDay){
                if(strcmp($timeSlotsText,"$betweenLabel $timeSlot")==0){
                    $confirmedTimeslot = true;
                    $selected = 'selected';
                } else {
                    $selected = '';
                }
                $timeSlotOptions .= "<option  data-from='$timeSlotFrom' data-to='$timeSlotTo' $selected >$betweenLabel $timeSlot</option>";
            }
        }
        break;
    }


}
$stm-> close();

if(strcmp($timeSlotOptions,'')==0){
    $stm = $db->prepare("SELECT zip_code_id,zip_code_region,zip_codes,time_slots,next_day_only_time_slots,disable_slot_hours_before,next_day_delivery_after_time FROM ZZ_Zip_Codes WHERE enable_timeslots='yes' AND zip_code_region LIKE 'All'");
    $stm-> execute();
    $stm-> bind_result($timeSlotsID,$region,$zipcodes,$timeslots,$nextDayTimeslots,$beforeHours,$cutoffTime);
    while ($stm->fetch()) {
        $zipcodeArray = explode(',',$zipcodes);
        $timeslotsArray = explode(',',$timeslots);

        if (true) {
            $timeslotsRegionTitle = '';

            $holidaySlots = getHolidaySlots($timeSlotsID,$deliveryDate);

            if($holidaySlots->special == true){
                if(strcmp($holidaySlots->timeSlots,'')==0){
                    $timeslotsArray = array();
                } else {
                    $timeslotsArray = explode(',',$holidaySlots->timeSlots);
                }
                $cutoffTime = $holidaySlots->nextDayDeliveryAfterTime;
                $nextDayTimeslots = 'notApplicable';
            }

            foreach ($timeslotsArray AS $timeSlot){

                $forNextDay = false;
                if(strpos($nextDayTimeslots, $timeSlot) !== false){
                    $forNextDay = true;
                }

                if($beforeHours >= 0){$timeInterval = "+$beforeHours minutes";}
                else {$timeInterval = "-".abs($beforeHours)." minutes";}

                $timeCheck = $deliveryDate." ".explode("-",$timeSlot)[0];
                $cutOffCheck = $deliveryDate." ".$cutoffTime;
                $timeSlotTimes = explode("-",$timeSlot);
                $timeSlotFrom = $timeSlotTimes[0];
                $timeSlotTo = $timeSlotTimes[1];
                $timeSlot = str_replace("-", " $andLabel ", $timeSlot);

                $d = new DateTime("now", new DateTimeZone("Europe/Athens"));
                $local_time_today_for_cutoff = $d->format('Y-m-d H:i');
                $local_date = $d->format('Y-m-d');
                $d->modify($timeInterval);
                $local_time_today = $d->format('Y-m-d H:i');

                if($forNextDay && $deliveryDate > $local_date){
                    $forNextDay = false;
                }

                $dateTimeCheck = new DateTime($timeCheck);
                $dateTimeLocalTime = new DateTime($local_time_today);
                $dateTimeCutOffCheck = new DateTime($cutOffCheck);
                $dateTimeTodayForCutoff = new DateTime($local_time_today_for_cutoff);

                if($dateTimeCheck > $dateTimeLocalTime && $cutOffCheck > $local_time_today_for_cutoff && !$forNextDay){

                    if(strcmp($timeSlotsText,"$betweenLabel $timeSlot")==0){
                        $confirmedTimeslot = true;
                        $selected = 'selected';
                    } else {
                        $selected = '';
                    }
                    $timeSlotOptions .= "<option  data-from='$timeSlotFrom' data-to='$timeSlotTo' $selected >$betweenLabel $timeSlot</option>";
                }
            }
            break;
        }


    }
    $stm-> close();
}



if(strcmp($timeSlotOptions,'')==0){
    $result=0;  
} else {
    $result="<label id='timeSlotsLabel'>Select Time Slot $timeslotsRegionTitle</label>
             <select id='timeSlots' name='timeSlots' class='form-control'>$timeSlotOptions</select>";
    $deliveryDateDisplay = date_format( date_create_from_format('Y-m-d', $deliveryDate), 'd/m/Y');
    if($confirmedTimeslot || strcmp($timeSlotsText,'')==0 || $fromAnonymous){
        $result.="<span id='timeslotCheck' style='display:none;'></span>";
    }else{
        $result.="<span id='timeslotCheck' style='display:block;color:firebrick;'>*$missedTimeSlot: $deliveryDateDisplay $timeSlotsText .</span>";
        
    }

}

$deliveryApproval = getDeliveryApproval($customerZipCode,$customerCity,$timeslotsPerCity,$result);

if(strcmp("$deliveryApproval",'')!=0 && strcmp("$result",'0')==0){
    $result = "";
}

$object = new stdClass();
$object->timeslots = $result;
$object->deliveryOptions = $deliveryApproval;

echo json_encode($object);


function getHolidaySlots($zipCodeID,$deliveryDate){
    global $username,$password,$database;
    
    $holyday = new stdClass();
    $holyday->special = false;
    $holyday->timeSlots = '';
    $holyday->nextDayDeliveryAfterTime = '';
    
    $db3 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db3->set_charset("utf8");
    $stm3 = $db3->prepare("SELECT time_slots, next_day_delivery_after_time FROM ZZ_Holiday_Time_Slots WHERE date='$deliveryDate' AND zip_code_id='$zipCodeID' ORDER BY timestamp DESC LIMIT 1");
    $stm3-> execute();
    $stm3-> bind_result($timeSlots,$next_day_delivery_after_time);
    while ($stm3->fetch()) {
        $holyday->special = true;
        $holyday->timeSlots = "$timeSlots";
        $holyday->nextDayDeliveryAfterTime = "$next_day_delivery_after_time";
    }
    $stm3-> close();
    
    return $holyday;
    
}

function getDeliveryApproval($customerZipCode,$customerCity,$timeslotsPerCity,$timeSlotsResult){
    $result = '';
    $hasDeliveryApprovalSlot = false;

    $dateNow = new DateTime("now", new DateTimeZone("Europe/Athens"));
    $localTime      = $dateNow->format('H:i');
    $localDayNumber = $dateNow->format('N');
    $localDate      = $dateNow->format('Y-m-d');

    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $hasRegionalDeliveryApproval = false;
    $stm = $db->prepare("SELECT zip_code_region,zip_codes FROM ZZ_Zip_Codes WHERE enable_delivery_approval='yes'");
    $stm-> execute();
    $stm-> bind_result($region,$zipcodes);
    while ($stm->fetch()) {
        $zipcodeArray = explode(',', $zipcodes);
        if (in_array($customerZipCode, $zipcodeArray) || $timeslotsPerCity && strcasecmp($customerCity, $region) == 0) {
            $hasRegionalDeliveryApproval = true;
            break;
        }
    }
    $stm-> close();

    if(!$hasRegionalDeliveryApproval) {

        $stm = $db->prepare("SELECT enable_delivery_approval FROM ZZ_Zip_Codes WHERE enable_delivery_approval='yes' AND zip_code_region LIKE 'All'");
        $stm->execute();
        $stm->bind_result($enableDeliveryApprovalForAll);
        while ($stm->fetch()) {
            if (strcmp("$enableDeliveryApprovalForAll", 'yes') == 0) {
                $hasRegionalDeliveryApproval = true;
                break;
            }
        }
        $stm->close();
    }


    $deliveryApproval = false;
    $stm = $db->prepare("SELECT has_delivery_approval,theme FROM B2B_Configuration LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($hasDeliveryApproval,$themeColor);
    while ($stm->fetch()) {
        if(strcmp($hasDeliveryApproval,'yes')==0){$deliveryApproval = true;}
    }
    $stm-> close();

    $hasDeliveryApprovalHoliday = false;
    if($deliveryApproval) {
        $stm = $db->prepare("SELECT description, day, from_time, to_time, ignore_regions, status,holiday_schedule_date, timestamp FROM B2B_Delivery_Approval_Schedules  WHERE status='yes' AND (day='$localDayNumber' OR holiday_schedule_date='$localDate' AND day='-1') ORDER BY holiday_schedule_date DESC, timestamp DESC ");
        $stm->execute();
        $stm->bind_result($description, $day, $from_time, $to_time, $ignore_regions, $status, $holidayScheduleDate, $timestamp);
        while ($stm->fetch()) {

            $dateCheckFrom  = new DateTime($localDate . " " . $from_time);
            $dateCheckTo    = new DateTime($localDate . " " . $to_time);
            $dateCheckToday = new DateTime($localDate . " " . $localTime);

            if($hasRegionalDeliveryApproval || strcmp("$ignore_regions",'yes')==0) {

                if (strcmp("$holidayScheduleDate", "$localDate") == 0) {
                    $hasDeliveryApprovalHoliday = true;
                    if ($dateCheckFrom <= $dateCheckToday && $dateCheckTo >= $dateCheckToday) {
                        $hasDeliveryApprovalSlot = true;
                    }
                }

                if (!$hasDeliveryApprovalHoliday) {
                    if ($dateCheckFrom <= $dateCheckToday && $dateCheckTo >= $dateCheckToday) {
                        $hasDeliveryApprovalSlot = true;
                    }
                }

                if ($hasDeliveryApprovalSlot) {
                    $result .= "$description $from_time-$to_time $holidayScheduleDate";
                    break;
                }
            }


        }
        $stm->close();
    }

    if($hasDeliveryApprovalSlot && strcmp("$timeSlotsResult",'')!=0){

        if(isset($_SESSION['selectedDeliveryOption']) && strcmp($_SESSION['selectedDeliveryOption'],'scheduledDelivery')==0){
            $selectedScheduledDelivery = 'checked';
            $selectedScheduledDeliveryToggle = "$('#scheduledDeliveryRadio')";
        } else {
            $selectedInstantDelivery = 'checked';
            $selectedScheduledDeliveryToggle = "$('#instantDeliveryRadio')";
        }

        $result = "
        <table  style='margin-top:10px;margin-bottom:5px;width: 100%;'>
            <tr>
                <td colspan='2'><label class='pull-left'>Delivery Options</label></td>
            </tr>
            <tr>
                <td style='padding-right: 3px;'>
                    <input type='radio' name='deliveryOptions' value='instantDelivery' id='instantDeliveryRadio' style='display: none;' $selectedInstantDelivery>
                    <label id='instantDeliveryLabel' for='instantDeliveryRadio' class='deliveryOptionBubble'>Delivery Now</label>
                </td>
                <td style='padding-left: 3px;'>
                    <input type='radio' name='deliveryOptions' value='scheduledDelivery' id='scheduledDeliveryRadio' style='display: none;' $selectedScheduledDelivery>
                    <label id='scheduledDeliveryLabel' for='scheduledDeliveryRadio' class='deliveryOptionBubble'>Scheduled Delivery</label>
                </td>
                
            </tr>
            
        </table> 
        
        <style>
         .deliveryOptionInfoBox{
            border: 2px solid $themeColor;
            border-radius: 7px 7px 7px 7px;
            padding: 15px;
            padding-top: 0px;
            margin: 3px;
            margin-top: -10px;
          }
          
          .selectedDeliveryOptionBubble{
            color: $themeColor !important;
            font-weight: bold !important;
            border: 2px solid $themeColor !important;
            background-color: rgba(248,248,255,0.2) !important;
            font-size: 15px !important;

          }
          
         .deliveryOptionBubble{
            width: 100%;
            padding: 10px; 
            border: 2px solid rgb(136,136,136,0.4); 
            cursor: pointer;
            text-align: center;
            border-radius: 10px;
            text-transform: none;
            font-size: 13px;
         }
          

            
        </style>

        <script>
            
            toggleDeliveryOptions($selectedScheduledDeliveryToggle);
            
        
            $('input[name=deliveryOptions]').change(function(){
                toggleDeliveryOptions($(this));
            });
            
            function toggleDeliveryOptions(element){
                
                $.ajax({
                    type:'POST',
                    url: './dbaccess/keepDeliveryOption.php',
                    data:{'selectedDeliveryOption':element.val()},
                    success:function(result){}
                });
                
                $('#deliveryDate').show();
                $('#deliveryDateLabel').show();
                
                if(element.val()=='scheduledDelivery'){
                    $('#deliveryDateDiv').show();
                    $('#timeSlotsElement').show();
                    $('#scheduledDeliveryLabel').addClass('selectedDeliveryOptionBubble');
                    $('#instantDeliveryLabel').removeClass('selectedDeliveryOptionBubble');
                    $('#deliveryOptionSlotsWarning').show();
                    
                    $('#scheduledDeliveryOptionBox').addClass('deliveryOptionInfoBox');
        
                } else {
                    $('#deliveryDateDiv').hide();
                    $('#timeSlotsElement').hide();
                    $('#scheduledDeliveryLabel').removeClass('selectedDeliveryOptionBubble');
                    $('#instantDeliveryLabel').addClass('selectedDeliveryOptionBubble');
                    $('#deliveryOptionSlotsWarning').hide();
                    
                    $('#deliveryDate').val($('#deliveryDate').attr('min'));
                    $('#deliveryDateChanged').hide();
                    
                    $('#scheduledDeliveryOptionBox').removeClass('deliveryOptionInfoBox');
                }
            }
        </script>
";
    }

    return $result;
}

function getDailySlots($zipCodeID,$deliveryDate){

    $dailySlotsArray = array();

    $dateNow = new DateTime("now", new DateTimeZone("Europe/Athens"));
    $localDayNumber = $dateNow->format('N');

    $deliveryDateNumber = date('N', strtotime($deliveryDate));

    if($localDayNumber == 7){$localDayNumber = 0;}
    if($deliveryDateNumber == 7){$deliveryDateNumber = 0;}

    global $username,$password,$database;

    $db3 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db3->set_charset("utf8");
    $stm3 = $db3->prepare("SELECT daily_slots_id, day, zip_code_id, time_slots, next_day_delivery_after_time, disable_slot_hours_before, next_day_only_time_slots, enable_timeslots, enable_delivery_approval FROM ZZ_Daily_Time_Slots WHERE zip_code_id='$zipCodeID'");
    $stm3-> execute();
    $stm3-> bind_result($dailySlotsID,$day,$zipCodeID,$timeSlots,$nextDayDeliveryAfterTime,$beforeHours,$nextDayTimeslots,$enableTimeslots,$enableDeliveryApproval);
    while ($stm3->fetch()) {
        if(strcmp($day,$localDayNumber)==0 || strcmp($deliveryDateNumber,$day)==0){
            $dailySlot = new stdClass();
            $dailySlot->dailySlotsID = $dailySlotsID;
            $dailySlot->day = $day;
            $dailySlot->dayName = date('l', strtotime("Sunday +$day days"));
            $dailySlot->zipCodeID = $zipCodeID;
            $dailySlot->timeSlots = $timeSlots;
            $dailySlot->nextDayDeliveryAfterTime = $nextDayDeliveryAfterTime;
            $dailySlot->beforeHours = $beforeHours;
            $dailySlot->nextDayTimeslots = $nextDayTimeslots;
            $dailySlot->enableTimeslots = $enableTimeslots;
            $dailySlot->enableDeliveryApproval = $enableDeliveryApproval;

            array_push($dailySlotsArray,$dailySlot);
        }
    }
    $stm3-> close();

    return $dailySlotsArray;
}
?>