<?php
session_start();
include_once("../../param.php");
require("dbhelper.php");
require_once("../assets/mobiledetect/Mobile_Detect.php");
$currencySign = getCurrencySign();
$orderID=$_SESSION['orderID'];
$customerID=$_SESSION['customerID'];

$detect = new Mobile_Detect;

$isMobile = false;

if ( $detect->isMobile() ) {
    $isMobile = true;
}

if(!isset($_SESSION['lang']))
{
    $_SESSION['lang'] = 'en';
}

include('../langs/'.$_SESSION['lang'].'.php');

$imageTitle = $langu['column_image_label'];
$quantityTitle = $langu['column_quantity_label'];
$productNameTitle = $langu['column_product_name_label'];
$priceTitle = $langu['column_price_label'];
$totalTitle = $langu['column_total_label'];

$extraCreditTitle = $langu['extra_credit_label'];
$checkoutTitle = $langu['checkout_table_label'];

$subTotalTitle = $langu['subtotal_label'];
$deliveryFeesTitle = $langu['delivery_fees_label'];
$vatTitle = $langu['vat_label'];
$grandTotalTitle = $langu['grand_total_label'];
$vatInfoLabel = $langu['total_includes_vat_of'];


$orderNotesHint = $langu['order_notes_hint'];
$deliveryDate = $langu['order_delivery_date_label'];
$paymentMethodLabel = $langu['payment_method_label'];
$DeliveryMethodLabel = $langu['delivery_method_label'];

$requestQuotationButtonTitle = $langu['request_quotation_button'];
$placeOrderButtonTitle = $langu['place_order_button'];
$payOrderButtonTitle = $langu['proceed_with_payment'];

$pickupAddress = $langu['order_pickup_address'];
$deliveryAddress = $langu['order_delivery_address'];

$noItemsMessage = $langu['checkout_no_items_message'];

$couponBoxTitle = $langu['coupons_title'];
$couponBoxLabel = $langu['insert_coupon'];
$useCouponButton = $langu['add_button'];


$hasItem=false;
$useMaxStock=false;
$showPrices=true;
$allowQuotation=true;
$allowOrder=true;
$denyOrderOverStock=true;
$itemOverStock = false;
$itemOverMaxStock = false;
$overMaxStock=false;
$showPricesWithVAT=false;
$includeVatOnPrice=false;
$useCoupons = false;
$isB2C = false;
$usePackingOnItem = false;
$addItemByUnits = true;

$timezone = 'Europe/Athens';

date_default_timezone_set($timezone);
$timestamp = strtotime(date('H:i'));
$local_time = $timestamp;
$local_time = date('H:i:s', $local_time);


$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT primary_language,show_prices,allow_quotation,allow_order,delivery_days_after,delay_delivery_after_time,use_max_stock_on_item,minimum_order,allow_order_over_stock,max_stock_limit,show_prices_with_vat,use_as_b2c,use_packing,drop_ship_item_id,order_qty_by_subunits FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($primaryLanguage,$showPrices,$allowQuotation,$allowOrder,$deliveryDaysAfter,$delayDeliveryTime,$useMaxStockOnItem,$minimumOrder,$allowOrderOverStockOnItem,$maxStockLimit,$showPricesIncludingVAT,$useAsB2C,$usePacking,$dropShipItemID,$orderQtyBySubunits);

while ($stm->fetch()) {

    if(strcmp($usePacking,'yes')==0){
        $usePackingOnItem = true;
    }
    if(strcmp($useAsB2C,"yes")==0){$isB2C = true;}
    if(strcmp($showPrices,"no")==0 || $_SESSION['showPrices']==false)
    {
        $showPrices=false;
        $priceTitle = '';
        $totalTitle = '';
    }
    if(strcmp($allowQuotation,"no")==0)
    {
        $allowQuotation=false;
    }
    if(strcmp($allowOrder,"no")==0)
    {
        $allowOrder=false;
    }
    if(strcmp($useMaxStockOnItem,"yes")==0)
    {
        $useMaxStock=true;
    }
    if(strcmp($allowOrderOverStockOnItem,"yes")==0)
    {
        $denyOrderOverStock=false;
    }

    if(strcmp($showPricesIncludingVAT,"yes")==0 || strcmp($showPricesIncludingVAT,"both")==0)
    {
        $showPricesWithVAT=true;
        if(strcmp($showPricesIncludingVAT,"yes")==0){
            $includeVatOnPrice = true;
        }
    }

    if(strcmp($orderQtyBySubunits,'yes')==0){
        $addItemByUnits = false;
    }
}
$stm-> close();



$stm = $db->prepare("SELECT use_coupons FROM B2C_Configuration LIMIT 1");
$stm-> execute();
$stm-> bind_result($useCouponsFlag);

while ($stm->fetch()) {
    if(strcmp($useCouponsFlag,"yes")==0) { $useCoupons = true; }
}
$stm-> close();

if(strcmp($delayDeliveryTime,'')!=0){
    $delayDeliveryTime .= ":00";
    if(strtotime($local_time)>strtotime($delayDeliveryTime)){
        $deliveryDaysAfter++;
    }
}

if($isMobile){
    $fontSize1 = '11px';
    $fontSize2 = '13px';
    $size1 = '38%';
    $size2 = '11%';
    $size3 = '25%';
} else {
    $fontSize1 = '14px';
    $fontSize2 = '16px';
    $size1 = '38%';
    $size2 = '15%';
    $size3 = '15%';

}

$result="<div class='row orders' ><div class='col-md-8' >

                                <table class='table lightBorder' id='onlineOrderItemsTableLabels' style='margin-bottom:0px;border: 1px solid  #cccccc'>
                                        <tr>
                                            <th style='width: 15%;display: none;' class='hidden-xs'>$imageTitle</th>
                                            <th style='display: none;'>onlineOrderItemID</th>
                                            <th style='display: none;'>itemID</th>
                                            <th style='display: none;'>UP</th>
                                            <th style='display: none;'>vatID</th>
                                            <th style='display: none;'>$quantityTitle</th>
                                            <th style=''><span style='margin-left: 6px;'>Boxes</span></th>
                                            <th style='text-align: right;width: $size2;display: none;'><span style='margin-left: 4px;'>$priceTitle</span></th>
                                            <th style='text-align: right;width: $size3;display: none;'>$totalTitle</th>
                                             <th style='width: 5%;display: none;'></th>
                                        </tr>
                                </table>
                                <table class='table lightBorder' id='onlineOrderItemsTable' style='overflow:hidden;border: 1px solid  #cccccc'>
                                    <thead>
                                        <tr style='display: none;'>
                                            <th style='display: none;'>Image</th>
                                            <th style='display: none;'>onlineOrderItemID</th>
                                            <th style='display: none;'>itemID</th>
                                            <th style='display: none;'>UP</th>
                                            <th style='display: none;'>vatID</th>
                                            <th style='display: none;'>Quantity</th>
                                            <th style='display: none;'>Product Name</th>
                                            <th style='display: none;text-align: right'>Price</th>
                                            <th style='display: none;text-align: right'>Total</th>
                                             <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>";

//MIX AND MATCH


$stm = $db->prepare("SELECT DISTINCT Categories.category_id FROM Categories,Promotions,Promotion_Customer WHERE Categories.category_id=Promotions.item_id AND CURDATE()>= valid_from AND CURDATE()<=valid_until  AND Promotion_Customer.promotion_id=Promotions.promotion_id AND (customer_id='0' OR customer_id='$customerID') AND type=2 ORDER BY category_code");
$stm-> execute();
$stm-> bind_result($categoryID);

$subTotalCategory=0;
while ($stm->fetch()) {

    $db2 = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");

    $stm2 = $db2->prepare("SELECT SUM(qty) FROM Online_Order_Item,Items,Category_Item WHERE Category_Item.category_id='$categoryID' AND Items.item_id=Category_Item.item_id AND  Online_Order_Item.item_id=Items.item_id AND Online_Order_Item.order_id='$orderID' AND Online_Order_Item.promotion_number=0");
    $stm2->execute();
    $stm2->bind_result($totalQty);

    while ($stm2->fetch()) {


    }
    $stm2->close();


    applyMixAndMatchDiscount($categoryID,$customerID,$totalQty,$orderID);




}
$stm-> close();

//------




$stm = $db->prepare("SELECT recommended_retail_price,numeric_stock FROM B2B_Page_Catalogue");
$stm-> execute();
$stm-> bind_result($recommendedRetailPrice,$numericStock);

while ($stm->fetch()) {

}
$stm-> close();
$totalVolumetrics = 0;
$totalWeight = 0;
$stm = $db->prepare("SELECT Online_Order_Item.order_item_id,Online_Order_Item.item_id,qty,unit_price,Items.vat_id,Items.item_code,Items.name,promotion_id,promotion_number,Items.short_description,line_discount_percentage,master_item,max_stock,packing,Online_Order_Item.description FROM Online_Order_Item,Items WHERE Online_Order_Item.item_id=Items.item_id AND Online_Order_Item.order_id='$orderID'");
$stm-> execute();
$stm-> bind_result($orderItemID,$itemID,$qty,$oldUnitPrice,$vatID,$itemCode,$name,$promotionID,$promotionNumber,$shortDescription,$lineDiscountPercentage,$masterItem,$maxStockOfItem,$packing,$volumetrics);

$i = 0;
$subTotal=0;
$grandTotal=0;
$vatTotal=0;
$sumOFQties=0;
$onlineOrderItemsID = array();
while ($stm->fetch()) {

    if($addItemByUnits) {
        $qty = $qty / floatval(getSubUnits($itemID));
    }

    array_push($onlineOrderItemsID, $itemID);
    $i++;
    $hasItem = true;
    $errorPrice = false;
    $errorStock = false;
    $lineDiscountApply = false;
    $imageUrl = getDefaultImage($itemID);
    $defaultPrice = getDefaultPriceFromDefaultPriceType($itemID,$qty);
    $unitPrice = getDefaultPriceInclPriceTypes($itemID, $customerID,false,$qty);
    if ($promotionID > 0) {
        $unitPrice = $oldUnitPrice;
    }
    if ($lineDiscountPercentage > 0) {
        $unitPrice = $oldUnitPrice;
        $lineDiscountApply = true;
    }

    $stock = getStock($itemID);
    if(!$addItemByUnits) {
        $lineTotal = $unitPrice*$qty / floatval(getSubUnits($itemID));
    } else {
        $lineTotal = $unitPrice*$qty;
    }
    $subTotal += $lineTotal;
    $lineVat = $lineTotal * getVatPercentage($vatID) / 100;
    $vatTotal += $lineVat;
    $sumOFQties += $qty;
    if ($unitPrice != $oldUnitPrice) {
        $errorPrice = true;
    }


    if (strcmp($_SESSION['lang'], $primaryLanguage) != 0 && isset($shortDescription) && strcmp($shortDescription, '') != 0) {
        $name = $shortDescription;
    }


    if ($qty > $stock) {
        $errorStock = true;
    }

    if ($qty > $maxStockLimit) {
        $overMaxStock = true;
    }

    if (!$itemOverStock && $errorStock) {
        $itemOverStock = true;
    }
    if (!$itemOverMaxStock && $overMaxStock) {
        $itemOverMaxStock = true;
    }

    if ($showPrices) {
        $displayDefaultPrice = number_format(floatval($defaultPrice),2);
        $displayunitPrice = number_format(floatval($unitPrice),2);
        $displayLineTotal = number_format(floatval($lineTotal),2);

        if ($showPricesWithVAT) {

            $inc = $langu['incl_label'];
            $vat = $langu['vat_label'];
            $PriceWithVatText = "";

            $displayDefaultPriceIncVat = "<br><span  style='font-size: 11px;color: #0aa66e;text-align: right;'>$currencySign" .number_format(floatval($defaultPrice + $defaultPrice * getVatPercentage($vatID) / 100),2) . " &nbsp;$inc $vat</span>";
            $displayunitPriceIncVat = "<br><span  style='font-size: 11px;color: #0aa66e;text-align: right;'>$currencySign" .number_format(floatval($unitPrice + $unitPrice * getVatPercentage($vatID) / 100),2) . " &nbsp;$inc $vat</span>";
            $displayLineTotalIncVat = "<br><span  style='font-size: 11px;color: #0aa66e '>$currencySign" .number_format(floatval($lineTotal + $lineVat),2) . " &nbsp;$inc $vat</span>";

            $displayLineTotal = "$currencySign" . number_format(floatval($lineTotal + $lineVat),2);
            $displayunitPrice = "$currencySign" . number_format(floatval($unitPrice),2);

            if ($includeVatOnPrice) {
                $displayunitPriceIncVat = '';
                $displayunitPrice = "$currencySign" . number_format(floatval($unitPrice + $unitPrice * getVatPercentage($vatID) / 100),2);
                $displayDefaultPrice = "$currencySign" . number_format(floatval($defaultPrice + $defaultPrice * getVatPercentage($vatID) / 100),2);
            }
        }

    } else {
        $displayunitPrice = "";
        $displayLineTotal = "";

    }
    $qtyTextDisable = "";

    if ($denyOrderOverStock && $maxStockLimit > 0) {
        if ($maxStockOfItem > $maxStockLimit || $maxStockOfItem == 0) {
            $maxStockOfItem = $maxStockLimit;
        }

    }

    if ($useMaxStock && $maxStockOfItem > 0 && $maxStockOfItem < $qty) {
        $overMaxStock = true;
    } else if (!$useMaxStock && $maxStockLimit > 0 && $maxStockLimit < $qty) {
        $maxStockOfItem = $maxStockLimit;
        $overMaxStock = true;
    } else {
        $overMaxStock = false;

    }


    if ($promotionNumber != 0 && strcmp($masterItem, "no") == 0) {
        $qtyTextDisable = "disabled";
    }


    if ($lineDiscountApply) {
        $displayunitPrice .= " <span style='color:#b22222'>(-$lineDiscountPercentage%)</span>";
    }

    if ($defaultPrice > $unitPrice) {
        $percentDiscount = round((1 - ($unitPrice / $defaultPrice)) * 100);
        $displayunitPrice .= " <span style='color:#b22222'>(-$percentDiscount%)</span>";
    }

    if (!$showPrices) {
        $displayunitPrice = "";
        $displayLineTotal = "";
    }

    if ($overMaxStock && $denyOrderOverStock) {
        $overMessage = "<br/><b style='color: #b22222'>" . $langu['no_orders_allowed_over'] . " $maxStockOfItem " . $langu['pieces'] . "!</b>";
        $overStyle = "color: #b22222;border-color: #b22222;";
    } else {
        $overMessage = '';
        $overStyle = '';
    }

    if ($usePackingOnItem) {
        $packingAttribute = "data-packing='$packing'";
    } else {
        $packingAttribute = '';
    }

    $result = $result . "  <tr class='itemRow'>
                             <td style='display: none;'><a class='media-link hidden-xs' href='#'><img class='hidden-xs' style='width:auto;height:50px;margin-left: 4px;' src='$imageUrl' alt='' width='50px' height='50px;'/></a></td>
                             <td style='display: none;'><input type='hidden' value='$orderItemID'></td>
                             <td style='display: none;'><input type='hidden' value='$itemID'></td>
                             <td style='display: none;'><input type='hidden' value='$unitPrice'></td>
                             <td style='display: none;'><input type='hidden' value='$vatID'></td>
                             <td class='quantity' style='display: none;'><input value='$qty' type='hidden' class='input quantityInCheckout' data-value='$itemID' $packingAttribute style='max-width:70px;text-align:center;$overStyle' $qtyTextDisable></td>
                             <td class='description' style='width: 100%;font-weight:300;font-family: Arial, Helvetica, sans-serif;font-size:$fontSize1;'>";

    $volumetricsArray = explode('|',$volumetrics);
    $h=str_replace("h:", "", $volumetricsArray[0]);
    $w=str_replace("w:", "", $volumetricsArray[1]);
    $d=str_replace("d:", "", $volumetricsArray[2]);
    $kg=str_replace("kg:", "", $volumetricsArray[3]);

    $itemVolumetrics = $d*$w*$h;
    $totalVolumetrics += $itemVolumetrics;
    $totalWeight += $kg;

    if($h == 0){$h='';}
    if($w == 0){$w='';}
    if($d == 0){$d='';}
    if($kg == 0){$kg='';}
    $result = $result . "<center>
                            <div style=\"height:300px;background-position: center center;background-size: auto 310px;background-image: url('./assets/img/dropshippingbox.jpg');background-repeat:no-repeat;\">
                                <input class='depth'  data-value='$orderItemID' value='$d'  type='number' placeholder='cm'  style='font-weight: bold;position: relative;top: 239px;left:-50px;background-color: transparent;width: 82px;text-align: center;border-color: transparent'>
                                <input class='kg'     data-value='$orderItemID' value='$kg' type='number' placeholder='Kg' style='font-weight: bold;position: relative;top: 178px;left: 58px;background-color: transparent;width:150px;text-align: center;border: 2px solid #446d9c'>
                                <input class='width'  data-value='$orderItemID' value='$w'  type='number' placeholder='cm'  style='font-weight: bold;position: relative;top: 78px; left:-59px;background-color: transparent;width: 82px;text-align: center;border-color: transparent'>
                                <input class='height' data-value='$orderItemID' value='$h'  type='number' placeholder='cm'  style='font-weight: bold;position: relative;top: 150px;left: 46px;background-color: transparent;width: 82px;text-align: center;border-color: transparent'>
                                
                                
                            </div>
                         </center>";


if(false){
    $result = $result." <h4 style='color:#222; font-size:$fontSize2;font-family: Arial, Helvetica, sans-serif;font-weight:bold;'>$name</h4>
                                                $itemCode ";

    if($_SESSION['showStock']) {
        if ($errorStock) {

            if(strcmp($numericStock,"yes")==0)
            {
                $result = $result . " <span style='color:#b22222'>-   Stock: $stock</span>
                                           $overMessage</td>";
            }

            else
            {
                $result = $result . "   <span style='height: 8px;width: 8px;background-color: #b22222;border-radius: 50%;display:inline-block;' class='dot'></span> <b style='color: #b22222'>".$langu['insufficient_stock']."!</b>
                                           $overMessage</td>";
            }


        } else {
            if(strcmp($numericStock,"yes")==0)
            {
                $result = $result . "   <span style='color:#008080'>-   Stock: $stock</span>
                                           $overMessage</td>";
            }

            else
            {
                $result = $result . "    <span style='height: 8px;width: 8px;background-color: #008080;border-radius: 50%;display:inline-block;' class='dot'></span>
                                           $overMessage</td>";
            }

        }
    }
}

    $result.= "
                                            <td class='total' style='display:none'><h4 style='color:#222; font-size:$fontSize1;font-family: Arial, Helvetica, sans-serif;font-weight:bold;text-align: right;margin-top: 20px'>$displayunitPrice $displayunitPriceIncVat</h4></td>";

    if($errorPrice)
    {
        $result.= "
                                            <td class='total' style='width: 15%;color:#b22222;font-size:$fontSize1;display:none'>$displayLineTotal</td>
                                             <td> <a style='cursor: pointer' href='#' onclick='removeItemFromCartDropShip($orderItemID,$itemID,$promotionID,$promotionNumber);'><i class='fa fa-close' ></i></a></td>
                                        </tr>";
    }
    else{
        $result.= "
                                            <td class='total' style='width: 15%;text-align:right;color:#222; font-size:15px;font-family: Arial, Tahoma, sans-serif;font-weight:bold;display:none'>$displayLineTotal</td>
                                            <td> <a style='cursor: pointer' href='#' onclick='removeItemFromCartDropShip($orderItemID,$itemID,$promotionID,$promotionNumber);'><i class='fa fa-close' ></i></a></td>
                                        </tr>";
    }




}
$stm-> close();

if($i == 0) {
    $result = $result . "<tr class='itemRow'><td>$noItemsMessage</td></tr>";
}



$result = $result."

                                    </tbody>
                                </table>
                                <button type='button' class='btn btn-theme' onclick='$(\"#dropShipInput\").change();'>Add Box</button>
                                <input type='hidden' class='quantityInCheckout' data-value='$dropShipItemID' id='dropShipInput' value='1'>
                            </div>
                            ";

$deliveryFee=getDeliveryCost($subTotal,$sumOFQties,$customerID);
$vatTotal += getDeliveryVatAmount($deliveryFee);



$subTotal +=$deliveryFee;

$subTotal = round($subTotal,2);
$vatTotal = round($vatTotal,2);
$grandTotal = $subTotal+$vatTotal;

if($showPrices)
{
    $displaySubTotal = number_format(floatval($subtotal),2);
    $displayVatTotal = number_format(floatval($vatTotal),2);
    $displayGrandTotal = number_format(floatval($grandTotal),2);
    $displayDeliveryFee=number_format(floatval($deliveryFee),2);
}
else
{
    $displaySubTotal = "";
    $displayVatTotal = "";
    $displayGrandTotal = "";
    $displayDeliveryFee="";
}

$result = $result."
 
 <div class='col-md-4' id='totalsBox'>";


$db4 = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db4->set_charset("utf8");

$stm4 = $db4->prepare("SELECT COUNT(category_id) FROM B2B_Categories_Promotions ");
$stm4->execute();
$stm4->bind_result($counter);
while ($stm4->fetch()) {
    if ($counter > 0) {


        $extraCreditResult = '';
        $db5 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db5->set_charset("utf8");
        $stm5 = $db5->prepare("SELECT B2B_Categories_Promotions.category_id,Categories.name,details,SUM(qty*unit_price) FROM Online_Order_Item,Items,Category_Item,B2B_Categories_Promotions,Categories WHERE Categories.category_id=B2B_Categories_Promotions.category_id AND B2B_Categories_Promotions.category_id=Category_Item.category_id AND Items.item_id=Category_Item.item_id AND  Online_Order_Item.item_id=Items.item_id AND Online_Order_Item.order_id='$orderID' AND ( Online_Order_Item.promotion_number>0 OR Online_Order_Item.line_discount_percentage>0) GROUP BY B2B_Categories_Promotions.category_id");
        $stm5->execute();
        $stm5->bind_result($categoryID,$categoryName,$details,$subTotalCategory);
        while ($stm5->fetch()) {

            $subTotalCategory = number_format(floatval($subTotalCategory),2);
            $extraCreditResult .= "<li class='cop-category'>

                                                 <a style='font-weight:bold;width:70%;margin-right:0;display:inline-block;color:black;text-transform:uppercase' class='selectCategory pointer abc' data-trigger='hover' data-toggle='popover-x' data-target='#over1$categoryID' data-placement='top' data-index='$categoryID'>$categoryName</a><span style='width:20%;margin-left:5px;text-align: right;display:inline-block;color:#6796d3;font-weight:bold' id='promo$categoryID'>$subTotalCategory</span>
                                                 <div id='over1$categoryID' class='popover popover-x popover-default' style='min-width:500px'>
                   $details
                    ";




        }
        $stm5->close();
        if(strcmp($extraCreditResult,'')!=0) {
            $result = $result ."<h3 class='block-title'><span>$extraCreditTitle</span></h3>
                                <div class='widget shop-categories' style='max-height:200px;overflow-y: auto;'>                                
                                    <div class='widget-content' id='promoCategoriesContainer'>
                                        $extraCreditResult                            
                                    </div>
                                </div><br>";
        }
    }
}
$stm4->close();
$result .= "<div class=\"modal fade\" id=\"checkoutModal\" tabindex=\"-1\" role=\"dialog\" aria-labelledby=\"appInfoLabel\" aria-hidden=\"true\">

            <div class=\"modal-dialog\" style='width: 90%;'>
                <div class=\"modal-content\" style='width: 100%;'>
                    <div class=\"modal-header\">
                        <button type=\"button\" class=\"close\" data-dismiss=\"modal\" aria-hidden=\"true\">&times;</button>
                        <h4 class='block-title' style=\"margin-left:10px;\" id='checkoutModalTitle'>".$langu['proceed_with_order_label'] ."</h4>
                    </div>

                    <div class=\"modal-body\" style=\"margin-top:5px;padding-top:5px;\">

";

if($useCoupons) {
    $result .= "<h3 class='block-title'><span>$couponBoxTitle</span></h3>
            <div class='widget shop-categories' style='max-height:200px;overflow-y: auto;'>                                
            <div class='widget-content' id='promoCategoriesContainer'>";
    $result .= "<table style='width: 100%'><tr>";
    $result .= "<td style='width: 70%;'><input type='text' id='couponBox' class='form-control' style='height: 47px;' name='couponBox' placeholder='$couponBoxLabel'/></td>";
    $result .= "<td style='width: 29%;'><button type='button' class='btn btn-theme' onclick='addCoupon()' >$useCouponButton</button></td>";
    $result .= "</tr></table></div></div><br>";
}
// =========== CHECKOUT ============== //
                $result = $result . "         
                                <div class='shopping-cart'><table class='table'><tr><td style='text-align: left !important;'>";



$deliveryMethods = '';
$deliveryMethodItems = array();
$hasSelectedMethod = false;
$firstDeliveryMethod = true;
$db->set_charset("utf8");
//$stm = $db->prepare("SELECT Items.item_id,item_code,name,short_description,Vats.percentage FROM B2C_Configuration,Category_Item,Items,Vats WHERE Vats.vat_id=Items.vat_id AND Category_Item.category_id=B2C_Configuration.delivery_method_category_id AND Items.item_id = Category_Item.item_id ORDER BY Category_Item.position DESC");
$stm = $db->prepare("SELECT delivery_range_id,Items.item_id,item_code,name,short_description,Vats.percentage,from_kg,to_kg,from_volume,to_volume,from_km,to_km,customer_id FROM B2B_Dropship_Delivery_Fee_Ranges,Items,Vats WHERE Vats.vat_id=Items.vat_id  AND Items.item_id = B2B_Dropship_Delivery_Fee_Ranges.item_id AND customer_id IN (1,$customerID)");
$stm-> execute();
$stm-> bind_result($rangeID,$deliveryMethodItemID,$deliveryMethodItemCode,$deliveryMethodName,$deliveryMethodShortDescription,$vatPercent,$from_kg,$to_kg,$from_volume,$to_volume,$from_km,$to_km,$customer_id);
while ($stm->fetch()) {

    if($firstDeliveryMethod){$firstDeliveryMethod = false; $firstDeliveryMethodItemID = $deliveryMethodItemID;}

    if(strcmp($_SESSION['lang'] ,'el')==0 && strcmp($deliveryMethodShortDescription,'')!=0){$deliveryMethodName = $deliveryMethodShortDescription;}

    if (in_array($deliveryMethodItemID, $onlineOrderItemsID) && !$hasSelectedMethod) {$selected='selected';$hasSelectedMethod = true;}
    else {$selected='';}
    $itemPrice = number_format(getDefaultPrice($deliveryMethodItemID,$customerID),2);
    $vatAmount = $itemPrice*$vatPercent/100;

    $deliveryMethod = "";
    $deliveryMethod->id = $deliveryMethodItemID;
    $deliveryMethod->rangeid = $rangeID;
    $deliveryMethod->price = $itemPrice;
    $deliveryMethod->vat = $vatAmount;
    $deliveryMethod->name = $deliveryMethodName;
    $deliveryMethod->selected = $selected;
    $deliveryMethod->from_kg = $from_kg;
    $deliveryMethod->to_kg = $to_kg;
    $deliveryMethod->from_volume = $from_volume;
    $deliveryMethod->from_km = $from_km;
    $deliveryMethod->to_km = $to_km;
    $deliveryMethod->customer_id = $customer_id;
    array_push($deliveryMethodItems,$deliveryMethod);

}
$stm->close();

$db->set_charset("utf8");
$stm = $db->prepare("SELECT delivery_method FROM Online_Orders WHERE order_id=$orderID");
$stm-> execute();
$stm-> bind_result($selectedDeliverytMethodID);
while ($stm->fetch()) {
    if(strcmp($selectedDeliverytMethodID,'')!=0) {
        $hasSelectedMethod = true;
    } else {
        $db2 = new mysqli('localhost',$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("UPDATE Online_Orders SET delivery_method=? WHERE order_id=?");
        $stm2->bind_param('ii',$firstDeliveryMethodItemID,$orderID);
        $stm2->execute();
        $stm2->close();
    }
}
$stm->close();

$selectedMethodCounter = 0;
foreach ( $deliveryMethodItems as $deliveryMethod) {
    $selectedMethodCounter++;
    if(!$hasSelectedMethod && $selectedMethodCounter == 1){
        $deliveryMethods .= "<option value='".$deliveryMethod->id."' data-price='".$deliveryMethod->price."' data-vat='".$deliveryMethod->vat."' data-range='".$deliveryMethod->rangeid."' selected >".$deliveryMethod->name."</option>";
    } else if(strcmp($selectedDeliverytMethodID,$deliveryMethod->id)==0) {
        $deliveryMethods .= "<option value='".$deliveryMethod->id."' data-price='".$deliveryMethod->price."' data-vat='".$deliveryMethod->vat."' data-range='".$deliveryMethod->rangeid."' selected >".$deliveryMethod->name."</option>";
    } else {
        $deliveryMethods .= "<option value='".$deliveryMethod->id."' data-price='".$deliveryMethod->price."' data-vat='".$deliveryMethod->vat."' data-range='".$deliveryMethod->rangeid."' ".$deliveryMethod->selected." >".$deliveryMethod->name."</option>";

    }

    $removeMethodsFromItems .= "productQuantityChanged($deliveryMethod->id,0);";

}

if(strcmp($deliveryMethods,'')!=0) {

    if($includeVatOnPrice){$deliveryTotalCalc = "+deliveryPrice + +deliveryPriceVat";}else{$deliveryTotalCalc = "+deliveryPrice";}

    $result .= "<div class='form-group' style='margin-top:1px;'>
                    <label>$DeliveryMethodLabel</label>
                    <select class='form-control'  id='deliveryMethod' name='deliveryMethod' style='background-image:linear-gradient(45deg, transparent 50%, gray 50%),linear-gradient(135deg, gray 50%, transparent 50%),linear-gradient(to right, #ccc, #ccc);background-position:calc(100% - 20px) calc(1em + 2px),calc(100% - 15px) calc(1em + 2px),calc(100% - 2.5em) 0.5em;background-size:5px 5px,5px 5px,1px 1.5em;background-repeat: no-repeat;' >
                      $deliveryMethods
                    </select>";

    if($showPrices) {
        $result .= "<script type='text/javascript'>
                                        jQuery(document).ready(function () {
                                           
                                            var deliveryPrice = parseFloat($('#deliveryMethod :selected').data('price')).toFixed(2);
                                            var deliveryPriceVat = parseFloat($('#deliveryMethod :selected').data('vat')).toFixed(2);
                                            
                                            var initialVATAmount = parseFloat($('#initialVAT').val()).toFixed(2);
                                            var subtotal =  parseFloat($('#subtotal').html()).toFixed(2);
                                            
                                            $('#deliveryTotal').html(parseFloat(+deliveryPrice).toFixed(2));
                                            $('#deliveryTotalincVat').html(parseFloat(+deliveryPrice + +deliveryPriceVat).toFixed(2));
                                            $('#grandTotal').html(parseFloat(+subtotal + +initialVATAmount + +deliveryPrice + +deliveryPriceVat).toFixed(2));
                                            $('#vatAmount').html(parseFloat(+initialVATAmount + +deliveryPriceVat).toFixed(2)); 
                                            
                                            var JCCPurchaseAmt = $('#grandTotal').html();
                                            JCCPurchaseAmt = JCCPurchaseAmt.split('.').join(\"\");
                                            while (JCCPurchaseAmt.length < (12)) {JCCPurchaseAmt = '0' + JCCPurchaseAmt;}
                                            $('#JCCPurchaseAmt').val(JCCPurchaseAmt);
                                            
                                            var PurchaseAmt = $('#JCCPurchaseAmt').val();
                                            var JCCorderID = '$orderID';
                                            
                                            $.ajax({
                                                type: 'POST',
                                                url: './dbaccess/getEncriptedSignatureJCC.php',
                                                data: {
                                                    'JCCcurrency': '$JCCcurrency',
                                                    'JCCacquirerID': '$JCCacquirerID',
                                                    'PurchaseAmt': PurchaseAmt,
                                                    'JCCorderID': JCCorderID
                    
                                                },
                                                success: function (result) {
                                                   
                                                    $('#JCCSignature').val(result);
                                                    
                                                }
                                            });
                                           
                                        });
                                                
                                        $('#deliveryMethod').on('change', function() {  
                                            
                                            var deliveryMethodID = $('#deliveryMethod :selected').val();
                                            var orderID = '$orderID';
                                            
                                            $.ajax({
                                                type: 'POST',
                                                url: './dbaccess/updateOrderDeliveryMethod.php',
                                                data: { 'deliveryMethodID': deliveryMethodID,'orderID':orderID },
                                                success: function (result) {}
                                            });
                                            
                                            var deliveryPrice = parseFloat($('#deliveryMethod :selected').data('price')).toFixed(2);
                                            var deliveryPriceVat = parseFloat($('#deliveryMethod :selected').data('vat')).toFixed(2);
                                            
                                            var initialVATAmount = parseFloat($('#initialVAT').val()).toFixed(2);
                                            var subtotal =  parseFloat($('#subtotal').html()).toFixed(2);
                                            $('#deliveryTotal').html(parseFloat(deliveryPrice).toFixed(2));
                                            

                                            $('#deliveryTotal').html(parseFloat(+deliveryPrice).toFixed(2));
                                            $('#deliveryTotalincVat').html(parseFloat(+deliveryPrice + +deliveryPriceVat).toFixed(2));
                                            $('#grandTotal').html(parseFloat(+subtotal + +initialVATAmount + +deliveryPrice + +deliveryPriceVat).toFixed(2));
                                            $('#vatAmount').html(parseFloat(+initialVATAmount + +deliveryPriceVat).toFixed(2));
                                                    
                                            var JCCPurchaseAmt = $('#grandTotal').html();
                                            JCCPurchaseAmt = JCCPurchaseAmt.split('.').join(\"\");
                                            while (JCCPurchaseAmt.length < (12)) {JCCPurchaseAmt = '0' + JCCPurchaseAmt;}
                                            $('#JCCPurchaseAmt').val(JCCPurchaseAmt);
                                            
                                            var PurchaseAmt = $('#JCCPurchaseAmt').val();
                                            var JCCorderID = '$orderID';
                                            
                                            $.ajax({
                                                type: 'POST',
                                                url: './dbaccess/getEncriptedSignatureJCC.php',
                                                data: {
                                                    'JCCcurrency': '$JCCcurrency',
                                                    'JCCacquirerID': '$JCCacquirerID',
                                                    'PurchaseAmt': PurchaseAmt,
                                                    'JCCorderID': JCCorderID
                    
                                                },
                                                success: function (result) {
                                                   
                                                    $('#JCCSignature').val(result);
                                                    
                                                }
                                            });
                                        });
                                        
                                    </script>";
    }
    $result .=  "</div>";
}


                $result = $result."
                                    <div id='deliveryAddressDiv'>
                                     <label>$pickupAddress</label>
                                     <table style='width: 100%;border-collapse: collapse;'>
                                     <tr><td style='width: 90%'>
                                        <select class='form-control' title='Select' id='address' style='background-image:linear-gradient(45deg, transparent 50%, gray 50%),linear-gradient(135deg, gray 50%, transparent 50%),linear-gradient(to right, #ccc, #ccc);background-position:calc(100% - 20px) calc(1em + 2px),calc(100% - 15px) calc(1em + 2px),calc(100% - 2.5em) 0.5em;background-size:5px 5px,5px 5px,1px 1.5em;background-repeat: no-repeat;'>";




$stm = $db->prepare("SELECT customer_address_id,address_line_1,address_line_2,postcode,lat,lng From CustomerAddress WHERE customer_id='$customerID' AND NOT primary_address='deleted'");
$stm-> execute();
$stm-> bind_result($customerAddressID,$addressLine1,$addressLine2,$postCode,$lat,$lng);

$i = 0;
$subTotal=0;
$grandTotal=0;
$vatTotal=0;
while ($stm->fetch()) {
  $result.= "<option value='$customerAddressID' data-lat='$lat' data-lng='$lng'>$addressLine1 $addressLine2  $postCode</option>";
}
$stm->close();

$defaultDeliveryDate = date('Y-m-d',strtotime(date('Y-m-d') . "+$deliveryDaysAfter Weekday"));
$deliveryDateValue = date('Y-m-d',strtotime(date('Y-m-d') . "+$deliveryDaysAfter Weekday"));
$db->set_charset("utf8");
$stm = $db->prepare("SELECT delivery_date FROM Online_Orders WHERE order_id=$orderID");
$stm-> execute();
$stm-> bind_result($selectedDeliverytDate);
while ($stm->fetch()) {
    if(strcmp($selectedDeliverytDate,'0000-00-00')!=0){
        if($selectedDeliverytDate > $defaultDeliveryDate){
            $deliveryDateValue = $selectedDeliverytDate;
        }
    }
}
$stm->close();
$db->set_charset("utf8");
$stm = $db->prepare("SELECT details FROM Online_Orders WHERE order_id=$orderID");
$stm-> execute();
$stm-> bind_result($deliveryTo);
while ($stm->fetch()) {}
$stm->close();
$result.="</select>
            </td><td>
                <a href='./customer_address_form.php'><button type='button' class='btn btn-theme'>Add Address</button></a>
            </td></tr></table>
<label>$deliveryAddress</label>
<input id='pac-input' class='controls form-control' type='text' placeholder='Search Box' value='$deliveryTo' />
                <div class='google_maps' style='height:402px;margin-bottom:10px;' id='map_coprime' ></div>
                        <script
                src='https://maps.googleapis.com/maps/api/js?key=AIzaSyAonEryABOdRQBcgEfH51-nOoXTca3XlWs&callback=initAutocomplete&libraries=places&v=weekly'
                async>
        </script>
        <style>
        .pac-container { z-index: 100000 !important; }
</style>
</td><td>

<div><label><b>Recipient Name: &nbsp;</b></label><input type='text' id='clientNameTo' class='form-control' style='font-weight: bolder;color: black'></div>

<table>
    <tr>
        <td style='text-align: left !important;width: 49%;'>
            <div><label><b>Recipient Address: &nbsp;</b></label><input type='text' id='addressTo' class='form-control' style='font-weight: bolder;color: black'></div>
        </td>
        <td style='text-align: left !important;width: 49%;'>
            <div><label><b>Recipient Area: &nbsp;</b></label><input type='text' id='addressAreaTo' class='form-control' style='font-weight: bolder;color: black'></div>
        </td>
    </tr>
</table>
<input type='text' id='latFrom' class='form-control' style='display: none'>
<input type='text' id='latTo' class='form-control' style='display: none'>
<input type='text' id='lngFrom' class='form-control' style='display: none'>
<input type='text' id='lngTo' class='form-control' style='display: none'>

<table>
    <tr>
        <td style='text-align: left !important;width: 33%;'>
            <div><label><b>Total Volume <span style='font-size: 15px;font-weight: normal;'>(&#13220;)</span>: &nbsp;</b></label><span id='totalVolumetrics' class='form-control' style='font-weight: bolder;color: black'>$totalVolumetrics</span></div>
        </td>
        <td style='text-align: left !important;width: 33%;'>
            <div><label><b>Total Weight (Kg): &nbsp;</b></label><span id='totalWeight' class='form-control' style='font-weight: bolder;color: black'>$totalWeight</span></div>
        </td>
        <td style='text-align: left !important;width: 33%;'>
            <div><label><b>Distance (Km): &nbsp;</b></label><span id='distanceKm' class='form-control' style='font-weight: bolder;color: black'></span></div>
        </td>
    </tr>
</table>
                     <script type='text/javascript'>
                          jQuery(document).ready(function () {
                              $('#checkoutModalTrigger').click(function() {
                                var totalKg = 0;
                                var itemKgs = document.getElementsByClassName('kg');
                                for (var i = 0; i < itemKgs.length; i++){
                                    var kgTemp = itemKgs[i].value;
                                    if(kgTemp.localeCompare('')==0){kgTemp = 0;}
                                    totalKg += +kgTemp;
                                }
                                $('#totalWeight').html(totalKg);
                                
                                var dTotal = [];
                                var wTotal = [];
                                var hTotal = [];
                                var volumetrics = 0;
                                var itemd = document.getElementsByClassName('depth');
                                for (var i = 0; i < itemd.length; i++){
                                    var dTemp = itemd[i].value;
                                    if(dTemp.localeCompare('')==0){dTemp = 0;}
                                    dTotal.push(dTemp); 
                                }
                                var itemw = document.getElementsByClassName('width');
                                for (var i = 0; i < itemw.length; i++){
                                    var wTemp = itemw[i].value;
                                    if(wTemp.localeCompare('')==0){wTemp = 0;}
                                    wTotal.push(wTemp);
                                }
                                var itemh = document.getElementsByClassName('height');
                                for (var i = 0; i < itemh.length; i++){
                                    var hTemp = itemh[i].value;
                                    if(hTemp.localeCompare('')==0){hTemp = 0;}
                                    hTotal.push(hTemp);
                                    var volumetricsTemp = +itemh[i].value * +wTotal[i] * +dTotal[i];
                                    volumetrics += +volumetricsTemp;
                                }

                                $('#totalVolumetrics').html(volumetrics);
                                var distanceKm = $('#distanceKm').html();
                                $.ajax({
                                  type: 'POST',
                                  url: './dbaccess/getDropShipDeliveryFee.php',
                                  data: { 'volumetrics': volumetrics,'totalKg':totalKg,'distanceKm':distanceKm },
                                  success: function (result) {
                                      if(result > 0){
                                          $('#deliveryMethod').val(result).change();
                                      }
                                                            
                                  }
                                });
                            });
                              
                          });
                     </script>
                                    </div>

                                     
<div class='form-group' style='margin-top:10px;' id='deliveryDateDiv'>
                                 <label >$deliveryDate</label>
                                  <input class='form-control deliveryDate' type='date' id='deliveryDate' name='deliveryDate' placeholder='yyyy-mm-dd' onChange='checkDate(false);' onkeydown='return false;' min='$defaultDeliveryDate' value='$deliveryDateValue' style='font-weight: bold' / >
                                     <script type='text/javascript'>
                                      jQuery(document).ready(function () {
                                          
                                        checkDate(true);
                                        $('#pac-input').on('change', function() {  
                                            
                                            var deliveryDate = $(this).val();
                                            var orderID = '$orderID';
                                            
                                            $.ajax({
                                                type: 'POST',
                                                url: './dbaccess/updateOrderDeliveryDate.php',
                                                data: { 'deliveryDate': deliveryDate,'orderID':orderID },
                                                success: function (result) {}
                                            });
                                        });
                                        
                                        
                                                  
                                        $('#deliveryDate').on('change', function() {  
                                            
                                            var deliveryDate = $(this).val();
                                            var orderID = '$orderID';
                                            
                                            $.ajax({
                                                type: 'POST',
                                                url: './dbaccess/updateOrderDeliveryDate.php',
                                                data: { 'deliveryDate': deliveryDate,'orderID':orderID },
                                                success: function (result) {}
                                            });
                                        });
                                       });     
                                            
                                    </script>
                                    <div id='deliveryDateChanged' style='display:none'>
                                        <h2 style='font-size:14px;color:gray'><b> *".$langu['delivery_date_changed']."</b></h2>
                                    </div>
                                    </div>
                                   
                                    
                                ";



if($isB2C) {
    $hasJCC = false;
    $paymentMethods = '';
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT payment_method_id,payment_method_code,name,alter_name,logo,allow_credit,merchant_id,acquirer_id,currency_iso_code,password,post_url FROM B2C_Payment_Methods WHERE active='yes' ORDER BY B2C_Payment_Methods.position ASC ");
    $stm->execute();
    $stm->bind_result($paymentMethodID, $paymentMethodCode, $paymentMethodName,$alterName, $paymentMethodLogo, $allowCredit, $merchantID, $acquirerID, $currencyISO, $paymentMethodPass, $paymentMethodFormURL);
    while ($stm->fetch()) {
        if(strcmp($_SESSION['lang'],'el')==0 && strcmp($alterName,'')!=0){$paymentMethodName = $alterName;}
        switch ($paymentMethodCode) {
            case "JCC":
                $hasJCC = true;
                $JCCmerchantID = $merchantID;
                $JCCpassword = $paymentMethodPass;
                $JCCacquirerID = $acquirerID;
                $JCCcurrency = $currencyISO;
                $JCCFormURL = $paymentMethodFormURL;
                $payButtonFunction = "placeOrder();";
                $JCCformattedPurchaseAmt = str_pad(str_replace('.', '', $displayGrandTotal), 12, '0', STR_PAD_LEFT);
                break;
        }
        if (strcmp($paymentMethodLogo, '') != 0 && file_exists(ROOT . "b2b/assets/img/$paymentMethodLogo")) {
            $paymentMethodLogo = "./assets/img/$paymentMethodLogo";
        } else {
            $paymentMethodLogo = "./assets/img/paymenticon.png";
        }
        if (strcmp($allowCredit, 'yes') != 0) {
            $allowCredit = 'no';
        }
        if(strcmp($allowCredit,'yes')==0 || $showPrices) {
            if (isset($_GET['pm']) && $_GET['pm'] == $paymentMethodID) {
                $paymentMethods .= "<option value='$paymentMethodID' data-logo='$paymentMethodLogo' data-iscredit='$allowCredit' data-method='$paymentMethodCode' selected>  $paymentMethodName </option>";

            } else {
                $paymentMethods .= "<option value='$paymentMethodID' data-logo='$paymentMethodLogo' data-iscredit='$allowCredit' data-method='$paymentMethodCode'>  $paymentMethodName </option>";

            }
        }
    }
    $stm->close();
    $result .= " <div class='form-group' style='margin-top:10px;'>
                <label >$orderNotesHint</label><br>
                   <textarea class='form-control' placeholder='$orderNotesHint' id='details'></textarea>
                 </div>";
    if($showPrices) {
        if($includeVatOnPrice){

            $displaySubTotalIncVat = number_format(floatval($subTotal+$vatTotal),2);
            $hideTotals = "style='display:none;'";
            $totalsInclVAT = "<tr style='display: none'>
                                            <td >$subTotalTitle</td>
                                            <td id='subtotalincvat' >$displaySubTotalIncVat</td>
                                        </tr>
                                        <tr>
                                            <td >$deliveryFeesTitle</td>
                                            <td id='deliveryTotalincVat'></td>
                                        </tr>";
            $vatTotalInfoAmount = number_format(floatval($vatTotal),2);
            if($vatTotal > 0) {
                $vatInfo = "<tr>
                                  <td  style='font-size: 11px;text-align: center;color: darkgrey' colspan='2' >* $vatInfoLabel:&nbsp; $vatTotalInfoAmount *</td>

                                </tr>";
            }
        }

        $result = $result . "
                                    <table >
                                        <thead>
                                            <tr style='border-bottom: 2px solid lightgrey;background-color: white !important;'><td colspan='2'></td></tr>
                                        </thead>
                                        <tfoot>
                                            <tr><td colspan='2'></td></tr>
                                        </tfoot>
                                        
                                        $totalsInclVAT
                                        <tr style='display: none'>
                                            <td $hideTotals>$subTotalTitle</td>
                                            <td id='subtotal' $hideTotals>$displaySubTotal</td>
                                        </tr>

                                          <tr>
                                            <td $hideTotals>$deliveryFeesTitle</td>
                                            <td id='deliveryTotal' $hideTotals>$displayDeliveryFee</td>
                                        </tr>
                                        <tr>
                                            <td $hideTotals>$vatTitle</td>
                                            <td id='vatAmount' $hideTotals>$displayVatTotal</td>
                                            <input type='hidden' id='initialVAT' value='$displayVatTotal'>
                                        </tr>
                                        <tfoot>
                                            <tr>
                                                <td >$grandTotalTitle</td>
                                                <td id='grandTotal' >$displayGrandTotal</td>
                                            </tr>
                                            $vatInfo
                                        </tfoot>
                                    </table>";
    }

    if (strcmp($paymentMethods, '') != 0) {
        $paymentMethods = "<table>
                                <tr>
                                    <td style='text-align: left !important;'>
                                        <label id='paymentMethodLabel'>$paymentMethodLabel</label><br>
                                        <img  id='paymentMethodLogo' class='form-control' height='auto' style='padding:0px;display: inline-block;width: 19%;' >
                                       <select class='form-control'  id='paymentMethod' name='paymentMethod' style='width: 80%;display: inline-block;background-image:linear-gradient(45deg, transparent 50%, gray 50%),linear-gradient(135deg, gray 50%, transparent 50%),linear-gradient(to right, #ccc, #ccc);background-position:calc(100% - 20px) calc(1em + 2px),calc(100% - 15px) calc(1em + 2px),calc(100% - 2.5em) 0.5em;background-size:5px 5px,5px 5px,1px 1.5em;background-repeat: no-repeat;' >
                                       $paymentMethods
                                       </select>
                                    </td>
                                    <td>
                                        <div><label><b>Freight Collect Amount: &nbsp;</b></label><input type='number' id='freightCollectAmount' class='form-control' style='font-weight: bolder;color: black'></div>
                                    </td>
                                </tr>
                                </table>
                      ";
    }

    $result .= "<div class='form-group' style='margin-top:10px;'>
                                 $paymentMethods
                                  </div></td></tr></table>
                                  <script type='text/javascript'>
                                        jQuery(document).ready(function () {
                                            $('#paymentMethodLogo').attr('src',$('#paymentMethod :selected').data('logo'));
                                            var iscredit = $('#paymentMethod :selected').data('iscredit');
                                            var code = $('#paymentMethod :selected').data('method');

                                                if(iscredit.localeCompare('yes') === 0){
                                                    $('#placeOrderButton').show();
                                                    $('#payOrderButton').hide();
                                                    $('#paymentFormJCC').hide();
                                                } else {
                                                    $('#placeOrderButton').hide();
                                                    $('#payOrderButton').show();
                                                    $('#paymentFormJCC').show();
                                                    
                                                }
                                            
                                            $('#paymentMethod').on('change', function() {
                                                
                                                $('#paymentMethodLogo').attr('src',$('#paymentMethod :selected').data('logo')); 
                                                
                                                var iscredit = $('#paymentMethod :selected').data('iscredit');
                                                var code = $('#paymentMethod :selected').data('method');
                                                if(iscredit.localeCompare('yes') === 0){
                                                    $('#placeOrderButton').show();
                                                    $('#payOrderButton').hide();
                                                    $('#paymentFormJCC').hide();
                                                } else {
                                                    $('#placeOrderButton').hide();
                                                    $('#payOrderButton').show();
                                                    $('#paymentFormJCC').show();
                                                    
                                                }
                                            });
                                        });
                                        
                                  </script>";
    if ($hasJCC) {
//    $JCCcurrency = "978";
//    $JCCacquirerID = "402971";
        $JCCorderID = $orderID;
        $captureFlag = "A"; // • A: automatically capture • M: do not automatically capture; will capture manually at a later stage
        $toEncrypt = $JCCpassword . $JCCmerchantID . $JCCacquirerID . $JCCorderID . $JCCformattedPurchaseAmt . $JCCcurrency;
        $sha1Signature = sha1($toEncrypt);
        $base64Sha1Signature = base64_encode(pack("H*", $sha1Signature));
        $result .= "      
          <div class='form-group' style='margin-top:10px;'>
              <form method='post' name='paymentFormJCC' id='paymentFormJCC' action='$JCCFormURL'>
                <input type='hidden' name='Version' value='1.0.0'>
                <input type='hidden' name='MerID' value='$JCCmerchantID'>
                <input type='hidden' name='AcqID' value='$JCCacquirerID'>
                <input type='hidden' name='MerRespURL' value='https://" . HTML_PATH . "/cop/b2b/dbaccess/JCCRedirect.php'>
                <input type='hidden' name='PurchaseAmt' id='JCCPurchaseAmt' value='$JCCformattedPurchaseAmt'>
                <input type='hidden' name='PurchaseCurrency' value='$JCCcurrency'>
                <input type='hidden' name='PurchaseCurrencyExponent' value='2'>
                <input type='hidden' name='OrderID' id='JCCOrderID' value='$JCCorderID'> 
                <input type='hidden' name='CaptureFlag' value='$captureFlag'> 
                <input type='hidden' name='Signature' id='JCCSignature' value='$base64Sha1Signature'>
                <input type='hidden' name='SignatureMethod' value='SHA1'>
              </form> 
          </div>";
    }

    $result .= "</div>";
}
if($itemOverMaxStock && $denyOrderOverStock){
    $hideButtons = "display:none;";
    $allowOrder = false;
    $result .= "<label style='width: 100%;color: firebrick; margin-top: 5px;' id='warningLabel'><h3><center>".$langu['insufficient_stock']."</center></h3></label>";

}
if($itemOverStock && $denyOrderOverStock){
    $hideButtons = "display:none;";
    $allowOrder = false;
    $result .= "<label style='width: 100%;color: firebrick; margin-top: 5px;' id='warningLabel'><h3><center>".$langu['insufficient_stock']."</center></h3></label>";

}
if($minimumOrder > $displaySubTotal && $showPrices){
    $minimumOrder = number_format("$minimumOrder","2",".",",");
    $result .= "<label style='width: 100%;color: firebrick; margin-top: 5px;' id='warningLabel'><h3><center>".$langu['minimum_order_warning'].": $minimumOrder</center></h3></label>";
    $hideButtons = "display:none;";
    $allowOrder = false;
}
if($allowQuotation && $hasItem ) {
    $result .= "<label style='width: 100%;color: firebrick; margin-top: 5px;' id='confirmTenderLabel'><h3><center>".$langu['confirm_tender_label']."</center></h3></label>";

    $result .= "<a class='btn btn-theme btn-tender' style='width:100%;margin-right:10px;margin-top:10px;height:42px;$hideButtons' href='#' id='requestQuotationButton' data-dismiss=\"modal\">$requestQuotationButtonTitle</a>";
}
if($allowOrder && $hasItem) {
    $result .= "  
                                                                   <a class='btn btn-theme' style='width:100%;margin-top:10px;$hideButtons' href='#' id='placeOrderButton' data-dismiss=\"modal\">$placeOrderButtonTitle</a>
                                                                   <a class='btn btn-theme' style='width:100%;display:none;margin-top:10px;$hideButtons' href='#' onclick='$payButtonFunction' id='payOrderButton' data-dismiss=\"modal\">$placeOrderButtonTitle</a>";

}
$result .= " </div>

                    <footer class=\"modal-footer\" >
                        
                    </footer>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->
";

if($customerID != 0) {
    $result .= "<button id=\"checkoutModalTrigger\" data-toggle=\"modal\" data-target=\"#checkoutModal\" class=\"btn btn-theme\" style='margin-top:10px;width: 100%' onclick='quotationModal(0);'>" . $langu['proceed_with_order_label'] . "</button>";
    if ($allowQuotation && $hasItem && false) {
        $result .= "<button id=\"checkoutModalTrigger\" data-toggle=\"modal\" data-target=\"#checkoutModal\" class=\"btn btn-theme btn-tender\" style='margin-top:10px;width: 100%' onclick='quotationModal(1);'>$requestQuotationButtonTitle</button>";

    }
} else {
    $result .= "<h3>Anonymous Order Under Development</h3>";
}
$result.="</div>
          </div>";

// =========== /CHECKOUT ============== //



echo $result;
?>