<?php
session_start();
include_once("../../param.php");
require("dbhelper.php");

if(isset($_POST['lang']) && strcmp($_POST['lang'],'')!=0)
{
    $_SESSION['lang'] = $_POST['lang'];
}


global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");


$stm = $db->prepare("SELECT  language, language_show, primary_color, product_image_background, currency, auto_search, search_with_bar_code_scanning, show_categories_list_in_home_page, categories_images_visibility, font_size, product_grid_image_size_androit, force_login,home_screen_view,sub_category_list_mode,product_catalogue_layout,timestamp FROM B2B_App_Configuration LIMIT 1");
$stm-> execute();
$stm-> bind_result($primaryLanguage,$languageShow,$primaryColor,$productImageBackground,$defaultCurrencySymbol,$autoSearch,$searchWithBarCodeScanning,$showCategoriesListInHomePage,$categoriesImagesVisibility,$fontSize,$productGridImageSizeAndroit,$forceLogin,$homeSreenView,$subCategoryListMode,$productCatalogueLayout,$timestamp);
while ($stm->fetch()) {}
$stm-> close();


$stm = $db->prepare("SELECT css_theme,use_loyalty,anonymous_order,has_delivery_approval,use_as_b2c,b2b_account_request FROM B2B_Configuration LIMIT 1");
$stm-> execute();
$stm-> bind_result($themeDefault,$useLoyalty,$anonymousOrder,$hasDeliveryApproval,$useAsB2C,$b2bAccountRequest);
while ($stm->fetch()) {}
$stm-> close();

$stm = $db->prepare("SELECT allow_user_favorites FROM B2B_Page_Catalogue LIMIT 1");
$stm-> execute();
$stm-> bind_result($allowUserFavorites);
while ($stm->fetch()) {}
$stm-> close();

if(strcmp($anonymousOrder,'yes')==0){$allowCartWithAnonymousUser=true;}
else {$allowCartWithAnonymousUser=false;}


if(strcmp($showCategoriesListInHomePage,'true')==0){$bottomNavigationShowCategories=true;}
else {$bottomNavigationShowCategories=false;}

$useDeliveryApproval=false;
if(strcmp($hasDeliveryApproval,'yes')==0) {
    $stmt = $db->prepare("SELECT device_id FROM B2B_Delivery_Approval_Devices LIMIT 1");
    $stmt->execute();
    $stmt->bind_result($deliveryApprovalDeviceID);
    while ($stmt->fetch()) {}
    $stmt->close();
    $deliveryApprovalDeviceID = intval($deliveryApprovalDeviceID);

    if ($deliveryApprovalDeviceID > 0) {
        $useDeliveryApproval=true;
    }
}

$currencies = array();
$stm = $db->prepare("SELECT currency_id,currency_name,currency_sign FROM Display_Currency");
$stm-> execute();
$stm-> bind_result($currencyID,$currencyName,$currencySymbol);
while ($stm->fetch()) {
    array_push($currencies, array("id" => "$currencyID", "name" => "$currencyName", "symbol" => "$currencySymbol"));
}
$stm-> close();
if(empty($currencies)) {
    array_push($currencies, array("id" => "1", "name" => "Euro", "symbol" => "€"));
}


$languages = array();
if(strcmp("$languageShow","true")==0 || strcmp("$primaryLanguage","el")==0){
    $gr= new stdClass();
    $gr->name="Greek";
    $gr->code="el";
    array_push($languages, $gr);
}

if(strcmp("$languageShow","true")==0 || strcmp("$primaryLanguage","en")==0){
    $en= new stdClass();
    $en->name="English";
    $en->code="en";
    array_push($languages, $en);
}

$loyalty = false;
if(strcmp($useLoyalty,'yes')==0){

    $db->set_charset("utf8");
    $stmt = $db->prepare("SELECT loyalty_type_id,name,acquiring_points_multiplier FROM Loyalty_Types WHERE type = '2' AND status='yes' AND DATE(valid_from)<=DATE(NOW()) AND DATE(valid_until)>=DATE(NOW()) ORDER BY valid_from DESC,valid_until ASC");
    $stmt->execute();
    $stmt->bind_result($loyaltyTypeID,$loyaltyTypeName,$multiplier);
    while ($stmt->fetch()) {}
    $stmt->close();

    if($loyaltyTypeID > 0) {$loyalty = true;}
}

if(strcmp(trim($forceLogin),'false')==0){$forceLogin = false;}
if(strcmp(trim($forceLogin),'true')==0){$forceLogin = true;}

$config= new stdClass();
$config->currencySimbol="$defaultCurrencySymbol";
$config->primaryColor="$primaryColor";
$config->autoSearch=$autoSearch;
$config->searchWithBarcodeScanning=$searchWithBarCodeScanning;
$config->bottomNavigationShowCategories=$bottomNavigationShowCategories;
$config->homeScreenView="$homeSreenView";
$config->categoriesImagesVisibility="$categoriesImagesVisibility";
$config->productImageBackground="$productImageBackground";
$config->languages=$languages;
$config->themeDefault=$themeDefault;
$config->fontSize=$fontSize;
$config->forceLogin=$forceLogin;
$config->currencies=$currencies;
$config->loyaltyPoints=$loyalty;
$config->allowCartWithAnonymousUser=$allowCartWithAnonymousUser;
$config->useDeliveryApproval=$useDeliveryApproval;
$config->subCategoryListMode="$subCategoryListMode";
$config->useAsB2C="$useAsB2C";
$config->b2bAccountRequest="$b2bAccountRequest";
$config->productCatalogueLayout = "$productCatalogueLayout";
$config->useCustomerFavoriteItems = "$allowUserFavorites";

echo json_encode($config);



?>