<?php
session_start();
include_once("../../param.php");
require("dbhelper.php");

if(isset($_POST['lang']) && strcmp($_POST['lang'],'')!=0)
{
    $_SESSION['lang'] = $_POST['lang'];
}
$result=new stdClass();
$result->image=getHeader();
$result->categories=array();

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT primary_language FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($primaryLanguage);

while ($stm->fetch()) {

}
$stm-> close();

$show = true;
$counterOfCategories = 0;

if(isset($_SESSION['userID']))
{
    $user=$_SESSION['userID'];

    $stm = $db->prepare("SELECT COUNT(*) FROM B2B_Allow_Categories_User WHERE b2b_user_id='$user'");
    $stm-> execute();
    $stm-> bind_result($counterOfCategories);

    while ($stm->fetch()) {

    }
    $stm-> close();
    if($counterOfCategories>0)
    {
//        $query="SELECT Categories.category_id,name,description FROM Categories,B2B_Categories,B2B_Allow_Categories_User WHERE Categories.category_id=B2B_Categories.category_id && Categories.category_id=B2B_Allow_Categories_User.category_id AND b2b_user_id='$user' ORDER BY B2B_Categories.position,category_code";
        $query="SELECT Categories.category_id,Categories.category_code,name,description FROM Categories INNER JOIN B2B_Allow_Categories_User ON(Categories.category_id=B2B_Allow_Categories_User.category_id) LEFT JOIN B2B_Categories ON (Categories.category_id=B2B_Categories.category_id) WHERE b2b_user_id='$user' ORDER BY B2B_Categories.position,category_code";

    }
    else
    {

        $query="SELECT Categories.category_id,Categories.category_code,name,description FROM Categories,B2B_Categories WHERE Categories.category_id=B2B_Categories.category_id ORDER BY B2B_Categories.position,category_code";
    }


}
else
{
    $query="SELECT Categories.category_id,Categories.category_code,name,description FROM Categories,B2B_Categories WHERE Categories.category_id=B2B_Categories.category_id AND Categories.category_id > 100 ORDER BY B2B_Categories.position,category_code";
}


$stm = $db->prepare($query);
$stm-> execute();
$stm-> bind_result($categoryID,$categoryCode,$name,$description);
while ($stm->fetch()) {
    $category=new stdClass();
    if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($description) && strcmp($description,'')!=0 )
    {
         $name=$description;
    }

    if($counterOfCategories == 1 && $categoryID == 2){$show = false;}
    else if($counterOfCategories == 1 && $categoryID == 14){$show = false;}

    $category->categoryID=$categoryID;
    $category->code=$categoryCode;
    $category->name=$name;
    $category->imageUrl=getCategoryImageURL($categoryID);
    $category->subcategories=getSubCategories($categoryID);

    array_push($result->categories,$category);

}
$stm-> close();
$result=json_encode($result);


echo $result;
function getCategoryImageURL($categoryID){
    $result = null;
    global $username,$password,$database;

    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $stm2 = $db2->prepare("SELECT icon FROM B2B_Grid_Menu WHERE b2b_grid_menu_id='$categoryID' AND level=999 LIMIT 1");
    $stm2-> execute();
    $stm2-> bind_result($image);
    while ($stm2->fetch()) {
        if(strcmp($image,'')!=0)
        {
            $result="//".HTML_PATH."/cop/b2b/".$image;
        }
    }
    $stm2-> close();

    return $result;

}
function getHeader(){
    $result = null;
    global $username,$password,$database;

    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $stm2 = $db2->prepare("SELECT website FROM Companies");
    $stm2-> execute();
    $stm2-> bind_result($image);
    while ($stm2->fetch()) {
        if(strcmp($image,'')!=0 && file_exists(ROOT."/b2b/".$image))
        {
            $result="//".HTML_PATH."/cop/b2b/".$image;
        }
    }
    $stm2-> close();

    return $result;

}
function getSubCategories($categoryID){
    $result=array();
    $nextLevel = 0;
    global $username,$password,$database;
    $subCategories=false;
    $subCategoriesSt="";
    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }


    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT Categories.category_id,name,description,category_code FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$categoryID\" AND Categories.category_id=Subcategories.subcategory_id ORDER BY name");
    $stm2-> execute();
    $stm2-> bind_result($subCategoryID,$subName,$descriptionSub,$subCategoryCode);
    while ($stm2->fetch()) {
        global $primaryLanguage;
        $subCategories=true;
        if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 &&isset($descriptionSub) && strcmp($descriptionSub,'')!=0 )
        {
            $subName=$descriptionSub;
        }
        $category=new stdClass();
        $category->categoryID=$subCategoryID;
        $category->code=$subCategoryCode;
        $category->name=$subName;
        $category->imageUrl=getCategoryImageURL($subCategoryID);
        $category->subcategories=getSubCategories($subCategoryID);
        array_push($result,$category);
    }
    $stm2-> close();
    return $result;
}

function uc_without_accents($string, $enc = "utf-8") {
    return strtr(mb_strtoupper($string, $enc),
        array('Ά' => 'Α', 'Έ' => 'Ε', 'Ί' => 'Ι', 'Ή' => 'Η', 'Ύ' => 'Υ',
            'Ό' => 'Ο', 'Ώ' => 'Ω', 'A' => 'A', 'A' => 'A', 'A' => 'A', 'A' => 'A',
            'Y' => 'Y','ΐ' => 'Ϊ'
        ));
}

function grstrtolower($string) {

    $string .= " ";

    $latin_check = '/[\x{0030}-\x{007f}]/u';

    if (preg_match($latin_check, $string))
    {

        $string = strtoupper($string);

    }

    $letters  								= array('α', 'β', 'γ', 'δ', 'ε', 'ζ', 'η', 'θ', 'ι', 'κ', 'λ', 'μ', 'ν', 'ξ', 'ο', 'π', 'ρ', 'σ', 'τ', 'υ', 'φ', 'χ', 'ψ', 'ω');
    $letters_accent 						= array('ά', 'έ', 'ή', 'ί', 'ό', 'ύ', 'ώ');
    $letters_upper_accent 					= array('Ά', 'Έ', 'Ή', 'Ί', 'Ό', 'Ύ', 'Ώ');
    $letters_upper_solvents 				= array('ϊ', 'ϋ');
    $letters_other 							= array('ς');

    $letters_to_uppercase					= array('Α', 'Β', 'Γ', 'Δ', 'Ε', 'Ζ', 'Η', 'Θ', 'Ι', 'Κ', 'Λ', 'Μ', 'Ν', 'Ξ', 'Ο', 'Π', 'Ρ', 'Σ', 'Τ', 'Υ', 'Φ', 'Χ', 'Ψ', 'Ω');
    $letters_accent_to_uppercase 			= array('Ά', 'Έ', 'Ή', 'Ί', 'Ό', 'Ύ', 'Ώ');
    $letters_upper_accent_to_uppercase 		= array('Α', 'Ε', 'Η', 'Ι', 'Ο', 'Υ', 'Ω');
    $letters_upper_solvents_to_uppercase 	= array('Ι', 'Υ');
    $letters_other_to_uppercase 			= array('Σ');

    $lowercase = array_merge($letters, $letters_accent, $letters_upper_accent, $letters_upper_solvents, $letters_other);
    $uppercase = array_merge($letters_to_uppercase, $letters_accent_to_uppercase, $letters_upper_accent_to_uppercase, $letters_upper_solvents_to_uppercase, $letters_other_to_uppercase);

    $uppecase_string = str_replace($uppercase,$lowercase, $string);
    $uppecase_string = str_replace('σ ', 'ς ', $uppecase_string);


    return $uppecase_string;

}

?>