<?php
session_start();
include_once("../../param.php");

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */

// DB table to use
$table = 'Waybills';

// Table's primary key
$primaryKey = "waybill_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`o`.`waybill_code`', 'dt' =>  'code', 'field' =>'waybill_code' ),

    array( 'db' => '`o`.`waybill_id`', 'dt' => 'projects', 'formatter' => function( $d, $row ) {

        global $db;

        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT COUNT( DISTINCT warehouse_id) FROM Waybill_Item WHERE waybill_id = $d ");
        $stm-> execute();
        $stm-> bind_result($projects);
        while ($stm->fetch()) {}
        $stm-> close();
        return $projects;
    }, 'field' => 'waybill_id' ),

    array( 'db' => '`o`.`waybill_id`', 'dt' => 'activities', 'formatter' => function( $d, $row ) {

        global $db;

        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT COUNT( DISTINCT item_id) FROM Waybill_Item WHERE waybill_id = $d ");
        $stm-> execute();
        $stm-> bind_result($projects);
        while ($stm->fetch()) {}
        $stm-> close();
        return $projects;
    }, 'field' => 'waybill_id' ),


    array( 'db' => '`o`.`waybill_id`', 'dt' => 'hours', 'formatter' => function( $d, $row ) {

        global $db;

        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT SUM(qty) FROM Waybill_Item WHERE waybill_id = $d");
        $stm-> execute();
        $stm-> bind_result($qty);
        while ($stm->fetch()) {}
        $stm-> close();

        $shownTimeHr  = floor($qty/60);
        $shownTimeMin = round(($qty/60-$shownTimeHr)*60);
        if($shownTimeMin < 10 ) {$shownTimeMin = "0".$shownTimeMin;}
        $qty = $shownTimeHr.':'.$shownTimeMin;

        return $qty;
    }, 'field' => 'waybill_id' ),

    array( 'db' => '`o`.`timestamp`', 'dt' => 'date' , 'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));
        },'field' => 'timestamp' ),

    array( 'db' => '`o`.`waybill_id`', 'dt' => 'form' , 'formatter' => function( $d, $row ) {
        return '<form id="'.$d.'"action="timesheet-history-single.php" method="post">
                    <input type="hidden" name="waybillID" value="'.$d.'">	           			                   
                    <input style="font-size:13px;" type="submit" class="btn btn-primary" value="View" style="width:60px">
                </form>';
            },'field' => 'waybill_id' )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */


$customerID =$_SESSION['customerID'];
$salesPersonID = $_SESSION['userID'];
$joinQuery = "FROM `Waybills` AS `o` ";
$where = "`o`.`customer_id`='$customerID' AND `o`.`salesperson_id`='$salesPersonID'";
require( 'ssp2.class.php' );

echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );

     ?>