<?php
session_start();
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../param.php");

// DB table to use
$table = 'CustomerAddress';
 
// Table's primary key
$primaryKey = "customer_address_id";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`a`.`address_line_1`'  , 'dt' =>  'address' , 'field' =>'address_line_1' ),
    array( 'db' => '`a`.`address_line_2`'  , 'dt' =>  'area'    , 'field' =>'address_line_2' ),
    array( 'db' => '`a`.`postcode`'        , 'dt' =>  'postcode', 'field' =>'postcode'       ),
    array( 'db' => '`a`.`city`'            , 'dt' =>  'city'    , 'field' =>'city'           ),
    array( 'db' => '`a`.`country`'         , 'dt' =>  'country' , 'field' =>'country'        ),

    array( 'db' => '`a`.`primary_address`' , 'dt' =>  'primary' , 'formatter' => function( $d, $row ) {
        if(strcmp($d,'yes')==0){
            return "<i class='fa fa-star'></i>";
        } else {
            return " ";
        }
    }, 'field' =>'primary_address'),

    array( 'db' => '`a`.`customer_address_id`', 'dt' => 'actions', 'formatter' => function( $d, $row ) {
        return '<form id="'.$d.'" action="customer_address_form.php" method="post">
           		<input type="hidden" name="edit" value="yes">
           		<input type="hidden" name="customerAddressID" value="'.$d.'">
			<button style="font-size:13px;" type="submit" class="btn btn-primary " id="editAddressButton" ><i class="fa fa-edit"></i> </button>
			</form>';
    }, 'field' => 'customer_address_id' )
);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */


$customerID =$_SESSION['customerID'];
$joinQuery = "FROM `CustomerAddress` AS `a` INNER JOIN `Customers` AS `c` ON (`a`.`customer_id` = `c`.`customer_id`)";
$where = "`a`.`customer_id`='$customerID' AND NOT `a`.`primary_address` = 'deleted'";
require( 'ssp2.class.php' );

echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>