<?php
session_start();
if(!isset($_SESSION['customerID']) ) {
    redirect("login.php");
}
function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}
include_once("../param.php");
require("./dbaccess/dbhelper.php");
include_once("headerImports.php");
require_once("./assets/mobiledetect/Mobile_Detect.php");

// ---Popup Message Modal---
include_once("./dbaccess/b2b_popup_message_modal.php");
b2b_popup_message_modal('checkout', $_SESSION['userID']);
// ---Popup Message Modal/--

$detect = new Mobile_Detect;
$isMobile = false;
$anonymousCheckout = false;
$anonymousQuotation = false;
$hasPendingOrders = false;
$importFromFile = false;
if ( $detect->isMobile() ) {$isMobile = true;}

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
if(isset($_SESSION['customerID']) && $_SESSION['customerID'] > 0) {
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT order_id,order_code FROM Orders WHERE customer_id='".$_SESSION['customerID']."' AND status = 'Payment Pending' ORDER BY timestamp DESC LIMIT 1");
    $stm->execute();
    $stm->bind_result($pendingOrderID,$pendingOrderCode);
    while ($stm->fetch()) {
        if(strcmp($pendingOrderCode,'')!=0){
            $hasPendingOrders = true;
        }
    }
    $stm->close();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT css_theme,delivery_on_weekend,link_delivery_to_schedules,anonymous_quotation,anonymous_checkout,anonymous_checkout_customer_id,footer,import_order_from_file,custom_delivery_time_slots FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($cssTheme,$deliveryOnWeekend,$linkSchedulesToB2B,$anonymousQuotationCheck,$anonymousCheckoutCheck,$anonymousCheckoutCustomerID,$footerLabel,$importOrderFromFile,$customDeliveryTimeslots);

while ($stm->fetch()) {
    if($cssTheme <= 1){
        $cssTheme = '';
    }
    if(strcmp($anonymousCheckoutCheck,'yes')==0 && $anonymousCheckoutCustomerID > 0 && $_SESSION['customerID'] == 0){
        $anonymousCheckout = true;
    }
    if(strcmp($anonymousQuotationCheck,'yes')==0 && $anonymousCheckoutCustomerID > 0 && $_SESSION['customerID'] == 0){
        $anonymousQuotation = true;
    }
    if(strcmp($importOrderFromFile,'yes')==0){
        $importFromFile = true;
    }
}


if(!isset($_SESSION['id']))
{
   $_SESSION['id'] = session_id();
 }
if(!isset($_SESSION['lang']))
{
    $_SESSION['lang'] = 'en';
}
if(isset($_SESSION['B2C']))
{
    $isB2C =  $_SESSION['B2C'];
}
if(file_exists('../langs/'.$_SESSION['lang'].'.php')) {
    include('../langs/' . $_SESSION['lang'] . '.php');
}

$loginTitle = $langu['login_page_login_title'];
$welcomeMessage = $langu['login_page_welcome_text'];
$usernameHint = $langu['login_page_username_hint'];
$passwordHint = $langu['login_page_password_hint'];
$loginButton = $langu['login_page_login_button'];
$registerButton = $langu['login_page_register_button'];

$registerButton = $langu['login_page_register_button'];
$registerTitle  = $langu['login_page_register_button'];
$companyNameTitle  = $langu['company_name_title'];
$firstNameTitle  = $langu['first_name_title'];
$lastNameTitle  = $langu['last_name_title'];
$phoneTitle  = $langu['phone_number_title'];
$emailTitle  = $langu['email_title'];
$cityTitle  = $langu['city_title'];
$areaTitle  = $langu['area_title'];
$streetTitle  = $langu['street_address_title'];
$postCodeTitle  = $langu['postcode_title'];
$enterPassTitle  = $langu['enter_password_title'];
$confirmPassTitle  = $langu['confirm_password_title'];
$countryTitle = $langu['country_title'];
$invalidEmailHint = $langu['invalid_email_hint'];
$emailExistsHint = $langu['email_exists_hint'];
$passMismatch = $langu['Password_mismatch'];
$companyExistsHint = $langu['company_exists_hint'];
$passRequirementsHint = $langu['password_requirements_hint'];
$userInfoTitle = $langu['user_info_title'];
$userAddressTitle =  $langu['user_address_title'];
$userPasswordTitle =  $langu['user_password_title'];
$confirmationNotice = $langu['account_created_notice'];
$activationNotice = $langu['email_activation_notice'];
$followLinkNotice = $langu['follow_link_notice'];
$loginButton = $langu['login_page_login_button'];
$accountActivatedTitle = $langu['account_active_notice'];
$contactUsNoEmail = $langu['no_email_contact_notice'];
$contactForActivation = $langu['contact_us_for_activation'];
$findActivationEmail = $langu['find_activation_email_notice'];
$accountInactive = $langu['account_inactive_notice'];
$contactUsButton = $langu['contact_us_title_label_left'];
$resendEmail = $langu['resend_email'];

$stm = $db->prepare("SELECT customer_activation_method FROM B2C_Configuration LIMIT 1");
$stm-> execute();
$stm-> bind_result($activationMethod);
while ($stm->fetch()) {}
$stm-> close();

$requiredFieldTitle   = "<i class='fa fa-asterisk' style='color: #d68170;font-size: 12px;'>&nbsp;".$langu['required_field_notice']."</i>";
$loginRedirection     = " <button type='button' class='btn btn-theme btn-block ' onclick='loginRedirect()'>$loginButton</button>";
$contactUsRedirection = " <button type='button' class='btn btn-theme btn-block ' onclick='contactUsRedirect()'>$contactUsButton</button>";

if(strcmp($activationMethod,'contact')!=0) {
    $resendEmail = "<button type='button' class='btn btn-theme btn-block ' onclick='resendEmail()'>$resendEmail</button>";
    $inactiveBox = "<div class='block-title' align='center' style='font-weight: bold;text-transform: initial'><center><h2>$accountInactive</h2><br>$findActivationEmail<br>$contactUsNoEmail</center><br><br>$contactUsRedirection $resendEmail</div>";

} else {
    $inactiveBox = "<div class='block-title' align='center' style='font-weight: bold;text-transform: initial'><center><h2>$accountInactive</h2><br>$contactForActivation</center><br><br>$contactUsRedirection</div>";

}

$confirmationBox = "<div class='block-title' align='center' style='font-weight: bold;text-transform: initial'><center><h2>$confirmationNotice</h2><br>$activationNotice<br>$followLinkNotice</center><br><br>$loginRedirection</div>";
$activeBox       = "<div class='block-title' align='center' style='font-weight: bold;text-transform: initial'><center><h2>$accountActivatedTitle</h2><br></center><br><br>$loginRedirection</div>";
$contactBox      = "<div class='block-title' align='center' style='font-weight: bold;text-transform: initial'><center><h2>$confirmationNotice</h2><br>$contactForActivation</center><br><br>$contactUsRedirection</div>";

if(isset($_GET['li']) && strcmp($_GET['li'],'y')==0 && $_SESSION['customerID'] > 0 ){
    $triggerOrder = "
    setTimeout(function() { 
        $('#checkoutModalTrigger').trigger('click');
    }, 500);";
} else if(isset($_GET['li']) && strcmp($_GET['li'],'n')==0 ){
    $triggerOrder = "
    setTimeout(function() { 
        $('#loginTrigger').trigger('click');
    }, 500);";
}

if(isset($_POST['orderFromFile']) && strcmp($_POST['orderFromFile'],'yes')==0 ){
    $processed = $_POST['processedCounterFromFile'];
    $nonProcessed = $_POST['nonProcessedCounterFromFile'];
    $json = $_POST['jsonResponse'];

    $triggerUploadedItemsFromFileModal = "$('#uploadedItemsFromFileModal').modal('toggle');";
}

if(isset($_GET['theme']) && strcmp($_GET['theme'],'dark')==0){
    echo "
    <style>
        body{
            background-color: rgba(0,0,0,0.91);
        }
        table{
            background-color: transparent !important;
            border-color: transparent !important;
            color: rgba(255,255,255,0.96) !important;
        }
        th, td {
            background-color: #232323 !important;
            border-color: rgba(0,0,0,0.91) !important;
            color: rgba(255,255,255,0.96) !important;
        }
        #totalsBox{
            background-color: #232323 !important;
            border-color: rgb(52,52,52) !important;
            color: rgba(255,255,255,0.96) !important;
        }
        .shopping-cart{
            background-color: transparent !important;
        }
        .btn-theme-transparent {
            color: rgba(255,255,255,0.96) !important;
        }
        .block-title{
            background-color: #232323 !important;
            color: rgba(255,255,255,0.96) !important;
        }
        input, textarea, select {
            background-color: #232323 !important;
            border-color: rgb(52,52,52) !important;
            color: rgba(255,255,255,0.96) !important;
        }
        h4{
            color: rgba(255,255,255,0.96) !important;
        }
        #preloader{
            background-color: rgba(0,0,0,0.91) !important;
            color: rgba(255,255,255,0.96) !important;
        }
        .modal-content{
            background-color: #232323 !important;
            color: rgba(255,255,255,0.96) !important;
        }
        label{
            color: rgba(255,255,255,0.88) !important;
        }
        .form-control{
            background-color: #232323 !important;
            color: rgba(255,255,255,0.96) !important;
        }
    </style>";
}
?>

<body id="home" class="wide">
        <input type="hidden" id="state" value="0">
        <!-- PRELOADER -->
        <div id="preloader">
            <div id="preloader-status">
                <div class="spinner">
                    <div class="rect1"></div>
                    <div class="rect2"></div>
                    <div class="rect3"></div>
                    <div class="rect4"></div>
                    <div class="rect5"></div>
                </div>
                <div id="preloader-title">Loading</div>
            </div>
        </div>
        <!-- /PRELOADER -->

        <!-- WRAPPER -->
        <div class="wrapper">

            <!-- Popup: Shopping cart items -->
            <div class="modal fade popup-cart" id="popup-cart" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="container">
                        <div class="cart-items">

                        </div>
                    </div>
                </div>
            </div>
            <!-- /Popup: Shopping cart items -->

            <!-- HEADER -->
                <?php
                $topmenu = "topMenuCheckout$cssTheme.php";

                if(strcmp($topmenu,"topMenuCheckout2.php")==0){
                    echo '<header class="header fixed" style="border: 0px;">';
                } else {
                    echo '<header class="header fixed" >';
                }

                include_once("$topmenu");
                if(strcmp($topmenu,"topMenuCheckout.php")==0) {
                    include_once("navigationMenu.php");
                }
                ?>
            </header>

            <!-- /HEADER -->

            <!-- CONTENT AREA -->
            <div class="content-area" >

                <!-- PAGE -->
                <section class="page-section color">

                    <?php
                    if(strcmp($topmenu,"topMenuCheckout3.php")==0){
                        echo '<center>
                                <h3 class="" style="background-color: '.$themeColor.';color:'.$textColor.';padding: 60px;text-align: center; margin-top: -28px;margin-bottom:20px; font-weight:bolder;font-size:40px;">'.$langu['checkout_title_label'].' </h3>
                              </center>';
                    } else {

                        if($importFromFile){
                            $importFromFileButton = '<button type="button" class="btn btn-theme btn-theme-transparent pull-right" style="border-color:transparent;margin-top: -10px;margin-right: -10px;" onclick="$(\'#uploadModal\').modal(\'toggle\');"><b style="font-size: 16px;">&#8683;</b><b class="hidden-xs"> &nbsp;'.$langu['import_from_file'].'</b></button>';
                        } else {
                            $importFromFileButton = '<button type="button" class="btn btn-theme btn-theme-transparent pull-right" style="border-color:transparent;margin-top: -10px;margin-right: -10px;opacity: 0;cursor: default;" >-</button>';
                        }

                        echo '<center>
                                <h3 class="container block-title alt" style="background-color: ghostwhite;padding-bottom: 0px;text-align: left;"><i class="fa fa-angle-down"></i>'.$langu['checkout_title_label'].$importFromFileButton.'</h3>
                              </center>';
                    }



                    ?>

                    <div class="container" id="checkoutContainer">
                        <div id="checkoutCartContainer">

                        </div>


                        <form action="#" class="form-delivery">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group selectpicker-wrapper">

                                    </div>
                                 </div>
                                 <div class="col-md-6">

                                </div>

                        </form>


                        <div >
                            <a class="btn btn-theme btn-theme-dark" href="./index.php"><?php echo $langu['home_page_button']?></a>
                            <a class="btn btn-theme btn-theme-transparent" data-toggle="modal" data-target="#clearCartModal" style="margin-left:20px;"><?php echo $langu['clear_cart_button']?></a>
                        </div>
                    </div>
                </section>
                <!-- /PAGE -->

            </div>
            <!-- /CONTENT AREA -->

            <!-- Modal -->
            <div class="modal fade" id="clearCartModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document" style="margin-top:20%">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 style="color:black;" class="modal-title" id="myModalLabel"><?php echo $langu['clear_cart_button'];?></h4>
                        </div>
                        <div class="modal-body">
                            <?php echo$langu['clear_cart_question']; ?>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo $langu['close_label'];?></button>
                            <button type="button" class="btn btn-primary" data-dismiss="modal" onclick="clearCart()"><?php echo $langu['clear_cart_button'];?></button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal -->
            <div class="modal fade" id="loginModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document" style="">
                    <div class="modal-content">
<!--                        <div class="modal-header">-->
<!--                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
<!--                        </div>-->
                        <div class="modal-body">
                            <?php if(!$isB2C){
                                echo ' <h1 class="" style="text-align:center;font-size:40px;font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif; color:black;margin-bottom:20px;">B2B Commerce</h1>';
                            }?>

                            <h3 class="block-title"><span><?php echo "$loginTitle";?></span></h3>
                            <form method="POST" action="./dbaccess/b2b_login.php" id="formLogin" class="form-login">
                                <div class="row">
                                    <input name="sessionID" class="form-control" type="hidden" value="<?php echo $_SESSION['id'];?>">
                                    <input name="anonymousOrder" class="form-control" type="hidden" value="yes">

                                    <div class="col-md-12">
                                        <div class="form-group"><input name="username" id="usernameLogin" class="form-control" type="text" placeholder="<?php echo "$usernameHint";?>"></div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group"><input name="password" id="passwordLogin" class="form-control" type="password" placeholder="<?php echo "$passwordHint";?>"></div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group"> <a href="forgotpassword.php">  Forgot password?</a></div>
                                    </div>
                                    <?php
                                    if($isB2C){
                                        echo '<div class="col-md-6 " align="right">
                                          <button type="button" class="btn btn-theme btn-block " onclick="$(\'#loginModal\').modal(\'toggle\');$(\'#registerModal\').modal(\'toggle\');">'.$registerButton.'</button>
                                      </div>
                                      <div class="col-md-6 ">
                                          <input type="button" class="btn btn-theme btn-block" onclick="rememberMe();" value="'.$loginButton.'"/>
                                      </div>';
                                    } else {
                                        echo '<div class="col-md-6 col-md-offset-3">
                                          <input type="button" class="btn btn-theme btn-block" onclick="rememberMe();" value="'.$loginButton.'"/>
                                      </div>';
                                    }
                                    ?>
                                </div>
                            </form>
                        </div>
<!--                        <div class="modal-footer">-->
<!---->
<!--                        </div>-->
                    </div>
                </div>
            </div>

            <!-- Modal -->
            <div class="modal fade" id="registerModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" style="<?php if($isMobile){echo "overflow-y: scroll !important";}?>">
                <div class="modal-dialog" role="document" style="<?php if($isMobile){echo "width:95%;overflow-y: scroll !important";}else{echo "width:80%";}?>">
                    <div class="modal-content" style="width:100%">

                        <div class="modal-body" style="width:100%;height: 80%;overflow-y: auto;">
                            <div class="row" style="width:100%">
                                <div id="registrationForm">
                                    <?php
                                    global $isMobile;
                                    if($isMobile){
                                        echo "<table style='width:100%'>
                                        <tr>
                                            <td style='padding: 10px;'>
                                                <br><h3 class='block-title'><span>$userInfoTitle</span></h3>
                                               &nbsp;&nbsp;$companyNameTitle
                                                <div class='form-group'><span id='companyNameHint' class='pull-right' style='font-size: 15px;font-weight: bold'></span><input name='companyName' id='companyName' class='form-control' type='text' placeholder='$companyNameTitle'></div>

                                <div class='form-group'>
                                    <table style='width: 100%'>
                                        <tr>
                                            <td>
                                                &nbsp;&nbsp;$firstNameTitle $requiredFieldTitle
                                                <input name='firstName' id='firstName' class='form-control' type='text' placeholder='$firstNameTitle' required>
                                            </td>
                                            <td style='width: 2%;'> </td>
                                            <td>
                                                &nbsp;&nbsp;$lastNameTitle $requiredFieldTitle
                                                <input name='lastName' id='lastName' class='form-control' type='text' placeholder='$lastNameTitle' required>
                                            </td>
                                        </tr>
                                    </table>
                                </div>

                                <div class='form-group'>&nbsp;&nbsp;$phoneTitle $requiredFieldTitle<input name='phone' id='phone' class='form-control' type='number' placeholder='$phoneTitle' required></div>

                                <div class='form-group'>&nbsp;&nbsp;$emailTitle $requiredFieldTitle<span id='emailHint' class='pull-right' style='font-size: 15px;font-weight: bold'></span><input name='email' id='email' class='form-control' type='email' placeholder='$emailTitle' required></div>
                                </td>
                                </tr>
                                <tr>
                                <td style='padding: 10px;'>
                                    <br><h3 class='block-title'><span>$userAddressTitle</span></h3>

                                    <div class='form-group'>
                                        &nbsp;&nbsp;$countryTitle
                                        <select name='country' id='country' class='form-control' required>
                                            <option selected>Cyprus</option>
                                        </select>
                                    </div>

                                    <div class='form-group'>
                                        <table style='width: 100%'>
                                            <tr>
                                                <td style='width: 49%;'>
                                                    &nbsp;&nbsp;$cityTitle $requiredFieldTitle
                                                    ";
                                        if(strcmp($customDeliveryTimeslots,'city') == 0) {
                                            echo "<select name='city' id='city' class='form-control' required>";
                                            echo "<option selected disabled value=''>Select City</option>";
                                            $stm = $db->prepare("SELECT zip_code_region FROM ZZ_Zip_Codes WHERE NOT zip_code_region LIKE 'all' ORDER BY zip_code_region ASC");
                                            $stm-> execute();
                                            $stm-> bind_result($cityOption);
                                            while ($stm->fetch()) {
                                                echo "<option value='$cityOption'>$cityOption</option>";
                                            }
                                            $stm-> close();
                                        } else {
                                            echo "<input name='city' id='city' class='form-control' type='text' placeholder='$cityTitle' required>";
                                        }

                                        echo "  </td>
                                                <td style='width: 2%'></td>
                                                <td>
                                                   &nbsp;&nbsp;$areaTitle
                                                    <input name='area' id='area' class='form-control' type='text' placeholder='$areaTitle'>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>

                                    <div class='form-group'>&nbsp;&nbsp;$streetTitle $requiredFieldTitle<input name='streetAddress' id='streetAddress' class='form-control' type='text' placeholder='$streetTitle' required></div>

                                    <div class='form-group'>&nbsp;&nbsp;$postCodeTitle $requiredFieldTitle<input name='postcode' id='postcode' class='form-control' type='number' placeholder='$postCodeTitle' required></div>
                                </td>
                                </tr>
                                <tr>
                                    <td colspan='2' style='padding: 10px;'>
                                        <br><h3 class='block-title'><span>$userPasswordTitle</span></h3>

                                        <div class='form-group'>&nbsp;&nbsp;$enterPassTitle $requiredFieldTitle<span id='passHint' class='pull-right' style='font-size: 15px;font-weight: bold'></span><input name='password' id='password' class='form-control' type='password' placeholder='$enterPassTitle' required></div>

                                        <div class='form-group'>&nbsp;&nbsp;$confirmPassTitle $requiredFieldTitle<input name='passwordConfirmation' id='passwordConfirmation' class='form-control' type='password' placeholder='$confirmPassTitle' required></div>
                                    </td>
                                </tr>
                                </table>
                                <center><span id='postcodeNotDeliverableNewAccount' class='form-control' style='margin-left:5px;border-color:firebrick;display:none;'><i class='fa fa-asterisk' style='color: fireBrick;font-size: 14px;'>&nbsp;<b>".$langu['not_delivering_in_area']."</b></i></span></center>
                                <input type='hidden' id='postcodeNotDeliverableInputNewAccount' value='1'><div id='validateRegistrationButtonNewAccount'>";
                                    } else {
                                        echo "<table style='width:100%'>
                                        <tr>
                                            <td style='padding: 10px;'>
                                                <br><h3 class='block-title'><span>$userInfoTitle</span></h3>
                                               &nbsp;&nbsp;$companyNameTitle
                                                <div class='form-group'><span id='companyNameHint' class='pull-right' style='font-size: 15px;font-weight: bold'></span><input name='companyName' id='companyName' class='form-control' type='text' placeholder='$companyNameTitle'></div>

                                <div class='form-group'>
                                    <table style='width: 100%'>
                                        <tr>
                                            <td>
                                                &nbsp;&nbsp;$firstNameTitle $requiredFieldTitle
                                                <input name='firstName' id='firstName' class='form-control' type='text' placeholder='$firstNameTitle' required>
                                            </td>
                                            <td style='width: 2%;'> </td>
                                            <td>
                                                &nbsp;&nbsp;$lastNameTitle $requiredFieldTitle
                                                <input name='lastName' id='lastName' class='form-control' type='text' placeholder='$lastNameTitle' required>
                                            </td>
                                        </tr>
                                    </table>
                                </div>

                                <div class='form-group'>&nbsp;&nbsp;$phoneTitle $requiredFieldTitle<input name='phone' id='phone' class='form-control' type='number' placeholder='$phoneTitle' required></div>

                                <div class='form-group'>&nbsp;&nbsp;$emailTitle $requiredFieldTitle<span id='emailHint' class='pull-right' style='font-size: 15px;font-weight: bold'></span><input name='email' id='email' class='form-control' type='email' placeholder='$emailTitle' required></div>
                                </td>
                                <td style='padding: 10px;'>
                                    <br><h3 class='block-title'><span>$userAddressTitle</span></h3>

                                    <div class='form-group'>
                                        &nbsp;&nbsp;$countryTitle
                                        <select name='country' id='country' class='form-control' required>
                                            <option selected>Cyprus</option>
                                        </select>
                                    </div>

                                    <div class='form-group'>
                                        <table style='width: 100%'>
                                            <tr>
                                                <td style='width: 49%;'>
                                                    &nbsp;&nbsp;$cityTitle $requiredFieldTitle
                                                    ";
                                        if(strcmp($customDeliveryTimeslots,'city') == 0) {
                                            echo "<select name='city' id='city' class='form-control' required>";
                                            echo "<option selected disabled value=''>Select City</option>";
                                            $stm = $db->prepare("SELECT zip_code_region FROM ZZ_Zip_Codes WHERE NOT zip_code_region LIKE 'all' ORDER BY zip_code_region ASC");
                                            $stm-> execute();
                                            $stm-> bind_result($cityOption);
                                            while ($stm->fetch()) {
                                                echo "<option value='$cityOption'>$cityOption</option>";
                                            }
                                            $stm-> close();
                                        } else {
                                            echo "<input name='city' id='city' class='form-control' type='text' placeholder='$cityTitle' required>";
                                        }

                                        echo "
                                                </td>
                                                <td style='width: 2%'></td>
                                                <td>
                                                   &nbsp;&nbsp;$areaTitle
                                                    <input name='area' id='area' class='form-control' type='text' placeholder='$areaTitle'>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>

                                    <div class='form-group'>&nbsp;&nbsp;$streetTitle $requiredFieldTitle<input name='streetAddress' id='streetAddress' class='form-control' type='text' placeholder='$streetTitle' required></div>

                                    <div class='form-group'>&nbsp;&nbsp;$postCodeTitle $requiredFieldTitle<input name='postcode' id='postcode' class='form-control' type='number' placeholder='$postCodeTitle' required></div>
                                </td>
                                </tr>
                                <tr>
                                    <td colspan='2' style='padding: 10px;'>
                                        <br><h3 class='block-title'><span>$userPasswordTitle</span></h3>

                                        <div class='form-group'>&nbsp;&nbsp;$enterPassTitle $requiredFieldTitle<span id='passHint' class='pull-right' style='font-size: 15px;font-weight: bold'></span><input name='password' id='password' class='form-control' type='password' placeholder='$enterPassTitle' required></div>

                                        <div class='form-group'>&nbsp;&nbsp;$confirmPassTitle $requiredFieldTitle<input name='passwordConfirmation' id='passwordConfirmation' class='form-control' type='password' placeholder='$confirmPassTitle' required></div>
                                    </td>
                                </tr>
                                </table>
                                <center><span id='postcodeNotDeliverableNewAccount' class='form-control' style='margin-left:5px;border-color:firebrick;display:none;'><i class='fa fa-asterisk' style='color: fireBrick;font-size: 14px;'>&nbsp;<b>".$langu['not_delivering_in_area']."</b></i></span></center>
                                <input type='hidden' id='postcodeNotDeliverableInputNewAccount' value='1'><div id='validateRegistrationButtonNewAccount'>
                                ";
                                    }
                                    ?>

                                    <?php
                                    echo '<div class="col-md-4 col-md-offset-4"><center>
                                                    
                                                    <input type="button" class="btn btn-theme btn-block" onclick="validateRegistration()" value="'.$registerButton.'"/>
                                                  </div>';
                                    ?>
                                </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <!-- Modal -->
            <div class="modal fade" id="anonymousCheckoutModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" style="<?php if($isMobile){echo "overflow-y: scroll !important";}?>">
                <div class="modal-dialog" role="document" style="<?php if($isMobile){echo "width:95%;overflow-y: scroll !important";}else{echo "width:80%";}?>">
                    <div class="modal-content" style="width:100%">

                        <div class="modal-body" style="width:100%;height: 80%;overflow-y: auto;">
                            <div class="row" style="width:100%">
                                <div id="anonymousCheckoutForm">
                                    <?php
                                        if($anonymousCheckout || $anonymousQuotation) {
                                            echo "<table style='width:100%'>
                                                        <tr>
                                                            <td style='padding: 10px;'>
                                                                <br><h3 class='block-title'><span>$userInfoTitle</span></h3>
                                                            
                                                                <div class='form-group'>
                                                                    <table style='width: 100%'>
                                                                        <tr>
                                                                            <td colspan='3'>
                                                                                &nbsp;&nbsp;$streetTitle $requiredFieldTitle
                                                                                <input name='streetAddressAnonymous' id='streetAddressAnonymous' class='form-control' type='text' placeholder='$streetTitle' required>
                                                                            </td>
                                                                        </tr>
                                                                    </table>
                                                                </div>
                                
                                                                 <div class='form-group'>
                                                                    <table style='width: 100%'>
                                                                        <tr>
                                                                            <td style='width: 49%;'>
                                                                                &nbsp;&nbsp;$cityTitle $requiredFieldTitle
                                                                                ";
                                                                            if(strcmp($customDeliveryTimeslots,'city') == 0) {
                                                                                echo "<select name='cityAnonymous' id='cityAnonymous' class='form-control' required>";
                                                                                echo "<option selected disabled value=''>Select City</option>";
                                                                                $stm = $db->prepare("SELECT zip_code_region FROM ZZ_Zip_Codes WHERE NOT zip_code_region LIKE 'all' ORDER BY zip_code_region ASC");
                                                                                $stm-> execute();
                                                                                $stm-> bind_result($cityOption);
                                                                                while ($stm->fetch()) {
                                                                                    echo "<option value='$cityOption'>$cityOption</option>";
                                                                                }
                                                                                $stm-> close();
                                                                            } else {
                                                                                echo "<input name='cityAnonymous' id='cityAnonymous' class='form-control' type='text' placeholder='$cityTitle' required>";
                                                                            }

                                                                            echo "
                                                                            </td>
                                                                            <td style='width: 2%;'> </td>
                                                                            <td>
                                                                                &nbsp;&nbsp;$postCodeTitle $requiredFieldTitle
                                                                                <input name='postcodeAnonymous' id='postcodeAnonymous' class='form-control' type='number' placeholder='$postCodeTitle' required>
                                                                            </td>
                                                                        </tr>
                                                                    </table>
                                                                 </div>
                                                           
                                                                <div class='form-group'>
                                                                    <table style='width: 100%'>
                                                                        <tr>
                                                                            <td>
                                                                                &nbsp;&nbsp;$firstNameTitle $requiredFieldTitle
                                                                                <input name='firstNameAnonymous' id='firstNameAnonymous' class='form-control' type='text' placeholder='$firstNameTitle' required>
                                                                            </td>
                                                                            <td style='width: 2%;'> </td>
                                                                            <td>
                                                                                &nbsp;&nbsp;$lastNameTitle $requiredFieldTitle
                                                                                <input name='lastNameAnonymous' id='lastNameAnonymous' class='form-control' type='text' placeholder='$lastNameTitle' required>
                                                                            </td>
                                                                        </tr>
                                                                    </table>
                                                                </div>
                                                                
                                                                <div class='form-group'>
                                                                    <table style='width: 100%'>
                                                                        <tr>
                                                                            <td>
                                                                                &nbsp;&nbsp;$phoneTitle $requiredFieldTitle
                                                                                <input name='phoneAnonymous' id='phoneAnonymous' class='form-control' type='number' placeholder='$phoneTitle' required>
                                                                            </td>
                                                                            <td style='width: 2%;'> </td>
                                                                            <td>
                                                                                &nbsp;&nbsp;$emailTitle $requiredFieldTitle
                                                                                <input name='emailAnonymous' id='emailAnonymous' class='form-control' type='email' placeholder='$emailTitle' required>
                                                                            </td>
                                                                        </tr>
                                                                    </table>
                                                                </div>
              
                                                            </td>
                                                        </tr>          
                                                   </table>
                                                   <center><span id='postcodeNotDeliverableAnonymous' class='form-control' style='margin-left:5px;border-color:firebrick;display:none;'><i class='fa fa-asterisk' style='color: fireBrick;font-size: 14px;'>&nbsp;<b>".$langu['not_delivering_in_area']."</b></i></span></center>
                                                    <input type='hidden' id='postcodeNotDeliverableInputAnonymous' value='1'><div id='validateRegistrationButtonAnonymous'>
                                            ";
                                            if($isB2C){
                                                echo '<div class="col-md-4 ">
                                                          <input type="submit" class="btn btn-theme btn-block" onclick="$(\'#anonymousCheckoutModal\').modal(\'toggle\');$(\'#loginModal\').modal(\'toggle\');" value="'.$loginButton.'"/>
                                                      </div>
                                                      <div class="col-md-4 ">
                                                          <button type="button" class="btn btn-theme btn-block " onclick="$(\'#anonymousCheckoutModal\').modal(\'toggle\');$(\'#registerModal\').modal(\'toggle\');">'.$registerButton.'</button>
                                                      </div>
                                                      <div class="col-md-4" >
                                                          <input type="button" class="btn btn-theme btn-block" onclick="placeOrderAnonymous()" id="placeAnonymousOrderButton" value="' . $langu['proceed_with_order_label'] . '"/>
                                                          <input type="button" class="btn btn-theme btn-tender btn-block pull-right" onclick="placeQuotationAnonymous()" id="placeAnonymousQuotationButton" value="' . $langu['request_quotation_button'] . '"/>
                                                      </div>';
                                            }else{
                                                echo '<div class="col-md-6 ">
                                                          <input type="submit" class="btn btn-theme btn-block" href="#" value="'.$loginButton.'"/>
                                                      </div>';
                                                echo "<div class='col-md-6' >
                                                          <input type='button' class='btn btn-theme btn-block' onclick='placeOrderAnonymous()' id='placeAnonymousOrderButton'  value='" . $langu['proceed_with_order_label'] . "'/>
                                                          <input type='button' class='btn btn-theme btn-tender btn-block pull-right' onclick='placeQuotationAnonymous()' id='placeAnonymousQuotationButton' value='" . $langu['request_quotation_button'] . "'/>
                                                      </div>";
                                                }
                                            echo "</div>";
                                        }
                                    ?>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <!-- Modal -->
            <div class="modal fade" id="uploadModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                            <h4 class="modal-title" style="margin-left:10px;"><i class="fa fa-upload"></i><strong style="padding-left:5px;">&nbsp; <?php echo $langu['import_from_file']?></strong></h4>
                        </div>

                        <div class="modal-body" style="margin-top:5px;padding-top:5px;">
                            <form method="post" action="dbaccess/insertOrderFromFile.php" id="uploadExcelForm" enctype="multipart/form-data">
                                <input type="file" id="uploadExcel" name="uploadExcel" class="btn btn-theme-transparent btn-block" onchange="selectExcelFile(this);" accept=".csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel"  style="display: none;"/>
                            </form>
                            <table style="width: 100%;">
                                <tr>
                                    <td style="width: 95%;"><span id="excel-file-name" class="form-control" style="height: 44px;"></span></td>
                                    <td style="width: 5%;"><button type="button" class="btn btn-theme btn-theme-transparent" onclick="$('#uploadExcel').trigger('click');"><?php echo $langu['select_file']?></button></td>
                                </tr>
                            </table>
                        </div>

                        <footer class="modal-footer" >
                            <form method="get" action="excels/orderSample.xlsx">
                                <button type="submit" class="btn btn-theme btn-theme-dark pull-left" style="font-size: 13px;padding: 7px 10px;"><i class="fa fa-download"></i> &nbsp;<?php echo $langu['download_template'] ?></button>
                            </form>
<!--                            <button onclick="$('#uploadModal').modal('toggle');" class="btn btn-theme btn-theme-transparent pull-left" type="button" style="margin-right:10px;">Cancel</button>-->
                            <button id="saveButton" onclick="importOrderFromFile();" class="btn btn-theme" style="font-size: 13px;padding: 7px 10px;"><i class="fa fa-upload"></i>&nbsp; <?php echo $langu['upload_file'] ?></button>
                        </footer>
                    </div><!-- /.modal-content -->
                </div><!-- /.modal-dialog -->
            </div><!-- /.modal -->


            <!-- Modal -->
            <div class="modal fade" id="uploadedItemsFromFileModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                            <h4 class="modal-title" style="margin-left:10px;"><i class="fa fa-upload"></i><strong style="padding-left:5px;">&nbsp; <?php echo $langu['import_from_file']?></strong></h4>
                        </div>

                        <div class="modal-body" style="margin-top:5px;padding-top:5px;">
                            <?php

                            $jsonItems = json_decode($json);

                            echo "<center><table class='table table-bordered'>";
                            echo "<tr><td style='width: 50%'>".$langu['imported_label'].": </td><td><b><center> $processed </td></tr>";
                            if(isset($jsonItems) && count($jsonItems) > 0) {
                                echo "<tr><td style='width: 50%'>" . $langu['not_imported_label'] . ": </td><td><b><center> $nonProcessed </td></tr>";
                                echo "<tr><td colspan='2'><center><b>" . $langu['not_imported_codes_label'] . "</center></td></tr>";
                                foreach ($jsonItems as $notPostedItem) {
                                    echo "<tr><td >$notPostedItem</td><td><b>" . $langu['product_not_found_label'] . "</td></tr>";
                                }
                            }
                            echo "</table></center>";


                            ?>
                        </div>

                        <footer class="modal-footer" >
                            <button onclick="$('#uploadedItemsFromFileModal').modal('toggle');" class="btn btn-theme btn-theme-transparent pull-left" type="button" style="margin-right:10px;">Close</button>
                        </footer>
                    </div><!-- /.modal-content -->
                </div><!-- /.modal-dialog -->
            </div><!-- /.modal -->


            <!-- Modal -->
            <div class="modal fade" id="pendingOrderModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                            <h3 class="modal-title" style="margin-left:10px;"><i class="fa fa-exclamation"></i><strong style="padding-left:5px;">&nbsp; <?php echo $langu['payment_pending_order']." ".$pendingOrderCode?></strong></h3>
                        </div>

                        <div class="modal-body" style="margin-top:5px;padding-top:5px;">
                            <p>
                            </p>
                            <center>
                            <form method="POST" action="viewsingleorder.php" id="viewSingleOrderForm" >
                                <input type="hidden" id="orderID" name="orderID" value="<?php echo $pendingOrderID?>" >
                                <input type="submit" class="btn btn-theme" value="<?php echo $langu['go_to_order']?>" style="margin-bottom: 15px;">
                                <br>
                                <input type="button" class="btn btn-theme btn-theme-transparent" onclick="$('#pendingOrderModal').modal('toggle');" value="<?php echo $langu['go_to_current_order']?>"  style="margin-bottom: 15px;">

                            </form>
                            </center>
                        </div>

                        <footer class="modal-footer" >

                        </footer>
                    </div><!-- /.modal-content -->
                </div><!-- /.modal-dialog -->
            </div><!-- /.modal -->

            <!-- FOOTER -->
            <?php
            if(strcmp($footerLabel,'')==0){$footerLabel = 'Powered by Coprime - 25311504';}
            if(strcmp($topmenu,"topMenuCheckout2.php")==0 || strcmp($topmenu,"topMenuCheckout3.php")==0 ) {
                echo '<footer class="footer" style="border: 0px;" >
                            <div class="footer-meta footer-custom" style="background: linear-gradient(to bottom, white  0%, whitesmoke 5%, '.$themeColor.' 15%);border: 0px;">
                                <div class="container" style="width: 100%" >
                                    <div class="row" >
            
                                        <div class="col-sm-6 footer-copyright-outer" >
                                            <div class="copyright footer-copyright-text" style="color: '.$textColor.';border-color: transparent">
                                                 '.$footerLabel.'
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </footer>';
            } else {
                echo '<footer class="footer">
                            <div class="footer-meta footer-custom">
                                <div class="container">
                                    <div class="row">
            
                                        <div class="col-sm-6 footer-copyright-outer" >
                                            <div class="copyright footer-copyright-text" >
                                                '.$footerLabel.'
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </footer>';
            }
            ?>

            <div id="to-top" class="to-top"><i class="fa fa-angle-up"></i></div>

        </div>
        <!-- /WRAPPER -->

        <!-- JS Global -->
        <script src="assets/plugins/jquery/jquery-1.11.1.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
        <script src="assets/plugins/bootstrap-select/js/bootstrap-select.min.js"></script>
        <script src="assets/plugins/superfish/js/superfish.min.js"></script>
        <script src="assets/plugins/prettyphoto/js/jquery.prettyPhoto.js"></script>
        <script src="assets/plugins/jquery.sticky.min.js"></script>
        <script src="assets/plugins/jquery.easing.min.js"></script>
        <script src="assets/plugins/jquery.smoothscroll.min.js"></script>
        <script src="assets/plugins/smooth-scrollbar.min.js"></script>

        <script src="assets/js/jquery.tabletojson.js"></script>
        <script src="assets/js/jquery-scrolltofixed-min.js"></script>

        <!-- JS Page Level -->
        <script src="assets/js/theme.js"></script>
        <script src="assets/js/watermark.min.js"></script>

        <!--[if (gte IE 9)|!(IE)]><!-->
        <script src="assets/plugins/jquery.cookie.js"></script>
        <!--<![endif]-->

        <script src="assets/js/waitMe.min.js"></script>

        <script src="assets/plugins/jsencrypt/bin/jsencrypt.min.js"></script>


        <script>

            function rememberMe(){
                var encrypt = new JSEncrypt();
                encrypt.setPublicKey('MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDu22a3sQheNF31dOKgWxOD26u8\n' +
                    'yNZDAtiPL1DdsiCYoqBvIoFjuMnTdfjPxjSVxuG110HtQ5jxPdy6IoeKgQYZ3yFF\n' +
                    'NOTbctobZOO/szk6epNjaPU6MPR037wQb6ixB0v6YLJEjupHs/yxNx3JYmUl+9n5\n' +
                    'rWW7W8jwX/fFXk6VaQIDAQAB');
                var pagingData = encrypt.encrypt($('input[name="password"]').val());
                var pageIndex = encrypt.encrypt($('input[name="username"]').val());
                document.cookie = "pageIndex="+pageIndex;
                document.cookie = "pagingData="+pagingData;
                $('#formLogin').submit();
            }

            jQuery(document).ready(function () {


                initThemeParameters();
                refreshCartInCheckout();
                <?php echo $triggerOrder; ?>
                <?php echo $triggerUploadedItemsFromFileModal; ?>

                <?php
                if($hasPendingOrders){
                    echo "$('#pendingOrderModal').modal('toggle');";
                }
                ?>


                $('#cityAnonymous').on('change',function () {
                    customTimeslotDeliveryValidationAnonymous();
                });

                $('#postcodeAnonymous').on('change',function () {
                    customTimeslotDeliveryValidationAnonymous();
                });

                $('#city').on('change',function () {
                    customTimeslotDeliveryValidationNewAccount();
                });

                $('#postcode').on('change',function () {
                    customTimeslotDeliveryValidationNewAccount();
                });


            });

            function apiCartCalculation(val){
                if(val == 0){
                    $('#apiCartCalculationTrigger')
                        .removeClass('btn-theme')
                        .addClass('btn-theme-transparent')
                        .prop('disabled',true)
                        .html('<div id="preloader">\n' +
                            '            <div id="preloader-status">\n' +
                            '                <div class="spinner">\n' +
                            '                    <div class="rect1"></div>\n' +
                            '                    <div class="rect2"></div>\n' +
                            '                    <div class="rect3"></div>\n' +
                            '                    <div class="rect4"></div>\n' +
                            '                    <div class="rect5"></div>\n' +
                            '                </div>\n' +
                            '                <div id="preloader-title"></div>\n' +
                            '            </div>\n' +
                            '        </div>');
                    $.ajax({
                        type: "POST",
                        url: "./dbaccess/apiCartCalculation.php",
                        success: function (result) {
                            refreshCartInCheckout('?validated=y&apiprices=y');


                        }
                    });

                }
            }

            function importOrderFromFile(){
                $('#uploadExcelForm').submit();
            }

            function selectExcelFile(target) {
                document.getElementById("excel-file-name").innerHTML = target.files[0].name;
            }

            function contactUsRedirect() {window.location.href = "contact.php";}

            function loginRedirect(){$('#loginModal').modal('toggle');$('#registerModal').modal('toggle');}

            function scrollIntoView(element){

                var offset = $(element).offset();

                offset.left -= 20;
                offset.top -= 80;

                $('html, body').animate({
                    scrollTop: offset.top,
                    scrollLeft: offset.left
                });
            }

            function ValidateEmail(mail) {
                if (/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(mail))
                {
                    return (true)
                }
                return (false)
            }

            function ValidatePassword(pass,passConfirm) {
                if(/^(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{6,20}$/.test(pass))
                {
                    if (pass == passConfirm) {
                        return true;
                    } else {
                        $('#password').css("color", "firebrick");
                        $('#passwordConfirmation').css("color", "firebrick");
                        $('#passHint').css("color", "firebrick").html('<?php echo $passMismatch?>');
                        scrollIntoView('#passHint');
                    }
                }
                else
                {

                    $('#passHint').css("color", "firebrick").html('<?php echo $passRequirementsHint?>');
                    scrollIntoView('#passHint');
                    return false;
                }
            }

            function validateRegistration(){

                $("input").css("border-color", "");
                $('#emailHint').css("color", "").html('');
                $('#passHint').css("color", "").html('');
                $('#companyNameHint').css("color", "").html('');

                var companyName          = $('#companyName').val();
                var email                = $('#email').val();
                var password             = $('#password').val();
                var passwordConfirmation = $('#passwordConfirmation').val();

                var validation           = true;
                var scrolled             = false;

                if(validation) {
                    if (!$('#companyName').val()) {}
                    else {
                        $.ajax({
                            type: "POST",
                            url: './dbaccess/b2c_company_validation.php',
                            data: {'companyName': companyName},
                            success: function (result) {
                                if (result != 0) {
                                    $('#companyName').css("border-color", "firebrick");
                                    $('#companyNameHint').css("color", "firebrick").html('<?php echo $companyExistsHint?>');
                                    scrollIntoView('#companyName');
                                    validation = false;
                                    if (!scrolled) {
                                        scrolled = true;
                                        scrollIntoView('#companyName');
                                    }
                                }
                            }
                        });
                    }
                    if (!$('#firstName').val()) {
                        if (!scrolled) {
                            scrolled = true;
                            scrollIntoView('#firstName');
                        }
                        validation = false;
                        $('#firstName').css("border-color", "firebrick");
                    }
                    if (!$('#lastName').val()) {
                        if (!scrolled) {
                            scrolled = true;
                            scrollIntoView('#lastName');
                        }
                        validation = false;
                        $('#lastName').css("border-color", "firebrick");
                    }
                    if (!$('#phone').val()) {
                        if (!scrolled) {
                            scrolled = true;
                            scrollIntoView('#phone');
                        }
                        validation = false;
                        $('#phone').css("border-color", "firebrick");
                    }
                    if (!$('#email').val()) {
                        if (!scrolled) {
                            scrolled = true;
                            scrollIntoView('#email');
                        }
                        validation = false;
                        $('#email').css("border-color", "firebrick");
                    }
                    if (!$('#country').val()) {
                        if (!scrolled) {
                            scrolled = true;
                            scrollIntoView('#country');
                        }
                        validation = false;
                        $('#country').css("border-color", "firebrick");
                    }
                    if (!$('#city').val()) {
                        if (!scrolled) {
                            scrolled = true;
                            scrollIntoView('#city');
                        }
                        validation = false;
                        $('#city').css("border-color", "firebrick");
                    }
                    if (!$('#streetAddress').val()) {
                        if (!scrolled) {
                            scrolled = true;
                            scrollIntoView('#streetAddress');
                        }
                        validation = false;
                        $('#streetAddress').css("border-color", "firebrick");
                    }
                    if (!$('#postcode').val()) {
                        if (!scrolled) {
                            scrolled = true;
                            scrollIntoView('#postcode');
                        }
                        validation = false;
                        $('#postcode').css("border-color", "firebrick");
                    }
                    if (!$('#password').val()) {
                        if (!scrolled) {
                            scrolled = true;
                            scrollIntoView('#password');
                        }
                        validation = false;
                        $('#password').css("border-color", "firebrick");
                    }
                    if (!$('#passwordConfirmation').val()) {
                        if (!scrolled) {
                            scrolled = true;
                            scrollIntoView('#passwordConfirmation');
                        }
                        validation = false;
                        $('#passwordConfirmation').css("border-color", "firebrick");
                    }
                }

                if(validation){
                    if(ValidateEmail(email)) {
                        validation = false;
                        $.ajax({
                            type: "POST",
                            url: './dbaccess/b2c_email_validation.php',
                            data: {'email': email},
                            success: function (result) {
                                if(result == 0){

                                    registerUser(ValidatePassword(password,passwordConfirmation));

                                } else {
                                    $('#email').css("border-color", "firebrick");
                                    $('#emailHint').css("color", "firebrick").html('<?php echo $emailExistsHint?>');
                                    scrollIntoView('#email');

                                }
                            }
                        });
                    } else {
                        $('#email').css("border-color", "firebrick");
                        $('#emailHint').css("color", "firebrick").html('<?php echo $invalidEmailHint?>');
                        scrollIntoView('#email');
                        validation = false;
                    }
                }


            }

            function registerUser(validation){
                if(validation){
                    var companyName          = $('#companyName').val();
                    var firstName            = $('#firstName').val();
                    var lastName             = $('#lastName').val();
                    var phone                = $('#phone').val();
                    var email                = $('#email').val();
                    var country              = $('#country').val();
                    var city                 = $('#city').val();
                    var area                 = $('#area').val();
                    var streetAddress        = $('#streetAddress').val();
                    var postcode             = $('#postcode').val();
                    var password             = $('#password').val();
                    var register             = true;

                    $.ajax({
                        type: "POST",
                        url: './dbaccess/b2c_register.php',
                        data: {
                            'companyName': companyName,
                            'firstName': firstName,
                            'lastName': lastName,
                            'phone': phone,
                            'email': email,
                            'country': country,
                            'city': city,
                            'area': area,
                            'streetAddress': streetAddress,
                            'postcode': postcode,
                            'register': register,
                            'password': password
                        },
                        success: function (result) {
                            if(result == 1){
                                $('#registrationForm').html("<?php echo $activeBox ?>");
                                $('#usernameLogin').val(email);
                                $('#passwordLogin').val(password);
                            } else if(result == 2) {
                                $('#registrationForm').html("<?php echo $confirmationBox ?>");
                            } else if(result == 404) {
                                alert('Something went Wrong..Please try again');
                            } else {
                                $('#registrationForm').html("<?php echo $contactBox ?>");
                            }
                            scrollIntoView('#registrationForm');
                        }
                    });
                }
            }

            function anonymousQuotationModal(val){

                if(val == 0 ) {
                    $('#placeAnonymousQuotationButton').hide();
                    $('#placeAnonymousOrderButton').show();
                } else {
                    $('#placeAnonymousQuotationButton').show();
                    $('#placeAnonymousOrderButton').hide();
                }
            }

            function quotationModal(val){

                if(val == 0 ) {
                    $('#checkoutModalTitle').html('<?php echo $langu['proceed_with_order_label'];?>');
                    $('#requestQuotationButton').hide();

                    $('#paymentMethod').show();
                    $('#paymentMethodLabel').show();
                    $('#paymentMethodLogo').show();
                    $('#deliveryAddressDiv').show();
                    $('#deliveryDateDiv').show();
                    $('#warningLabel').show();

                    $('#confirmTenderLabel').hide();

                    var iscredit = $('#paymentMethod :selected').data('iscredit');
                    if(!iscredit || iscredit.localeCompare('yes') === 0){
                        $('#placeOrderButton').show();
                        $('#placeSplitOrderButton').show();
                        $('#payOrderButton').hide();
                        $('#paySplitOrderButton').hide();
                    } else {
                        $('#placeOrderButton').hide();
                        $('#placeSplitOrderButton').hide();
                        $('#payOrderButton').show();
                        $('#paySplitOrderButton').show();
                    }
                } else {
                    $('#checkoutModalTitle').html('<?php echo $langu['request_quotation_button'];?>');
                    $('#requestQuotationButton').show();

                    var anonymousCheckoutUserInfo = $('#anonymousCheckoutUserInfo').val();
                    if(anonymousCheckoutUserInfo) {
                        anonymousCheckoutUserInfo = anonymousCheckoutUserInfo.replaceAll('Customer:', '</td><td style="text-align: left;width: 10% !important;"><b>Customer:</b></td><td>')
                        anonymousCheckoutUserInfo = anonymousCheckoutUserInfo.replaceAll('Address:', '</td><tr/><tr><td style="text-align: left;width: 10% !important;"><b>Address:</b></td><td>')
                        anonymousCheckoutUserInfo = anonymousCheckoutUserInfo.replaceAll('Phone:', '</td><tr/><tr><td style="text-align: left;width: 10% !important;"><b>Phone:</b></td><td>')
                        anonymousCheckoutUserInfo = anonymousCheckoutUserInfo.replaceAll('Email:', '</td><tr/><tr><td style="text-align: left;width: 10% !important;"><b>Email:</b></td><td>')
                        $('#anonymousCustomerInfoSpan').html('<table><tr>' + anonymousCheckoutUserInfo + '</tr><table>').show();
                    }
                    $('#paymentMethod').hide();
                    $('#paymentMethodLabel').hide();
                    $('#paymentMethodLogo').hide();

                    $('#placeOrderButton').hide();
                    $('#placeSplitOrderButton').hide();
                    $('#payOrderButton').hide();
                    $('#paySplitOrderButton').hide();
                    $('#deliveryAddressDiv').hide();
                    $('#deliveryDateDiv').hide();
                    $('#warningLabel').hide();

                    $('#confirmTenderLabel').show();

                }
            }

            function addCoupon(){
                var coupon = $('#couponBox').val();
                if(coupon.localeCompare('')!=0){

                    $.ajax({
                        type: "POST",
                        url: "./dbaccess/getPromotionFromCoupon.php",
                        data: {coupon: coupon},
                        success: function (result) {
                            if(result == 0) {
                                $('#couponBox').css('border-color','firebrick').css('color','firebrick').val('Invalid Coupon');
                                setTimeout(function(){$('#couponBox').css('border-color', '').css('color','').val(''); }, 1000);
                            } else {
                                $('#couponBox').css('border-color','green').css('color','green');
                                refreshCartInCheckout();
                            }

                        }
                    });

                }
            }

            function checkDate(first){
                var curDate = new Date($('.deliveryDate').val());
                var day = curDate.getDay();

                <?php


                if(strcmp($deliveryOnWeekend,'no')==0){
                    echo " if(day === 6){
                               curDate.setDate(curDate.getDate() + 2);
                               if(!first){
                                 $('#deliveryDateChanged').show();
                               }
                           } else if(day === 0){
                               curDate.setDate(curDate.getDate() + 1);
                               if(!first){
                                 $('#deliveryDateChanged').show();
                               }
                           } else {
                             $('#deliveryDateChanged').hide();
                           }";
                } else if(strcmp($deliveryOnWeekend,'saturday')==0){
                    echo "if(day === 0){
                            curDate.setDate(curDate.getDate() + 1);
                            if(!first){
                              $('#deliveryDateChanged').show();
                            }
                          } else {
                            $('#deliveryDateChanged').hide();
                          }";
                } else if(strcmp($deliveryOnWeekend,'sunday')==0){
                    echo "if(day === 6){
                            curDate.setDate(curDate.getDate() + 1);
                            if(!first){
                              $('#deliveryDateChanged').show();
                            }
                          } else {
                            $('#deliveryDateChanged').hide();
                          }";
                } else {
                    echo " $('#deliveryDateChanged').hide();";
                }

                if(true){
                    $linkedSchedules = 'no';
                    if(strcmp($linkSchedulesToB2B,'yes')==0){$linkedSchedules = 'yes';}
                    echo "  var pdd = curDate.getDate();
                            var pmm = curDate.getMonth() + 1; //January is 0!
                            var pyyyy = curDate.getFullYear();
                            if (pdd < 10) {pdd = '0' + pdd;}
                            if (pmm < 10) {pmm = '0' + pmm;}
                            var postDate = pyyyy + '-' + pmm + '-' + pdd;
                            $('.deliveryDate').val(postDate);
                            $.ajax({
                                type:'POST',
                                url: './dbaccess/getNextScheduledDateForDelivery.php',
                                data:{'postDate':postDate,'linkedSchedules':'$linkedSchedules'},
                                success:function(result){

                                    if(result > 0){
                                        curDate.setDate(curDate.getDate() + +result);
                                        var dd = curDate.getDate();
                                        var mm = curDate.getMonth() + 1; //January is 0!
                                        var yyyy = curDate.getFullYear();
                                        if (dd < 10) {dd = '0' + dd;}
                                        if (mm < 10) {mm = '0' + mm;}
                                        var newDate = yyyy + '-' + mm + '-' + dd;
                                        $('.deliveryDate').val(newDate);
                                        if(!first){
                                            $('#deliveryDateChanged').show();
                                        }
                                    } else {
                                        $('#deliveryDateChanged').hide();
                                    }
                                }
                            });";
                }
//                else
//                {
//                    echo "  var dd = curDate.getDate();
//                            var mm = curDate.getMonth() + 1; //January is 0!
//                            var yyyy = curDate.getFullYear();
//                            if (dd < 10) {dd = '0' + dd;}
//                            if (mm < 10) {mm = '0' + mm;}
//                            var newDate = yyyy + '-' + mm + '-' + dd;
//                            $('.deliveryDate').val(newDate);";
//                }

                ?>





            }

            function placeOrder()
            {

                $.ajax({
                    type: 'POST',
                    url: './dbaccess/checkLoginState.php',
                    <?php if($anonymousCheckout){echo "data:{'anonymous':'yes'},\n";}else{echo '';} ?>
                    success: function (loginState) {

                        $('#checkoutModal').modal('hide');

                        var isCredit = $('#paymentMethod option:selected').data('iscredit');

                        var numItems = $('.itemRow').size();
                        if(loginState >= 1) {
                            if (numItems > 0) {
                                var anonymousCheckout = <?php if($anonymousCheckout){echo "true;\n";}else{echo "false;\n";} ?>
                                var subtotal = $('#subtotal').text();
                                var vatAmount = $('#vatAmount').text();
                                var grandTotal = $('#grandTotal').text();
                                var discountTotal = $('#discountTotal').text();
                                var address = $('#address').val();
                                var billAddress = $('#billAddress').val();
                                var details = $('#details').val();
                                var deliveryTotal = $('#deliveryTotal').text();
                                var deliveryDate = $('#deliveryDate').val();
                                var deliveryFeeItem = $('#deliveryMethod').val();
                                var weightFeeItem = $('#weightFeeItem').val();
                                var weightFeeItemQty = $('#weightFeeItemQty').val();
                                var deliveryMethod = $('#deliveryMethod option:selected').text();
                                var anonymousCheckoutUserInfo = $('#anonymousCheckoutUserInfo').val();

                                if (subtotal) {subtotal = subtotal.toString().replaceAll(',', '');}
                                if (vatAmount) {vatAmount = vatAmount.toString().replaceAll(',', '');}
                                if (grandTotal) {grandTotal = grandTotal.toString().replaceAll(',', '');}
                                if (discountTotal) {discountTotal = discountTotal.toString().replaceAll(',', '');}
                                if (deliveryTotal) {deliveryTotal = deliveryTotal.toString().replaceAll(',', '');}

                                var paymentMethodText = $('#paymentMethod option:selected').text();
                                var paymentMethodID = $('#paymentMethod option:selected').val();
                                if(paymentMethodText.localeCompare('')!==0){
                                    details = $('#details').val() + ' \nPayment Method:' + $('#paymentMethod option:selected').text();;
                                }
                                if(anonymousCheckoutUserInfo.localeCompare('')!==0){
                                    details = details + ' ' + anonymousCheckoutUserInfo;
                                }

                                var timeSlotsText = $('#timeSlots option:selected').text();
                                var timeSlotsFrom = '';
                                var timeSlotsTo = '';
                                if(timeSlotsText.localeCompare('')!==0){
                                    details = details + ' \nTime Slot: ' + $('#timeSlots option:selected').text();
                                    timeSlotsFrom = $('#timeSlots option:selected').data('from');
                                    timeSlotsTo = $('#timeSlots option:selected').data('to');
                                }

                                var onlineOrderItems = $('#onlineOrderItemsTable').tableToJSON(
                                    {
                                        ignoreColumns: [0],
                                        textExtractor: {
                                            0: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            1: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            2: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            3: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            4: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            5: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            6: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            }
                                        },
                                        ignoreHiddenRows: false,
                                        ignoreEmptyRows: false
                                    }
                                );

                                $.ajax({
                                    type: "POST",
                                    url: "./dbaccess/placeOrder.php",
                                    data: {
                                        anonymousCheckout: anonymousCheckout,
                                        <?php if($anonymousCheckout){echo "anonymousCheckoutCustomer: $anonymousCheckoutCustomerID,\n";}?>
                                        subtotal: subtotal,
                                        vatAmount: vatAmount,
                                        grandTotal: grandTotal,
                                        discountTotal: discountTotal,
                                        address: address,
                                        billAddress: billAddress,
                                        details: details,
                                        deliveryTotal: deliveryTotal,
                                        deliveryDate: deliveryDate,
                                        deliveryFeeItem: deliveryFeeItem,
                                        weightFeeItem: weightFeeItem,
                                        weightFeeItemQty: weightFeeItemQty,
                                        deliveryMethod: deliveryMethod,
                                        isCredit: isCredit,
                                        timeSlotsFrom: timeSlotsFrom,
                                        timeSlotsTo: timeSlotsTo,
                                        paymentMethodID: paymentMethodID,
                                        onlineOrderItems: onlineOrderItems
                                    },
                                    success: function (result) {
                                        window.scrollTo(0, 0);
                                        // alert(isCredit.localeCompare('no'));
                                        if (typeof isCredit === 'undefined' || isCredit === null) {
                                            var creditOrder = true;
                                        } else {
                                            if (isCredit.localeCompare('no') == 0) {
                                                var creditOrder = false;
                                            } else {
                                                var creditOrder = true;
                                            }
                                        }
                                        if (result == 0) {
                                            var alert = '<center><h2>Oops! Something went wrong..</h2><h3>Please reload the page and try Again.</h3></center>';
                                            $('#checkoutContainer').empty();
                                            $('#checkoutContainer').append(alert);
                                            setTimeout(function () {location.reload();}, 3000);
                                        } else {
                                            if (creditOrder) {

                                                $('#checkoutContainer').empty();
                                                $('#checkoutContainer').append(result);
                                                // var ID = $('#orderIDEmail').val();
                                                // var action = "ORDER";

                                                // $.ajax({
                                                //     type: "POST",
                                                //     url: '../backend/b2bAdmin/sendTemplateEmail.php',
                                                //     data: {
                                                //         'ID': ID,
                                                //         'action': action
                                                //
                                                //     },
                                                //     success: function (result) {
                                                //         // alert(result);
                                                //     }
                                                // });
                                            } else {

                                                switch ($('#paymentMethod option:selected').data('method')) {
                                                    case 'JCC':
                                                        $('#JCCOrderID').val(result);

                                                        var PurchaseAmt = $('#JCCPurchaseAmt').val();
                                                        var JCCorderID = result;

                                                        $.ajax({
                                                            type: 'POST',
                                                            url: './dbaccess/getEncriptedSignatureJCC.php',
                                                            data: {
                                                                'PurchaseAmt': PurchaseAmt,
                                                                'JCCorderID': JCCorderID

                                                            },
                                                            success: function (result) {

                                                                $('#JCCSignature').val(result);
                                                                document.forms["paymentFormJCC"].submit();

                                                                $('#checkoutContainer').empty();
                                                                $('#checkoutContainer').append('<div id=\"preloader\"><div id=\"preloader-status\"><div class=\"spinner\"><div class=\"rect1\"></div><div class=\"rect2\"></div><div class=\"rect3\"></div><div class=\"rect4\"></div><div class=\"rect5\"></div></div><div id=\"preloader-title\">Loading</div></div>');

                                                            }
                                                        });
                                                        break;
                                                    case 'VIVA':
                                                        window.location.href="./dbaccess/createPaymentOrderVIVA.php?oid="+result
                                                        break;
                                                    case 'PAYPAL':
                                                        window.location.href="./payPaypalOrder.php?p=0&oid="+result
                                                        break;
                                                    case 'STRIPE':
                                                        window.location.href="./stripe/stripeCheckout.php?p=0&oid="+result
                                                        break;
                                                    case 'SIX':
                                                        window.location.href="./dbaccess/createPaymentOrderSIX.php?oid="+result
                                                        break;
                                                    case 'JCC_V2': //allagh
                                                        var sc  = $('#scJccV2').val();
                                                        var pwb = $('#pwbJssV2').val();
                                                        var mp  = $('#mpJssV2').val();
                                                        // console.log(sc);
                                                        // console.log(pwb);
                                                        // console.log(mp);
                                                        window.location.href="./dbaccess/createPaymentOrderJCCv2.php?sc="+sc+"&pwb="+pwb+"&mp="+mp+"&oid="+result
                                                        break;
                                                }

                                            }
                                        }
                                    }
                                });
                            }
                        } else {
                            window.location.href='login.php';
                        }
                    }
                });
            }

            function placeOrderWithAttachment()
            {

                $.ajax({
                    type: 'POST',
                    url: './dbaccess/checkLoginState.php',
                    <?php if($anonymousCheckout){echo "data:{'anonymous':'yes'},\n";}else{echo '';} ?>
                    success: function (loginState) {

                        $('#checkoutModal').modal('hide');

                        var isCredit = $('#paymentMethod option:selected').data('iscredit');

                        var numItems = $('.itemRow').size();
                        if(loginState >= 1) {
                            if (numItems > 0) {
                                var anonymousCheckout = <?php if($anonymousCheckout){echo "true;\n";}else{echo "false;\n";} ?>
                                var subtotal = $('#subtotal').text();
                                var vatAmount = $('#vatAmount').text();
                                var grandTotal = $('#grandTotal').text();
                                var discountTotal = $('#discountTotal').text();
                                var address = $('#address').val();
                                var billAddress = $('#billAddress').val();
                                var details = $('#details').val();
                                var deliveryTotal = $('#deliveryTotal').text();
                                var deliveryDate = $('#deliveryDate').val();
                                var deliveryFeeItem = $('#deliveryMethod').val();
                                var weightFeeItem = $('#weightFeeItem').val();
                                var weightFeeItemQty = $('#weightFeeItemQty').val();
                                var deliveryMethod = $('#deliveryMethod option:selected').text();
                                var anonymousCheckoutUserInfo = $('#anonymousCheckoutUserInfo').val();

                                if (subtotal) {subtotal = subtotal.toString().replaceAll(',', '');}
                                if (vatAmount) {vatAmount = vatAmount.toString().replaceAll(',', '');}
                                if (grandTotal) {grandTotal = grandTotal.toString().replaceAll(',', '');}
                                if (discountTotal) {discountTotal = discountTotal.toString().replaceAll(',', '');}
                                if (deliveryTotal) {deliveryTotal = deliveryTotal.toString().replaceAll(',', '');}

                                var paymentMethodText = $('#paymentMethod option:selected').text();
                                var paymentMethodID = $('#paymentMethod option:selected').val();
                                if(paymentMethodText.localeCompare('')!==0){
                                    details = $('#details').val() + ' \nPayment Method:' + $('#paymentMethod option:selected').text();;
                                }
                                if(anonymousCheckoutUserInfo.localeCompare('')!==0){
                                    details = details + ' ' + anonymousCheckoutUserInfo;
                                }

                                var timeSlotsText = $('#timeSlots option:selected').text();
                                var timeSlotsFrom = '';
                                var timeSlotsTo = '';
                                if(timeSlotsText.localeCompare('')!==0){
                                    details = details + ' \nTime Slot: ' + $('#timeSlots option:selected').text();
                                    timeSlotsFrom = $('#timeSlots option:selected').data('from');
                                    timeSlotsTo = $('#timeSlots option:selected').data('to');
                                }

                                var onlineOrderItems = $('#onlineOrderItemsTable').tableToJSON(
                                    {
                                        ignoreColumns: [0],
                                        textExtractor: {
                                            0: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            1: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            2: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            3: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            4: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            5: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            6: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            }
                                        },
                                        ignoreHiddenRows: false,
                                        ignoreEmptyRows: false
                                    }
                                );

                                var formData = new FormData();
                                formData.append('anonymousCheckout', anonymousCheckout);
                                <?php if($anonymousCheckout){echo "formData.append('anonymousCheckoutCustomer', $anonymousCheckoutCustomerID);\n";}?>
                                formData.append('subtotal', subtotal);
                                formData.append('vatAmount', vatAmount);
                                formData.append('grandTotal', grandTotal);
                                formData.append('discountTotal', discountTotal);
                                formData.append('address', address);
                                formData.append('billAddress', billAddress);
                                formData.append('details', details);
                                formData.append('deliveryTotal', deliveryTotal);
                                formData.append('deliveryDate', deliveryDate);
                                formData.append('deliveryFeeItem', deliveryFeeItem);
                                formData.append('weightFeeItem', weightFeeItem);
                                formData.append('weightFeeItemQty', weightFeeItemQty);
                                formData.append('deliveryMethod', deliveryMethod);
                                formData.append('isCredit', isCredit);
                                formData.append('timeSlotsFrom', timeSlotsFrom);
                                formData.append('timeSlotsTo', timeSlotsTo);
                                formData.append('paymentMethodID', paymentMethodID);
                                formData.append('orderAttachment', document.getElementById('orderAttachment').files[0]);
                                formData.append('onlineOrderItems', JSON.stringify(onlineOrderItems));

                                $.ajax({
                                    type: "POST",
                                    url: "./dbaccess/placeOrderWithAttachment.php",
                                    processData: false,
                                    contentType: false,
                                    data: formData,
                                    success: function (result) {
                                        window.scrollTo(0, 0);
                                        if (typeof isCredit === 'undefined' || isCredit === null) {
                                            var creditOrder = true;
                                        } else {
                                            if (isCredit.localeCompare('no') == 0) {
                                                var creditOrder = false;
                                            } else {
                                                var creditOrder = true;
                                            }
                                        }
                                        if (result == 0) {
                                            var alert = '<center><h2>Oops! Something went wrong..</h2><h3>Please reload the page and try Again.</h3></center>';
                                            $('#checkoutContainer').empty();
                                            $('#checkoutContainer').append(alert);
                                            setTimeout(function () {location.reload();}, 3000);
                                        } else {
                                            if (creditOrder) {

                                                $('#checkoutContainer').empty();
                                                $('#checkoutContainer').append(result);

                                            } else {

                                                switch ($('#paymentMethod option:selected').data('method')) {
                                                    case 'JCC':
                                                        $('#JCCOrderID').val(result);

                                                        var PurchaseAmt = $('#JCCPurchaseAmt').val();
                                                        var JCCorderID = result;

                                                        $.ajax({
                                                            type: 'POST',
                                                            url: './dbaccess/getEncriptedSignatureJCC.php',
                                                            data: {
                                                                'PurchaseAmt': PurchaseAmt,
                                                                'JCCorderID': JCCorderID

                                                            },
                                                            success: function (result) {

                                                                $('#JCCSignature').val(result);
                                                                document.forms["paymentFormJCC"].submit();

                                                                $('#checkoutContainer').empty();
                                                                $('#checkoutContainer').append('<div id=\"preloader\"><div id=\"preloader-status\"><div class=\"spinner\"><div class=\"rect1\"></div><div class=\"rect2\"></div><div class=\"rect3\"></div><div class=\"rect4\"></div><div class=\"rect5\"></div></div><div id=\"preloader-title\">Loading</div></div>');

                                                            }
                                                        });
                                                        break;
                                                    case 'VIVA':
                                                        window.location.href="./dbaccess/createPaymentOrderVIVA.php?oid="+result
                                                        break;
                                                    case 'PAYPAL':
                                                        window.location.href="./payPaypalOrder.php?p=0&oid="+result
                                                        break;
                                                    case 'STRIPE':
                                                        window.location.href="./stripe/stripeCheckout.php?p=0&oid="+result
                                                        break;
                                                    case 'SIX':
                                                        window.location.href="./dbaccess/createPaymentOrderSIX.php?oid="+result
                                                        break;
                                                    case 'JCC_V2': //allagh
                                                        var sc  = $('#scJccV2').val();
                                                        var pwb = $('#pwbJssV2').val();
                                                        var mp  = $('#mpJssV2').val();
                                                        // console.log(sc);
                                                        // console.log(pwb);
                                                        // console.log(mp);
                                                        window.location.href="./dbaccess/createPaymentOrderJCCv2.php?sc="+sc+"&pwb="+pwb+"&mp="+mp+"&oid="+result
                                                        break;
                                                }

                                            }
                                        }
                                    }
                                });
                            }
                        } else {
                            window.location.href='login.php';
                        }
                    }
                });
            }

            function placeSplitOrder()
            {

                $.ajax({
                    type: 'POST',
                    url: './dbaccess/checkLoginState.php',
                    <?php if($anonymousCheckout){echo "data:{'anonymous':'yes'},\n";}else{echo '';} ?>
                    success: function (loginState) {

                        $('#checkoutModal').modal('hide');

                        var isCredit = $('#paymentMethod option:selected').data('iscredit');

                        var numItems = $('.itemRow').size();
                        if(loginState >= 1) {
                            if (numItems > 0) {
                                var anonymousCheckout = <?php if($anonymousCheckout){echo "true;\n";}else{echo "false;\n";} ?>
                                var subtotal = $('#subtotal').text();
                                var vatAmount = $('#vatAmount').text();
                                var grandTotal = $('#grandTotal').text();
                                var discountTotal = $('#discountTotal').text();
                                var address = $('#address').val();
                                var billAddress = $('#billAddress').val();
                                var details = $('#details').val();
                                var deliveryTotal = $('#deliveryTotal').text();
                                var deliveryDate = $('#deliveryDate').val();
                                var deliveryFeeItem = $('#deliveryMethod').val();
                                var deliveryMethod = $('#deliveryMethod option:selected').text();
                                var anonymousCheckoutUserInfo = $('#anonymousCheckoutUserInfo').val();

                                if (subtotal) {subtotal = subtotal.toString().replaceAll(',', '');}
                                if (vatAmount) {vatAmount = vatAmount.toString().replaceAll(',', '');}
                                if (grandTotal) {grandTotal = grandTotal.toString().replaceAll(',', '');}
                                if (discountTotal) {discountTotal = discountTotal.toString().replaceAll(',', '');}
                                if (deliveryTotal) {deliveryTotal = deliveryTotal.toString().replaceAll(',', '');}

                                var paymentMethodText = $('#paymentMethod option:selected').text();
                                var paymentMethodID = $('#paymentMethod option:selected').val();
                                if(paymentMethodText.localeCompare('')!==0){
                                    details = $('#details').val() + ' \nPayment Method:' + $('#paymentMethod option:selected').text();;
                                }
                                if(anonymousCheckoutUserInfo.localeCompare('')!==0){
                                    details = details + ' ' + anonymousCheckoutUserInfo;
                                }

                                var timeSlotsText = $('#timeSlots option:selected').text();
                                var timeSlotsFrom = '';
                                var timeSlotsTo = '';
                                if(timeSlotsText.localeCompare('')!==0){
                                    details = details + ' \nTime Slot: ' + $('#timeSlots option:selected').text();
                                    timeSlotsFrom = $('#timeSlots option:selected').data('from');
                                    timeSlotsTo = $('#timeSlots option:selected').data('to');
                                }

                                var onlineOrderItems = $('#onlineOrderItemsTable').tableToJSON(
                                    {
                                        ignoreColumns: [0],
                                        textExtractor: {
                                            0: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            1: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            2: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            3: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            4: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            5: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            6: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            }
                                        },
                                        ignoreHiddenRows: false,
                                        ignoreEmptyRows: false
                                    }
                                );

                                $.ajax({
                                    type: "POST",
                                    url: "./dbaccess/placeSplitOrder.php",
                                    data: {
                                        anonymousCheckout: anonymousCheckout,
                                        <?php if($anonymousCheckout){echo "anonymousCheckoutCustomer: $anonymousCheckoutCustomerID,\n";}?>
                                        subtotal: subtotal,
                                        vatAmount: vatAmount,
                                        grandTotal: grandTotal,
                                        discountTotal: discountTotal,
                                        address: address,
                                        billAddress: billAddress,
                                        details: details,
                                        deliveryTotal: deliveryTotal,
                                        deliveryDate: deliveryDate,
                                        deliveryFeeItem: deliveryFeeItem,
                                        deliveryMethod: deliveryMethod,
                                        isCredit: isCredit,
                                        timeSlotsFrom: timeSlotsFrom,
                                        timeSlotsTo: timeSlotsTo,
                                        paymentMethodID: paymentMethodID,
                                        onlineOrderItems: onlineOrderItems
                                    },
                                    success: function (result) {
                                        window.scrollTo(0, 0);
                                        // alert(isCredit.localeCompare('no'));
                                        if (typeof isCredit === 'undefined' || isCredit === null) {
                                            var creditOrder = true;
                                        } else {
                                            if (isCredit.localeCompare('no') == 0) {
                                                var creditOrder = false;
                                            } else {
                                                var creditOrder = true;
                                            }
                                        }
                                        if (result == 0) {
                                            alert('Something Went Wrong.. Please Try Again.');
                                        } else {
                                            if (creditOrder) {

                                                $('#checkoutContainer').empty();
                                                $('#checkoutContainer').append(result);

                                            } else {

                                                switch ($('#paymentMethod option:selected').data('method')) {
                                                    case 'JCC':
                                                        $('#JCCOrderID').val(result);

                                                        var PurchaseAmt = $('#JCCPurchaseAmt').val();
                                                        var JCCorderID = result;

                                                        $.ajax({
                                                            type: 'POST',
                                                            url: './dbaccess/getEncriptedSignatureJCC.php',
                                                            data: {
                                                                'PurchaseAmt': PurchaseAmt,
                                                                'JCCorderID': JCCorderID

                                                            },
                                                            success: function (result) {

                                                                $('#JCCSignature').val(result);
                                                                document.forms["paymentFormJCC"].submit();
                                                            }
                                                        });
                                                        break;
                                                    case 'VIVA':
                                                        window.location.href="./dbaccess/createPaymentOrderVIVA.php?oid="+result
                                                        break;
                                                    case 'PAYPAL':
                                                        window.location.href="./payPaypalOrder.php?p=0&oid="+result
                                                        break;
                                                    case 'STRIPE':
                                                        window.location.href="./stripe/stripeCheckout.php?p=0&oid="+result
                                                        break;
                                                    case 'SIX':
                                                        window.location.href="./dbaccess/createPaymentOrderSIX.php?oid="+result
                                                        break;
                                                    case 'JCC_V2': //allagh
                                                        var sc  = $('#scJccV2').val();
                                                        var pwb = $('#pwbJssV2').val();
                                                        var mp  = $('#mpJssV2').val();
                                                        // console.log(sc);
                                                        // console.log(pwb);
                                                        // console.log(mp);
                                                        window.location.href="./dbaccess/createPaymentOrderJCCv2.php?sc="+sc+"&pwb="+pwb+"&mp="+mp+"&oid="+result
                                                        // break;
                                                }

                                            }
                                        }
                                    }
                                });
                            }
                        } else {
                            window.location.href='login.php';
                        }
                    }
                });
            }
			
			function placeQuotation()
            {
                $.ajax({
                    type: 'POST',
                    url: './dbaccess/checkLoginState.php',
                    <?php if($anonymousQuotation){echo "data:{'anonymous':'yes'},\n";}else{echo '';} ?>
                    success: function (loginState) {
                        $('#checkoutModal').modal('hide');

                        var numItems = $('.itemRow').size();

                        if(numItems > 0)
                        {
                            var anonymousCheckout = <?php if($anonymousQuotation){echo "true;\n";}else{echo "false;\n";} ?>
                            var subtotal = $('#subtotal').text();
                            var vatAmount = $('#vatAmount').text();
                            var grandTotal = $('#grandTotal').text();
                            var address = $('#address').val();
                            var billAddress = $('#billAddress').val();
                            var details = $('#details').val();
                            var anonymousCheckoutUserInfo = $('#anonymousCheckoutUserInfo').val();

                            if (subtotal) {subtotal = subtotal.toString().replaceAll(',', '');}
                            if (vatAmount) {vatAmount = vatAmount.toString().replaceAll(',', '');}
                            if (grandTotal) {grandTotal = grandTotal.toString().replaceAll(',', '');}


                            if(anonymousCheckoutUserInfo.localeCompare('')!==0){
                                details = details + ' ' + anonymousCheckoutUserInfo;
                            }
                            $.ajax({
                                type: "POST",
                                url: "./dbaccess/placeQuotation.php",
                                data: {<?php if($anonymousQuotation){echo "anonymousCheckoutCustomer: $anonymousCheckoutCustomerID,";}?>anonymousCheckout:anonymousCheckout,subtotal: subtotal,vatAmount: vatAmount,grandTotal: grandTotal,address: address,billAddress: billAddress,details: details},
                                success: function (result) {
                                    window.scrollTo(0, 0);
                                    $('#checkoutContainer').empty();
                                    $('#checkoutContainer').append(result);

                                }
                            });
                        }
                    }
                });
            }

            function clearCart()
            {
                    $.ajax({
                        type: "POST",
                        url: "./dbaccess/clearCart.php",
                        data: {},
                        success: function (result) {

                            refreshCartInCheckout();

                        }
                    });

            }

            function placeQuotationAnonymous(){

                $('#anonymousCheckoutUserInfo').val('');
                var streetAddress = $('#streetAddressAnonymous').val();
                var cityAnonymous = $('#cityAnonymous').val();
                var postcodeAnonymous = $('#postcodeAnonymous').val();
                var firstNameAnonymous = $('#firstNameAnonymous').val();
                var lastNameAnonymous = $('#lastNameAnonymous').val();
                var emailAnonymous = $('#emailAnonymous').val();
                var phoneAnonymous = $('#phoneAnonymous').val();

                var run = true;
                var cssChange = '';

                if(run && streetAddress.localeCompare('')==0){run = false;cssChange='#streetAddressAnonymous';}
                if(run && cityAnonymous.localeCompare('')==0){run = false;cssChange='#cityAnonymous';}
                if(run && postcodeAnonymous.localeCompare('')==0){run = false;cssChange='#postcodeAnonymous';}
                if(run && firstNameAnonymous.localeCompare('')==0){run = false;cssChange='#firstNameAnonymous';}
                if(run && lastNameAnonymous.localeCompare('')==0){run = false;cssChange='#lastNameAnonymous';}
                if(run && emailAnonymous.localeCompare('')==0){run = false;cssChange='#emailAnonymous';}
                if(run && phoneAnonymous.localeCompare('')==0){run = false;cssChange='#phoneAnonymous';}

                if(run) {
                    $('#anonymousCheckoutUserInfo').val('\nCustomer: ' + firstNameAnonymous + ' ' + lastNameAnonymous + '\nAddress: '+ streetAddress + ', ' + cityAnonymous + ', ' + postcodeAnonymous + '\nPhone: ' + phoneAnonymous + ' \nEmail: ' + emailAnonymous);

                    quotationModal(1);

                    $('#anonymousCheckoutModal').modal('toggle');
                    $('#deliveryAddressDiv').hide();
                    $('#checkoutModal').modal('toggle');
                } else {
                    $(cssChange).css('border-color','firebrick');
                    setTimeout(function() {
                        $(cssChange).css('border-color','');
                    }, 1000);
                }
            }

            function placeOrderAnonymous(){

                $('#anonymousCheckoutUserInfo').val('');
                var streetAddress = $('#streetAddressAnonymous').val();
                var cityAnonymous = $('#cityAnonymous').val();
                var postcodeAnonymous = $('#postcodeAnonymous').val();
                var firstNameAnonymous = $('#firstNameAnonymous').val();
                var lastNameAnonymous = $('#lastNameAnonymous').val();
                var emailAnonymous = $('#emailAnonymous').val();
                var phoneAnonymous = $('#phoneAnonymous').val();

                var run = true;
                var cssChange = '';

                if(run && streetAddress.localeCompare('')==0){run = false;cssChange='#streetAddressAnonymous';}
                if(run && cityAnonymous.localeCompare('')==0){run = false;cssChange='#cityAnonymous';}
                if(run && postcodeAnonymous.localeCompare('')==0){run = false;cssChange='#postcodeAnonymous';}
                if(run && firstNameAnonymous.localeCompare('')==0){run = false;cssChange='#firstNameAnonymous';}
                if(run && lastNameAnonymous.localeCompare('')==0){run = false;cssChange='#lastNameAnonymous';}
                if(run && emailAnonymous.localeCompare('')==0){run = false;cssChange='#emailAnonymous';}
                if(run && phoneAnonymous.localeCompare('')==0){run = false;cssChange='#phoneAnonymous';}

                var customTimeslotsValidation = $('#postcodeNotDeliverableInputAnonymous').val();
                if(customTimeslotsValidation != 1) {
                    run = false;
                }

                if(run) {
                    $('#anonymousCheckoutUserInfo').val('\nCustomer: ' + firstNameAnonymous + ' ' + lastNameAnonymous + '\nAddress: ' + cityAnonymous + ', ' + streetAddress + ', ' + postcodeAnonymous + '\nPhone: ' + phoneAnonymous + ' \nEmail: ' + emailAnonymous);

                    quotationModal(0);

                    $('#anonymousCheckoutModal').modal('toggle');
                    $('#deliveryAddressDiv').hide();
                    $('#checkoutModal').modal('toggle');
                } else {
                    $(cssChange).css('border-color','firebrick');
                    setTimeout(function() {
                        $(cssChange).css('border-color','');
                    }, 1000);
                }
            }

            function customTimeslotDeliveryValidationAnonymous(){
                var postCode = $('#postcodeAnonymous').val();
                var city = $('#cityAnonymous').val();
                $.ajax({
                    type: "POST",
                    url: './dbaccess/b2c_zip_code_validation.php',
                    data: {'postCode': postCode,'city':city},
                    success: function (result) {
                        $('#postcodeNotDeliverableInputAnonymous').val(result);
                        if(result == 0){
                            $('#postcodeNotDeliverableAnonymous').show();
                            $('#validateRegistrationButtonAnonymous').hide();
                            return false;
                        } else {
                            $('#postcodeNotDeliverableAnonymous').hide();
                            $('#validateRegistrationButtonAnonymous').show();
                            return true;
                        }
                    }
                });
            }

            function customTimeslotDeliveryValidationNewAccount(){
                var postCode = $('#postcode').val();
                var city = $('#city').val();
                $.ajax({
                    type: "POST",
                    url: './dbaccess/b2c_zip_code_validation.php',
                    data: {'postCode': postCode,'city':city},
                    success: function (result) {
                        $('#postcodeNotDeliverableInputNewAccount').val(result);
                        if(result == 0){
                            $('#postcodeNotDeliverableNewAccount').show();
                            $('#validateRegistrationButtonNewAccount').hide();
                            return false;
                        } else {
                            $('#postcodeNotDeliverableNewAccount').hide();
                            $('#validateRegistrationButtonNewAccount').show();
                            return true;
                        }
                    }
                });
            }

            function refreshCartPrices(){
                $.ajax({
                    type: "POST",
                    url: "./dbaccess/refreshCartPrices.php",
                    data: {},
                    success: function (result) {
                        location.reload();
                    }
                });
            }

        </script>

        <link href="./assets/popover/bootstrap-popover-x.min.css" media="all" rel="stylesheet" type="text/css" />
        <script src="./assets/popover/bootstrap-popover-x.min.js" type="text/javascript"></script>

    </body>
</html>