<?php
session_start();
require("../concc/dbinfo.php");


$dataPOST = trim(file_get_contents('php://input'));

$myfile = fopen("oaoa.txt", "w") or die("Unable to open file!");

fwrite($myfile, $dataPOST);

fclose($myfile);
$dataPOST = str_replace('&', '&amp;', $dataPOST);
$xmlData = simplexml_load_string($dataPOST);


$fileName=$xmlData->deviceID['devID'];
$db = new mysqli('localhost',$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	 $db->set_charset("utf8");


$validID=false;
$stm = $db->prepare("SELECT expiry_date,status FROM Devices_Pop WHERE device_pop_id='$fileName'");
$stm-> execute();
$stm-> bind_result($expiryDate,$status);
while ($stm->fetch()) {

    $validID=true;


}
$stm-> close();


if(!$validID)
{
    return;
}



$myfile = fopen("error.txt", "w") or die("Unable to open file!");
fwrite($myfile, "ERROR Reporting:");
fclose($myfile);

$devID = $xmlData->deviceID['devID'];
$appURL = $xmlData->deviceID['url'];
$currURL = $_SERVER["HTTP_HOST"].$_SERVER['REQUEST_URI'];
$androidID = $xmlData->deviceID['androidID'];
$companyCode = $xmlData->deviceID['companyCode'];
$displayPrefix = $xmlData->deviceID['displayPrefix'];
$databasePrefix = $xmlData->deviceID['databasePrefix'];
$activationCode = $xmlData->deviceID['activationCode'];
$isActivation   = $xmlData->deviceID['activation'];

$appURL = str_replace('https://','',$appURL);
$appURL = str_replace('http://' ,'',$appURL);

$authError = new stdClass();

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

if(strcmp("$appURL","$currURL")!=0){
    $authError->code = '1';
    $authError->name = 'Domain Mismatch';
    $authError->details = "App URL Call [$appURL] - Server URL Call [$currURL]";
    $myfile = fopen("error.txt", "a") or die("Unable to open file!");
    fwrite($myfile, "\n".json_encode($authError));
    fclose($myfile);
    http_response_code(403);
    echo "Forbidden: Access Denied";
    exit();
} else {

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT count(company_id) FROM Companies WHERE company_code = '$companyCode' LIMIT 1");
    $stm->execute();
    $stm->bind_result($companiesCount);
    while ($stm->fetch()) {}
    $stm->close();

    if($companiesCount > 0){

        $stm = $db->prepare("SELECT count(device_pop_id) FROM Devices_Pop WHERE display_prefix = '$displayPrefix' AND device_pop_id = '$devID' LIMIT 1");
        $stm->execute();
        $stm->bind_result($devicesCount);
        while ($stm->fetch()) {}
        $stm->close();

        if($devicesCount == 0){
            $authError->code = '2';
            $authError->name = 'Device Mismatch';
            $authError->details = "Device [ID:$devID][PREFIX:$displayPrefix] does not exist in Database";
            http_response_code(403);
            echo "Forbidden: Access Denied";
            $myfile = fopen("error.txt", "a") or die("Unable to open file!");
            fwrite($myfile, "\n".json_encode($authError));
            fclose($myfile);
            exit();
        }

    } else if(strcmp($isActivation,'CopYes')==0){

        $stm = $db->prepare("SELECT count(device_pop_id) FROM Devices_Pop WHERE activation_code = '$activationCode' AND device_pop_id = '$devID' LIMIT 1");
        $stm->execute();
        $stm->bind_result($devicesCount);
        while ($stm->fetch()) {}
        $stm->close();

        if($devicesCount == 0){
            $authError->code = '3';
            $authError->name = 'Activation Device Mismatch';
            $authError->details = "Activation Device [ID:$devID][PREFIX:$displayPrefix][PREFIX:$displayPrefix] does not exist in Database";
            http_response_code(403);
            echo "Forbidden: Access Denied";
            $myfile = fopen("error.txt", "a") or die("Unable to open file!");
            fwrite($myfile, "\n".json_encode($authError));
            fclose($myfile);
            exit();
        }

    } else {
        $authError->code = '4';
        $authError->name = 'Company Mismatch';
        $authError->details = "Company [CODE:$companyCode] does not exist in Database";
        http_response_code(403);
        echo "Forbidden: Access Denied";
        $myfile = fopen("error.txt", "a") or die("Unable to open file!");
        fwrite($myfile, "\n".json_encode($authError));
        fclose($myfile);
        exit();
    }


}
$myfile = fopen("error.txt", "a") or die("Unable to open file!");
fwrite($myfile, "\nNo Errors.");
fclose($myfile);
//Suppliers ----------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Suppliers as $s) { 
	
      
       $customerID = $s['customer_id'];
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       $balance =$s['balance'];
       
       $stm = $db->prepare("SELECT timestamp,balance FROM Suppliers WHERE customer_id='$customerID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB,$balanceDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp || $balance==$balanceDB)
		{
			
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		$customerCode=$s['customer_code'];
    		$name=$s['customer_company_name'];	
    		$reportName=$s['customer_report_name'];
    		$logo=$s['logo'];
    		$registrationCode=$s['registration_code'];
    		$mobile=$s['mobile'];
    		$website=$s['website'];	
    		$email=$s['email'];
    		$description=$s['description'];
    		$typeOfBusiness=$s['type_of_business'];
    		$ticCode=$s['tic_code'];	
    		$vatCode=$s['vat_code'];
    		$creditLimit=$s['credit_limit'];
    		$typeOfCustomer=$s['customer_type'];

    		$stmt = $db->prepare("REPLACE INTO Suppliers (customer_id,customer_code,customer_company_name,customer_report_name,logo,registration_code,mobile,website,email,description,type_of_business,tic_code,vat_code,credit_limit,customer_type,balance,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
 		$stmt->bind_param('issssssssssssssd',$customerID,$customerCode,$name,$reportName,$logo,$registrationCode,$mobile,$website,$email,$description,$typeOfBusiness,$ticCode,$vatCode,$creditLimit,$typeOfCustomer,$balance);
 		$stmt->execute(); 		
 		$stmt->close();    	
    	}
   
} 
	


	
//SupplierAddress----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->SupplierAddress as $s) { 
	

       $customerAddressID= $s['supplier_address_id'];
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
       
       $stm = $db->prepare("SELECT timestamp FROM SupplierAddress WHERE supplier_address_id='$customerAddressID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
			
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		$addressCode=$s['address_code'];	
    		$customerID=$s['supplier_id'];	
    		$country=$s['country'];	
    		$city=$s['city'];	
    		$addressLine1=$s['address_line_1'];	
    		$addressLine2=$s['address_line_2'];	
    		$postcode=$s['postcode'];	
    		$region=$s['region'];	
    		$lat=$s['lat'];	
    		$lng=$s['lng'];	
    		$pobox=$s['pobox'];	
    		$landline=$s['landline'];	
    		$fax=$s['fax'];	
    		$primaryAddress=$s['primary_address'];	   
    				
    		$stmt = $db->prepare("REPLACE INTO SupplierAddress (supplier_address_id,address_code,supplier_id,country,city,address_line_1,address_line_2,postcode,region,lat,lng,pobox,landline,fax,primary_address,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
 		$stmt->bind_param('isissssssssssss',$customerAddressID,$addressCode,$customerID,$country,$city,$addressLine1,$addressLine2,$postcode,$region,$lat,$lng,$pobox,$landline,$fax,$primaryAddress);
 		$stmt->execute(); 		
 		$stmt->close();    	
    	}
   
} 


	



	
	
//Items--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Items as $s) { 
	

       $itemID= $s['item_id'];
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
       
       $stm = $db->prepare("SELECT timestamp FROM Items WHERE item_id='$itemID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
			
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		
    		$itemCode=$s['item_code'];	
    		$itemSku=$s['item_sku'];	
    		$companyID=$s['company_id'];	
    		$vatID=$s['vat_id'];	
    		$subunits=$s['subunits'];	
    		$salesUnits=$s['sales_units'];	
    		$manufacturerID=$s['manufacturer_id'];	
    		$name=$s['name'];	
    		$shortDescription=$s['short_description'];	
    		$longDescription=$s['long_description'];	
    		$thumb=$s['thumbnail_url'];	
    		$reorderLevel=$s['reorder_level'];	
    		$targetQTY=$s['target_qty'];	
    		$bundled=$s['bundled'];	
    		$maxStock=$s['max_stock'];	
    		$minStock=$s['min_stock'];	
    		$packing=$s['packing'];		
    		$stockControl=$s['stock_control'];	
			$sellable=$s['sellable'];	
			$weight=$s['weight'];
			$cbm=$s['cbm'];
			$status=$s['status'];
    				
    		$stmt = $db->prepare("REPLACE INTO Items (item_id,item_code,item_sku,company_id,vat_id,subunits,sales_units,manufacturer_id,name,short_description,long_description,thumbnail_url,reorder_level,target_qty,bundled,max_stock,min_stock,packing,stock_control,sellable,weight,cbm,status,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
 		$stmt->bind_param('issiidsissssdisdddsssss',$itemID,$itemCode,$itemSku,$companyID,$vatID,$subunits,$salesUnits,$manufacturerID,$name,$shortDescription,$longDescription,$thumb,$reorderLevel,$targetQTY,$bundled,$maxStock,$minStock,$packing,$stockControl,$sellable,$weight,$cbm,$status);
 		$stmt->execute(); 		
 		$stmt->close();    	
    	}
   
}


//Item_Barcode--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Item_Barcode as $s) {


    $itemID= $s['item_id'];
    $barcode= $s['barcode'];
    $multiplier= $s['multiplier'];
    $defaultBarcode= $s['default_barcode'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Item_Barcode WHERE item_id='$itemID' AND barcode='$barcode'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {
            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $stmt = $db->prepare("REPLACE INTO Item_Barcode (item_id,barcode,multiplier,default_barcode,timestamp) VALUES(?,?,?,?,NOW())");
        $stmt->bind_param('isis',$itemID,$barcode,$multiplier,$defaultBarcode);
        $stmt->execute();
        $stmt->close();
    }

}




	
	
	
//PriceTypes-----------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->PriceTypes as $s) { 
	

       $priceTypeID= $s['pricetype_id'];
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
      
       $stm = $db->prepare("SELECT timestamp FROM PriceTypes WHERE pricetype_id='$priceTypeID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		
    		$priceCode=$s['price_code'];	
    		$name=$s['name'];	
    		$allowDiscount=$s['allow_discount'];	
    		$defaultType=$s['default_type'];
    				
    		$stmt = $db->prepare("REPLACE INTO PriceTypes (pricetype_id,price_code,name,allow_discount,default_type,timestamp) VALUES(?,?,?,?,?,NOW())");
 		$stmt->bind_param('issss',$priceTypeID,$priceCode,$name,$allowDiscount,$defaultType);
 		$stmt->execute(); 		
 		$stmt->close();    	
    	}
   
} 


//Prices--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Prices as $s) { 
	

       $itemID= $s['item_id'];
       $pricetypeID= $s['pricetype_id'];
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
        
       
       $stm = $db->prepare("SELECT timestamp FROM Prices WHERE item_id='$itemID' AND pricetype_id='$pricetypeID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
			
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		
    		$price=$s['price'];	
    		$allowDiscount=$s['allow_discount'];	
    		$incVat=$s['inc_vat'];
    		
    		$stmt = $db->prepare("REPLACE INTO Prices (item_id,pricetype_id,price,allow_discount,inc_vat,timestamp) VALUES(?,?,?,?,?,NOW())");
 		$stmt->bind_param('iisss',$itemID,$pricetypeID,$price,$allowDiscount,$incVat);
 		$stmt->execute(); 		
 		$stmt->close();    	
    	}
   
} 

	



	


// Purchase_Orders-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Purchase_Orders as $s) { 
	

       $orderID= $s['order_id'];       
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
      
       $stm = $db->prepare("SELECT timestamp FROM Purchase_Orders WHERE order_id='$orderID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		
       $orderCode= $s['order_code'];
       $companyID=$s['company_id'];
       $customerID= $s['customer_id'];
       $salespersonID= $s['salesperson_id'];
       $paymentTypeID= $s['paymenttype_id'];
       
         $dateTime = new DateTime($s['order_date']);
       $orderDate= date_format($dateTime, 'Y-m-d' );	
      
       $subtotal= $s['subtotal'];
       $grandTotal= $s['grand_total'];
       $vatAmount= $s['vat_amount'];
       $discountAmount= $s['discount_amount'];
       $printCount= $s['print_count'];
       $orderAddressID= $s['order_address_id'];
       $deliveryAddressID= $s['delivery_address_id'];
       $tenderID= $s['tender_id'];
       $vatIE= $s['vat_i_or_e'];
       
        
		
		if(isset($s['delivery_date']))
		{
		$dateTime = new DateTime($s['delivery_date']);
		   $deliveryDate= date_format($dateTime, 'Y-m-d' );
		}
		else
		{ 
			$deliveryDate= "";	
		
		}    
  	
       $depositAmount= $s['deposit_amount'];

		if(isset($s['details']))
		{
			$details= $s['details'];	
		}
		else
		{ 
			$details= "";	
		
		}
     
       $status= $s['status'];	
     	$currencyID= $s['currency_id'];	
		$globalDiscountPercentage= $s['global_discount_percentage'];	
		$deliveryMethod= $s['delivery_method'];	
			$shippingCompany= $s['shipping_company'];	
			$trackingNumber= $s['tracking_number'];	
			$loadingDate= $s['loading_date'];	
			$landingDate= $s['landing_date'];	
			$cbmTotal= $s['cbm_total'];	
			

if(isset($s['cover_period_start']))
		{
		$dateTime = new DateTime($s['cover_period_start']);
		   $coverPeriodStart= date_format($dateTime, 'Y-m-d' );
		}

if(isset($s['cover_period_end']))
		{
		$dateTime = new DateTime($s['cover_period_end']);
		   $coverPeriodEnd= date_format($dateTime, 'Y-m-d' );
		}

                      		
    		    		
    		$stmt = $db->prepare("REPLACE INTO Purchase_Orders (order_id,order_code,company_id,customer_id,salesperson_id,paymenttype_id,order_date,subtotal,grand_total,vat_amount,discount_amount,print_count,order_address_id,delivery_address_id,tender_id,vat_i_or_e,delivery_date,deposit_amount,details,status,currency_id,global_discount_percentage,delivery_method,shipping_company,tracking_number,loading_date,landing_date,cbm_total,cover_period_start,cover_period_end,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
            $stmt->bind_param('isiiiisddddiiiissdssidsssssdss',$orderID,$orderCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$orderAddressID,$deliveryAddressID,$tenderID,$vatIE,$deliveryDate,$depositAmount,$details,$status,$currencyID,$globalDiscountPercentage,$deliveryMethod,$shippingCompany,$trackingNumber,$loadingDate,$landingDate,$cbmTotal,$coverPeriodStart,$coverPeriodEnd);
            $stmt->execute();
            $stmt->close();

            $deleteID = getNextKey("Deletes", "delete_id");
            $dstatement="DELETE FROM Unsent_Records WHERE table_row_id=$orderID AND table_name='Purchase_Orders'";

            $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
            $stmt->bind_param('is',$deleteID,$dstatement);
            $stmt->execute();
            $stmt->close();
    	}
   
} 


// Purchase_Order_Item---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Purchase_Order_Item as $s) { 
	

       $orderItemID= $s['order_item_id'];       
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
      
       $stm = $db->prepare("SELECT timestamp FROM Purchase_Order_Item WHERE order_item_id='$orderItemID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		
       $orderID= $s['order_id'];
       $itemID=$s['item_id'];
       $qty= $s['qty'];
       $qtyDelivered= $s['qty_delivered'];
	   $qtyInvoiced= $s['qty_invoiced'];
       $unitPrice= $s['unit_price'];
       $lineDiscount= $s['line_discount'];
	   $globalDiscount= $s['global_discount'];
	   $lineDiscountPercentage= $s['line_discount_percentage'];
       $vatAmount= $s['vat_amount'];
       $pricetypeID= $s['pricetype_id'];
       $vatID= $s['vat_id'];
	   
	   if(isset($s['description']))
		{
			$description= $s['description'];	
		}
		else
		{ 
			$description= "";	
		
		}
  $deliveryDate= $s['delivery_date'];	
     		
    		    		
    		$stmt = $db->prepare("REPLACE INTO Purchase_Order_Item (order_item_id,order_id,item_id,qty,qty_delivered,qty_invoiced,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,description,delivery_date,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
 		$stmt->bind_param('iiiddddddddiiss',$orderItemID,$orderID,$itemID,$qty,$qtyDelivered,$qtyInvoiced,$unitPrice,$lineDiscount,$globalDiscount,$lineDiscountPercentage,$vatAmount,$pricetypeID,$vatID,$description,$deliveryDate);
 		$stmt->execute(); 		
 		$stmt->close();    	
    	}
   
} 





// Purchase_Order_Item_Calculation---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Purchase_Order_Item_Calculation as $s) { 
	

       $purchaseOrderItemID= $s['purchase_order_item_id'];
       $purchaseCalculationID= $s['purchase_calculation_id'];
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
      
       $stm = $db->prepare("SELECT timestamp FROM Purchase_Order_Item_Calculation WHERE purchase_order_item_id='$purchaseOrderItemID' AND Purchase_calculation_id='$purchaseCalculationID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		
       $calculation= $s['calculation'];
    
    		    		
    		$stmt = $db->prepare("REPLACE INTO Purchase_Order_Item_Calculation (purchase_order_item_id,purchase_calculation_id,calculation,timestamp) VALUES(?,?,?,NOW())");
 		$stmt->bind_param('iid',$purchaseOrderItemID,$purchaseCalculationID,$calculation);
 		$stmt->execute(); 		
 		$stmt->close();    	
    	}
   
} 



// GRNs-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->GRNs as $s) { 
	

       $waybillID= $s['waybill_id'];       
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
      
       $stm = $db->prepare("SELECT timestamp FROM GRNs WHERE waybill_id='$waybillID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		
       $waybillCode= $s['waybill_code'];
       $companyID=$s['company_id'];
       $customerID= $s['customer_id'];
       $salespersonID= $s['salesperson_id'];
       $paymentTypeID= $s['paymenttype_id'];
       $orderID= $s['order_id'];
       $tenderID= $s['tender_id'];
       $subtotal= $s['subtotal'];
       $grandTotal= $s['grand_total'];
       $vatAmount= $s['vat_amount'];
       $vatIorE= $s['vat_i_e'];
       $discountAmount= $s['discount_amount'];
       $waybillAddressID= $s['waybill_address_id'];
       $deliveryAdressID= $s['delivery_address_id'];
       $printCount= $s['print_count'];
       if($s['waybill_date']!="null" && isset($s['waybill_date']) )
       {
       $dateTime = new DateTime($s['waybill_date']);
       $waybillDATE= date_format($dateTime, 'Y-m-d' );	
       }
       else
       {
       $waybillDATE="";
       }
	   if(isset($s['details']))
	   {
		   
		   $details= $s['details'];	    
       }
	   else
	   {
				
			$details= "";	    
	   }

$status= $s['status'];
$currencyID= $s['currency_id'];
$globalDiscountPercent= $s['global_discount_percentage'];


 $documentDate = $s['document_date'];
  //  if(isset($s['document_date']))
	//	{
	//	$dateTime = new DateTime($s['document_date']);
		//   $documentDate= date_format($dateTime, 'Y-m-d' );
	//	}

$documentNumber= $s['document_number'];
$documentUrl= $s['document_url'];   
      	
    	$stmt = $db->prepare("REPLACE INTO GRNs (waybill_id,waybill_code,company_id,customer_id,salesperson_id,paymenttype_id,order_id,tender_id,subtotal,grand_total,vat_amount,vat_i_e,discount_amount,waybill_address_id,delivery_address_id,print_count,waybill_date,details,status,currency_id,global_discount_percentage,document_date,document_number,document_url,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
 		$stmt->bind_param('isiiiiiidddsdiiissssdsss',$waybillID,$waybillCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderID,$tenderID,$subtotal,$grandTotal,$vatAmount,$vatIorE,$discountAmount,$waybillAddressID,$deliveryAdressID,$printCount,$waybillDATE,$details,$status,$currencyID,$globalDiscountPercent,$documentDate,$documentNumber,$documentUrl);
 		$stmt->execute(); 		
 		$stmt->close();

            $deleteID = getNextKey("Deletes", "delete_id");
            $dstatement="DELETE FROM Unsent_Records WHERE table_row_id=$waybillID AND table_name='GRNs'";

            $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
            $stmt->bind_param('is',$deleteID,$dstatement);
            $stmt->execute();
            $stmt->close();
    	}
   
} 


// GRN_Item-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->GRN_Item as $s) { 
	

       $waybillItemID= $s['waybill_item_id'];       
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
      
       $stm = $db->prepare("SELECT timestamp FROM GRN_Item WHERE waybill_item_id='$waybillItemID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		
       $waybillID= $s['waybill_id'];
       $itemID=$s['item_id'];
       $batchNumber= $s['batch_number'];
       $warehouseID= $s['warehouse_id'];
       $qty= $s['qty'];
       $qtyInvoiced= $s['qty_invoiced'];
       $unitPrice= $s['unit_price'];
       $lineDiscount= $s['line_discount'];
       $globalDiscount= $s['global_discount'];
       $lineDiscountPercent= $s['line_discount_percentage'];
       $vatAmount= $s['vat_amount'];
       $priceTypeID= $s['pricetype_id'];
       $vatID= $s['vat_id'];
       $serialnumber= $s['serialnumber'];
       if(isset($s['description']))
	   {
		   
		   $description= $s['description'];	    
       }
	   else
	   {
				
			$description= "";	    
	   }

$cost= $s['cost'];
      	
    		$stmt = $db->prepare("REPLACE INTO GRN_Item (waybill_item_id,waybill_id,item_id,batch_number,warehouse_id,qty,qty_invoiced,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,serialnumber,description,cost,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
 		$stmt->bind_param('iiisidddddddiissd',$waybillItemID,$waybillID,$itemID,$batchNumber,$warehouseID,$qty,$qtyInvoiced,$unitPrice,$lineDiscount,$globalDiscount,$lineDiscountPercent,$vatAmount,$priceTypeID,$vatID,$serialnumber,$description,$cost);
 		$stmt->execute(); 		
 		$stmt->close();    	
    	}
   
} 



// Purchase_Invoices-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Purchase_Invoices as $s) { 
	

       $invoiceID= $s['invoice_id'];       
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
      
       $stm = $db->prepare("SELECT timestamp FROM Purchase_Invoices WHERE invoice_id='$invoiceID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		
       $invoiceCode= $s['invoice_code'];
       $companyID=$s['company_id'];
       $customerID= $s['customer_id'];
       $salespersonID= $s['salesperson_id'];
       $paymentTypeID= $s['paymenttype_id'];
       $orderID= $s['order_id'];
       $tenderID= $s['tender_id'];
       $subtotal= $s['subtotal'];
       $grandTotal= $s['grand_total'];
       $vatAmount= $s['vat_amount'];
       $vatIorE= $s['vat_i_e'];
       $discountAmount= $s['discount_amount'];
       $invoiceAddressID= $s['invoice_address_id'];
       $deliveryAdressID= $s['delivery_address_id'];
       $printCount= $s['print_count'];
       if($s['invoice_date']!="null" && isset($s['invoice_date']) )
       {
       $dateTime = new DateTime($s['invoice_date']);
       $invoiceDATE= date_format($dateTime, 'Y-m-d' );	
       }
       else
       {
       $invoiceDATE="";
       }
         if(isset($s['details']))
		{
			$details= $s['details'];	
		}
		else
		{ 
			$details= "";	
		
		}
       $invoiceType= $s['invoice_type'];
       
       
        if($s['due_date']!="null" && !is_null($s['due_date']))
       	{
       $dateTime = new DateTime($s['due_date']);
       $dueDate=date_format($dateTime, 'Y-m-d' );
       }
       else
       {$dueDate="";
       }
	        $status= $s['status'];
			$currencyID= $s['currency_id'];
		    $globalDiscountPercentage= $s['global_discount_percentage'];
 $documentDate = $s['document_date'];
  //  if(isset($s['document_date']))
	//	{
	//	$dateTime = new DateTime($s['document_date']);
		//   $documentDate= date_format($dateTime, 'Y-m-d' );
	//	}
$documentNumber= $s['document_number'];
$documentUrl= $s['document_url'];






      	
    		$stmt = $db->prepare("REPLACE INTO Purchase_Invoices (invoice_id,invoice_code,company_id,customer_id,salesperson_id,paymenttype_id,order_id,tender_id,subtotal,grand_total,vat_amount,vat_i_e,discount_amount,invoice_address_id,delivery_address_id,print_count,invoice_date,details,invoice_type,due_date,status,currency_id,global_discount_percentage,document_date,document_number,document_url,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
 		$stmt->bind_param('isiiiiiidddsdiiisssssidsss',$invoiceID,$invoiceCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderID,$tenderID,$subtotal,$grandTotal,$vatAmount,$vatIorE,$discountAmount,$invoiceAddressID,$deliveryAdressID,$printCount,$invoiceDATE,$details,$invoiceType,$dueDate,$status,$currencyID,$globalDiscountPercentage,$documentDate,$documentNumber,$documentUrl);
 		$stmt->execute(); 		
 		$stmt->close();

            $deleteID = getNextKey("Deletes", "delete_id");
            $dstatement="DELETE FROM Unsent_Records WHERE table_row_id=$invoiceID AND table_name='Purchase_Invoices'";

            $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
            $stmt->bind_param('is',$deleteID,$dstatement);
            $stmt->execute();
            $stmt->close();
    	}
   
} 


// Purchase_Invoice_Item-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Purchase_Invoice_Item as $s) { 
	

       $invoiceItemID= $s['invoice_item_id'];       
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
      
       $stm = $db->prepare("SELECT timestamp FROM  Purchase_Invoice_Item WHERE invoice_item_id='$invoiceItemID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		
       $invoiceID= $s['invoice_id'];
       $itemID=$s['item_id'];
       $batchNumber= $s['batch_number'];
       $warehouseID= $s['warehouse_id'];
       $qty= $s['qty'];
       $unitPrice= $s['unit_price'];
       $lineDiscount= $s['line_discount'];
	   $globalDiscount= $s['global_discount'];
	   $lineDiscountPercentage= $s['line_discount_percentage'];
       $vatAmount= $s['vat_amount'];
       $priceTypeID= $s['pricetype_id'];
       $vatID= $s['vat_id'];
       $serialnumber= $s['serialnumber'];
    if(isset($s['description']))
		{
			$description= $s['description'];	
		}
		else
		{ 
			$description= "";	
		
		}
      	 $cost= $s['cost'];
    		$stmt = $db->prepare("REPLACE INTO Purchase_Invoice_Item (invoice_item_id,invoice_id,item_id,batch_number,warehouse_id,qty,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,serialnumber,description,cost,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
 		$stmt->bind_param('iiisiddddddiissd',$invoiceItemID,$invoiceID,$itemID,$batchNumber,$warehouseID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$lineDiscountPercentage,$vatAmount,$priceTypeID,$vatID,$serialnumber,$description,$cost);
 		$stmt->execute(); 		
 		$stmt->close();    	
    	}
   
} 



// Purchase_Returns-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Purchase_Returns as $s) { 
	

       $returnID= $s['return_id'];       
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
      
       $stm = $db->prepare("SELECT timestamp FROM Purchase_Returns WHERE return_id='$returnID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		
       $returnCode= $s['return_code'];
       $companyID=$s['company_id'];
       $customerID= $s['customer_id'];
       $salespersonID= $s['salesperson_id'];
       $paymentTypeID= $s['paymenttype_id'];
       $orderID= $s['order_id'];
       $subtotal= $s['subtotal'];
       $grandTotal= $s['grand_total'];
       $vatAmount= $s['vat_amount'];
       $vatIorE= $s['vat_i_e'];
       $discountAmount= $s['discount_amount'];
       $returnAddressID= $s['return_address_id'];
       $printCount= $s['print_count'];
       $returnDate= $s['return_date'];
      if(isset($s['details']))
	   {
	   $details= $s['details'];
	   }
	   else
	   {
	   $details= "";
	   }
     $status= $s['status'];
	  $currencyID= $s['currency_id'];
	   $globalDiscountPercentage= $s['global_discount_percentage'];
 $documentDate = $s['document_date'];
  //  if(isset($s['document_date']))
	//	{
	//	$dateTime = new DateTime($s['document_date']);
		//   $documentDate= date_format($dateTime, 'Y-m-d' );
	//	}

$documentNumber= $s['document_number'];
$documentUrl= $s['document_url'];
$returnType = $s['return_type'];
    		$stmt = $db->prepare("REPLACE INTO Purchase_Returns  (return_id,return_code,company_id,customer_id,salesperson_id,paymenttype_id,order_id,subtotal,grand_total,vat_amount,vat_i_e,discount_amount,return_address_id,print_count,return_date,details,status,currency_id,global_discount_percentage,document_date,document_number,document_url,return_type,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
 		$stmt->bind_param('isiiiiidddsdiisssidssss',$returnID,$returnCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderID,$subtotal,$grandTotal,$vatAmount,$vatIorE,$discountAmount,$returnAddressID,$printCount,$returnDate,$details,$status,$currencyID,$globalDiscountPercentage,$documentDate,$documentNumber,$documentUrl,$returnType);
 		$stmt->execute(); 		
 		$stmt->close();

            $deleteID = getNextKey("Deletes", "delete_id");
            $dstatement="DELETE FROM Unsent_Records WHERE table_row_id=$returnID AND table_name='Purchase_Returns'";

            $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
            $stmt->bind_param('is',$deleteID,$dstatement);
            $stmt->execute();
            $stmt->close();
    	}
   
} 




// Purchase_Return_Item-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Purchase_Return_Item as $s) { 
	

       $returnItemID= $s['return_item_id'];       
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
      
       $stm = $db->prepare("SELECT timestamp FROM Purchase_Return_Item WHERE return_item_id='$returnItemID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		
       $returnID= $s['return_id'];
       $itemID=$s['item_id'];
       $batchNumber= $s['batch_number'];
       $warehouseID= $s['warehouse_id'];
       $qty= $s['qty'];
       $unitPrice= $s['unit_price'];
       $lineDiscount= $s['line_discount'];
	   $globalDiscount= $s['global_discount'];
	   $lineDiscountPercentage= $s['line_discount_percentage'];
       $vatAmount= $s['vat_amount'];
       $priceTypeID= $s['pricetype_id'];
       $vatID= $s['vat_id'];
       $serialnumber= $s['serialnumber'];
      $description= $s['description'];
      	 $status= $s['status'];
		  $cost= $s['cost'];
		 
		 
    		$stmt = $db->prepare("REPLACE INTO Purchase_Return_Item (return_item_id,return_id,item_id,batch_number,warehouse_id,qty,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,serialnumber,description,status,cost,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
 		$stmt->bind_param('iiisiddddddiisssd',$returnItemID,$returnID,$itemID,$batchNumber,$warehouseID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$lineDiscountPercentage,$vatAmount,$priceTypeID,$vatID,$serialnumber,$description,$status,$cost);
 		$stmt->execute(); 		
 		$stmt->close();    	
    	}
   
} 


// Stock_Taking-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Stock_Taking as $s) { 
	

       $stockTakingID= $s['stock_taking_id'];       
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
      
       $stm = $db->prepare("SELECT timestamp FROM Stock_Taking WHERE stock_taking_id='$stockTakingID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		
       $stockTakingCode= $s['stock_taking_code'];
       $companyID=$s['company_id'];
       $warehouseID= $s['warehouse_id'];
       $salespersonID= $s['salesperson_id'];
       $printCount= $s['print_count'];
       $date= $s['date'];
       $title= $s['title'];
      if(isset($s['details']))
	   {
	   $details= $s['details'];
	   }
	   else
	   {
	   $details= "";
	   }
     $addOverride= $s['add_override'];
	 
    		$stmt = $db->prepare("REPLACE INTO Stock_Taking (stock_taking_id,stock_taking_code,title,company_id,warehouse_id,salesperson_id,print_count,date,details,add_override,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,NOW())");
 		$stmt->bind_param('issiiiisss',$stockTakingID,$stockTakingCode,$title,$companyID,$warehouseID,$salespersonID,$printCount,$date,$details,$addOverride);
 		$stmt->execute(); 		
 		$stmt->close();

            $deleteID = getNextKey("Deletes", "delete_id");
            $dstatement="DELETE FROM Unsent_Records WHERE table_row_id=$stockTakingID AND table_name='Stock_Taking'";

            $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
            $stmt->bind_param('is',$deleteID,$dstatement);
            $stmt->execute();
            $stmt->close();
    	}
   
} 

// Stock_Taking_Item-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Stock_Taking_Item as $s) { 
	

       $stockTakingItemID= $s['stock_taking_item_id'];       
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
      
       $stm = $db->prepare("SELECT timestamp FROM Stock_Taking_Item WHERE stock_taking_item_id='$stockTakingItemID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		
       $stockTakingID= $s['stock_taking_id'];
       $itemID=$s['item_id'];
       $batchNumber= $s['batch_number'];
       $warehouseID= $s['warehouse_id'];
       $qty= $s['qty'];      
       $serialnumber= $s['serialnumber'];
       $description= $s['description'];
      	 
		 
		 
    		$stmt = $db->prepare("REPLACE INTO Stock_Taking_Item (stock_taking_item_id,stock_taking_id,item_id,batch_number,warehouse_id,qty,serialnumber,description,timestamp) VALUES(?,?,?,?,?,?,?,?,NOW())");
 		$stmt->bind_param('iiisidss',$stockTakingItemID,$stockTakingID,$itemID,$batchNumber,$warehouseID,$qty,$serialnumber,$description);
 		$stmt->execute(); 		
 		$stmt->close();    	
    	}
   
} 



// Stock_Adjustment-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Stock_Adjustment as $s) { 
	

       $stockTakingID= $s['stock_taking_id'];       
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
      
       $stm = $db->prepare("SELECT timestamp FROM Stock_Adjustment WHERE stock_taking_id='$stockTakingID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		
       $stockTakingCode= $s['stock_taking_code'];
       $companyID=$s['company_id'];
       $warehouseID= $s['warehouse_id'];
       $salespersonID= $s['salesperson_id'];
       $printCount= $s['print_count'];
       $date= $s['date'];	
      if(isset($s['details']))
	   {
	   $details= $s['details'];
	   }
	   else
	   {
	   $details= "";
	   }
     $addOverride= $s['add_override'];
	 
    		$stmt = $db->prepare("REPLACE INTO Stock_Adjustment (stock_taking_id,stock_taking_code,company_id,warehouse_id,salesperson_id,print_count,date,details,add_override,timestamp) VALUES(?,?,?,?,?,?,?,?,?,NOW())");
 		$stmt->bind_param('isiiiisss',$stockTakingID,$stockTakingCode,$companyID,$warehouseID,$salespersonID,$printCount,$date,$details,$addOverride);
 		$stmt->execute(); 		
 		$stmt->close();

            $deleteID = getNextKey("Deletes", "delete_id");
            $dstatement="DELETE FROM Unsent_Records WHERE table_row_id=$stockTakingID AND table_name='Stock_Adjustment'";

            $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
            $stmt->bind_param('is',$deleteID,$dstatement);
            $stmt->execute();
            $stmt->close();
    	}
   
} 

// Stock_Adjustment_Item-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Stock_Adjustment_Item as $s) { 
	

       $stockTakingItemID= $s['stock_taking_item_id'];       
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
      
       $stm = $db->prepare("SELECT timestamp FROM Stock_Adjustment_Item WHERE stock_taking_item_id='$stockTakingItemID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		
       $stockTakingID= $s['stock_taking_id'];
       $itemID=$s['item_id'];
       $batchNumber= $s['batch_number'];
       $warehouseID= $s['warehouse_id'];
       $qty= $s['qty'];      
       $serialnumber= $s['serialnumber'];
       $description= $s['description'];
      	 
		 
		 
    		$stmt = $db->prepare("REPLACE INTO Stock_Adjustment_Item (stock_taking_item_id,stock_taking_id,item_id,batch_number,warehouse_id,qty,serialnumber,description,timestamp) VALUES(?,?,?,?,?,?,?,?,NOW())");
 		$stmt->bind_param('iiisidss',$stockTakingItemID,$stockTakingID,$itemID,$batchNumber,$warehouseID,$qty,$serialnumber,$description);
 		$stmt->execute(); 		
 		$stmt->close();    	
    	}
   
} 

//Warehouse_Transactions-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Warehouse_Transactions as $s) { 
	

       $warehouseTransactionID= $s['warehouse_transaction_id'];       
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
      
       $stm = $db->prepare("SELECT timestamp FROM Warehouse_Transactions WHERE warehouse_transaction_id='$warehouseTransactionID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		$warehouseTransactionCode= $s['warehouse_transaction_code'];
       $warehouseFrom= $s['warehouse_id_from'];
	   $warehouseTo= $s['warehouse_id_to'];
       $companyID=$s['company_id'];      
       $salespersonID= $s['salesperson_id'];      
       $type= $s['type'];
       if($s['transaction_date']!="null" && isset($s['transaction_date']) )
       {
       $dateTime = new DateTime($s['transaction_date']);
       $transactionDate= date_format($dateTime, 'Y-m-d' );	
       }
       else
       {
       $transactionDate="";
       }
       $details= $s['details'];	    
       
   
      	
    	$stmt = $db->prepare("REPLACE INTO Warehouse_Transactions (warehouse_transaction_id,warehouse_transaction_code,warehouse_id_from,warehouse_id_to,company_id,salesperson_id,type,transaction_date,details,timestamp) VALUES(?,?,?,?,?,?,?,?,?,NOW())");
 		$stmt->bind_param('isiiiisss',$warehouseTransactionID,$warehouseTransactionCode,$warehouseFrom,$warehouseTo,$companyID,$salespersonID,$type,$transactionDate,$details);
 		$stmt->execute(); 		
 		$stmt->close();

            $deleteID = getNextKey("Deletes", "delete_id");
            $dstatement="DELETE FROM Unsent_Records WHERE table_row_id=$warehouseTransactionID AND table_name='Warehouse_Transactions'";

            $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
            $stmt->bind_param('is',$deleteID,$dstatement);
            $stmt->execute();
            $stmt->close();
    	}
   
} 


// Warehouse_Transaction_Item-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Warehouse_Transaction_Item as $s) { 
	

       $warehouseTransactionItemID= $s['warehouse_transaction_item_id'];       
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
      
       $stm = $db->prepare("SELECT timestamp FROM Warehouse_Transaction_Item WHERE warehouse_transaction_item_id='$warehouseTransactionItemID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		
       $warehouseTransactionID= $s['warehouse_transaction_id'];
       $itemID=$s['item_id'];
       $batchNumber= $s['batch_number'];
       $warehouseID= $s['warehouse_id'];   
       $qty= $s['qty'];    	   
       $serialnumber= $s['serialnumber'];
       $itemCondition= $s['item_condition'];
       $notes = $s['notes'];
     
      	
    		$stmt = $db->prepare("REPLACE INTO Warehouse_Transaction_Item (warehouse_transaction_item_id,warehouse_transaction_id,item_id,batch_number,warehouse_id,qty,serialnumber,item_condition,notes,timestamp) VALUES(?,?,?,?,?,?,?,?,?,NOW())");
 		$stmt->bind_param('iiisidsss',$warehouseTransactionItemID,$warehouseTransactionID,$itemID,$batchNumber,$warehouseID,$qty,$serialnumber,$itemCondition,$notes);
 		$stmt->execute(); 		
 		$stmt->close();    	
    	}
   
} 

//Item_Images-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Item_Images as $s) { 
	

       $imageID= $s['item_image_id'];
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
             
       $stm = $db->prepare("SELECT timestamp FROM Item_Images WHERE item_image_id='$imageID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		
    		$itemID=$s['item_id'];	    	
    		$imageUrl=$s['image_url'];	
    		$imageName=$s['image_name'];	
    		$imageOrder=$s['image_order'];	
    	
    		
    				
    	$stmt = $db->prepare("REPLACE INTO Item_Images (item_image_id,item_id,image_url,image_name,image_order,timestamp) VALUES(?,?,?,?,?,NOW())");
 		$stmt->bind_param('iisss',$imageID,$itemID,$imageUrl,$imageName,$imageOrder);
 		$stmt->execute(); 		
 		$stmt->close();    	
    	}
   
} 





//Purchase_Order_GRN-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Purchase_Order_GRN as $s) { 
	

       $orderID= $s['order_id'];
	   $waybillID= $s['waybill_id'];
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
             
       $stm = $db->prepare("SELECT timestamp FROM Purchase_Order_GRN WHERE order_id='$orderID' AND waybill_id ='$waybillID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    				
    	$stmt = $db->prepare("REPLACE INTO Purchase_Order_GRN (order_id,waybill_id,timestamp) VALUES(?,?,NOW())");
 		$stmt->bind_param('ii',$orderID,$waybillID);
 		$stmt->execute(); 		
 		$stmt->close();    	
    	}
   
}

// Pick-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Pick as $s) { 
	

       $pickID= $s['pick_id'];       
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
      
       $stm = $db->prepare("SELECT timestamp FROM Pick WHERE pick_id='$pickID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		
       $pickCode= $s['pick_code'];
       $companyID=$s['company_id'];      
       $salespersonID= $s['salesperson_id'];       
       
         $date= new DateTime($s['date']);
       $date= date_format($date, 'Y-m-d' );	
      
       $notes= $s['notes'];
       $status= $s['status'];       
       $isForPack= $s['is_for_pack'];

		
		
    		    		
    		$stmt = $db->prepare("REPLACE INTO Pick (pick_id,pick_code,company_id,salesperson_id,date,notes,status,is_for_pack,timestamp) VALUES(?,?,?,?,?,?,?,?,NOW())");
 		$stmt->bind_param('isiissss',$pickID,$pickCode,$companyID,$salespersonID,$date,$notes,$status,$isForPack);
 		$stmt->execute(); 		
 		$stmt->close();

            $deleteID = getNextKey("Deletes", "delete_id");
            $dstatement="DELETE FROM Unsent_Records WHERE table_row_id=$pickID AND table_name='Pick'";

            $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
            $stmt->bind_param('is',$deleteID,$dstatement);
            $stmt->execute();
            $stmt->close();
    	}
   
} 


// Pick_Item---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Pick_Item as $s) { 
	

       $pickItemID= $s['pick_item_id'];       
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
      
       $stm = $db->prepare("SELECT timestamp FROM Pick_Item WHERE pick_item_id='$pickItemID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		
       $pickID= $s['pick_id'];
       $itemID=$s['item_id'];
       $batchNumber= $s['batch_number'];
       $warehouseID= $s['warehouse_id'];

       $qty= $s['qty'];
       $qtyToPick= $s['qty_to_pick'];
	   $notes= $s['notes'];
       $replacedPickItemID = $s['replaced_pick_item_id'];
       $replacedReason = $s['replaced_reason'];
       $fromDocumentLineID = $s['from_document_line_id'];
    		    		
        $stmt = $db->prepare("REPLACE INTO Pick_Item (pick_item_id,pick_id,item_id,batch_number,warehouse_id,qty,qty_to_pick,notes,replaced_pick_item_id,replaced_reason,from_document_line_id,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,NOW())");
 		$stmt->bind_param('iisssddsisi',$pickItemID,$pickID,$itemID,$batchNumber,$warehouseID,$qty,$qtyToPick,$notes,$replacedPickItemID,$replacedReason,$fromDocumentLineID);
 		$stmt->execute(); 		
 		$stmt->close();    	
    	}
   
} 

//Pick_Order-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Pick_Order as $s) { 
	

       $pickID= $s['pick_id'];
	   $orderID= $s['order_id'];
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
             
       $stm = $db->prepare("SELECT timestamp FROM Pick_Order WHERE order_id='$orderID' AND pick_id='$pickID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    				
    	$stmt = $db->prepare("REPLACE INTO Pick_Order (pick_id,order_id,timestamp) VALUES(?,?,NOW())");
 		$stmt->bind_param('ii',$pickID,$orderID);
 		$stmt->execute(); 		
 		$stmt->close();    	
    	}
   
}

// Orders-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Orders as $s) { 
	

       $orderID= $s['order_id'];       
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
      
       $stm = $db->prepare("SELECT timestamp FROM Orders WHERE order_id='$orderID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    		
       $orderCode= $s['order_code'];
       $companyID=$s['company_id'];
       $customerID= $s['customer_id'];
       $salespersonID= $s['salesperson_id'];
       $paymentTypeID= $s['paymenttype_id'];
       
         $dateTime = new DateTime($s['order_date']);
       $orderDate= date_format($dateTime, 'Y-m-d' );	
      
       $subtotal= $s['subtotal'];
       $grandTotal= $s['grand_total'];
       $vatAmount= $s['vat_amount'];
       $discountAmount= $s['discount_amount'];
       $printCount= $s['print_count'];
       $orderAddressID= $s['order_address_id'];
       $deliveryAddressID= $s['delivery_address_id'];
       $tenderID= $s['tender_id'];
       $vatIE= $s['vat_i_or_e'];
       
        
		
		if(isset($s['delivery_date']))
		{
		$dateTime = new DateTime($s['delivery_date']);
		   $deliveryDate= date_format($dateTime, 'Y-m-d' );
		}
		else
		{ 
			$deliveryDate= "";	
		
		}    
  	
       $depositAmount= $s['deposit_amount'];

		if(isset($s['details']))
		{
			$details= $s['details'];	
		}
		else
		{ 
			$details= "";	
		
		}
     
       $status= $s['status'];	
     	$currencyID= $s['currency_id'];	
		$globalDiscountPercentage= $s['global_discount_percentage'];	
		$deliveryMethod= $s['delivery_method'];	
    		    		
    		$stmt = $db->prepare("REPLACE INTO Orders (order_id,order_code,company_id,customer_id,salesperson_id,paymenttype_id,order_date,subtotal,grand_total,vat_amount,discount_amount,print_count,order_address_id,delivery_address_id,tender_id,vat_i_or_e,delivery_date,deposit_amount,details,status,currency_id,global_discount_percentage,delivery_method,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
 		$stmt->bind_param('isiiiisddddiiiissdssids',$orderID,$orderCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$orderAddressID,$deliveryAddressID,$tenderID,$vatIE,$deliveryDate,$depositAmount,$details,$status,$currencyID,$globalDiscountPercentage,$deliveryMethod);
 		$stmt->execute(); 		
 		$stmt->close();

            $deleteID = getNextKey("Deletes", "delete_id");
            $dstatement="DELETE FROM Unsent_Records WHERE table_row_id=$orderID AND table_name='Orders'";

            $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
            $stmt->bind_param('is',$deleteID,$dstatement);
            $stmt->execute();
            $stmt->close();
    	}
   
}


// Order_Item---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Order_Item as $s) {


    $orderItemID= $s['order_item_id'];
    $orderID= $s['order_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Order_Item WHERE order_item_id='$orderItemID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();


    if($executeCommand)
    {


        $itemID=$s['item_id'];
        $qty= $s['qty'];
        $qtyDelivered= $s['qty_delivered'];
        $qtyInvoiced= $s['qty_invoiced'];
        $qtyPicked= $s['qty_picked'];
        $unitPrice= $s['unit_price'];
        $lineDiscount= $s['line_discount'];
        $globalDiscount= $s['global_discount'];
        $lineDiscountPercentage= $s['line_discount_percentage'];
        $vatAmount= $s['vat_amount'];
        $pricetypeID= $s['pricetype_id'];
        $vatID= $s['vat_id'];

        if(isset($s['description']))
        {
            $description= $s['description'];
        }
        else
        {
            $description= "";

        }

        $promotionID= ''.$s['promotion_id'];
        $promotionNumber= ''.$s['promotion_number'];
        $masterItem= ''.$s['master_item'];

        $stmt = $db->prepare("REPLACE INTO Order_Item (order_item_id,order_id,item_id,qty,qty_picked,qty_delivered,qty_invoiced,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,description,promotion_id,promotion_number,master_item,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiidddddddddiissss',$orderItemID,$orderID,$itemID,$qty,$qtyPicked,$qtyDelivered,$qtyInvoiced,$unitPrice,$lineDiscount,$globalDiscount,$lineDiscountPercentage,$vatAmount,$pricetypeID,$vatID,$description,$promotionID,$promotionNumber,$masterItem);
        $stmt->execute();
        $stmt->close();
    }

}

// Order_Delivery_Details---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Order_Delivery_Details as $s) {
    $orderID= $s['order_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp,delivery_status FROM Order_Delivery_Details WHERE order_id='$orderID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB,$prevDeliveryStatus);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {
            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand){
        $prepareDurationMinutes= $s['prepare_duration_minutes'];
        $deliveryTime= $s['delivery_time'];
        $deliveryStatus= $s['delivery_status'];

        $stmt = $db->prepare("UPDATE Order_Delivery_Details SET prepare_duration_minutes=?,delivery_time=?,delivery_status=? WHERE order_id=?");
        $stmt->bind_param('issi',$prepareDurationMinutes,$deliveryTime,$deliveryStatus,$orderID);
        $stmt->execute();
        $stmt->close();

        // ----------------- PUSH NOTIFICATIONS FOR B2B APP 13112023-----------------

        if(strcmp("$prevDeliveryStatus","$deliveryStatus")!=0){

            $b2bAppUserID = $s['user_id'];

            $stm = $db->prepare("SELECT order_code,customer_id FROM Orders WHERE order_id=? LIMIT 1");
            $stm->bind_param('i',$orderID);
            $stm-> execute();
            $stm-> bind_result($b2bAppOrderCode,$b2bAppCustomerID);
            while ($stm->fetch()) {}
            $stm-> close();

            $b2bAppCustomerID = intval($b2bAppCustomerID);
            $b2bAppUserID     = intval($b2bAppUserID);
            $b2bAppTokensArray = array();

            if($b2bAppCustomerID>0) {
                $stm = $db->prepare("SELECT token FROM B2B_User_App_Tokens WHERE customer_id=? AND b2b_user_id=?");
                $stm->bind_param('ii', $b2bAppCustomerID,$b2bAppUserID);
                $stm->execute();
                $stm->bind_result($b2bAppToken);
                while ($stm->fetch()) {array_push($b2bAppTokensArray, $b2bAppToken);}
                $stm->close();
            }

            if(count($b2bAppTokensArray) > 0) {
                include_once('../libs/gcm/FirebasePushNotification.php');
                $push = new FirebasePushNotification($db);
                $push->senderID(0);
                $push->title("Order Update!");
                $push->body("View Order $b2bAppOrderCode.");
                $push->notificationType('DeliveryApproval');

                foreach ($b2bAppTokensArray as $b2bAppToken) {
                    $push->selectDeviceForB2BApp("$orderID","$b2bAppToken", 'B2B');
                    $push->send();
                }


            }

        }

        // ----------------- PUSH NOTIFICATIONS FOR B2B APP 13112023-----------------

    }
}

//Stock_Updates---------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Stock_Updates as $s) {

    $stockUpdateID =$s['stock_update_id'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT COUNT(stock_update_id) FROM Stock_Updates WHERE stock_update_id='$stockUpdateID'");
    $stm-> execute();
    $stm-> bind_result($counter);
    while ($stm->fetch()) {
        if($counter >0)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {



        $warehouseID= $s['warehouse_id'];
        $itemID= $s['item_id'];
        $batchnumber=$s['batch_number'];

        $available=$s['available'];
        $reserved=$s['reserved'];
        $delivered=$s['delivered'];
        $onOrder=$s['on_order'];
        $requested=$s['requested'];
        $sold=$s['sold'];
        $expiryDate=$s['expiry_date'];

        $actionType=$s['action_type'];
        $actionID=$s['action_id'];
        $actionCode=$s['action_code'];
        $reason=$s['reason'];
        $fromActionType=$s['from_action_type'];
        $fromActionID=$s['from_action_id'];
        $fromActionCode=$s['from_action_code'];
        $fromActionQty=$s['from_action_qty'];
        $fromActionField=$s['from_action_field'];


        $stmt = $db->prepare("INSERT INTO Stock (warehouse_id,item_id,batch_number,available,reserved,delivered,on_order,requested,sold,expiry_date,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,NOW())
			ON DUPLICATE KEY UPDATE available=available+?,reserved=reserved+?,delivered=delivered+?,on_order=on_order+?,requested=requested+?,sold=sold+?");
        $stmt->bind_param('iisddddddsdddddd',$warehouseID,$itemID,$batchnumber,$available,$reserved,$delivered,$onOrder,$requested,$sold,$expiryDate,$available,$reserved,$delivered,$onOrder,$requested,$sold);
        $stmt->execute();
        $stmt->close();

        $stmt = $db->prepare("REPLACE INTO Stock_Updates (stock_update_id,warehouse_id,item_id,batch_number,available,reserved,delivered,on_order,requested,sold,expiry_date,action_type,action_id,action_code,reason,from_action_type,from_action_id,from_action_code,from_action_qty,from_action_field,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiisddddddssssssssss',$stockUpdateID,$warehouseID,$itemID,$batchnumber,$available,$reserved,$delivered,$onOrder,$requested,$sold,$expiryDate,$actionType,$actionID,$actionCode,$reason,$fromActionType,$fromActionID,$fromActionCode,$fromActionQty,$fromActionField);
        $stmt->execute();
        $stmt->close();



    }




}
// Production_Receipt-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Production_Receipt as $s) {


    $productionReceiptID= $s['production_receipt_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;

    $stm = $db->prepare("SELECT timestamp FROM Production_Receipt WHERE production_receipt_id='$productionReceiptID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $productionReceiptCode = $s['production_receipt_code'];
        $companyID = $s['company_id'];
        $fromWarehouseID = $s['from_warehouse_id'];
        $toWarehouseID = $s['to_warehouse_id'];
        $salespersonID = $s['salesperson_id'];
        $printCount = $s['print_count'];
        $documentID = $s['document_id'];
        $documentType = $s['document_type'];
        $details = $s['details'];
        $status = $s['status'];


        if(isset($s['start_date']))
        {
            $dateTime = new DateTime($s['start_date']);
            $startDate= date_format($dateTime, 'Y-m-d H:i:s' );
        }
        else
        {
            $startDate= "";
        }

        if(isset($s['end_date']))
        {
            $dateTime = new DateTime($s['end_date']);
            $endDate= date_format($dateTime, 'Y-m-d H:i:s' );
        }
        else
        {
            $endDate= "";
        }


        if(isset($s['details']))
        {
            $details= $s['details'];
        }
        else
        {
            $details= "";

        }

        if(isset($s['status']))
        {
            $status= $s['status'];
        }
        else
        {
            $status= "";
        }

        $stmt = $db->prepare("REPLACE INTO Production_Receipt (production_receipt_id,production_receipt_code,company_id,from_warehouse_id,to_warehouse_id,salesperson_id,print_count,document_id,document_type,start_date,end_date,details,status,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('isiiiiiisssss',$productionReceiptID,$productionReceiptCode,$companyID,$fromWarehouseID,$toWarehouseID,$salespersonID,$printCount,$documentID,$documentType,$startDate,$endDate,$details,$status);
        $stmt->execute();
        $stmt->close();

        $deleteID = getNextKey("Deletes", "delete_id");
        $dstatement="DELETE FROM Unsent_Records WHERE table_row_id=$productionReceiptID AND table_name='Production_Receipt'";

        $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
        $stmt->bind_param('is',$deleteID,$dstatement);
        $stmt->execute();
        $stmt->close();
    }

}

// Production_Receipt_Item--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Production_Receipt_Item as $s) {


    $productionReceiptItemID= $s['production_receipt_item_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Production_Receipt_Item WHERE production_receipt_item_id='$productionReceiptItemID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $productionReceiptID = $s['production_receipt_id'];
        $itemID = $s['item_id'];
        $batchNumber = $s['batch_number'];
        $warehouseID = $s['warehouse_id'];
        $qty = $s['qty'];
        $isMaterial = $s['is_material'];
        $serialnumber = $s['serialnumber'];
        $description = $s['description'];

        if(isset($s['batch_number']))
        {
            $batchNumber= $s['batch_number'];
        }
        else
        {
            $batchNumber= "";
        }

        if(isset($s['serialnumber']))
        {
            $serialnumber= $s['serialnumber'];
        }
        else
        {
            $serialnumber= "";

        }

        if(isset($s['is_material']))
        {
            $status= $s['is_material'];
        }
        else
        {
            $status= "";
        }

        if(isset($s['description']))
        {
            $status= $s['description'];
        }
        else
        {
            $status= "";
        }

        $stmt = $db->prepare("REPLACE INTO Production_Receipt_Item (production_receipt_item_id,production_receipt_id,item_id,batch_number,warehouse_id,qty,is_material,serialnumber,description,timestamp) VALUES(?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiisidsss',$productionReceiptItemID,$productionReceiptID,$itemID,$batchNumber,$warehouseID,$qty,$isMaterial,$serialnumber,$description);
        $stmt->execute();
        $stmt->close();
    }

}


// Return_Item-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Return_Item as $s) {


    $returnItemID= $s['return_item_id'];
    $returnID= $s['return_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Return_Item WHERE return_item_id='$returnItemID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();
    if(docIsLocked($returnID,'Returns'))
    {
        $executeCommand = false;
    }
    if($executeCommand)
    {


        $itemID=$s['item_id'];
        $batchNumber= $s['batch_number'];
        $warehouseID= $s['warehouse_id'];
        $qty= $s['qty'];
        $unitPrice= $s['unit_price'];
        $lineDiscount= $s['line_discount'];
        $globalDiscount= $s['global_discount'];
        $lineDiscountPercentage= $s['line_discount_percentage'];
        $vatAmount= $s['vat_amount'];
        $priceTypeID= $s['pricetype_id'];
        $vatID= $s['vat_id'];
        $serialnumber= $s['serialnumber'];
        $description= $s['description'];
        $status= $s['status'];
        $cost= $s['cost'];


        $stmt = $db->prepare("REPLACE INTO Return_Item (return_item_id,return_id,item_id,batch_number,warehouse_id,qty,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,serialnumber,description,status,cost,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiisiddddddiisssd',$returnItemID,$returnID,$itemID,$batchNumber,$warehouseID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$lineDiscountPercentage,$vatAmount,$priceTypeID,$vatID,$serialnumber,$description,$status,$cost);
        $stmt->execute();
        $stmt->close();
    }

}


// Returns-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Returns as $s) {


    $returnID= $s['return_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Returns WHERE return_id='$returnID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();
    if(docIsLocked($returnID,'Returns'))
    {
        $executeCommand = false;
    }
    if($executeCommand)
    {

        $returnCode= $s['return_code'];
        $companyID=$s['company_id'];
        $customerID= $s['customer_id'];
        $salespersonID= $s['salesperson_id'];
        $paymentTypeID= $s['paymenttype_id'];
        $orderID= $s['order_id'];
        $subtotal= $s['subtotal'];
        $grandTotal= $s['grand_total'];
        $vatAmount= $s['vat_amount'];
        $vatIorE= $s['vat_i_e'];
        $discountAmount= $s['discount_amount'];
        $returnAddressID= $s['return_address_id'];
        $printCount= $s['print_count'];
        $returnDate= $s['return_date'];
        if(isset($s['details']))
        {
            $details= $s['details'];
        }
        else
        {
            $details= "";
        }
        $status= $s['status'];
        $currencyID= $s['currency_id'];
        $globalDiscountPercentage= $s['global_discount_percentage'];
        $returnType =$s['return_type'];
        $stmt = $db->prepare("REPLACE INTO Returns (return_id,return_code,company_id,customer_id,salesperson_id,paymenttype_id,order_id,subtotal,grand_total,vat_amount,vat_i_e,discount_amount,return_address_id,print_count,return_date,details,status,currency_id,global_discount_percentage,return_type,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('isiiiiidddsdiisssids',$returnID,$returnCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderID,$subtotal,$grandTotal,$vatAmount,$vatIorE,$discountAmount,$returnAddressID,$printCount,$returnDate,$details,$status,$currencyID,$globalDiscountPercentage,$returnType);
        $stmt->execute();
        $stmt->close();



        $deleteID = getNextKey("Deletes", "delete_id");
        $dstatement="DELETE FROM Unsent_Records WHERE table_row_id=$returnID AND table_name='Returns'";

        $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
        $stmt->bind_param('is',$deleteID,$dstatement);
        $stmt->execute();
        $stmt->close();
    }

}

//  ZA_Custom_Form_Object-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->ZA_Custom_Form_Object as $s) {


    $customFormObjectID= $s['custom_form_object_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM ZA_Custom_Form_Object WHERE custom_form_object_id='$customFormObjectID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {



        $customFormID= $s['custom_form_id'];
        $customFormCode= $s['custom_form_code'];
        $linkedTableID= $s['linked_table_id'];
        $salespersonID= $s['salesperson_id'];




        $stmt = $db->prepare("REPLACE INTO ZA_Custom_Form_Object (custom_form_object_id,custom_form_id,custom_form_code,linked_table_id,salesperson_id,timestamp) VALUES(?,?,?,?,?,NOW())");
        $stmt->bind_param('iisii',$customFormObjectID,$customFormID,$customFormCode,$linkedTableID,$salespersonID);
        $stmt->execute();
        $stmt->close();
    }

}




// ZA_Custom_Field_Object-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->ZA_Custom_Field_Object as $s) {


    $customFiledObjectID= $s['custom_field_object_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM ZA_Custom_Field_Object WHERE custom_field_object_id='$customFiledObjectID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {



        $customFieldID= $s['custom_field_id'];
        $customFormObjectID= $s['custom_form_object_id'];
        $value= $s['value'];





        $stmt = $db->prepare("REPLACE INTO ZA_Custom_Field_Object (custom_field_object_id,custom_field_id,custom_form_object_id,value,timestamp) VALUES(?,?,?,?,NOW())");
        $stmt->bind_param('iiis',$customFiledObjectID,$customFieldID,$customFormObjectID,$value);
        $stmt->execute();
        $stmt->close();
    }

}



//Action_Attachments-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Action_Attachments as $s) {


    $actionAttachmentID= $s['action_attachment_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Action_Attachments WHERE action_attachment_id='$actionAttachmentID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $actionType= $s['action_type'];
        $actionID= $s['action_id'];
        $attachmentURL= $s['attachment_url'];
        $name= $s['name'];



        $stmt = $db->prepare("REPLACE INTO Action_Attachments (action_attachment_id, action_type, action_id, attachment_url, name,timestamp) VALUES(?,?,?,?,?,NOW())");
        $stmt->bind_param('issss',$actionAttachmentID,$actionType,$actionID,$attachmentURL,$name);
        $stmt->execute();
        $stmt->close();

    }

}

//Dynamic Custom Tables (UDT) -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
$customTables = array();
$stm = $db->prepare("SELECT custom_table_id, custom_table_name FROM ZA_Custom_Tables WHERE NOT linked_table='' AND status = 'yes' AND update_app = 'yes'");
$stm-> execute();
$stm->bind_result($customTableID, $customTableName);
while ($stm->fetch()) {
    $line = new stdClass();
    $line->id = $customTableID;
    $line->table = $customTableName;
    array_push($customTables,$line);
}
$stm-> close();

foreach($customTables as $customTable) {

    $customTableName = $customTable->table;

    foreach ($xmlData->$customTableName as $s) {

        $id = $s['id'];
        $timestampApp = $s['timestamp'];
        $executeCommand = true;

        $stm = $db->prepare("SELECT timestamp FROM $customTableName WHERE id='$id'");
        $stm-> execute();
        $stm-> bind_result($timestampDB);
        while ($stm->fetch()) {
            if($timestampDB >=$timestampApp) {
                $executeCommand = false;
            }
        }
        $stm-> close();

        if($executeCommand) {

            $customTableFields = array('id');
            $stm = $db->prepare("SELECT custom_table_field FROM ZA_Custom_Table_Fields WHERE custom_table_id='$customTable->id' ");
            $stm-> execute();
            $stm->bind_result($customTableField);
            while ($stm->fetch()) {array_push($customTableFields,$customTableField);}
            $stm-> close();
            array_push($customTableFields,'timestamp');


            $customTableFieldsValues = array();
            foreach ($customTableFields as $customTableField) {
                array_push($customTableFieldsValues,"".$s["$customTableField"]);
            }

            $stm1 = $db->prepare("REPLACE INTO ".$customTable->table." (".implode(',',$customTableFields).") VALUES (".str_repeat('?,',count($customTableFields)-1)."?)");
            $stm1->bind_param(str_repeat('s',count($customTableFields)),...$customTableFieldsValues);
            $stm1->execute();
            $stm1->close();



        }
    }
}
//Dynamic Custom Tables (UDT)/-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


//----------------Warehouse_Transactions_Request_Transactions--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Warehouse_Transactions_Request_Transactions as $s) {
    $requestID = $s['request_id'];
    $transactionID = $s['transaction_id'];
    $timestampApp= $s['timestamp'];

    $executeCommand = true;

    $stm = $db->prepare("SELECT timestamp FROM Warehouse_Transactions_Request_Transactions WHERE request_id='$requestID' AND transaction_id='$transactionID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp) {
            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand){

        $salesPersonID= $s['salesperson_id'];
        $transactionDate= $s['transaction_date'];
        $notes= $s['notes'];
        $status= $s['status'];

        $stmt = $db->prepare("REPLACE INTO Warehouse_Transactions_Request_Transactions (request_id, transaction_id, salesperson_id, transaction_date, notes, status, timestamp) VALUES(?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiisss',$requestID,$transactionID,$salesPersonID,$transactionDate,$notes,$status);
        $stmt->execute();
        $stmt->close();

    }



}

foreach($xmlData->deviceID as $s) { 
	

       $devID= $s['devID'];    
       $db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("greek");
	$stmt1 = $db1->prepare("UPDATE Devices_Pop SET last_update_from= NOW() WHERE device_pop_id='$devID'");

 	$stmt1->execute(); 	
 	$stmt1->close();
       

}


function getNextKey($tableName,$idName)
{
    require("../concc/dbinfo.php");
    $z=0;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("greek");



    $likeVar = $prefix."%";
    $stm1 = $db1->prepare("SELECT $idName FROM $tableName WHERE $idName LIKE '$likeVar' ORDER BY $idName DESC LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($nextID);
    while ($stm1->fetch()) {

        $z = substr($nextID,4,strlen($nextID));
        $z+=1;


    }
    $stm1->close();


    return $prefix.$z;


}

function docIsLocked($documentID,$documentType)
{
    require("../concc/dbinfo.php");
    $contains=false;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(*) FROM ZD_Lock_Document WHERE document_id='$documentID' AND document_type='$documentType'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $contains=true;
        }

    }
    $stm1->close();
    return $contains;
}
?>